/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.AbstractNosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryCreator;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeNosqlQuery
extends AbstractNosqlQuery {
    private final PartTree tree;
    private final MappingContext<?, NosqlPersistentProperty> mappingContext;
    private final ResultProcessor processor;

    public PartTreeNosqlQuery(NosqlQueryMethod method, NosqlOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    @Override
    protected NosqlQuery createQuery(NosqlParameterAccessor accessor) {
        ReturnedType returnedType = this.processor.withDynamicProjection((ParameterAccessor)accessor).getReturnedType();
        NosqlQueryCreator creator = new NosqlQueryCreator(this.tree, accessor, this.mappingContext, returnedType);
        NosqlQuery query = (NosqlQuery)creator.createQuery();
        return query;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }
}

