/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.repository.Query;
import com.oracle.nosql.spring.data.repository.query.NosqlEntityMetadata;
import com.oracle.nosql.spring.data.repository.query.SimpleNosqlEntityMetadata;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;

public class NosqlQueryMethod
extends QueryMethod {
    private final Method method;
    private final Map<Class<? extends Annotation>, Optional<Annotation>> annotationCache;
    private NosqlEntityMetadata<?> metadata;

    public NosqlQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.annotationCache = new ConcurrentReferenceHashMap();
    }

    public EntityMetadata<?> getEntityInformation() {
        Class domainClass = this.getDomainClass();
        NosqlEntityInformation entityInformation = new NosqlEntityInformation(domainClass);
        this.metadata = new SimpleNosqlEntityMetadata(domainClass, entityInformation);
        return this.metadata;
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    @Nullable
    String getAnnotatedQuery() {
        return this.findAnnotatedQuery().orElse(null);
    }

    private Optional<String> findAnnotatedQuery() {
        return this.lookupQueryAnnotation().map(Query::value).filter(StringUtils::hasText);
    }

    @Nullable
    Query getQueryAnnotation() {
        return this.lookupQueryAnnotation().orElse(null);
    }

    Optional<Query> lookupQueryAnnotation() {
        return this.doFindAnnotation(Query.class);
    }

    private <A extends Annotation> Optional<A> doFindAnnotation(Class<A> annotationType) {
        return this.annotationCache.computeIfAbsent(annotationType, it -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)it)));
    }
}

