/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.query.Criteria;
import com.oracle.nosql.spring.data.core.query.CriteriaQuery;
import com.oracle.nosql.spring.data.core.query.CriteriaType;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NosqlQueryCreator
extends AbstractQueryCreator<NosqlQuery, Criteria> {
    private final MappingContext<?, NosqlPersistentProperty> mappingContext;
    private final PartTree tree;
    private final ReturnedType returnedType;

    public NosqlQueryCreator(PartTree tree, NosqlParameterAccessor accessor, MappingContext<?, NosqlPersistentProperty> mappingContext, ReturnedType returnedType) {
        super(tree, (ParameterAccessor)accessor);
        this.mappingContext = mappingContext;
        this.tree = tree;
        this.returnedType = returnedType;
    }

    private String getSubject(Part part) {
        if (part == null) {
            return null;
        }
        String subject = this.mappingContext.getPersistentPropertyPath(part.getProperty()).toDotPath();
        return subject;
    }

    protected Criteria create(Part part, Iterator<Object> parameters) {
        if (part == null) {
            return null;
        }
        Part.Type type = part.getType();
        String subject = this.getSubject(part);
        ArrayList<Object> values = new ArrayList<Object>();
        if (CriteriaType.isPartTypeUnSupported(type)) {
            throw new UnsupportedOperationException("Unsupported keyword: " + type);
        }
        for (int i = 0; i < part.getNumberOfArguments(); ++i) {
            Assert.isTrue((boolean)parameters.hasNext(), (String)"should not reach the end of iterator");
            values.add(parameters.next());
        }
        boolean shouldIgnoreCase = part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS || part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE;
        return Criteria.getInstance(part, shouldIgnoreCase, subject, values);
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> parameters) {
        Object right = this.create(part, (Iterator)parameters);
        return Criteria.getInstance(part, CriteriaType.AND, base, (Criteria)right);
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        if (base == null) {
            return null;
        }
        return Criteria.getInstance(base.getPart(), CriteriaType.OR, base, criteria);
    }

    protected NosqlQuery complete(@Nullable Criteria criteria, Sort sort) {
        CriteriaQuery query = new CriteriaQuery(criteria, this.mappingContext).with(sort).setCount(this.tree.isCountProjection()).setDistinct(this.tree.isDistinct()).limit(this.tree.getMaxResults()).project(this.returnedType);
        return query;
    }
}

