/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlEntityMetadata;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryExecution;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.lang.Nullable;

public abstract class AbstractNosqlQuery
implements RepositoryQuery {
    private final NosqlQueryMethod method;
    private final NosqlOperations operations;

    public AbstractNosqlQuery(NosqlQueryMethod method, NosqlOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    @Nullable
    public Object execute(Object[] parameters) {
        NosqlParameterParameterAccessor accessor = new NosqlParameterParameterAccessor(this.method, parameters);
        NosqlQuery query = this.createQuery(accessor);
        NosqlQueryExecution execution = this.getExecution(accessor);
        Object queryResult = execution.execute(query);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        if (processor.getReturnedType().isProjecting()) {
            return queryResult;
        }
        return processor.processResult(queryResult);
    }

    private <T> NosqlQueryExecution getExecution(NosqlParameterAccessor accessor) {
        NosqlEntityInformation entityInformation = ((NosqlEntityMetadata)this.method.getEntityInformation()).getNosqlEntityInformation();
        if (this.isDeleteQuery()) {
            return new NosqlQueryExecution.DeleteExecution(this.operations, entityInformation, this.method);
        }
        if (this.method.isSliceQuery()) {
            return new NosqlQueryExecution.SlicedExecution(this.operations, entityInformation, this.method, accessor.getPageable());
        }
        if (this.isCountQuery()) {
            return new NosqlQueryExecution.CountExecution(this.operations, entityInformation, this.method);
        }
        if (this.method.isCollectionQuery()) {
            return new NosqlQueryExecution.CollectionExecution(this.operations, entityInformation, this.method);
        }
        if (this.method.isPageQuery()) {
            return new NosqlQueryExecution.PagedExecution(this.operations, entityInformation, this.method, accessor.getPageable());
        }
        if (this.isExistsQuery()) {
            return new NosqlQueryExecution.ExistsExecution(this.operations, entityInformation, this.method);
        }
        throw new IllegalStateException("NYI");
    }

    public NosqlQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract NosqlQuery createQuery(NosqlParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isCountQuery();
}

