/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.config;

import com.oracle.nosql.spring.data.core.mapping.NosqlMappingContext;
import com.oracle.nosql.spring.data.repository.ReactiveNosqlRepository;
import com.oracle.nosql.spring.data.repository.support.ReactiveNosqlRepositoryFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;

public class ReactiveNosqlRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public String getModuleName() {
        return "oracle-nosql";
    }

    public String getModulePrefix() {
        return "oracle-nosql";
    }

    public String getRepositoryFactoryBeanClassName() {
        return ReactiveNosqlRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(ReactiveNosqlRepository.class);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        if (!registry.containsBeanDefinition("nosqlMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(NosqlMappingContext.class);
            definition.setRole(2);
            definition.setSource(config.getSource());
            registry.registerBeanDefinition("nosqlMappingContext", (BeanDefinition)definition);
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        super.postProcess(builder, source);
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }
}

