/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.query;

import com.oracle.nosql.spring.data.core.convert.MappingNosqlConverter;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentEntity;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.query.Criteria;
import com.oracle.nosql.spring.data.core.query.CriteriaType;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.nosql.driver.values.LongValue;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Circle;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CriteriaQuery
extends NosqlQuery {
    private final Criteria criteria;
    private final MappingContext<?, NosqlPersistentProperty> mappingContext;
    private boolean isDistinct;
    private ReturnedType returnedType;

    public CriteriaQuery(@Nullable Criteria criteria, MappingContext<?, NosqlPersistentProperty> mappingContext) {
        this.criteria = criteria;
        this.mappingContext = mappingContext;
    }

    @Override
    public CriteriaQuery with(Sort sort) {
        super.with(sort);
        return this;
    }

    @Override
    public CriteriaQuery with(@NonNull Pageable pageable) {
        super.with(pageable);
        return this;
    }

    @Override
    public CriteriaQuery limit(Integer limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public CriteriaQuery setCount(boolean isCount) {
        super.setCount(isCount);
        return this;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    private boolean hasKeywordOr() {
        return this.criteria != null && this.criteria.getType() == CriteriaType.OR;
    }

    public Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType) {
        return this.getCriteriaByType(criteriaType, this.criteria);
    }

    private Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType, @NonNull Criteria criteria) {
        if (criteria.getType().equals((Object)criteriaType)) {
            return Optional.of(criteria);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            if (!this.getCriteriaByType(criteriaType, subCriteria).isPresent()) continue;
            return Optional.of(subCriteria);
        }
        return Optional.empty();
    }

    private Optional<Criteria> getSubjectCriteria(@NonNull Criteria criteria, @NonNull String keyName) {
        if (keyName.equals(criteria.getSubject())) {
            return Optional.of(criteria);
        }
        List<Criteria> subCriteriaList = criteria.getSubCriteria();
        for (Criteria c : subCriteriaList) {
            Optional<Criteria> subjectCriteria = this.getSubjectCriteria(c, keyName);
            if (!subjectCriteria.isPresent()) continue;
            return subjectCriteria;
        }
        return Optional.empty();
    }

    @Override
    public String generateSql(String tableName, Map<String, Object> params, String idPropertyName) {
        Integer limit;
        String sql = "select " + (this.isDistinct ? "distinct " : "") + (this.isCount() ? "count(*)" : this.generateProjection(idPropertyName)) + " from " + tableName + " as t";
        String whereClause = this.generateSql(this.criteria, params);
        if (StringUtils.hasText((String)whereClause)) {
            sql = sql + " where " + whereClause;
        }
        if (this.getSort().isSorted()) {
            sql = sql + " ORDER BY ";
            sql = sql + this.getSort().stream().map(order -> this.getSqlField(order.getProperty(), order.getProperty().equals(idPropertyName)) + (order.isAscending() ? " ASC" : " DESC")).collect(Collectors.joining(","));
        }
        if ((limit = this.getLimit()) != null) {
            sql = sql + " LIMIT $kv_limit_";
            params.put("$kv_limit_", new LongValue((long)this.getLimit().intValue()));
        }
        if (this.getPageable().isPaged()) {
            sql = sql + " OFFSET $kv_offset_";
            params.put("$kv_offset_", new LongValue(this.getPageable().getOffset()));
        }
        if (!params.isEmpty()) {
            String paramDecl = params.keySet().stream().map(key -> key + " " + MappingNosqlConverter.toNosqlSqlType(params.get(key))).collect(Collectors.joining("; ", "declare ", "; "));
            sql = paramDecl + sql;
        }
        return sql;
    }

    private String generateSql(@Nullable Criteria crt, @NonNull Map<String, Object> parameters) {
        if (crt == null) {
            return "";
        }
        switch (crt.getType()) {
            case ALL: {
                return "";
            }
            case TRUE: {
                if (StringUtils.hasText((String)crt.getSubject())) {
                    return this.getSqlField(crt) + " = true";
                }
                return "true";
            }
            case FALSE: {
                if (StringUtils.hasText((String)crt.getSubject())) {
                    return this.getSqlField(crt) + " = false";
                }
                return "false";
            }
            case IS_NULL: {
                if (StringUtils.hasText((String)crt.getSubject())) {
                    return this.getSqlField(crt) + " = null";
                }
                return " is null";
            }
            case IS_NOT_NULL: {
                if (StringUtils.hasText((String)crt.getSubject())) {
                    return this.getSqlField(crt) + " != null";
                }
                return " is not null";
            }
            case EXISTS: {
                if (StringUtils.hasText((String)crt.getSubject())) {
                    return "EXISTS " + this.getSqlField(crt);
                }
                return " EXISTS ";
            }
            case OR: 
            case AND: {
                Assert.isTrue((crt.getSubCriteria().size() == 2 ? 1 : 0) != 0, (String)"AND, OR criteria should have two children.");
                String op1 = this.generateSql(crt.getSubCriteria().get(0), parameters);
                String op2 = this.generateSql(crt.getSubCriteria().get(1), parameters);
                return " (" + op1 + " " + crt.getType().getSqlKeyword() + " " + op2 + ") ";
            }
            case IS_EQUAL: 
            case NOT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case AFTER: 
            case BEFORE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case CONTAINING: 
            case NOT_CONTAINING: 
            case REGEX: 
            case LIKE: 
            case NOT_LIKE: {
                Assert.isTrue((crt.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Binary criteria should have only one subject value");
                Assert.isTrue((boolean)CriteriaType.isBinary(crt.getType()), (String)"Criteria type should be binary operation");
                String subject = this.getSqlFieldWithCast(crt);
                Object subjectValue = crt.getSubjectValues().get(0);
                String parameter = this.generateQueryParameter(crt.getSubject(), parameters);
                parameters.put(parameter, subjectValue);
                if (crt.isIgnoreCase()) {
                    subject = "lower(" + subject + ")";
                    parameter = "lower(" + parameter + ")";
                }
                if (CriteriaType.isFunction(crt.getType())) {
                    return String.format("%s(%s, %s)", crt.getType().getSqlKeyword(), subject, parameter);
                }
                return String.format("%s %s %s", subject, crt.getType().getSqlKeyword(), parameter);
            }
            case IN: 
            case NOT_IN: {
                Assert.isTrue((crt.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Criteria should have only one subject value");
                if (!(crt.getSubjectValues().get(0) instanceof Collection)) {
                    throw new IllegalArgumentException("IN keyword requires Collection type in parameters");
                }
                String inParameter = this.generateQueryParameter(crt.getSubject(), parameters);
                Object inSubjectValue = crt.getSubjectValues().get(0);
                parameters.put(inParameter, inSubjectValue);
                inParameter = inParameter + "[]";
                String sqlFieldWithCast = this.getSqlFieldWithCast(crt);
                if (crt.isIgnoreCase()) {
                    sqlFieldWithCast = "lower(" + sqlFieldWithCast + ")";
                    inParameter = "seq_transform(" + inParameter + ", lower($))";
                }
                String result = String.format("%s %s (%s)", sqlFieldWithCast, crt.getType().getSqlKeyword(), inParameter);
                if (crt.getType() == CriteriaType.NOT_IN) {
                    result = "NOT (" + result + ")";
                }
                return result;
            }
            case BETWEEN: {
                Assert.isTrue((crt.getSubjectValues().size() == 2 ? 1 : 0) != 0, (String)"Between criteria should have two subject values");
                Object bwSubjectValue1 = crt.getSubjectValues().get(0);
                Object bwSubjectValue2 = crt.getSubjectValues().get(1);
                String bwParameter1 = this.generateQueryParameter(crt.getSubject(), parameters);
                parameters.put(bwParameter1, bwSubjectValue1);
                String bwParameter2 = this.generateQueryParameter(crt.getSubject(), parameters);
                parameters.put(bwParameter2, bwSubjectValue2);
                String bwField = this.getSqlFieldWithCast(crt);
                if (crt.isIgnoreCase()) {
                    bwField = "lower(" + bwField + ")";
                    bwParameter1 = "lower(" + bwParameter1 + ")";
                    bwParameter2 = "lower(" + bwParameter2 + ")";
                }
                return String.format("(%s >= %s AND %s <= %s)", bwField, bwParameter1, bwField, bwParameter2);
            }
            case NEAR: {
                Assert.isTrue((crt.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Near criteria should have 1 subject values.");
                Object nSubjectValue1 = crt.getSubjectValues().get(0);
                if (nSubjectValue1 instanceof Circle) {
                    Circle circle = (Circle)nSubjectValue1;
                    String nGeoShape = this.generateQueryParameter(crt.getSubject() + "_shape", parameters);
                    parameters.put(nGeoShape, circle.getCenter());
                    String nGeoDist = this.generateQueryParameter(crt.getSubject() + "_dist", parameters);
                    parameters.put(nGeoDist, circle.getRadius().getNormalizedValue());
                    String nField = this.getSqlFieldWithCast(crt);
                    return String.format("%s(%s, %s, %s)", crt.getType().getSqlKeyword(), nField, nGeoShape, nGeoDist);
                }
                throw new IllegalArgumentException("Unsupported type for Near criteria: " + nSubjectValue1.getClass().getName() + ". Use org.springframework.data.geo.Circle instead.");
            }
            case WITHIN: {
                Assert.isTrue((crt.getSubjectValues().size() == 1 ? 1 : 0) != 0, (String)"Within criteria should have one subject values");
                Object wSubjectValue1 = crt.getSubjectValues().get(0);
                String wGeoShape = this.generateQueryParameter(crt.getSubject(), parameters);
                parameters.put(wGeoShape, wSubjectValue1);
                String wField = this.getSqlFieldWithCast(crt);
                return String.format("%s(%s, %s)", crt.getType().getSqlKeyword(), wField, wGeoShape);
            }
        }
        throw new IllegalArgumentException("Unsupported Criteria type: " + (Object)((Object)crt.getType()));
    }

    private String getSqlFieldWithCast(@NonNull Criteria crt) {
        PersistentPropertyPath path = this.mappingContext.getPersistentPropertyPath(crt.getPart().getProperty());
        NosqlPersistentProperty property = (NosqlPersistentProperty)path.getLeafProperty();
        return this.getSqlFieldWithCast(crt.getSubject(), property);
    }

    private String getSqlFieldWithCast(@NonNull String field, NosqlPersistentProperty property) {
        String result = this.getSqlField(field, property.isIdProperty());
        if (this.requiresTimestampCast(property)) {
            result = "cast(" + result + " as Timestamp)";
        }
        return result;
    }

    private String getSqlField(@NonNull Criteria crt) {
        PersistentPropertyPath path = this.mappingContext.getPersistentPropertyPath(crt.getPart().getProperty());
        NosqlPersistentProperty property = (NosqlPersistentProperty)path.getLeafProperty();
        return this.getSqlField(crt.getSubject(), property);
    }

    private String getSqlField(@NonNull String field, NosqlPersistentProperty property) {
        return this.getSqlField(field, property.isIdProperty());
    }

    private String getSqlField(@NonNull String field, boolean isKey) {
        if (isKey) {
            return "t." + field;
        }
        return "t.kv_json_." + field;
    }

    private boolean requiresTimestampCast(NosqlPersistentProperty property) {
        NosqlPersistentProperty.TypeCode typeCode = property.getTypeCode();
        return !property.isIdProperty() && (typeCode == NosqlPersistentProperty.TypeCode.DATE || typeCode == NosqlPersistentProperty.TypeCode.INSTANT || typeCode == NosqlPersistentProperty.TypeCode.TIMESTAMP);
    }

    private String generateQueryParameter(@NonNull String field, @NonNull Map<String, Object> parameters) {
        String rootName;
        String potentialName = rootName = "$p_" + field.replace(".", "_");
        int i = 0;
        while (parameters.containsKey(potentialName)) {
            if (i > 1000000) {
                throw new IllegalStateException("Too many tries to find a valid sql parameter name.");
            }
            potentialName = rootName + ++i;
        }
        return potentialName;
    }

    public CriteriaQuery setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
        return this;
    }

    public CriteriaQuery project(ReturnedType returnedType) {
        this.returnedType = returnedType;
        return this;
    }

    private String generateProjection(String idPropertyName) {
        if (this.returnedType == null || !this.returnedType.isProjecting()) {
            return "*";
        }
        ArrayList inputProperties = new ArrayList();
        NosqlPersistentEntity entity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(this.returnedType.getReturnedType());
        entity.doWithProperties(prop -> {
            if (prop.isWritable()) {
                inputProperties.add(prop.getName());
            }
        });
        if (inputProperties.isEmpty()) {
            throw new IllegalArgumentException("There are no accessible fields in returned type: " + this.returnedType.getReturnedType().getName());
        }
        ArrayList keyFields = new ArrayList();
        ArrayList nonKeyFields = new ArrayList();
        inputProperties.stream().forEach(prop -> {
            NosqlPersistentProperty pp = (NosqlPersistentProperty)this.mappingContext.getPersistentPropertyPath(prop, this.returnedType.getReturnedType()).getBaseProperty();
            String field = this.getSqlField((String)prop, pp);
            if (pp.getName().equals(idPropertyName)) {
                keyFields.add(this.getSqlField(pp.getName(), true));
            } else {
                nonKeyFields.add(field);
            }
        });
        String nonKeysProj = nonKeyFields.stream().map(f -> "'" + f.substring(f.lastIndexOf(46) + 1) + "': " + f).collect(Collectors.joining(", ", "{", "} as kv_json_"));
        return Stream.concat(keyFields.stream(), nonKeyFields.isEmpty() ? Stream.empty() : Stream.of(nonKeysProj)).collect(Collectors.joining(", "));
    }
}

