/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.mapping;

import com.oracle.nosql.spring.data.core.mapping.NosqlId;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentEntity;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import oracle.nosql.driver.values.FieldValue;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class BasicNosqlPersistentProperty
extends AnnotationBasedPersistentProperty<NosqlPersistentProperty>
implements NosqlPersistentProperty {
    private NosqlPersistentProperty.TypeCode typeCode = null;

    BasicNosqlPersistentProperty(Property property, NosqlPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
    }

    protected Association<NosqlPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        if (this.isAnnotationPresent(NosqlId.class)) {
            return true;
        }
        return "id".equals(this.getName());
    }

    @Override
    public NosqlPersistentProperty.TypeCode getTypeCode() {
        if (this.typeCode == null) {
            this.typeCode = BasicNosqlPersistentProperty.getCodeForDeserialization(this.getType());
        }
        return this.typeCode;
    }

    public static NosqlPersistentProperty.TypeCode getCodeForDeserialization(Class<?> cls) {
        if (String.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.STRING;
        }
        if (Integer.TYPE.equals(cls) || Integer.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.INT;
        }
        if (Long.TYPE.equals(cls) || Long.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.LONG;
        }
        if (Float.TYPE.equals(cls) || Float.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.FLOAT;
        }
        if (Double.TYPE.equals(cls) || Double.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.DOUBLE;
        }
        if (BigInteger.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BIGINTEGER;
        }
        if (BigDecimal.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BIGDECIMAL;
        }
        if (Boolean.TYPE.equals(cls) || Boolean.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BOOLEAN;
        }
        if (byte[].class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BYTEARRAY;
        }
        if (Timestamp.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.DATE;
        }
        if (Instant.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.INSTANT;
        }
        if (Point.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.GEO_JSON_POINT;
        }
        if (Polygon.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.GEO_JSON_POLYGON;
        }
        if (cls.isArray()) {
            return NosqlPersistentProperty.TypeCode.ARRAY;
        }
        if (cls.isAssignableFrom(ArrayList.class) || cls.isAssignableFrom(HashSet.class) || cls.isAssignableFrom(TreeSet.class)) {
            return NosqlPersistentProperty.TypeCode.COLLECTION;
        }
        if (Object.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.OBJECT;
        }
        if (FieldValue.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.FIELD_VALUE;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.ENUM;
        }
        return NosqlPersistentProperty.TypeCode.POJO;
    }

    public static NosqlPersistentProperty.TypeCode getCodeForSerialization(Class<?> cls) {
        if (String.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.STRING;
        }
        if (Integer.TYPE.equals(cls) || Integer.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.INT;
        }
        if (Long.TYPE.equals(cls) || Long.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.LONG;
        }
        if (Float.TYPE.equals(cls) || Float.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.FLOAT;
        }
        if (Double.TYPE.equals(cls) || Double.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.DOUBLE;
        }
        if (BigInteger.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BIGINTEGER;
        }
        if (BigDecimal.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BIGDECIMAL;
        }
        if (Boolean.TYPE.equals(cls) || Boolean.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BOOLEAN;
        }
        if (byte[].class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.BYTEARRAY;
        }
        if (Timestamp.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.DATE;
        }
        if (Instant.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.INSTANT;
        }
        if (Point.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.GEO_JSON_POINT;
        }
        if (Polygon.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.GEO_JSON_POLYGON;
        }
        if (cls.isArray()) {
            return NosqlPersistentProperty.TypeCode.ARRAY;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.COLLECTION;
        }
        if (Object.class.equals(cls)) {
            return NosqlPersistentProperty.TypeCode.OBJECT;
        }
        if (FieldValue.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.FIELD_VALUE;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            return NosqlPersistentProperty.TypeCode.ENUM;
        }
        return NosqlPersistentProperty.TypeCode.POJO;
    }
}

