/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.mapping;

import com.oracle.nosql.spring.data.core.mapping.NosqlId;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentEntity;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;

public class BasicNosqlPersistentEntity<T>
extends BasicPersistentEntity<T, NosqlPersistentProperty>
implements NosqlPersistentEntity<T>,
ApplicationContextAware {
    private final StandardEvaluationContext context = new StandardEvaluationContext();

    public BasicNosqlPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    @Nullable
    protected NosqlPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(NosqlPersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (!this.hasIdProperty()) {
            if (property.isIdProperty()) {
                return property;
            }
            return null;
        }
        NosqlPersistentProperty currentIdProp = (NosqlPersistentProperty)this.getIdProperty();
        if (!currentIdProp.isAnnotationPresent(NosqlId.class) && !currentIdProp.isAnnotationPresent(Id.class) && (property.isAnnotationPresent(NosqlId.class) || property.isAnnotationPresent(Id.class))) {
            return property;
        }
        throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), currentIdProp.getField()));
    }
}

