/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core;

import com.oracle.nosql.spring.data.NosqlDbFactory;
import com.oracle.nosql.spring.data.config.AbstractNosqlConfiguration;
import com.oracle.nosql.spring.data.config.NosqlDbConfig;
import com.oracle.nosql.spring.data.core.IterableUtil;
import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.convert.MappingNosqlConverter;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentEntity;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.TableNotFoundException;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.WriteMultipleRequest;
import oracle.nosql.driver.util.LruCache;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class NosqlTemplate
implements NosqlOperations,
ApplicationContextAware {
    public static final String JSON_COLUMN = "kv_json_";
    private static final Logger log = LoggerFactory.getLogger(NosqlTemplate.class);
    static final String TEMPLATE_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS %s (%s %s %s, kv_json_ JSON, PRIMARY KEY( %s ))";
    static final String TEMPLATE_GENERATED_ALWAYS = "GENERATED ALWAYS as IDENTITY (NO CYCLE)";
    static final String TEMPLATE_GENERATED_UUID = " AS UUID GENERATED BY DEFAULT";
    static final String TEMPLATE_DROP_TABLE = "DROP TABLE IF EXISTS %s ";
    static final String TEMPLATE_DELETE_ALL = "DELETE FROM %s ";
    static final String TEMPLATE_SELECT_ALL = "SELECT * FROM %s t";
    static final String TEMPLATE_COUNT = "SELECT count(*) FROM %s ";
    static final String TEMPLATE_UPDATE = "DECLARE $id %s; $json JSON; UPDATE %s t SET t.kv_json_ = $json WHERE t.%s = $id";
    private final NosqlDbFactory nosqlDbFactory;
    private final NoSQLHandle nosqlClient;
    private final MappingNosqlConverter mappingNosqlConverter;
    private final SpelAwareProxyProjectionFactory projectionFactory;
    private LruCache<String, PreparedStatement> psCache;

    public static NosqlTemplate create(NosqlDbConfig nosqlDBConfig) throws ClassNotFoundException {
        Assert.notNull((Object)nosqlDBConfig, (String)"NosqlDbConfig should not be null.");
        return NosqlTemplate.create(new NosqlDbFactory(nosqlDBConfig));
    }

    public static NosqlTemplate create(NosqlDbFactory nosqlDbFactory) throws ClassNotFoundException {
        Assert.notNull((Object)nosqlDbFactory, (String)"NosqlDbFactory should not be null.");
        AbstractNosqlConfiguration configuration = new AbstractNosqlConfiguration();
        return new NosqlTemplate(nosqlDbFactory, configuration.mappingNosqlConverter());
    }

    public NosqlTemplate(NosqlDbFactory nosqlDbFactory, MappingNosqlConverter mappingNosqlConverter) {
        Assert.notNull((Object)nosqlDbFactory, (String)"NosqlDbFactory should not be null.");
        this.nosqlDbFactory = nosqlDbFactory;
        this.nosqlClient = nosqlDbFactory.getNosqlClient();
        this.mappingNosqlConverter = mappingNosqlConverter;
        this.projectionFactory = new SpelAwareProxyProjectionFactory();
        this.psCache = new LruCache(nosqlDbFactory.getQueryCacheCapacity(), nosqlDbFactory.getQueryCacheLifetime());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public String getTableName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return this.getNosqlEntityInformation(domainClass).getTableName();
    }

    @Override
    public boolean createTableIfNotExists(NosqlEntityInformation<?, ?> entityInformation) {
        String sql;
        TableRequest tableReq;
        TableResult tableRes;
        TableResult.State tableState;
        String idColName = entityInformation.getIdField().getName();
        String idColType = entityInformation.getIdNosqlType().toString();
        if (entityInformation.getIdNosqlType() == FieldValue.Type.TIMESTAMP) {
            idColType = idColType + "(" + this.nosqlDbFactory.getTimestampPrecision() + ")";
        }
        String autogen = "";
        if (entityInformation.isAutoGeneratedId()) {
            autogen = entityInformation.getIdNosqlType() == FieldValue.Type.STRING ? TEMPLATE_GENERATED_UUID : TEMPLATE_GENERATED_ALWAYS;
        }
        return (tableState = (tableRes = this.doTableRequest(entityInformation, tableReq = new TableRequest().setStatement(sql = String.format(TEMPLATE_CREATE_TABLE, entityInformation.getTableName(), idColName, idColType, autogen, idColName)).setTableLimits(entityInformation.getTableLimits()))).getTableState()) == TableResult.State.ACTIVE;
    }

    private TableResult doTableRequest(NosqlEntityInformation<?, ?> entityInformation, TableRequest tableReq) {
        TableResult tableRes;
        if (entityInformation != null && entityInformation.getTimeout() > 0) {
            tableReq.setTimeout(entityInformation.getTimeout());
        }
        try {
            log.debug("DDL: {}", (Object)tableReq.getStatement());
            tableRes = this.nosqlClient.doTableRequest(tableReq, this.nosqlDbFactory.getTableReqTimeout(), this.nosqlDbFactory.getTableReqPollInterval());
        }
        catch (NoSQLException nse) {
            log.error("DDL: {}", (Object)tableReq.getStatement());
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        return tableRes;
    }

    @Override
    public <T> T insert(@NonNull T objectToSave) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return (T)this.insert(this.getNosqlEntityInformation(objectToSave.getClass()), objectToSave);
    }

    @Override
    public <T, ID> T insert(NosqlEntityInformation<T, ID> entityInformation, @NonNull T objectToSave) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        MapValue row = this.mappingNosqlConverter.convertObjToRow(objectToSave, entityInformation.isAutoGeneratedId());
        PutResult putRes = this.doPut(entityInformation, row, false);
        if (entityInformation.isAutoGeneratedId()) {
            FieldValue id = putRes.getGeneratedValue();
            if (id == null) {
                throw new IllegalStateException("Expected generated value is null.");
            }
            objectToSave = this.populateIdIfNecesary(objectToSave, id);
        }
        return objectToSave;
    }

    private PutResult doPut(NosqlEntityInformation<?, ?> entityInformation, MapValue row, boolean ifPresent) {
        PutResult putRes;
        block9: {
            PutRequest putReq = new PutRequest().setTableName(entityInformation.getTableName()).setValue(row);
            if (ifPresent) {
                putReq.setOption(PutRequest.Option.IfPresent);
            }
            if (entityInformation.isAutoGeneratedId()) {
                putReq.setReturnRow(true);
            }
            if (entityInformation.getTimeout() > 0) {
                putReq.setTimeout(entityInformation.getTimeout());
            }
            try {
                try {
                    putRes = this.nosqlClient.put(putReq);
                }
                catch (TableNotFoundException tnfe) {
                    if (entityInformation.isAutoCreateTable()) {
                        this.createTableIfNotExists(entityInformation);
                        putRes = this.nosqlClient.put(putReq);
                        break block9;
                    }
                    throw tnfe;
                }
            }
            catch (NoSQLException nse) {
                log.error("Put: table: {} key: {}", (Object)putReq.getTableName(), (Object)row.get(entityInformation.getIdColumnName()));
                log.error(nse.getMessage());
                throw MappingNosqlConverter.convert(nse);
            }
        }
        assert (putRes != null);
        return putRes;
    }

    private <T> T populateIdIfNecesary(T objectToSave, FieldValue id) {
        return this.mappingNosqlConverter.setId(objectToSave, id);
    }

    @Override
    public <T> void update(T objectToSave) {
        Assert.notNull(objectToSave, (String)"entity should not be null");
        this.update(this.getNosqlEntityInformation(objectToSave.getClass()), objectToSave);
    }

    @Override
    public <T, ID> void update(NosqlEntityInformation<T, ID> entityInformation, T objectToSave) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        log.debug("execute update in table {}", (Object)entityInformation.getTableName());
        MapValue row = this.mappingNosqlConverter.convertObjToRow(objectToSave, false);
        this.doUpdate(entityInformation, row);
    }

    private void doUpdate(NosqlEntityInformation<?, ?> entityInformation, MapValue row) {
        if (entityInformation.isAutoGeneratedId()) {
            String idColumnName = entityInformation.getIdColumnName();
            String sql = String.format(TEMPLATE_UPDATE, entityInformation.getIdNosqlType().name(), entityInformation.getTableName(), idColumnName);
            HashMap<String, FieldValue> params = new HashMap<String, FieldValue>();
            params.put("$id", row.get(idColumnName));
            params.put("$json", row.get(JSON_COLUMN));
            this.runQueryNosqlParams(entityInformation, sql, params).iterator().next();
        } else {
            this.doPut(entityInformation, row, true);
        }
    }

    @Override
    public void deleteAll(NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        String sql = String.format(TEMPLATE_DELETE_ALL, entityInformation.getTableName());
        this.runQuery(entityInformation, sql).iterator().next();
    }

    @Override
    public <T, ID> void deleteAll(NosqlEntityInformation<T, ID> entityInformation, Iterable<? extends ID> ids) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(ids, (String)"ids should not be null");
        StreamSupport.stream(ids.spliterator(), false).forEach(id -> this.deleteById(entityInformation, id));
    }

    public <T, ID> void deleteInShard(String tableName, Class<T> entityClass, Iterable<? extends ID> ids) {
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        Assert.notNull(ids, (String)"ids should not be null");
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        NosqlEntityInformation<T, ?> entityInformation = this.getNosqlEntityInformation(entityClass);
        WriteMultipleRequest wmReq = new WriteMultipleRequest();
        if (entityInformation.getTimeout() > 0) {
            wmReq.setTimeout(entityInformation.getTimeout());
        }
        String idColumnName = this.getIdColumnName(entityClass);
        StreamSupport.stream(ids.spliterator(), true).map(id -> this.mappingNosqlConverter.convertIdToPrimaryKey(idColumnName, id)).map(pk -> new DeleteRequest().setKey(pk).setTableName(tableName)).forEach(dr -> wmReq.add((Request)dr, false));
        try {
            this.nosqlClient.writeMultiple(wmReq);
        }
        catch (NoSQLException nse) {
            log.error("WriteMultiple: table: {}", (Object)wmReq.getTableName());
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
    }

    @Override
    public boolean dropTableIfExists(String tableName) {
        Assert.hasText((String)tableName, (String)"tableName should not be null, empty or only whitespaces");
        String sql = String.format(TEMPLATE_DROP_TABLE, tableName);
        TableRequest tableReq = new TableRequest().setStatement(sql);
        TableResult tableRes = this.doTableRequest(null, tableReq);
        return tableRes.getTableState() == TableResult.State.DROPPED || tableRes.getTableState() == TableResult.State.DROPPING;
    }

    @Override
    public MappingNosqlConverter getConverter() {
        return this.mappingNosqlConverter;
    }

    public <T> NosqlEntityInformation<T, ?> getNosqlEntityInformation(Class<T> domainClass) {
        return new NosqlEntityInformation(domainClass);
    }

    @Override
    public <T, ID> T findById(ID id, Class<T> javaType) {
        return this.findById(this.getNosqlEntityInformation(javaType), id);
    }

    @Override
    public <T, ID> T findById(NosqlEntityInformation<T, ID> entityInformation, ID id) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(id, (String)"id should not be null");
        log.debug("execute findById in table {}", (Object)entityInformation.getTableName());
        String idColumName = this.mappingNosqlConverter.getIdProperty(entityInformation.getJavaType()).getName();
        MapValue row = this.mappingNosqlConverter.convertIdToPrimaryKey(idColumName, id);
        GetResult getRes = this.doGet(entityInformation, row);
        return (T)this.mappingNosqlConverter.read(entityInformation.getJavaType(), (FieldValue)getRes.getValue());
    }

    private GetResult doGet(NosqlEntityInformation<?, ?> entityInformation, MapValue primaryKey) {
        GetResult getRes;
        GetRequest getReq = new GetRequest().setTableName(entityInformation.getTableName()).setKey(primaryKey);
        if (entityInformation.getTimeout() > 0) {
            getReq.setTimeout(entityInformation.getTimeout());
        }
        getReq.setConsistency(entityInformation.getConsistency());
        try {
            getRes = this.nosqlClient.get(getReq);
        }
        catch (NoSQLException nse) {
            log.error("Get: table: {} key: {}", (Object)getReq.getTableName(), (Object)primaryKey);
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        assert (getRes != null);
        return getRes;
    }

    @Override
    public <T, ID> Iterable<T> findAllById(NosqlEntityInformation<T, ID> entityInformation, Iterable<ID> ids) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(ids, (String)"Id list should not be null");
        return IterableUtil.getIterableFromStream(StreamSupport.stream(ids.spliterator(), false).map(x -> this.findById(entityInformation, x)));
    }

    @Override
    public <T, ID> void deleteById(NosqlEntityInformation<T, ID> entityInformation, ID id) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull(id, (String)"id should not be null");
        log.debug("execute deleteById in table {}", (Object)entityInformation.getTableName());
        String idColumnName = this.getIdColumnName(entityInformation.getJavaType());
        MapValue row = this.mappingNosqlConverter.convertIdToPrimaryKey(idColumnName, id);
        this.doDelete(entityInformation, row);
    }

    private <T> String getIdColumnName(@NonNull Class<T> entityClass) {
        NosqlPersistentEntity entity = (NosqlPersistentEntity)this.mappingNosqlConverter.getMappingContext().getPersistentEntity(entityClass);
        Assert.notNull((Object)entity, (String)"entity should not be null");
        Assert.notNull((Object)entity.getIdProperty(), (String)"entity.getIdProperty() should not be null");
        return ((NosqlPersistentProperty)entity.getIdProperty()).getName();
    }

    private DeleteResult doDelete(NosqlEntityInformation<?, ?> entityInformation, MapValue primaryKey) {
        DeleteResult delRes;
        DeleteRequest delReq = new DeleteRequest().setTableName(entityInformation.getTableName()).setKey(primaryKey);
        if (entityInformation.getTimeout() > 0) {
            delReq.setTimeout(entityInformation.getTimeout());
        }
        try {
            delRes = this.nosqlClient.delete(delReq);
        }
        catch (NoSQLException nse) {
            log.error("Delete: table: {} key: {}", (Object)delReq.getTableName(), (Object)primaryKey);
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        assert (delRes != null);
        return delRes;
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findAll(this.getNosqlEntityInformation(entityClass));
    }

    @Override
    public <T> Iterable<T> findAll(NosqlEntityInformation<T, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        String sql = String.format(TEMPLATE_SELECT_ALL, entityInformation.getTableName());
        Iterable<MapValue> items = this.runQuery(entityInformation, sql);
        Stream<Object> result = IterableUtil.getStreamFromIterable(items).map(d -> this.getConverter().read(entityInformation.getJavaType(), (FieldValue)d));
        return IterableUtil.getIterableFromStream(result);
    }

    @Override
    public long count(NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        String sql = String.format(TEMPLATE_COUNT, entityInformation.getTableName());
        Iterable<MapValue> res = this.runQuery(entityInformation, sql);
        Assert.isTrue((res != null ? 1 : 0) != 0, (String)"Result of a count query should not be null and should have a non null iterator.");
        Iterator<MapValue> iterator = res.iterator();
        Assert.isTrue((boolean)iterator.hasNext(), (String)"Result of count query iterator should have 1 result.");
        Collection values = iterator.next().values();
        FieldValue countField = (FieldValue)values.iterator().next();
        Assert.isTrue((countField != null && countField.getType() == FieldValue.Type.LONG ? 1 : 0) != 0, (String)"Result of a count query should be of type LONG.");
        return countField.asLong().getValue();
    }

    @Override
    public <T> Iterable<T> findAll(NosqlEntityInformation<T, ?> entityInformation, Sort sort) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        String sql = String.format(TEMPLATE_SELECT_ALL, entityInformation.getTableName());
        sql = sql + " " + this.orderBySql(entityInformation, sort);
        Iterable<MapValue> items = this.runQuery(entityInformation, sql);
        return IterableUtil.getIterableFromStream(IterableUtil.getStreamFromIterable(items).map(d -> this.getConverter().read(entityInformation.getJavaType(), (FieldValue)d)));
    }

    @Override
    public <T> Page<T> findAll(NosqlEntityInformation<T, ?> entityInformation, Pageable pageable) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        HashMap<String, FieldValue> params = new HashMap<String, FieldValue>();
        String sql = this.limitOffsetSql(entityInformation, pageable, params);
        Iterable<MapValue> items = this.runQueryNosqlParams(entityInformation, sql, params);
        List result = IterableUtil.getStreamFromIterable(items).map(d -> this.getConverter().read(entityInformation.getJavaType(), (FieldValue)d)).collect(Collectors.toList());
        return new PageImpl(result, pageable, this.count(entityInformation));
    }

    private <T> String limitOffsetSql(NosqlEntityInformation<T, ?> entityInformation, Pageable pageable, @NonNull Map<String, FieldValue> params) {
        String sql = String.format(TEMPLATE_SELECT_ALL, entityInformation.getTableName());
        if (pageable == null || pageable.isUnpaged()) {
            return sql;
        }
        sql = sql + this.orderBySql(entityInformation, pageable.getSort());
        sql = sql + " LIMIT $kv_limit_ OFFSET $kv_offset_";
        params.put("$kv_limit_", (FieldValue)new LongValue((long)pageable.getPageSize()));
        params.put("$kv_offset_", (FieldValue)new LongValue(pageable.getOffset()));
        sql = "DECLARE $kv_limit_ LONG; $kv_offset_ LONG; " + sql;
        return sql;
    }

    private <T> String orderBySql(NosqlEntityInformation<T, ?> entityInformation, Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return "";
        }
        String sql = sort.stream().map(f -> "t." + this.convertProperty(entityInformation, f.getProperty()) + " " + (f.isAscending() ? "ASC" : "DESC")).collect(Collectors.joining(",", "ORDER BY ", ""));
        return " " + sql;
    }

    private <T> String convertProperty(NosqlEntityInformation<T, ?> entityInformation, @NonNull String property) {
        Field field = FieldUtils.getField((Class)entityInformation.getJavaType(), (String)property);
        if (field != null && field.equals(entityInformation.getIdField())) {
            return property;
        }
        return "kv_json_." + property;
    }

    public void runTableRequest(String statement) {
        TableRequest tableRequest = new TableRequest();
        tableRequest.setStatement(statement);
        this.doTableRequest(null, tableRequest);
    }

    public Iterable<MapValue> runQuery(NosqlEntityInformation<?, ?> entityInformation, String query) {
        return this.runQueryNosqlParams(entityInformation, query, null);
    }

    public Iterable<MapValue> runQueryJavaParams(NosqlEntityInformation<?, ?> entityInformation, String query, Map<String, Object> javaParams) {
        HashMap<String, FieldValue> nosqlParams = null;
        if (javaParams != null) {
            nosqlParams = new HashMap<String, FieldValue>(javaParams.size());
            for (Map.Entry<String, Object> e : javaParams.entrySet()) {
                FieldValue fieldValue = this.mappingNosqlConverter.convertObjToFieldValue(e.getValue(), null, false);
                nosqlParams.put(e.getKey(), fieldValue);
            }
        }
        return this.runQueryNosqlParams(entityInformation, query, nosqlParams);
    }

    public Iterable<MapValue> runQueryNosqlParams(NosqlEntityInformation<?, ?> entityInformation, String query, Map<String, FieldValue> nosqlParams) {
        PreparedStatement preparedStatement = this.getPreparedStatement(entityInformation, query);
        if (nosqlParams != null) {
            for (Map.Entry<String, FieldValue> e : nosqlParams.entrySet()) {
                preparedStatement.setVariable(e.getKey(), e.getValue());
            }
        }
        QueryRequest qReq = new QueryRequest().setPreparedStatement(preparedStatement);
        if (entityInformation != null) {
            if (entityInformation.getTimeout() > 0) {
                qReq.setTimeout(entityInformation.getTimeout());
            }
            qReq.setConsistency(entityInformation.getConsistency());
        }
        log.debug("Q: {}", (Object)query);
        Iterable<MapValue> results = this.doQuery(qReq);
        return results;
    }

    @Override
    public <T> Iterable<MapValue> count(NosqlEntityInformation<T, ?> entityInformation, NosqlQuery query) {
        return this.executeMapValueQuery(entityInformation, query);
    }

    @Override
    public <T, ID> Iterable<T> delete(NosqlEntityInformation<T, ID> entityInformation, NosqlQuery query) {
        return IterableUtil.getIterableFromStream(IterableUtil.getStreamFromIterable(this.find(entityInformation, entityInformation.getJavaType(), query)).map(e -> {
            this.deleteById(entityInformation, entityInformation.getId(e));
            return e;
        }));
    }

    @Override
    public <S, T> Iterable<T> find(NosqlEntityInformation<S, ?> entityInformation, Class<T> targetType, NosqlQuery query) {
        Class entityType = entityInformation.getJavaType();
        Class typeToRead = targetType.isInterface() || targetType.isAssignableFrom(entityType) ? entityType : targetType;
        Iterable<MapValue> results = this.executeMapValueQuery(entityInformation, query);
        Stream<Object> resStream = IterableUtil.getStreamFromIterable(results).map(d -> {
            Object source = this.getConverter().read(typeToRead, (FieldValue)d);
            Object result = targetType.isInterface() ? this.projectionFactory.createProjection(targetType, source) : source;
            return result;
        });
        return IterableUtil.getIterableFromStream(resStream);
    }

    private <T> Iterable<MapValue> executeMapValueQuery(NosqlEntityInformation<T, ?> entityInformation, NosqlQuery query) {
        Assert.notNull(entityInformation, (String)"Entity information should not be null.");
        Assert.notNull((Object)query, (String)"Query should not be null.");
        Class entityClass = entityInformation.getJavaType();
        String idPropertyName = entityClass == null || this.mappingNosqlConverter.getIdProperty(entityClass) == null ? null : this.mappingNosqlConverter.getIdProperty(entityClass).getName();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String sql = query.generateSql(entityInformation.getTableName(), params, idPropertyName);
        PreparedStatement pStmt = this.getPreparedStatement(entityInformation, sql);
        for (Map.Entry param : params.entrySet()) {
            pStmt.setVariable((String)param.getKey(), this.mappingNosqlConverter.convertObjToFieldValue(param.getValue(), null, false));
        }
        QueryRequest qReq = new QueryRequest().setPreparedStatement(pStmt);
        if (entityInformation.getTimeout() > 0) {
            qReq.setTimeout(entityInformation.getTimeout());
        }
        qReq.setConsistency(entityInformation.getConsistency());
        if (query.isCount()) {
            qReq.setLimit(1);
        }
        log.debug("Q: {}", (Object)sql);
        return this.doQuery(qReq);
    }

    private PreparedStatement getPreparedStatement(NosqlEntityInformation<?, ?> entityInformation, String query) {
        PreparedStatement preparedStatement = (PreparedStatement)this.psCache.get((Object)query);
        if (preparedStatement == null) {
            PrepareRequest pReq = new PrepareRequest().setStatement(query);
            if (entityInformation != null && entityInformation.getTimeout() > 0) {
                pReq.setTimeout(entityInformation.getTimeout());
            }
            try {
                log.debug("Prepare: {}", (Object)pReq.getStatement());
                PrepareResult pRes = this.nosqlClient.prepare(pReq);
                preparedStatement = pRes.getPreparedStatement();
                this.psCache.put((Object)query, (Object)preparedStatement);
            }
            catch (NoSQLException nse) {
                log.error("Prepare: {}", (Object)pReq.getStatement());
                log.error(nse.getMessage());
                throw MappingNosqlConverter.convert(nse);
            }
        }
        return preparedStatement.copyStatement();
    }

    private Iterable<MapValue> doQuery(QueryRequest qReq) {
        return new IterableUtil.IterableImpl(this.nosqlClient, qReq);
    }
}

