/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core;

import com.oracle.nosql.spring.data.core.convert.MappingNosqlConverter;
import java.util.Iterator;
import java.util.stream.Stream;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.values.MapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.NonNull;

public class IterableUtil {
    public static <T> Iterable<T> getIterableFromStream(Stream<T> stream) {
        return new StreamIterable<T>(stream);
    }

    public static <T> Stream<T> getStreamFromIterable(@NonNull Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        return IterableUtil.getStreamFromIterator(iterator);
    }

    public static <T> Stream<T> getStreamFromIterator(@NonNull Iterator<T> iterator) {
        return StreamUtils.createStreamFromIterator(iterator);
    }

    static class StreamIterable<T>
    implements Iterable<T> {
        private final Stream<T> stream;

        StreamIterable(Stream<T> stream) {
            this.stream = stream;
        }

        @Override
        public Iterator<T> iterator() {
            return this.stream.iterator();
        }
    }

    public static class IteratorImpl
    implements Iterator<MapValue> {
        private static final Logger log = LoggerFactory.getLogger(IteratorImpl.class);
        final NoSQLHandle nosqlClient;
        final QueryRequest queryRequest;
        QueryResult queryResult;
        Iterator<MapValue> iterator;

        IteratorImpl(NoSQLHandle nosqlClient, QueryRequest queryRequest) {
            this.nosqlClient = nosqlClient;
            this.queryRequest = queryRequest;
        }

        @Override
        public boolean hasNext() {
            this.ensureIterator();
            return this.iterator.hasNext();
        }

        @Override
        public MapValue next() {
            this.ensureIterator();
            return this.iterator.next();
        }

        private boolean ensureIterator() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return true;
            }
            if (this.iterator != null && !this.iterator.hasNext() && this.queryRequest.isDone()) {
                return false;
            }
            try {
                do {
                    this.queryResult = this.nosqlClient.query(this.queryRequest);
                    this.iterator = this.queryResult.getResults().iterator();
                } while (!this.iterator.hasNext() && !this.queryRequest.isDone());
                return this.iterator.hasNext() || !this.queryRequest.isDone();
            }
            catch (NoSQLException nse) {
                log.error("Query: {}", (Object)this.queryRequest.getStatement());
                log.error(nse.getMessage());
                throw MappingNosqlConverter.convert(nse);
            }
        }
    }

    public static class IterableImpl
    implements Iterable<MapValue> {
        final NoSQLHandle nosqlClient;
        final QueryRequest queryRequest;
        final IteratorImpl iter;

        IterableImpl(NoSQLHandle nosqlClient, QueryRequest queryRequest) {
            this.nosqlClient = nosqlClient;
            this.queryRequest = queryRequest;
            this.iter = new IteratorImpl(nosqlClient, queryRequest);
        }

        @Override
        public Iterator<MapValue> iterator() {
            return this.iter;
        }
    }
}

