/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data;

import com.oracle.nosql.spring.data.config.NosqlDbConfig;
import java.io.IOException;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.NoSQLHandleFactory;
import oracle.nosql.driver.ops.Request;
import org.springframework.util.Assert;

public class NosqlDbFactory {
    private final NosqlDbConfig config;
    private NoSQLHandle handle;

    public NosqlDbFactory(NosqlDbConfig config) {
        Assert.notNull((Object)config, (String)"NosqlDbConfig should not be null.");
        this.validateConfig(config);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NoSQLHandle getNosqlClient() {
        if (this.handle == null) {
            NosqlDbFactory nosqlDbFactory = this;
            synchronized (nosqlDbFactory) {
                if (this.handle == null) {
                    this.handle = NoSQLHandleFactory.createNoSQLHandle((NoSQLHandleConfig)this.config.getNosqlHandleConfig());
                }
            }
        }
        return this.handle;
    }

    private void validateConfig(NosqlDbConfig config) {
        Assert.notNull((Object)config, (String)"NosqlDbConfig should not be null.");
        Assert.notNull((Object)config.getNosqlHandleConfig(), (String)"NosqlDbConfig should have a non-null NoSQLHandleConfig.");
        Assert.notNull((Object)config.getNosqlHandleConfig().getServiceURL(), (String)"NosqlDbConfig should have a non-null endpoint.");
        Assert.notNull((Object)config.getNosqlHandleConfig().getAuthorizationProvider(), (String)"NosqlDbConfig should have a non-null authorization provider.");
    }

    public static NosqlDbFactory createCloudFactory(String endpoint, String configFile) throws IOException {
        return new NosqlDbFactory(NosqlDbConfig.createCloudConfig(endpoint, configFile));
    }

    public static NosqlDbFactory createCloudSimFactory(String endpoint) {
        return new NosqlDbFactory(NosqlDbConfig.createCloudSimConfig(endpoint));
    }

    public static NosqlDbFactory createProxyFactory(String endpoint) {
        return new NosqlDbFactory(NosqlDbConfig.createProxyConfig(endpoint));
    }

    public static NosqlDbFactory createProxyFactory(String endpoint, String user, char[] password) {
        return new NosqlDbFactory(NosqlDbConfig.createProxyConfig(endpoint, user, password));
    }

    public int getQueryCacheCapacity() {
        return this.config.getQueryCacheCapacity();
    }

    public int getQueryCacheLifetime() {
        return this.config.getQueryCacheLifetime();
    }

    public int getTableReqTimeout() {
        return this.config.getTableReqTimeout();
    }

    public int getTableReqPollInterval() {
        return this.config.getTableReqPollInterval();
    }

    public int getTimestampPrecision() {
        return this.config.getTimestampPrecision();
    }

    public static class CloudSimProvider
    implements AuthorizationProvider {
        private static final String id = "Bearer exampleId";
        private static AuthorizationProvider provider = new CloudSimProvider();

        public static AuthorizationProvider getProvider() {
            return provider;
        }

        private CloudSimProvider() {
        }

        public String getAuthorizationString(Request request) {
            return id;
        }

        public void close() {
        }
    }
}

