/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.repository.NosqlRepository;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleNosqlRepository<T, ID extends Serializable>
implements NosqlRepository<T, ID> {
    private final NosqlOperations operation;
    private final NosqlEntityInformation<T, ID> entityInformation;

    public SimpleNosqlRepository(NosqlEntityInformation<T, ID> entityInformation, ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null.");
        this.operation = (NosqlOperations)applicationContext.getBean(NosqlOperations.class);
        this.entityInformation = entityInformation;
        if (this.entityInformation.isAutoCreateTable()) {
            this.createTableIfNotExists();
        }
    }

    public SimpleNosqlRepository(NosqlEntityInformation<T, ID> metadata, NosqlOperations dbOperations) {
        Assert.notNull((Object)dbOperations, (String)"NosqlOprerations must not be null.");
        this.operation = dbOperations;
        this.entityInformation = metadata;
        if (this.entityInformation.isAutoCreateTable()) {
            this.createTableIfNotExists();
        }
    }

    private void createTableIfNotExists() {
        this.operation.createTableIfNotExists(this.entityInformation);
    }

    @Override
    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null.");
        if (this.entityInformation.isAutoGeneratedId()) {
            boolean isNew = this.entityInformation.isNew(entity);
            if (isNew) {
                return (S)this.operation.insert(this.entityInformation, entity);
            }
        } else {
            return (S)this.operation.insert(this.entityInformation, entity);
        }
        this.operation.update(this.entityInformation, entity);
        return entity;
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null.");
        entities.forEach(this::save);
        return entities;
    }

    @Override
    public Iterable<T> findAll() {
        return this.operation.findAll(this.entityInformation);
    }

    @Override
    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        return this.operation.findAllById(this.entityInformation, ids);
    }

    @Override
    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null.");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.operation.findById(this.entityInformation, id));
    }

    @Override
    public long count() {
        return this.operation.count(this.entityInformation);
    }

    @Override
    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Id to be deleted should not be null.");
        this.operation.deleteById(this.entityInformation, id);
    }

    @Override
    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity to be deleted should not be null.");
        this.operation.deleteById(this.entityInformation, this.entityInformation.getId(entity));
    }

    @Override
    public void deleteAll() {
        this.operation.deleteAll(this.entityInformation);
    }

    @Override
    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null.");
        List ids = StreamSupport.stream(entities.spliterator(), true).map(e -> {
            Assert.notNull((Object)e, (String)"Entity can not be null.");
            return (Serializable)this.entityInformation.getId(e);
        }).collect(Collectors.toList());
        this.operation.deleteAll(this.entityInformation, ids);
    }

    @Override
    public boolean existsById(ID primaryKey) {
        Assert.notNull(primaryKey, (String)"PrimaryKey should not be null.");
        return this.findById(primaryKey).isPresent();
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort of findAll should not be null.");
        return this.operation.findAll(this.entityInformation, sort);
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable should not be null.");
        return this.operation.findAll(this.entityInformation, pageable);
    }

    @Override
    public int getTimeout() {
        return this.entityInformation.getTimeout();
    }

    @Override
    public void setTimeout(int milliseconds) {
        this.entityInformation.setTimeout(milliseconds);
    }

    @Override
    public String getConsistency() {
        return this.entityInformation.getConsistency().name();
    }

    @Override
    public void setConsistency(String consistency) {
        this.entityInformation.setConsistency(consistency);
    }
}

