/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import com.oracle.nosql.spring.data.repository.query.PartTreeReactiveNosqlQuery;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import com.oracle.nosql.spring.data.repository.support.SimpleReactiveNosqlRepository;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class ReactiveNosqlRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final ApplicationContext applicationContext;
    private final ReactiveNosqlOperations reactiveNosqlOperations;

    public ReactiveNosqlRepositoryFactory(ReactiveNosqlOperations nosqlOperations, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.reactiveNosqlOperations = nosqlOperations;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new NosqlEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.applicationContext});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveNosqlRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new ReactiveNosqlQueryLookupStrategy(this.reactiveNosqlOperations, evaluationContextProvider));
    }

    private static class ReactiveNosqlQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ReactiveNosqlOperations nosqlOperations;

        public ReactiveNosqlQueryLookupStrategy(ReactiveNosqlOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.nosqlOperations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            NosqlQueryMethod queryMethod = new NosqlQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.nosqlOperations, (String)"dbOperations must not be null!");
            return new PartTreeReactiveNosqlQuery(queryMethod, this.nosqlOperations);
        }
    }
}

