/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import com.oracle.nosql.spring.data.repository.query.PartTreeNosqlQuery;
import com.oracle.nosql.spring.data.repository.query.StringBasedNosqlQuery;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import com.oracle.nosql.spring.data.repository.support.SimpleNosqlRepository;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class NosqlRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext applicationContext;
    private final NosqlOperations nosqlOperations;

    public NosqlRepositoryFactory(NosqlOperations nosqlOperations, ApplicationContext applicationContext) {
        this.nosqlOperations = nosqlOperations;
        this.applicationContext = applicationContext;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleNosqlRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.applicationContext});
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new NosqlEntityInformation(domainClass);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new NosqlDbQueryLookupStrategy(this.nosqlOperations, evaluationContextProvider));
    }

    private static class NosqlDbQueryLookupStrategy
    implements QueryLookupStrategy {
        private final NosqlOperations dbOperations;
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public NosqlDbQueryLookupStrategy(NosqlOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.dbOperations = operations;
            this.evaluationContextProvider = provider;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            NosqlQueryMethod queryMethod = new NosqlQueryMethod(method, metadata, factory);
            String namedQueryName = queryMethod.getNamedQueryName();
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.dbOperations, (String)"dbOperations must not be null!");
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedNosqlQuery(namedQuery, queryMethod, this.dbOperations, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedNosqlQuery(queryMethod, this.dbOperations, this.evaluationContextProvider);
            }
            return new PartTreeNosqlQuery(queryMethod, this.dbOperations);
        }
    }
}

