/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.support;

import com.oracle.nosql.spring.data.core.mapping.NosqlId;
import com.oracle.nosql.spring.data.core.mapping.NosqlTable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.ops.TableLimits;
import oracle.nosql.driver.values.FieldValue;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.ReflectionUtils;

public class NosqlEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private Field id;
    private String tableName;
    private boolean autoCreateTable;
    private TableLimits tableLimits;
    private boolean autoGeneratedId;
    private Consistency consistency;
    private int timeout;
    private FieldValue.Type idNosqlType;

    public NosqlEntityInformation(Class<T> domainClass) {
        super(domainClass);
        this.id = this.getIdField(domainClass);
        ReflectionUtils.makeAccessible((Field)this.id);
        this.idNosqlType = this.findIdNosqlType();
        NosqlId nosqlIdAnn = this.id.getAnnotation(NosqlId.class);
        if (nosqlIdAnn != null && nosqlIdAnn.generated()) {
            FieldValue.Type nosqlKeyType = this.getIdNosqlType();
            switch (nosqlKeyType) {
                case LONG: 
                case INTEGER: 
                case NUMBER: 
                case STRING: {
                    this.autoGeneratedId = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported to be autogenerated: " + this.id.getType() + ". Only int, long, Integer, Long, BigInteger, BigDecimal and String are supported.");
                }
            }
        }
        this.setTableOptions(domainClass);
    }

    public ID getId(T entity) {
        return (ID)ReflectionUtils.getField((Field)this.id, entity);
    }

    public Field getIdField() {
        return this.id;
    }

    public String getIdColumnName() {
        return this.id.getName();
    }

    public Class<ID> getIdType() {
        return this.id.getType();
    }

    public FieldValue.Type getIdNosqlType() {
        return this.idNosqlType;
    }

    private FieldValue.Type findIdNosqlType() {
        Class<ID> idClass = this.getIdType();
        if (idClass == String.class) {
            return FieldValue.Type.STRING;
        }
        if (idClass == Integer.TYPE || idClass == Integer.class) {
            return FieldValue.Type.INTEGER;
        }
        if (idClass == Long.TYPE || idClass == Long.class) {
            return FieldValue.Type.LONG;
        }
        if (idClass == Float.TYPE || idClass == Float.class || idClass == Double.TYPE || idClass == Double.class) {
            return FieldValue.Type.DOUBLE;
        }
        if (idClass == BigInteger.class || idClass == BigDecimal.class) {
            return FieldValue.Type.NUMBER;
        }
        if (idClass == Timestamp.class || idClass == Date.class || idClass == Instant.class) {
            return FieldValue.Type.TIMESTAMP;
        }
        throw new IllegalStateException("Unsupported ID type.");
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isAutoCreateTable() {
        return this.autoCreateTable;
    }

    public boolean isAutoGeneratedId() {
        return this.autoGeneratedId;
    }

    private Field getIdField(Class<?> domainClass) {
        Field idField;
        List idFields = FieldUtils.getFieldsListWithAnnotation(domainClass, Id.class);
        if (idFields.isEmpty()) {
            idField = ReflectionUtils.findField((Class)this.getJavaType(), (String)"id");
        } else if (idFields.size() == 1) {
            idField = (Field)idFields.get(0);
        } else {
            throw new IllegalArgumentException("Only one field can be with @Id annotation in " + domainClass.getName());
        }
        List nsFields = FieldUtils.getFieldsListWithAnnotation(domainClass, NosqlId.class);
        if (nsFields.size() == 1) {
            idField = (Field)nsFields.get(0);
        } else if (nsFields.size() > 1) {
            throw new IllegalArgumentException("Only one field in class " + domainClass + " can be with @NosqlId annotation.");
        }
        if (!idFields.isEmpty() && !nsFields.isEmpty()) {
            throw new IllegalArgumentException("Only one of @Id or @NosqlId annotation can be used on entity class: " + domainClass.getCanonicalName());
        }
        if (idField == null) {
            throw new IllegalArgumentException("Entity should contain @Id or @NosqlId annotated field or field named id: " + domainClass.getName());
        }
        if (idField.getType() != String.class && idField.getType() != Integer.class && idField.getType() != Integer.TYPE && idField.getType() != Long.class && idField.getType() != Long.TYPE && idField.getType() != Float.class && idField.getType() != Float.TYPE && idField.getType() != Double.class && idField.getType() != Double.TYPE && idField.getType() != BigInteger.class && idField.getType() != BigDecimal.class && idField.getType() != Timestamp.class && idField.getType() != Date.class && idField.getType() != Instant.class) {
            throw new IllegalArgumentException("Id field must be of type java.lang.String, int, java.lang.Integer, long, java.lang.Long, java.math.BigInteger, java.math.BigDecimal, java.sql.Timestamp, java.util.Date or java.time.Instant in " + domainClass.getName());
        }
        if ("kv_json_".equals(idField.getName())) {
            throw new IllegalArgumentException("Id field can not be named 'kv_json_' in " + domainClass.getName());
        }
        return idField;
    }

    private void setTableOptions(Class<T> domainClass) {
        NosqlTable annotation;
        this.autoCreateTable = true;
        this.tableLimits = null;
        this.consistency = Consistency.EVENTUAL;
        this.timeout = 0;
        this.tableName = domainClass.getSimpleName();
        if (domainClass.isArray()) {
            this.tableName = domainClass.getComponentType().getSimpleName() + "_Array";
        }
        if ((annotation = domainClass.getAnnotation(NosqlTable.class)) != null) {
            this.autoCreateTable = annotation.autoCreateTable();
            if (annotation.readUnits() != -1 || annotation.writeUnits() != -1 || annotation.storageGB() != -1) {
                this.tableLimits = new TableLimits(annotation.readUnits(), annotation.writeUnits(), annotation.storageGB());
            }
            this.consistency = Consistency.valueOf((String)annotation.consistency());
            this.timeout = annotation.timeout();
            if (annotation.tableName() != null && !annotation.tableName().isEmpty()) {
                this.tableName = annotation.tableName();
            }
        }
    }

    public TableLimits getTableLimits() {
        return this.tableLimits;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = Consistency.valueOf((String)consistency);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int milliseconds) {
        if (milliseconds < 0) {
            throw new IllegalArgumentException("Timeout cannot be a negative value.");
        }
        this.timeout = milliseconds;
    }
}

