/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.IterableUtil;
import com.oracle.nosql.spring.data.core.NosqlOperations;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.lang.NonNull;

public interface NosqlQueryExecution {
    public Object execute(NosqlQuery var1);

    public static final class CountExecution<T>
    extends AbstratExecution<T> {
        CountExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod) {
            super(operations, entityInformation, queryMethod);
        }

        @Override
        public Object execute(NosqlQuery query) {
            Iterable<MapValue> res = this.operations.count(this.entityInformation, query);
            if (res == null) {
                throw new IllegalStateException("Count result not available.");
            }
            Iterator<MapValue> iterator = res.iterator();
            MapValue mapValue = iterator.next();
            if (mapValue.size() != 1) {
                throw new IllegalStateException("Unexpected count query result.");
            }
            return ((FieldValue)mapValue.values().iterator().next()).asLong().getValue();
        }
    }

    public static final class SlicedExecution<T>
    extends AbstratExecution<T> {
        @NonNull
        private final Pageable pageable;

        SlicedExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod, @NonNull Pageable pageable) {
            super(operations, entityInformation, queryMethod);
            this.pageable = pageable;
        }

        @Override
        public Object execute(NosqlQuery query) {
            int pageSize = this.pageable.getPageSize();
            NosqlQuery modifiedQuery = query.with(this.pageable).limit(pageSize + 1);
            List result = IterableUtil.getStreamFromIterable(this.operations.find(this.entityInformation, this.queryMethod.getReturnedObjectType(), modifiedQuery)).collect(Collectors.toList());
            boolean hasNext = result.size() > pageSize;
            return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, this.pageable, hasNext);
        }
    }

    public static final class PagedExecution<T>
    extends AbstratExecution<T> {
        private final Pageable pageable;

        PagedExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod, Pageable pageable) {
            super(operations, entityInformation, queryMethod);
            this.pageable = pageable;
        }

        @Override
        public Object execute(NosqlQuery query) {
            query.with(this.pageable);
            int overallLimit = query.getLimit();
            List result = IterableUtil.getStreamFromIterable(this.operations.find(this.entityInformation, this.queryMethod.getReturnedObjectType(), query)).collect(Collectors.toList());
            return PageableExecutionUtils.getPage(result, (Pageable)this.pageable, () -> {
                long count = result.size();
                return overallLimit != 0 ? Math.min(count, (long)overallLimit) : count;
            });
        }
    }

    public static final class DeleteExecution<T>
    extends AbstratExecution<T> {
        DeleteExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod) {
            super(operations, entityInformation, queryMethod);
        }

        @Override
        public Iterable<T> execute(NosqlQuery query) {
            return this.operations.delete(this.entityInformation, query);
        }
    }

    public static final class ExistsExecution<T>
    extends AbstratExecution<T> {
        ExistsExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod) {
            super(operations, entityInformation, queryMethod);
        }

        @Override
        public Object execute(NosqlQuery query) {
            Iterable res = this.operations.find(this.entityInformation, this.entityInformation.getJavaType(), query);
            if (res == null) {
                throw new IllegalStateException("Exists result not available.");
            }
            return res.iterator().hasNext();
        }
    }

    public static final class CollectionExecution<T>
    extends AbstratExecution<T> {
        CollectionExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod) {
            super(operations, entityInformation, queryMethod);
        }

        @Override
        public Iterable<T> execute(NosqlQuery query) {
            return this.operations.find(this.entityInformation, this.queryMethod.getReturnedObjectType(), query);
        }
    }

    public static abstract class AbstratExecution<T>
    implements NosqlQueryExecution {
        protected final NosqlOperations operations;
        protected final NosqlEntityInformation<T, ?> entityInformation;
        protected final NosqlQueryMethod queryMethod;

        AbstratExecution(NosqlOperations operations, NosqlEntityInformation<T, ?> entityInformation, NosqlQueryMethod queryMethod) {
            this.operations = operations;
            this.entityInformation = entityInformation;
            this.queryMethod = queryMethod;
        }

        @Override
        public abstract Object execute(NosqlQuery var1);
    }
}

