/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.repository.query;

import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.query.NosqlEntityMetadata;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlParameterParameterAccessor;
import com.oracle.nosql.spring.data.repository.query.NosqlQueryMethod;
import com.oracle.nosql.spring.data.repository.query.ReactiveNosqlQueryExecution;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractReactiveNosqlQuery
implements RepositoryQuery {
    private final NosqlQueryMethod method;
    private final ReactiveNosqlOperations operations;

    public AbstractReactiveNosqlQuery(NosqlQueryMethod method, ReactiveNosqlOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        NosqlParameterParameterAccessor accessor = new NosqlParameterParameterAccessor(this.method, parameters);
        NosqlQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String tableName = ((NosqlEntityMetadata)this.method.getEntityInformation()).getTableName();
        ReactiveNosqlQueryExecution execution = this.getExecution(accessor);
        return execution.execute(query, processor.getReturnedType().getDomainType(), tableName);
    }

    private ReactiveNosqlQueryExecution getExecution(NosqlParameterAccessor accessor) {
        NosqlEntityInformation entityInformation = ((NosqlEntityMetadata)this.method.getEntityInformation()).getNosqlEntityInformation();
        if (this.isDeleteQuery()) {
            return new ReactiveNosqlQueryExecution.DeleteExecution(this.operations, entityInformation);
        }
        if (this.isExistsQuery()) {
            return new ReactiveNosqlQueryExecution.ExistsExecution(this.operations, entityInformation);
        }
        if (this.isCountQuery()) {
            return new ReactiveNosqlQueryExecution.CountExecution(this.operations, entityInformation);
        }
        return new ReactiveNosqlQueryExecution.MultiEntityExecution(this.operations, entityInformation);
    }

    public NosqlQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract NosqlQuery createQuery(NosqlParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isCountQuery();
}

