/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.query;

import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class NosqlQuery {
    protected Sort sort = Sort.unsorted();
    protected Pageable pageable = Pageable.unpaged();
    protected Integer limit;
    protected boolean isCount;

    public NosqlQuery with(Sort sort) {
        if (sort.isSorted()) {
            this.sort = sort.and(this.sort);
        }
        return this;
    }

    public NosqlQuery with(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        this.pageable = pageable;
        return this;
    }

    public NosqlQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getLimit() {
        return this.limit != null && this.limit > 0 ? this.limit : (this.pageable.equals(Pageable.unpaged()) ? null : Integer.valueOf(this.pageable.getPageSize()));
    }

    public Sort getSort() {
        return this.sort;
    }

    public abstract String generateSql(String var1, Map<String, Object> var2, String var3);

    public NosqlQuery setCount(boolean isCount) {
        this.isCount = isCount;
        return this;
    }

    public boolean isCount() {
        return this.isCount;
    }
}

