/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.query;

import com.oracle.nosql.spring.data.core.query.CriteriaType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.NonNull;

public class Criteria {
    private Part part;
    private final CriteriaType type;
    private final List<Criteria> subCriteria;
    private boolean ignoreCase;
    private String subject;
    private List<Object> subjectValues;

    private Criteria(CriteriaType type) {
        this.type = type;
        this.subCriteria = new ArrayList<Criteria>();
    }

    public static Criteria getInstance(Part part, boolean isIgnorecase, @NonNull String subject, @NonNull List<Object> values) {
        Criteria criteria = new Criteria(CriteriaType.toCriteriaType(part.getType()));
        criteria.part = part;
        criteria.ignoreCase = isIgnorecase;
        criteria.subject = subject;
        criteria.subjectValues = values;
        return criteria;
    }

    public static Criteria getInstance(Part part, CriteriaType type, @NonNull Criteria left, @NonNull Criteria right) {
        Criteria criteria = new Criteria(type);
        criteria.subCriteria.add(left);
        criteria.subCriteria.add(right);
        criteria.part = part;
        return criteria;
    }

    public static Criteria getInstance(CriteriaType type) {
        return new Criteria(type);
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Object> getSubjectValues() {
        return this.subjectValues;
    }

    public CriteriaType getType() {
        return this.type;
    }

    public List<Criteria> getSubCriteria() {
        return this.subCriteria;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Part getPart() {
        return this.part;
    }
}

