/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core.convert;

import com.oracle.nosql.spring.data.core.mapping.BasicNosqlPersistentProperty;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentEntity;
import com.oracle.nosql.spring.data.core.mapping.NosqlPersistentProperty;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.nosql.driver.IndexExistsException;
import oracle.nosql.driver.IndexNotFoundException;
import oracle.nosql.driver.InvalidAuthorizationException;
import oracle.nosql.driver.JsonParseException;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.OperationNotSupportedException;
import oracle.nosql.driver.RequestTimeoutException;
import oracle.nosql.driver.ResourceExistsException;
import oracle.nosql.driver.ResourceLimitException;
import oracle.nosql.driver.RetryableException;
import oracle.nosql.driver.TableExistsException;
import oracle.nosql.driver.TableNotFoundException;
import oracle.nosql.driver.TableSizeException;
import oracle.nosql.driver.UnauthorizedException;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.JsonNullValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MappingNosqlConverter
implements EntityConverter<NosqlPersistentEntity<?>, NosqlPersistentProperty, Object, FieldValue>,
ApplicationContextAware {
    private static final String CLASS_FIELD_NAME = "#class";
    private static final Logger log = LoggerFactory.getLogger(MappingNosqlConverter.class);
    private final MappingContext<? extends NosqlPersistentEntity<?>, NosqlPersistentProperty> mappingContext;
    private GenericConversionService conversionService;
    private ApplicationContext applicationContext;
    private EntityInstantiators instantiators = new EntityInstantiators();

    public MappingNosqlConverter(@NonNull MappingContext<? extends NosqlPersistentEntity<?>, NosqlPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
        this.conversionService = new GenericConversionService();
    }

    public <E> NosqlPersistentProperty getIdProperty(@NonNull Class<E> entityClass) {
        NosqlPersistentEntity persistentEntity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata for entity type: " + entityClass.getName());
        }
        return (NosqlPersistentProperty)persistentEntity.getIdProperty();
    }

    @Nullable
    public <R> R read(@NonNull Class<R> type, @NonNull FieldValue nosqlRowValue) {
        return (R)this.convertFieldValueToObj(type, nosqlRowValue, true);
    }

    @Deprecated
    public void write(@Nullable Object sourceEntity, @Nullable FieldValue document) {
        throw new UnsupportedOperationException("The feature is not implemented yet");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @NonNull
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @NonNull
    public MappingContext<? extends NosqlPersistentEntity<?>, NosqlPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @NonNull
    private <T> ConvertingPropertyAccessor<T> getPropertyAccessor(T entity) {
        NosqlPersistentEntity entityInformation = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        Assert.notNull((Object)entityInformation, (String)"EntityInformation should not be null.");
        PersistentPropertyAccessor accessor = entityInformation.getPropertyAccessor(entity);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    public <T> MapValue convertObjToRow(T objectToSave, boolean skipSetId) {
        if (objectToSave == null) {
            return null;
        }
        NosqlPersistentEntity persistentEntity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(objectToSave.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + objectToSave.getClass().getName());
        }
        ConvertingPropertyAccessor<T> accessor = this.getPropertyAccessor(objectToSave);
        NosqlPersistentProperty idProperty = (NosqlPersistentProperty)persistentEntity.getIdProperty();
        MapValue row = new MapValue();
        MapValue valueMap = new MapValue();
        row.put("kv_json_", (FieldValue)valueMap);
        if (!skipSetId && idProperty != null) {
            row.put(idProperty.getName(), this.convertObjToFieldValue(accessor.getProperty((PersistentProperty)idProperty), idProperty, false));
        }
        Iterator iterator = persistentEntity.iterator();
        while (iterator.hasNext()) {
            NosqlPersistentProperty prop = (NosqlPersistentProperty)iterator.next();
            if (prop.equals(idProperty) || !prop.isWritable()) continue;
            Object value = accessor.getProperty((PersistentProperty)prop);
            this.convertObjToFieldValue(value, valueMap, prop);
        }
        return row;
    }

    private void convertObjToFieldValue(Object javaObj, MapValue valueMap, NosqlPersistentProperty prop) {
        FieldValue convertedValue = this.convertObjToFieldValue(javaObj, prop, false);
        valueMap.put(prop.getName(), convertedValue);
    }

    @Nullable
    public FieldValue convertObjToFieldValue(Object javaObj, @Nullable NosqlPersistentProperty prop, boolean isItemInCollection) {
        FieldValue convertedValue;
        if (javaObj == null) {
            return NullValue.getInstance();
        }
        NosqlPersistentProperty.TypeCode typeCode = BasicNosqlPersistentProperty.getCodeForSerialization(javaObj.getClass());
        switch (typeCode) {
            case STRING: {
                convertedValue = new StringValue((String)javaObj);
                break;
            }
            case INT: {
                convertedValue = new IntegerValue(((Integer)javaObj).intValue());
                break;
            }
            case LONG: {
                convertedValue = new LongValue(((Long)javaObj).longValue());
                break;
            }
            case FLOAT: {
                convertedValue = new DoubleValue((double)((Float)javaObj).floatValue());
                break;
            }
            case DOUBLE: {
                convertedValue = new DoubleValue(((Double)javaObj).doubleValue());
                break;
            }
            case BIGINTEGER: {
                convertedValue = new NumberValue(new BigDecimal((BigInteger)javaObj));
                break;
            }
            case BIGDECIMAL: {
                convertedValue = new NumberValue((BigDecimal)javaObj);
                break;
            }
            case BOOLEAN: {
                convertedValue = BooleanValue.getInstance((boolean)((Boolean)javaObj));
                break;
            }
            case BYTEARRAY: {
                convertedValue = new BinaryValue((byte[])javaObj);
                break;
            }
            case DATE: {
                convertedValue = new TimestampValue(((Date)javaObj).getTime());
                break;
            }
            case TIMESTAMP: {
                convertedValue = new TimestampValue((Timestamp)javaObj);
                break;
            }
            case INSTANT: {
                convertedValue = new TimestampValue(((Instant)javaObj).toEpochMilli());
                break;
            }
            case ENUM: {
                convertedValue = new StringValue(((Enum)javaObj).name());
                break;
            }
            case GEO_JSON_POINT: {
                Point point = (Point)javaObj;
                MapValue geoPoint = new MapValue();
                geoPoint.put(CLASS_FIELD_NAME, Point.class.getName());
                geoPoint.put("type", "point");
                geoPoint.put("coordinates", (FieldValue)new ArrayValue(2).add(point.getX()).add(point.getY()));
                convertedValue = geoPoint;
                break;
            }
            case GEO_JSON_POLYGON: {
                Polygon polygon = (Polygon)javaObj;
                MapValue geoPolygon = new MapValue();
                geoPolygon.put("type", "polygon");
                ArrayValue coordinates = new ArrayValue();
                polygon.forEach(p -> coordinates.add((FieldValue)new ArrayValue(2).add(p.getX()).add(p.getY())));
                geoPolygon.put("coordinates", (FieldValue)new ArrayValue(1).add((FieldValue)coordinates));
                convertedValue = geoPolygon;
                break;
            }
            case ARRAY: {
                if (!(javaObj instanceof Object[])) {
                    throw new IllegalStateException("Expected Object[] actual: " + javaObj.getClass().getName());
                }
                convertedValue = this.convertCollectionObjToFieldValue(Arrays.asList((Object[])javaObj), prop);
                break;
            }
            case COLLECTION: {
                if (!(javaObj instanceof Collection)) {
                    throw new IllegalStateException("Expected Collection<?> actual: " + javaObj.getClass().getName());
                }
                convertedValue = this.convertCollectionObjToFieldValue((Collection)javaObj, prop);
                break;
            }
            case FIELD_VALUE: {
                convertedValue = (FieldValue)javaObj;
                break;
            }
            case POJO: {
                Class expectedCls = prop != null ? (isItemInCollection ? prop.getActualType() : prop.getType()) : javaObj.getClass();
                convertedValue = this.convertPojoObjToFieldValue(javaObj, expectedCls);
                break;
            }
            default: {
                throw new RuntimeException("Simple type: " + (Object)((Object)typeCode) + " not supported.");
            }
        }
        return convertedValue;
    }

    private <T> FieldValue convertPojoObjToFieldValue(@NonNull T javaObj, Class<?> expectedCls) {
        NosqlPersistentEntity persistentEntity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(javaObj.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + javaObj.getClass().getName());
        }
        ConvertingPropertyAccessor<T> accessor = this.getPropertyAccessor(javaObj);
        MapValue valueMap = new MapValue();
        if (javaObj.getClass() != expectedCls) {
            valueMap.put(CLASS_FIELD_NAME, javaObj.getClass().getName());
        }
        Iterator iterator = persistentEntity.iterator();
        while (iterator.hasNext()) {
            NosqlPersistentProperty prop = (NosqlPersistentProperty)iterator.next();
            if (!prop.isWritable()) continue;
            Object propValue = accessor.getProperty((PersistentProperty)prop);
            this.convertObjToFieldValue(propValue, valueMap, prop);
        }
        return valueMap;
    }

    private FieldValue convertCollectionObjToFieldValue(Collection<?> javaCollection, @Nullable NosqlPersistentProperty prop) {
        if (prop != null) {
            Assert.isTrue((boolean)prop.isCollectionLike(), (String)"PersistedProperty required to be list like.");
        }
        ArrayValue arrayValue = new ArrayValue(javaCollection.size());
        for (Object element : javaCollection) {
            arrayValue.add(this.convertObjToFieldValue(element, prop, true));
        }
        return arrayValue;
    }

    public <E, ID> E setId(E objectToSave, FieldValue id) {
        NosqlPersistentEntity persistentEntity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(objectToSave.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + objectToSave.getClass().getName());
        }
        ConvertingPropertyAccessor<E> accessor = this.getPropertyAccessor(objectToSave);
        NosqlPersistentProperty idProperty = (NosqlPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null) {
            Object idValue = this.convertFieldValueToObject(id, idProperty);
            accessor.setProperty((PersistentProperty)idProperty, idValue);
        }
        return objectToSave;
    }

    private <E> E convertFieldValueToObj(Class<?> type, FieldValue nosqlValue, boolean isRoot) {
        if (nosqlValue == null || nosqlValue.isNull() || nosqlValue.isJsonNull() || nosqlValue.isEMPTY()) {
            return null;
        }
        FieldValue.Type nosqlType = nosqlValue.getType();
        switch (nosqlType) {
            case INTEGER: {
                return (E)Integer.valueOf(nosqlValue.asInteger().getValue());
            }
            case LONG: {
                return (E)Long.valueOf(nosqlValue.asLong().getValue());
            }
            case DOUBLE: {
                return (E)Double.valueOf(nosqlValue.asDouble().getValue());
            }
            case NUMBER: {
                return (E)nosqlValue.asNumber().getValue();
            }
            case STRING: {
                return (E)nosqlValue.asString().getValue();
            }
            case TIMESTAMP: {
                return (E)nosqlValue.asTimestamp().getString();
            }
            case BOOLEAN: {
                return (E)Boolean.valueOf(nosqlValue.asBoolean().getValue());
            }
            case BINARY: {
                return this.convertFieldValueToByteArray(nosqlValue, type);
            }
            case EMPTY: 
            case NULL: 
            case JSON_NULL: {
                return null;
            }
            case ARRAY: {
                NosqlPersistentProperty.TypeCode entityCode = BasicNosqlPersistentProperty.getCodeForDeserialization(type);
                switch (entityCode) {
                    case BYTEARRAY: {
                        return this.convertFieldValueToByteArray(nosqlValue, type);
                    }
                    case COLLECTION: 
                    case OBJECT: {
                        return (E)this.convertArrayValueToCollection(nosqlValue);
                    }
                    case ARRAY: {
                        List<Object> list = this.convertArrayValueToCollection(nosqlValue);
                        return (E)list.toArray();
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + nosqlValue.getType().name() + " to " + type.getName() + ".");
            }
            case MAP: {
                E entityObj = null;
                NosqlPersistentEntity entity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(type);
                if (isRoot) {
                    if (type == MapValue.class) {
                        return (E)nosqlValue.asMap();
                    }
                    FieldValue idFieldValue = null;
                    if (entity.getIdProperty() != null) {
                        idFieldValue = nosqlValue.asMap().get(((NosqlPersistentProperty)entity.getIdProperty()).getName());
                    }
                    if (nosqlValue.asMap().get("kv_json_") != null) {
                        MapValue jsonValue = nosqlValue.asMap().get("kv_json_").asMap();
                        NosqlPersistentEntity<E> clsEntity = this.updateEntity(entity, this.getInstanceClass(jsonValue));
                        entityObj = this.getNewInstance(clsEntity, nosqlValue.asMap(), jsonValue);
                        if (idFieldValue != null) {
                            this.setId(entityObj, idFieldValue);
                        }
                        this.setPojoProperties(clsEntity, entityObj, jsonValue);
                    }
                } else {
                    MapValue mapValue = nosqlValue.asMap();
                    String instClsStr = this.getInstanceClass(mapValue);
                    if (Point.class.getName().equals(instClsStr)) {
                        if (mapValue.get("coordinates") != null && mapValue.get("coordinates").getType() == FieldValue.Type.ARRAY && mapValue.get("coordinates").asArray().size() >= 2 && mapValue.get("coordinates").asArray().get(0) != null && mapValue.get("coordinates").asArray().get(1) != null && mapValue.get("coordinates").asArray().get(0).isNumeric() && mapValue.get("coordinates").asArray().get(1).isNumeric()) {
                            ArrayValue coord = mapValue.get("coordinates").asArray();
                            return (E)new Point(coord.get(0).getDouble(), coord.get(1).getDouble());
                        }
                        throw new IllegalArgumentException("Unexpected GeoJson point representation: " + mapValue);
                    }
                    if (Polygon.class.getName().equals(instClsStr)) {
                        if (mapValue.get("coordinates") != null && mapValue.get("coordinates").getType() == FieldValue.Type.ARRAY && mapValue.get("coordinates").asArray().get(0) != null && mapValue.get("coordinates").asArray().get(0).getType() == FieldValue.Type.ARRAY && mapValue.get("coordinates").asArray().get(0).asArray() != null && mapValue.get("coordinates").asArray().get(0).asArray().get(0) != null && mapValue.get("coordinates").asArray().get(0).asArray().get(0).getType() == FieldValue.Type.ARRAY) {
                            ArrayValue coord = mapValue.get("coordinates").asArray().get(0).asArray().get(0).asArray();
                            ArrayList points = new ArrayList(coord.size());
                            coord.forEach(fv -> {
                                if (fv == null || fv.getType() != FieldValue.Type.ARRAY || fv.asArray().size() < 2 || fv.asArray().get(0) == null || fv.asArray().get(1) == null || !fv.asArray().get(0).isNumeric() || !fv.asArray().get(1).isNumeric()) {
                                    throw new IllegalArgumentException("Unexpected GeoJson point representation: " + fv);
                                }
                                points.add(new Point(fv.asArray().get(0).getDouble(), fv.asArray().get(1).getDouble()));
                            });
                            return (E)new Polygon(points);
                        }
                        throw new IllegalArgumentException("Unexpected GeoJson polygon representation: " + mapValue);
                    }
                    NosqlPersistentEntity<E> clsEntity = this.updateEntity(entity, instClsStr);
                    entityObj = this.getNewInstance(clsEntity, null, mapValue);
                    this.setPojoProperties(clsEntity, entityObj, mapValue);
                }
                return entityObj;
            }
        }
        throw new IllegalStateException("Unknown FieldValue.Type: " + nosqlType.name());
    }

    private <E> E convertFieldValueToByteArray(FieldValue nosqlValue, Class<?> type) {
        switch (nosqlValue.getType()) {
            case BINARY: {
                return (E)nosqlValue.asBinary().getValue();
            }
            case STRING: {
                return (E)BinaryValue.decodeBase64((String)nosqlValue.asString().getValue());
            }
        }
        throw new IllegalArgumentException("Conversion unknown from: " + nosqlValue.getType().name() + " to " + type.getName() + ".");
    }

    private <E> NosqlPersistentEntity<E> updateEntity(NosqlPersistentEntity<E> entity, String instanceClsName) {
        block4: {
            if (!(instanceClsName == null || entity != null && entity.getType().getName().equals(instanceClsName))) {
                try {
                    Class<?> instanceCls = Class.forName(instanceClsName);
                    if (instanceCls != null && (entity == null || entity.getType().isAssignableFrom(instanceCls))) {
                        entity = (NosqlPersistentEntity)this.mappingContext.getPersistentEntity(instanceCls);
                    }
                }
                catch (Exception cnf) {
                    if (entity != null) break block4;
                    throw new IllegalArgumentException("Class '" + instanceClsName + "' couldn't be found and no entity hint available.");
                }
            }
        }
        return entity;
    }

    private String getInstanceClass(MapValue mapValue) {
        FieldValue clsField;
        if (mapValue != null && (clsField = mapValue.get(CLASS_FIELD_NAME)) != null && clsField.getType() == FieldValue.Type.STRING) {
            return clsField.asString().getValue();
        }
        return null;
    }

    private List<Object> convertArrayValueToCollection(FieldValue nosqlValue) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FieldValue item : nosqlValue.asArray()) {
            list.add(this.convertFieldValueToObj(Object.class, item, false));
        }
        return list;
    }

    private <R> R getNewInstance(final NosqlPersistentEntity<R> entity, final MapValue rootFieldValue, final @NonNull MapValue jsonValue) {
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        ParameterValueProvider<NosqlPersistentProperty> paramProvider = new ParameterValueProvider<NosqlPersistentProperty>(){

            public <T> T getParameterValue(@NonNull PreferredConstructor.Parameter<T, NosqlPersistentProperty> parameter) {
                FieldValue value;
                String paramName = parameter.getName();
                NosqlPersistentProperty prop = (NosqlPersistentProperty)entity.getPersistentProperty(paramName);
                if (rootFieldValue == null) {
                    value = jsonValue.get(paramName);
                } else if (prop.isIdProperty()) {
                    value = rootFieldValue.get(paramName);
                } else {
                    value = jsonValue.get(paramName);
                    if (value == null) {
                        value = rootFieldValue.get(paramName);
                    }
                }
                return (T)MappingNosqlConverter.this.convertFieldValueToObject(value, prop);
            }
        };
        try {
            return (R)instantiator.createInstance(entity, (ParameterValueProvider)paramProvider);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to instantiate entity type: " + entity.getType() + ". Check available public constructors.", e);
        }
    }

    private <E> void setPojoProperties(NosqlPersistentEntity<E> entity, E entityObj, MapValue jsonValue) {
        if (jsonValue == null) {
            return;
        }
        ConvertingPropertyAccessor<E> accessor = this.getPropertyAccessor(entityObj);
        for (Map.Entry entry : jsonValue.entrySet()) {
            NosqlPersistentProperty prop = (NosqlPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (prop == null || !prop.isWritable()) continue;
            Object value = this.convertFieldValueToObject((FieldValue)entry.getValue(), prop);
            accessor.setProperty((PersistentProperty)prop, value);
        }
    }

    @Nullable
    private <T> T convertFieldValueToObject(FieldValue fieldValue, @Nullable NosqlPersistentProperty prop) {
        Object objValue;
        if (fieldValue == null) {
            return null;
        }
        NosqlPersistentProperty.TypeCode objClsTypeCode = prop == null ? NosqlPersistentProperty.TypeCode.OBJECT : prop.getTypeCode();
        block0 : switch (fieldValue.getType()) {
            case NULL: 
            case JSON_NULL: {
                objValue = null;
                break;
            }
            case STRING: {
                switch (objClsTypeCode) {
                    case STRING: {
                        objValue = fieldValue.asString().getValue();
                        break block0;
                    }
                    case BYTEARRAY: {
                        objValue = BinaryValue.decodeBase64((String)fieldValue.asString().getValue());
                        break block0;
                    }
                    case DATE: {
                        objValue = new Date(fieldValue.asTimestamp().getValue().getTime());
                        break block0;
                    }
                    case TIMESTAMP: {
                        objValue = fieldValue.asTimestamp().getValue();
                        break block0;
                    }
                    case INSTANT: {
                        objValue = fieldValue.asTimestamp().getValue().toInstant();
                        break block0;
                    }
                    case ENUM: {
                        String strValue = fieldValue.asString().getValue();
                        objValue = Enum.valueOf(prop.getType(), strValue.trim().toUpperCase());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case INTEGER: {
                int i = fieldValue.asInteger().getValue();
                switch (objClsTypeCode) {
                    case INT: {
                        objValue = i;
                        break block0;
                    }
                    case STRING: {
                        objValue = String.valueOf(i);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case LONG: {
                long l = fieldValue.asLong().getValue();
                switch (objClsTypeCode) {
                    case LONG: {
                        objValue = l;
                        break block0;
                    }
                    case STRING: {
                        objValue = String.valueOf(l);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case DOUBLE: {
                switch (objClsTypeCode) {
                    case DOUBLE: {
                        objValue = fieldValue.asDouble().getValue();
                        break block0;
                    }
                    case FLOAT: {
                        objValue = Float.valueOf((float)fieldValue.asDouble().getValue());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case NUMBER: {
                BigDecimal decimal = fieldValue.asNumber().getNumber();
                switch (objClsTypeCode) {
                    case BIGDECIMAL: {
                        objValue = decimal;
                        break block0;
                    }
                    case BIGINTEGER: {
                        objValue = decimal.toBigInteger();
                        break block0;
                    }
                    case STRING: {
                        objValue = decimal.toString();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case BOOLEAN: {
                boolean boolVal = fieldValue.asBoolean().getValue();
                switch (objClsTypeCode) {
                    case BOOLEAN: {
                        objValue = boolVal;
                        break block0;
                    }
                    case STRING: {
                        objValue = Boolean.valueOf(boolVal).toString();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case TIMESTAMP: {
                Timestamp timestamp = fieldValue.asTimestamp().getValue();
                switch (objClsTypeCode) {
                    case DATE: {
                        objValue = new Date(timestamp.getTime());
                        break block0;
                    }
                    case TIMESTAMP: {
                        objValue = new Timestamp(timestamp.getTime());
                        break block0;
                    }
                    case INSTANT: {
                        objValue = Instant.ofEpochMilli(timestamp.getTime());
                        break block0;
                    }
                    case STRING: {
                        objValue = timestamp.toString();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case BINARY: {
                byte[] baVal = fieldValue.asBinary().getValue();
                switch (objClsTypeCode) {
                    case BYTEARRAY: {
                        objValue = baVal;
                        break block0;
                    }
                    case STRING: {
                        objValue = Arrays.toString(baVal);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                Class actualType = prop == null ? Object.class : prop.getActualType();
                for (FieldValue item : fieldValue.asArray()) {
                    list.add(this.convertFieldValueToObj(actualType, item, false));
                }
                switch (objClsTypeCode) {
                    case COLLECTION: {
                        Class propType = prop.getRawType();
                        if (propType.isAssignableFrom(ArrayList.class)) {
                            objValue = list;
                            break block0;
                        }
                        if (propType.isAssignableFrom(HashSet.class)) {
                            objValue = new HashSet<Object>(list);
                            break block0;
                        }
                        if (propType.isAssignableFrom(TreeSet.class)) {
                            objValue = new TreeSet<Object>(list);
                            break block0;
                        }
                        objValue = list;
                        break block0;
                    }
                    case ARRAY: {
                        objValue = MappingNosqlConverter.listToArray(list, prop.getActualType());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Conversion unknown from: " + fieldValue.getType().name() + " to " + (Object)((Object)objClsTypeCode) + ".");
            }
            case MAP: {
                Class cls = prop == null ? Object.class : prop.getType();
                objValue = this.convertFieldValueToObj(cls, fieldValue, false);
                break;
            }
            case EMPTY: {
                throw new IllegalStateException("Invalid type: " + fieldValue.getType().name());
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + fieldValue.getType());
            }
        }
        return (T)objValue;
    }

    private static <E> E[] listToArray(List<Object> list, Class<E> cls) {
        int s;
        if (list == null || (s = list.size()) < 1) {
            return null;
        }
        Object[] temp = (Object[])Array.newInstance(cls, s);
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            if (item == null) continue;
            if (cls.isAssignableFrom(item.getClass())) {
                Array.set(temp, i, item);
                continue;
            }
            throw new IllegalArgumentException("Cannot assign item of class " + item.getClass().getName() + " to array of type: " + cls.getName());
        }
        return temp;
    }

    public <ID> MapValue convertIdToPrimaryKey(String idColumnName, ID id) {
        if (id == null) {
            return null;
        }
        MapValue row = new MapValue();
        row.put(idColumnName, this.convertObjToFieldValue(id, null, false));
        return row;
    }

    public static String toNosqlSqlType(Object fromPropertyValue) {
        if (fromPropertyValue == null || fromPropertyValue instanceof JsonNullValue || fromPropertyValue instanceof NullValue) {
            throw new IllegalArgumentException("Param value can not be a null value.");
        }
        if (fromPropertyValue instanceof String || fromPropertyValue instanceof StringValue) {
            return "String";
        }
        if (fromPropertyValue instanceof Integer || fromPropertyValue instanceof IntegerValue) {
            return "Integer";
        }
        if (fromPropertyValue instanceof Long || fromPropertyValue instanceof LongValue) {
            return "Long";
        }
        if (fromPropertyValue instanceof BigDecimal || fromPropertyValue instanceof BigInteger || fromPropertyValue instanceof NumberValue) {
            return "Number";
        }
        if (fromPropertyValue instanceof Float || fromPropertyValue instanceof Double || fromPropertyValue instanceof DoubleValue) {
            return "Double";
        }
        if (fromPropertyValue instanceof Boolean || fromPropertyValue instanceof BooleanValue) {
            return "Boolean";
        }
        if (fromPropertyValue instanceof byte[] || fromPropertyValue instanceof BinaryValue) {
            return "Binary";
        }
        if (fromPropertyValue instanceof Date || fromPropertyValue instanceof Instant || fromPropertyValue instanceof TimestampValue) {
            return "Timestamp";
        }
        if (fromPropertyValue instanceof List) {
            List list = (List)fromPropertyValue;
            if (list.size() > 0) {
                String nosqlType = MappingNosqlConverter.toNosqlSqlType(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    if (nosqlType.equals(MappingNosqlConverter.toNosqlSqlType(list.get(i)))) continue;
                    log.debug("Not all entries in the array map to the same type. Will use ARRAY(ANY).");
                    return "ARRAY(ANY)";
                }
                return "ARRAY(" + nosqlType + ")";
            }
            return "ARRAY(ANY)";
        }
        if (fromPropertyValue instanceof Object[]) {
            Object[] arr = (Object[])fromPropertyValue;
            if (arr != null || arr.length > 0) {
                String nosqlType = MappingNosqlConverter.toNosqlSqlType(Array.get(arr, 0));
                for (int i = 1; i < arr.length; ++i) {
                    if (nosqlType.equals(MappingNosqlConverter.toNosqlSqlType(Array.get(arr, i)))) continue;
                    log.debug("Not all entries in the array map to the same type. Will use ARRAY(ANY).");
                    return "ARRAY(ANY)";
                }
                return "ARRAY(" + nosqlType + ")";
            }
            return "ARRAY(ANY)";
        }
        if (fromPropertyValue instanceof Point || fromPropertyValue instanceof Polygon) {
            return "JSON";
        }
        if (fromPropertyValue instanceof ArrayValue) {
            return "ARRAY(ANY)";
        }
        if (fromPropertyValue instanceof MapValue) {
            return "MAP(ANY)";
        }
        throw new IllegalArgumentException("Unsupported type: " + fromPropertyValue.getClass());
    }

    public static RuntimeException convert(NoSQLException nse) {
        if (nse instanceof RequestTimeoutException) {
            return new QueryTimeoutException(nse.getMessage(), nse.getCause());
        }
        if (nse instanceof RetryableException) {
            return new TransientDataAccessResourceException(nse.getMessage(), nse.getCause());
        }
        if (nse instanceof InvalidAuthorizationException || nse instanceof UnauthorizedException) {
            return new PermissionDeniedDataAccessException(nse.getMessage(), nse.getCause());
        }
        if (nse instanceof IndexExistsException || nse instanceof IndexNotFoundException || nse instanceof JsonParseException || nse instanceof OperationNotSupportedException || nse instanceof ResourceExistsException || nse instanceof TableExistsException || nse instanceof TableNotFoundException) {
            return new InvalidDataAccessApiUsageException(nse.getMessage(), nse.getCause());
        }
        if (nse instanceof ResourceLimitException || nse instanceof TableSizeException) {
            return new InvalidDataAccessResourceUsageException(nse.getMessage(), nse.getCause());
        }
        log.debug("Unknown exception to convert: " + nse.getClass().getName());
        return nse;
    }
}

