/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.core;

import com.oracle.nosql.spring.data.NosqlDbFactory;
import com.oracle.nosql.spring.data.config.AbstractNosqlConfiguration;
import com.oracle.nosql.spring.data.config.NosqlDbConfig;
import com.oracle.nosql.spring.data.core.IterableUtil;
import com.oracle.nosql.spring.data.core.ReactiveNosqlOperations;
import com.oracle.nosql.spring.data.core.convert.MappingNosqlConverter;
import com.oracle.nosql.spring.data.core.query.NosqlQuery;
import com.oracle.nosql.spring.data.repository.support.NosqlEntityInformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.TableNotFoundException;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.util.LruCache;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveNosqlTemplate
implements ReactiveNosqlOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReactiveNosqlTemplate.class);
    private final NosqlDbFactory nosqlDbFactory;
    private final NoSQLHandle nosqlClient;
    private final MappingNosqlConverter mappingNosqlConverter;
    private LruCache<String, PreparedStatement> psCache;

    public static ReactiveNosqlTemplate create(NosqlDbConfig nosqlDBConfig) throws ClassNotFoundException {
        Assert.notNull((Object)nosqlDBConfig, (String)"NosqlDbConfig should not be null.");
        return ReactiveNosqlTemplate.create(new NosqlDbFactory(nosqlDBConfig));
    }

    public static ReactiveNosqlTemplate create(NosqlDbFactory nosqlDbFactory) throws ClassNotFoundException {
        Assert.notNull((Object)nosqlDbFactory, (String)"NosqlDbFactory should not be null.");
        AbstractNosqlConfiguration configuration = new AbstractNosqlConfiguration(){};
        return new ReactiveNosqlTemplate(nosqlDbFactory, configuration.mappingNosqlConverter());
    }

    public ReactiveNosqlTemplate(NosqlDbFactory nosqlDbFactory, MappingNosqlConverter mappingNosqlConverter) {
        Assert.notNull((Object)nosqlDbFactory, (String)"NosqlDbFactory should not be null.");
        this.nosqlDbFactory = nosqlDbFactory;
        this.nosqlClient = nosqlDbFactory.getNosqlClient();
        this.mappingNosqlConverter = mappingNosqlConverter;
        this.psCache = new LruCache(nosqlDbFactory.getQueryCacheCapacity(), nosqlDbFactory.getQueryCacheLifetime());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public String getTableName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return new NosqlEntityInformation(domainClass).getTableName();
    }

    @Override
    public Mono<Boolean> createTableIfNotExists(NosqlEntityInformation<?, ?> information) {
        Assert.notNull(information, (String)"Entity information should not be null");
        return Mono.just((Object)this.createTable(information));
    }

    @Override
    public Mono<Boolean> dropTableIfExists(String tableName) {
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        String sql = String.format("DROP TABLE IF EXISTS %s ", tableName);
        TableRequest tableReq = new TableRequest().setStatement(sql);
        TableResult tableRes = this.doTableRequest(null, tableReq);
        return Mono.just((Object)(tableRes.getTableState() == TableResult.State.DROPPED || tableRes.getTableState() == TableResult.State.DROPPING ? 1 : 0));
    }

    @Override
    public <T, ID> Flux<T> findAll(NosqlEntityInformation<T, ID> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        String sql = String.format("SELECT * FROM %s t", tableName);
        return Flux.fromIterable(this.runQuery(sql, entityInformation)).map(mv -> this.getConverter().read(entityInformation.getJavaType(), (FieldValue)mv));
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        return this.findAll(this.getNosqlEntityInformation(entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        return this.findById(this.getNosqlEntityInformation(entityClass), id);
    }

    @Override
    public <T, ID> Mono<T> findById(NosqlEntityInformation<T, ID> entityInformation, ID id) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"tableName should not be null, empty or only whitespaces");
        Assert.notNull(id, (String)"id should not be null");
        log.debug("execute findById in table {}", (Object)tableName);
        Class entityClass = entityInformation.getJavaType();
        String idColumName = this.mappingNosqlConverter.getIdProperty(entityClass).getName();
        MapValue row = this.mappingNosqlConverter.convertIdToPrimaryKey(idColumName, id);
        GetResult getRes = this.doGet(entityInformation, row);
        Object res = this.mappingNosqlConverter.read(entityClass, (FieldValue)getRes.getValue());
        return Mono.justOrEmpty(res);
    }

    private GetResult doGet(NosqlEntityInformation<?, ?> entityInformation, MapValue primaryKey) {
        GetResult getRes;
        GetRequest getReq = new GetRequest().setTableName(entityInformation.getTableName()).setKey(primaryKey);
        if (entityInformation.getTimeout() > 0) {
            getReq.setTimeout(entityInformation.getTimeout());
        }
        getReq.setConsistency(entityInformation.getConsistency());
        try {
            getRes = this.nosqlClient.get(getReq);
        }
        catch (NoSQLException nse) {
            log.error("Get: table: {} key: {}", (Object)getReq.getTableName(), (Object)primaryKey);
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        assert (getRes != null);
        return getRes;
    }

    @Override
    public <T> Mono<T> insert(T objectToSave) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return this.insert(this.getNosqlEntityInformation(objectToSave.getClass()), objectToSave);
    }

    @Override
    public <S, ID> Mono<S> insert(NosqlEntityInformation<?, ID> entityInformation, S objectToSave) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"tableName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        log.debug("execute insert in table {}", (Object)tableName);
        MapValue row = this.mappingNosqlConverter.convertObjToRow(objectToSave, entityInformation.isAutoGeneratedId());
        PutResult putRes = this.doPut(row, entityInformation, false);
        if (entityInformation.isAutoGeneratedId()) {
            FieldValue id = putRes.getGeneratedValue();
            objectToSave = this.mappingNosqlConverter.setId(objectToSave, id);
        }
        return Mono.just(objectToSave);
    }

    private <T, ID> NosqlEntityInformation<T, ID> getNosqlEntityInformation(Class<T> domainClass) {
        return new NosqlEntityInformation(domainClass);
    }

    private PutResult doPut(MapValue row, NosqlEntityInformation<?, ?> entityInformation, boolean ifPresent) {
        PutResult putRes;
        block9: {
            PutRequest putReq = new PutRequest().setTableName(entityInformation.getTableName()).setValue(row);
            if (ifPresent) {
                putReq.setOption(PutRequest.Option.IfPresent);
            }
            if (entityInformation.isAutoGeneratedId()) {
                putReq.setReturnRow(true);
            }
            if (entityInformation.getTimeout() > 0) {
                putReq.setTimeout(entityInformation.getTimeout());
            }
            try {
                try {
                    putRes = this.nosqlClient.put(putReq);
                }
                catch (TableNotFoundException tnfe) {
                    if (entityInformation.isAutoCreateTable()) {
                        this.createTable(entityInformation);
                        putRes = this.nosqlClient.put(putReq);
                        break block9;
                    }
                    throw tnfe;
                }
            }
            catch (NoSQLException nse) {
                log.error("Put: table: {} key: {}", (Object)putReq.getTableName(), (Object)row.get(entityInformation.getIdColumnName()));
                log.error(nse.getMessage());
                throw MappingNosqlConverter.convert(nse);
            }
        }
        assert (putRes != null);
        return putRes;
    }

    private boolean createTable(NosqlEntityInformation<?, ?> entityInformation) {
        String idColName = entityInformation.getIdField().getName();
        String idColType = entityInformation.getIdNosqlType().toString();
        if (entityInformation.getIdNosqlType() == FieldValue.Type.TIMESTAMP) {
            idColType = idColType + "(" + this.nosqlDbFactory.getTimestampPrecision() + ")";
        }
        String tableName = entityInformation.getTableName();
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s (%s %s %s, kv_json_ JSON, PRIMARY KEY( %s ))", tableName, idColName, idColType, entityInformation.isAutoGeneratedId() ? "GENERATED ALWAYS as IDENTITY (NO CYCLE)" : "", idColName);
        TableRequest tableReq = new TableRequest().setStatement(sql).setTableLimits(entityInformation.getTableLimits());
        TableResult tableRes = this.doTableRequest(entityInformation, tableReq);
        TableResult.State tableState = tableRes.getTableState();
        return tableState == TableResult.State.ACTIVE;
    }

    private TableResult doTableRequest(NosqlEntityInformation<?, ?> entityInformation, TableRequest tableReq) {
        TableResult tableRes;
        if (entityInformation != null && entityInformation.getTimeout() > 0) {
            tableReq.setTimeout(entityInformation.getTimeout());
        }
        try {
            log.debug("DDL: {}", (Object)tableReq.getStatement());
            tableRes = this.nosqlClient.doTableRequest(tableReq, this.nosqlDbFactory.getTableReqTimeout(), this.nosqlDbFactory.getTableReqPollInterval());
        }
        catch (NoSQLException nse) {
            log.error("DDL: {}", (Object)tableReq.getStatement());
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        return tableRes;
    }

    @Override
    public <T> Mono<T> update(T object) {
        Assert.notNull(object, (String)"entity should not be null");
        return this.update(this.getNosqlEntityInformation(object.getClass()), object);
    }

    @Override
    public <S, ID> Mono<S> update(NosqlEntityInformation<?, ID> entityInformation, S object) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"object should not be null");
        log.debug("execute update in table {}", (Object)tableName);
        MapValue row = this.mappingNosqlConverter.convertObjToRow(object, false);
        this.doUpdate(tableName, row, entityInformation);
        return Mono.just(object);
    }

    private <T, ID> void doUpdate(String tableName, MapValue row, NosqlEntityInformation<T, ID> entityInformation) {
        if (entityInformation.isAutoGeneratedId()) {
            String idColumnName = entityInformation.getIdColumnName();
            String sql = String.format("DECLARE $id %s; $json JSON; UPDATE %s t SET t.kv_json_ = $json WHERE t.%s = $id", entityInformation.getIdNosqlType().name(), tableName, idColumnName);
            HashMap<String, FieldValue> params = new HashMap<String, FieldValue>();
            params.put("$id", row.get(idColumnName));
            params.put("$json", row.get("kv_json_"));
            this.runQueryNosqlParams(entityInformation, sql, params).iterator().next();
        } else {
            this.doPut(row, entityInformation, true);
        }
    }

    @Override
    public <ID> Mono<Void> deleteById(NosqlEntityInformation<?, ID> entityInformation, ID id) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"tableName should not be null, empty or only whitespaces");
        Assert.notNull(id, (String)"id should not be null");
        log.debug("execute deleteById in table {}", (Object)tableName);
        String idColumName = this.mappingNosqlConverter.getIdProperty(entityInformation.getJavaType()).getName();
        MapValue row = this.mappingNosqlConverter.convertIdToPrimaryKey(idColumName, id);
        this.doDelete(entityInformation, row);
        return Mono.empty();
    }

    private DeleteResult doDelete(NosqlEntityInformation<?, ?> entityInformation, MapValue primaryKey) {
        DeleteResult delRes;
        DeleteRequest delReq = new DeleteRequest().setTableName(entityInformation.getTableName()).setKey(primaryKey);
        if (entityInformation.getTimeout() > 0) {
            delReq.setTimeout(entityInformation.getTimeout());
        }
        try {
            delRes = this.nosqlClient.delete(delReq);
        }
        catch (NoSQLException nse) {
            log.error("Delete: table: {} key: {}", (Object)delReq.getTableName(), (Object)primaryKey);
            log.error(nse.getMessage());
            throw MappingNosqlConverter.convert(nse);
        }
        assert (delRes != null);
        return delRes;
    }

    @Override
    public Mono<Void> deleteAll(NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String sql = String.format("DELETE FROM %s ", entityInformation.getTableName());
        this.runQuery(sql, entityInformation).iterator().next();
        return Mono.empty();
    }

    @Override
    public <T, ID> Flux<T> delete(NosqlQuery query, NosqlEntityInformation<T, ID> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        return this.executeQuery(query, entityInformation).map(e -> {
            this.deleteById(entityInformation, entityInformation.getId(e));
            return e;
        });
    }

    @Override
    public <T> Flux<T> find(NosqlQuery query, NosqlEntityInformation<T, ?> entityInformation) {
        return this.executeQuery(query, entityInformation);
    }

    @Override
    public Mono<Boolean> exists(NosqlQuery query, NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        return this.executeQuery(query, entityInformation).hasElements();
    }

    @Override
    public <ID> Mono<Boolean> existsById(NosqlEntityInformation<?, ID> entityInformation, ID id) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"tableName should not be null, empty or only whitespaces");
        Assert.notNull(id, (String)"id should not be null");
        log.debug("execute existsById in table {}", (Object)tableName);
        String idColumName = this.mappingNosqlConverter.getIdProperty(entityInformation.getJavaType()).getName();
        MapValue row = this.mappingNosqlConverter.convertIdToPrimaryKey(idColumName, id);
        GetResult getRes = this.doGet(entityInformation, row);
        return Mono.just((Object)(getRes.getValue() != null ? 1 : 0));
    }

    @Override
    public Mono<Long> count(NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        String sql = String.format("SELECT count(*) FROM %s ", tableName);
        log.debug("count(" + tableName + "): SQL: " + sql);
        Iterable<MapValue> res = this.runQuery(sql, entityInformation);
        Assert.isTrue((res != null && res.iterator() != null ? 1 : 0) != 0, (String)"Result of a count query should not be null and should have a non null iterator.");
        Iterator<MapValue> iterator = res.iterator();
        Assert.isTrue((boolean)iterator.hasNext(), (String)"Result of count query iterator should have 1 result.");
        Collection values = iterator.next().values();
        Assert.isTrue((values.size() == 1 ? 1 : 0) != 0, (String)"Results of a count query collection should have 1 result.");
        FieldValue countField = (FieldValue)values.iterator().next();
        Assert.isTrue((countField != null && countField.getType() == FieldValue.Type.LONG ? 1 : 0) != 0, (String)"Result of a count query should be of type LONG.");
        return Mono.just((Object)countField.asLong().getValue());
    }

    @Override
    public Mono<Long> count(NosqlQuery query, NosqlEntityInformation<?, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces");
        Assert.isTrue((boolean)query.isCount(), (String)"Query must be a count projection query.");
        return this.executeMapValueQuery(query, entityInformation).elementAt(0).map(mv -> {
            Assert.isTrue((mv != null && mv.values() != null ? 1 : 0) != 0, (String)"Count query must return at least one value.");
            FieldValue countField = (FieldValue)mv.values().iterator().next();
            Assert.notNull((Object)countField, (String)"Results of a count query collection should have 1 result.");
            Assert.isTrue((countField != null && countField.getType() == FieldValue.Type.LONG ? 1 : 0) != 0, (String)"Result of a count query should be of type LONG.");
            return countField.asLong().getValue();
        });
    }

    @Override
    public MappingNosqlConverter getConverter() {
        return this.mappingNosqlConverter;
    }

    @Override
    public <T, ID> Flux<T> findAllById(NosqlEntityInformation<T, ID> entityInformation, Publisher<ID> idStream) {
        return Flux.from(idStream).flatMap(id -> this.findById(entityInformation, id));
    }

    private Iterable<MapValue> runQuery(String query, NosqlEntityInformation<?, ?> entityInformation) {
        return this.runQueryNosqlParams(entityInformation, query, null);
    }

    private Iterable<MapValue> runQueryNosqlParams(NosqlEntityInformation<?, ?> entityInformation, String query, Map<String, FieldValue> nosqlParams) {
        PreparedStatement preparedStatement = this.getPreparedStatement(entityInformation, query);
        if (nosqlParams != null) {
            for (Map.Entry<String, FieldValue> e : nosqlParams.entrySet()) {
                preparedStatement.setVariable(e.getKey(), e.getValue());
            }
        }
        QueryRequest qReq = new QueryRequest().setPreparedStatement(preparedStatement);
        if (entityInformation.getTimeout() > 0) {
            qReq.setTimeout(entityInformation.getTimeout());
        }
        qReq.setConsistency(entityInformation.getConsistency());
        log.debug("Q: {}", (Object)query);
        Iterable<MapValue> results = this.doQuery(qReq);
        return results;
    }

    public <T> Flux<T> executeQuery(NosqlQuery query, NosqlEntityInformation<T, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        Class entityClass = entityInformation.getJavaType();
        return this.executeMapValueQuery(query, entityInformation).map(d -> this.getConverter().read(entityClass, (FieldValue)d));
    }

    public <T> Flux<MapValue> executeMapValueQuery(NosqlQuery query, NosqlEntityInformation<T, ?> entityInformation) {
        Assert.notNull(entityInformation, (String)"EntityInformation should not be null");
        String tableName = entityInformation.getTableName();
        Assert.hasText((String)tableName, (String)"Table name should not be null, empty or only whitespaces.");
        Assert.notNull((Object)query, (String)"Query should not be null.");
        Class entityClass = entityInformation.getJavaType();
        String idPropertyName = entityClass == null || this.mappingNosqlConverter.getIdProperty(entityClass) == null ? null : this.mappingNosqlConverter.getIdProperty(entityClass).getName();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String sql = query.generateSql(tableName, params, idPropertyName);
        PreparedStatement pStmt = this.getPreparedStatement(entityInformation, sql);
        for (Map.Entry param : params.entrySet()) {
            pStmt.setVariable((String)param.getKey(), this.mappingNosqlConverter.convertObjToFieldValue(param.getValue(), null, false));
        }
        QueryRequest qReq = new QueryRequest().setPreparedStatement(pStmt);
        if (entityInformation.getTimeout() > 0) {
            qReq.setTimeout(entityInformation.getTimeout());
        }
        qReq.setConsistency(entityInformation.getConsistency());
        log.debug("Q: {}", (Object)sql);
        Iterable<MapValue> results = this.doQuery(qReq);
        return Flux.fromIterable(results);
    }

    private PreparedStatement getPreparedStatement(NosqlEntityInformation<?, ?> entityInformation, String query) {
        PreparedStatement preparedStatement = (PreparedStatement)this.psCache.get((Object)query);
        if (preparedStatement == null) {
            PrepareRequest pReq = new PrepareRequest().setStatement(query);
            if (entityInformation.getTimeout() > 0) {
                pReq.setTimeout(entityInformation.getTimeout());
            }
            try {
                log.debug("Prepare: {}", (Object)pReq.getStatement());
                PrepareResult pRes = this.nosqlClient.prepare(pReq);
                preparedStatement = pRes.getPreparedStatement();
                this.psCache.put((Object)query, (Object)preparedStatement);
            }
            catch (NoSQLException nse) {
                log.error("Prepare: {}", (Object)pReq.getStatement());
                log.error(nse.getMessage());
                throw MappingNosqlConverter.convert(nse);
            }
        }
        return preparedStatement.copyStatement();
    }

    private Iterable<MapValue> doQuery(QueryRequest qReq) {
        return new IterableUtil.IterableImpl(this.nosqlClient, qReq);
    }
}

