/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.nosql.spring.data.config;

import com.oracle.nosql.spring.data.NosqlDbFactory;
import java.io.IOException;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.iam.SignatureProvider;
import oracle.nosql.driver.kv.StoreAccessTokenProvider;

public class NosqlDbConfig {
    private NoSQLHandleConfig nosqlHandleConfig;
    private int queryCacheCapacity = 1000;
    private int queryCacheLifetime = 600000;
    private int tableReqTimeout = 60000;
    private int tableReqPollInterval = 500;
    private int timestampPrecision = 3;

    public NosqlDbConfig(String endpoint, AuthorizationProvider authorizationProvider) {
        this(new NoSQLHandleConfig(endpoint).setAuthorizationProvider(authorizationProvider));
    }

    public NosqlDbConfig(NoSQLHandleConfig nosqlHandleConfig) {
        this.nosqlHandleConfig = nosqlHandleConfig;
    }

    public static NosqlDbConfig createCloudConfig(String endpoint, String configFile) throws IOException {
        NosqlDbConfig config = new NosqlDbConfig(endpoint, (AuthorizationProvider)new SignatureProvider(configFile, "DEFAULT"));
        config.getNosqlHandleConfig().setRateLimitingEnabled(true);
        return config;
    }

    public static NosqlDbConfig createCloudSimConfig(String endpoint) {
        NosqlDbConfig config = new NosqlDbConfig(endpoint, NosqlDbFactory.CloudSimProvider.getProvider());
        config.getNosqlHandleConfig().setRateLimitingEnabled(true);
        return config;
    }

    public static NosqlDbConfig createProxyConfig(String endpoint) {
        return new NosqlDbConfig(endpoint, (AuthorizationProvider)new StoreAccessTokenProvider());
    }

    public static NosqlDbConfig createProxyConfig(String endpoint, String user, char[] password) {
        return new NosqlDbConfig(endpoint, (AuthorizationProvider)new StoreAccessTokenProvider(user, password));
    }

    public NoSQLHandleConfig getNosqlHandleConfig() {
        return this.nosqlHandleConfig;
    }

    public int getQueryCacheCapacity() {
        return this.queryCacheCapacity;
    }

    NosqlDbConfig setQueryCacheCapacity(int capacity) {
        this.queryCacheCapacity = capacity;
        return this;
    }

    public int getQueryCacheLifetime() {
        return this.queryCacheLifetime;
    }

    NosqlDbConfig setQueryCacheLifetime(int lifetime) {
        this.queryCacheCapacity = lifetime;
        return this;
    }

    public int getTableReqTimeout() {
        return this.tableReqTimeout;
    }

    public NosqlDbConfig setTableReqTimeout(int tableReqTimeout) {
        this.tableReqTimeout = tableReqTimeout;
        return this;
    }

    public int getTableReqPollInterval() {
        return this.tableReqPollInterval;
    }

    public NosqlDbConfig setTableReqPollInterval(int pollInterval) {
        this.tableReqPollInterval = pollInterval;
        return this;
    }

    public int getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public NosqlDbConfig setTimestampPrecision(int precision) {
        this.timestampPrecision = precision;
        return this;
    }
}

