/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Stack;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLReader;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.util.QxName;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CXMLParser
implements CXMLConstants {
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    Stack qnames = new Stack();
    Stack<ArrayList> nsAttrs = new Stack();

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String string) throws IOException, SAXException {
        BufferedInputStream bufferedInputStream = null;
        BinaryStream binaryStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            binaryStream = new CXMLStream();
            binaryStream.setObjectInput(new ObjectInputStream(bufferedInputStream));
            this.parse((CXMLReader)((CXMLStream)binaryStream).getInfosetReader());
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (binaryStream != null) {
                binaryStream.close();
            }
        }
    }

    public void parse(ObjectInput objectInput) throws IOException, SAXException {
        try (CXMLStream cXMLStream = null;){
            cXMLStream = new CXMLStream();
            cXMLStream.setObjectInput(objectInput);
            this.parse((CXMLReader)cXMLStream.getInfosetReader());
        }
    }

    void parse(CXMLReader cXMLReader) throws IOException, SAXException {
        block13: while (cXMLReader.hasNext()) {
            cXMLReader.next();
            switch (cXMLReader.getEventType()) {
                case 7: {
                    this.contentHandler.startDocument();
                    continue block13;
                }
                case 1: {
                    Object object;
                    QxName qxName = (QxName)cXMLReader.getQName();
                    this.qnames.push(qxName);
                    SAXAttrList sAXAttrList = (SAXAttrList)cXMLReader.getAttributes();
                    if (cXMLReader.nsDecl) {
                        object = new ArrayList();
                        int n = sAXAttrList.getLength();
                        for (int i = 0; i < n; ++i) {
                            String string;
                            String string2;
                            if (sAXAttrList.getPrefix(i) == "xmlns") {
                                string2 = sAXAttrList.getLocalName(i);
                                string = sAXAttrList.getValue(i);
                                this.contentHandler.startPrefixMapping(string2, string);
                                ((ArrayList)object).add(string2);
                                continue;
                            }
                            if (sAXAttrList.getLocalName(i) != "xmlns") continue;
                            string2 = "";
                            string = sAXAttrList.getValue(i);
                            this.contentHandler.startPrefixMapping(string2, string);
                            ((ArrayList)object).add(string2);
                        }
                        this.nsAttrs.push((ArrayList)object);
                    } else {
                        this.nsAttrs.push(null);
                    }
                    this.contentHandler.startElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName(), sAXAttrList);
                    continue block13;
                }
                case 4: 
                case 12: {
                    this.contentHandler.characters(cXMLReader.getData(), cXMLReader.getDataStart(), cXMLReader.getDataLength());
                    continue block13;
                }
                case 6: {
                    this.contentHandler.ignorableWhitespace(cXMLReader.getData(), cXMLReader.getDataStart(), cXMLReader.getDataLength());
                    continue block13;
                }
                case 11: {
                    continue block13;
                }
                case 3: {
                    QxName qxName = (QxName)cXMLReader.getQName();
                    Object object = cXMLReader.getValue();
                    this.contentHandler.processingInstruction(qxName.getLocalPart(), (String)object);
                    continue block13;
                }
                case 5: {
                    continue block13;
                }
                case 2: {
                    ArrayList arrayList;
                    QxName qxName = (QxName)this.qnames.pop();
                    if (qxName != null) {
                        this.contentHandler.endElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName());
                    }
                    if ((arrayList = this.nsAttrs.pop()) == null) continue block13;
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        this.contentHandler.endPrefixMapping((String)arrayList.get(i));
                    }
                    continue block13;
                }
                case 8: {
                    this.contentHandler.endDocument();
                    continue block13;
                }
                case 14: {
                    this.qnames.push(null);
                    continue block13;
                }
                case 9: 
                case 15: {
                    continue block13;
                }
            }
            throw new SAXException("Error parsing stream " + cXMLReader.getEventType());
        }
    }
}

