/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.i18n.text.OraCollator;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class DeepEqual
extends OXMLFunction {
    private int numParams;

    DeepEqual(int n) {
        this.numParams = n;
    }

    @Override
    public String getFunctionName() {
        return "deep-equal";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TBOOLEAN;
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0 || n == 1) {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }
        if (n == 2) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence deepEQ(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OraCollator oraCollator) throws XQException {
        OXMLItem oXMLItem;
        boolean bl;
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        boolean bl2 = true;
        boolean bl3 = !oXMLSequence.next();
        boolean bl4 = bl = !oXMLSequence2.next();
        if (bl3 && bl) {
            bl2 = true;
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, bl2);
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        if (bl3 || bl) {
            bl2 = false;
            OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
            oXMLItem3.setBoolean(OXMLSequenceType.TBOOLEAN, bl2);
            oXMLSequence3.appendItem(oXMLItem3);
            return oXMLSequence3;
        }
        boolean bl5 = true;
        boolean bl6 = true;
        while (bl5 && bl6) {
            block11: {
                oXMLItem = oXMLSequence.getItem();
                OXMLItem oXMLItem4 = oXMLSequence2.getItem();
                boolean bl7 = FNUtil.isNode(oXMLItem);
                boolean bl8 = FNUtil.isNode(oXMLItem4);
                if (bl7 && bl8) {
                    if (!FNUtil.isEqualNode(oXMLItem.getNode(), oXMLItem4.getNode())) {
                        bl2 = false;
                        break;
                    }
                } else {
                    if (bl7 || bl8) {
                        bl2 = false;
                        break;
                    }
                    try {
                        if (!(oXMLItem.isNaN() && oXMLItem4.isNaN() || oXMLItem.compareValue(oXMLItem4, oraCollator) == 0)) {
                            bl2 = false;
                        }
                        break block11;
                    }
                    catch (XQException xQException) {
                        bl2 = false;
                    }
                    break;
                }
            }
            bl5 = oXMLSequence.next();
            bl6 = oXMLSequence2.next();
        }
        if (bl5 || bl6) {
            bl2 = false;
        }
        oXMLItem = oXMLFunctionContext.createItem();
        oXMLItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl2);
        oXMLSequence3.appendItem(oXMLItem);
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OraCollator oraCollator = FNUtil.getCollator(oXMLFunctionContext.getDefaultCollation(), oXMLFunctionContext.getDBCharSet());
        return this.deepEQ(oXMLFunctionContext, oXMLSequence, oXMLSequence2, oraCollator);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        if (oXMLSequenceArray.length == 3) {
            OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequenceArray[2]);
            OraCollator oraCollator = FNUtil.getCollator(oXMLItem.getString(), oXMLFunctionContext.getDBCharSet());
            return this.deepEQ(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1], oraCollator);
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

