/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.scalable.BinaryNav;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.IntArrayIndex;
import oracle.xml.scalable.LongArrayIndex;
import oracle.xml.scalable.ShortArrayIndex;

public abstract class BinaryIndex {
    BinaryStream stream;
    static final long SMALL = 32767L;
    static final long MEDIUM = Integer.MAX_VALUE;
    static final int MAX_LEVEL = 64;

    public BinaryNav getNavigator() {
        return new BinaryNav(this);
    }

    public static BinaryIndex buildIndex(InfosetReader infosetReader, long l) throws Exception {
        BinaryIndex binaryIndex = null;
        binaryIndex = l < 32767L ? new ShortArrayIndex() : (l < Integer.MAX_VALUE ? new IntArrayIndex() : new LongArrayIndex());
        binaryIndex.setStream(infosetReader.getStream());
        binaryIndex.buildIndex(infosetReader);
        return binaryIndex;
    }

    public static BinaryIndex createIndex(int n) {
        BinaryIndex binaryIndex = null;
        binaryIndex = (long)n < 32767L ? new ShortArrayIndex() : ((long)n < Integer.MAX_VALUE ? new IntArrayIndex() : new LongArrayIndex());
        return binaryIndex;
    }

    BinaryStream getStream() {
        return this.stream;
    }

    public void setStream(BinaryStream binaryStream) {
        this.stream = binaryStream;
    }

    void buildIndex(InfosetReader infosetReader) throws Exception {
    }

    public BinaryIndex enlargeIndex() {
        return this;
    }

    long getLocator(int n, int n2) {
        return 0L;
    }

    int getChildStart(int n, int n2) {
        return 0;
    }

    int getChildEnd(int n, int n2) {
        return 0;
    }

    int getIndexDepth() {
        return 0;
    }

    public boolean startElement(long l) {
        return false;
    }

    public void endElement() {
    }
}

