/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import oracle.xml.common.format.IntegerFormatter;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLCompatible;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

class XSLNumber
extends XSLNode
implements XSLConstants {
    private static final String SINGLE = "single";
    private static final String MULTIPLE = "multiple";
    private static final String ANY = "any";
    private static final String ALPHABETIC = "alphabetic";
    private static final String TRADITIONAL = "traditional";
    private static final String LEVEL = "level";
    private static final String COUNT = "count";
    private static final String FROM = "from";
    private static final String VALUE = "value";
    private static final String FORMAT = "format";
    private static final String LANG = "lang";
    private static final String LETTER_VALUE = "letter-value";
    private static final String GROUPING_SEPARATOR = "grouping-separator";
    private static final String GROUPING_SIZE = "grouping-size";
    private static final String ORDINAL = "ordinal";
    private static final String XSLNUMBER = "xsl:number";
    private static final String LEFT_BRACKET = "{";
    String m_strValue = null;
    String m_strCount = null;
    String m_strFrom = null;
    String m_strLevel = null;
    boolean m_blnIsMul = true;
    int m_intLastPadLen;
    String m_strLastFormatStartValue;
    Integer m_objLastIntCurFor;
    String m_strLastSep = "";
    XSLNode.AttrValueTmpl m_avtLang = null;
    String m_strLang = null;
    XSLExprBase select;
    boolean ordinal = false;
    String m_strFormat = "1";
    XSLNode.AttrValueTmpl m_avtLetterValue;
    String m_strLetterValue = "traditional";
    String m_strGroupingSeparator = null;
    String m_strGroupingSize = null;
    XSLNode.AttrValueTmpl m_avtFormat;
    XSLNode.AttrValueTmpl m_avtGroupingSeparator;
    XSLNode.AttrValueTmpl m_avtGroupingSize;
    DecimalFormat m_dfDecimalFormat;
    XSLExprBase m_stringValue = null;
    XSLExprBase m_countPattern = null;
    int m_intCountAnchorType = -1;
    String[] m_countAnchorName = new String[2];
    String m_countAnchorLocalName = null;
    String m_countAnchorNamespace = null;
    XSLExprBase m_fromPattern = null;
    int m_intFromAnchorType = -1;
    String[] m_fromAnchorName = new String[2];
    String m_fromAnchorLocalName = null;
    String m_fromAnchorNamespace = null;
    IntFormatter nformatter = new IntFormatter();
    private static final Integer DEC_FORMAT = new Integer(1);
    private static final Integer ALU_FORMAT = new Integer(2);
    private static final Integer ALL_FORMAT = new Integer(3);
    private static final Integer RMU_FORMAT = new Integer(4);
    private static final Integer RML_FORMAT = new Integer(5);
    private static final Integer NML_FORMAT = new Integer(6);
    private static final Integer NMU_FORMAT = new Integer(7);
    private static final Integer NMT_FORMAT = new Integer(8);
    Vector m_vecSeparators;
    FastVector m_vecFormats;
    int m_intFormatsCurPtr = 0;
    String m_strPrefix = "";
    String m_strPostfix = "";

    private int getFormatPrefix(char[] cArray, int n) throws XSLException {
        int n2 = 0;
        if (!Character.isLetterOrDigit(cArray[n2])) {
            while (n2 < n && !Character.isLetterOrDigit(cArray[n2])) {
                ++n2;
            }
            this.m_strPrefix = new String(cArray, 0, n2);
        }
        if (n2 == n) {
            this.addDefaultElement();
            return -1;
        }
        return n2;
    }

    private int getFormatPostfix(char[] cArray, int n) throws XSLException {
        int n2;
        for (n2 = n - 1; n2 >= 0 && !Character.isLetterOrDigit(cArray[n2]); --n2) {
        }
        if (n2 != n - 1) {
            this.m_strPostfix = new String(cArray, n2 + 1, n - n2 - 1);
            n = n2 + 1;
        }
        return n;
    }

    private boolean isPureDigits(char[] cArray, int n) throws XSLException {
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(cArray[i])) continue;
            this.addDefaultElement();
            return false;
        }
        return true;
    }

    private void getFormatDigits(char[] cArray, int n) throws XSLException {
        int n2;
        if (!this.isPureDigits(cArray, n)) {
            return;
        }
        int n3 = 0;
        for (n2 = 0; n2 < n && cArray[n2] == '0'; ++n2) {
            ++n3;
        }
        String string = n2 == 0 ? new String(cArray) : new String(cArray, n2, n - n3);
        this.m_vecFormats.addElement(DEC_FORMAT);
        this.m_vecFormats.addElement(new Integer(n3));
        this.m_vecFormats.addElement(new Integer(string));
    }

    private void addDefaultElement() throws XSLException {
        this.m_vecFormats.addElement(DEC_FORMAT);
        this.m_vecFormats.addElement(new Integer(0));
        this.m_vecFormats.addElement(new Integer(1));
    }

    private void processAlpPureUpperLetters(char[] cArray, int n) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c > '@' && c < '[') continue;
            this.addDefaultElement();
            return;
        }
        String string = new String(cArray);
        this.m_vecFormats.addElement(ALU_FORMAT);
        this.m_vecFormats.addElement(string);
    }

    private void processAlpPureLowerLetters(char[] cArray, int n) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c > '`' && c < '{') continue;
            this.addDefaultElement();
            return;
        }
        String string = new String(cArray);
        this.m_vecFormats.addElement(ALL_FORMAT);
        this.m_vecFormats.addElement(string);
    }

    private void processRomanPureLowerNumbers(char[] cArray, int n) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c == 'i' || c == 'v' || c == 'x' || c == 'l' || c == 'c' || c == 'd' || c == 'm' || c == 'p') continue;
            this.processAlpPureLowerLetters(cArray, n);
            return;
        }
        String string = new String(cArray);
        this.m_vecFormats.addElement(RML_FORMAT);
        this.m_vecFormats.addElement(string);
    }

    private void processRomanPureUpperNumbers(char[] cArray, int n) throws XSLException {
        for (int i = 1; i < n; ++i) {
            char c = cArray[i];
            if (c == 'I' || c == 'V' || c == 'X' || c == 'L' || c == 'C' || c == 'D' || c == 'M' || c == 'P') continue;
            this.processAlpPureUpperLetters(cArray, n);
            return;
        }
        String string = new String(cArray);
        this.m_vecFormats.addElement(RMU_FORMAT);
        this.m_vecFormats.addElement(string);
    }

    private void processNamedNumber(char[] cArray, int n) {
        char c = cArray[0];
        if (c == 'w') {
            this.m_vecFormats.addElement(NML_FORMAT);
        } else if (c == 'W') {
            if (n > 1 && cArray[1] == 'w') {
                this.m_vecFormats.addElement(NMT_FORMAT);
            } else {
                this.m_vecFormats.addElement(NMU_FORMAT);
            }
        }
        String string = new String(cArray);
        this.m_vecFormats.addElement(string);
    }

    private void parseFormatString(String string) throws XSLException {
        this.m_vecFormats = new FastVector();
        if (string == null || string.length() == 0) {
            this.addDefaultElement();
            return;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        if (!this.m_blnIsMul) {
            this.parseFormatStringSglAny(cArray, n);
        } else {
            this.parseFormatStringMul(cArray, n);
        }
    }

    private void parseFormatStringMul(char[] cArray, int n) throws XSLException {
        this.m_vecSeparators = new Vector(5, 5);
        int n2 = 0;
        String string = "";
        String string2 = "";
        boolean bl = false;
        this.getFormatPostfix(cArray, n);
        char c = cArray[n2++];
        if (Character.isLetterOrDigit(c)) {
            string = string + c;
        } else {
            string2 = string2 + c;
            bl = true;
        }
        while (n2 < n) {
            char c2 = cArray[n2++];
            if (Character.isLetterOrDigit(c) && Character.isLetterOrDigit(c2)) {
                string = string + c2;
            } else if (Character.isLetterOrDigit(c) && !Character.isLetterOrDigit(c2)) {
                this.parseFormatStringSglAny(string.toCharArray(), string.length());
                string = "";
                string2 = String.valueOf(c2);
            } else if (!Character.isLetterOrDigit(c) && !Character.isLetterOrDigit(c2)) {
                string2 = string2 + c2;
            } else if (!Character.isLetterOrDigit(c) && Character.isLetterOrDigit(c2)) {
                this.m_vecSeparators.addElement(string2);
                string2 = "";
                string = String.valueOf(c2);
            }
            c = c2;
        }
        if (string != "") {
            this.parseFormatStringSglAny(string.toCharArray(), string.length());
        }
        if (string2 != "") {
            this.m_vecSeparators.addElement(string2);
        }
        if (bl) {
            this.m_strPrefix = this.m_vecSeparators.elementAt(0).toString();
            this.m_vecSeparators.removeElementAt(0);
        }
    }

    private void parseFormatStringSglAny(char[] cArray, int n) throws XSLException {
        int n2 = 0;
        n2 = this.getFormatPrefix(cArray, n);
        if (n2 == -1) {
            return;
        }
        char[] cArray2 = new char[n -= n2];
        System.arraycopy(cArray, n2, cArray2, 0, n);
        n = this.getFormatPostfix(cArray2, n);
        n2 = 0;
        char[] cArray3 = new char[n];
        System.arraycopy(cArray2, 0, cArray3, 0, n);
        if (Character.isDigit(cArray3[0])) {
            this.getFormatDigits(cArray3, n);
        } else if (this.m_strLetterValue.equals(ALPHABETIC)) {
            char c = cArray3[0];
            if (c > '@' && c < '[') {
                this.processAlpPureUpperLetters(cArray3, n);
            } else if (c > '`' && c < '{') {
                this.processAlpPureLowerLetters(cArray3, n);
            } else {
                this.addDefaultElement();
            }
        } else {
            char c = cArray3[0];
            char c2 = cArray3[0];
            if (c == 'i' || c == 'v' || c == 'x' || c == 'l' || c == 'c' || c == 'd' || c == 'm' || c == 'p') {
                this.processRomanPureLowerNumbers(cArray3, n);
            } else if (c == 'I' || c == 'V' || c == 'X' || c == 'L' || c == 'C' || c == 'D' || c == 'M' || c == 'P') {
                this.processRomanPureUpperNumbers(cArray3, n);
            } else if (c == 'W' || c == 'w') {
                this.processNamedNumber(cArray3, n);
            } else if (c2 > '@' && c2 < '[') {
                this.processAlpPureUpperLetters(cArray3, n);
            } else if (c2 > '`' && c2 < '{') {
                this.processAlpPureLowerLetters(cArray3, n);
            } else {
                this.addDefaultElement();
            }
        }
    }

    XSLNumber(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
    }

    private int[] getMultiCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode;
        FastVector fastVector = new FastVector();
        for (xMLNode = xSLTContext.getContextNode(); xMLNode != null && xMLNode.getNodeType() == 1 && (this.m_fromPattern == null || this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) == null); xMLNode = (XMLNode)xMLNode.getParentNode()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null) continue;
            fastVector.addElement(xMLNode);
        }
        int[] nArray = new int[fastVector.size()];
        int n = fastVector.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            nArray[n2] = 0;
            for (xMLNode = (XMLNode)fastVector.elementAt(n); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null || xMLNode.getNodeType() != 1) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
            }
            --n;
            ++n2;
        }
        return nArray;
    }

    private int getSingleCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode;
        int n = 0;
        XMLNode xMLNode2 = null;
        for (xMLNode = xSLTContext.getContextNode(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getParentNode()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) != null) {
                if (xMLNode2 == null) {
                    xMLNode2 = xMLNode;
                }
                if (this.m_fromPattern == null) break;
            }
            if (this.m_fromPattern != null && this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) != null) break;
        }
        if (xMLNode2 == null) {
            return n;
        }
        for (xMLNode = xMLNode2; xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) == null || xMLNode.getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    private int getAnyCnt(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLNode xMLNode = xSLTContext.getContextNode();
        int n = 0;
        while (xMLNode != null && (this.m_fromPattern == null || this.matchFromPattern(xMLNode, -1000.0f, xSLTContext) == null)) {
            if (this.matchCountPattern(xMLNode, -1000.0f, xSLTContext) != null) {
                ++n;
            }
            xMLNode = XPathAxis.getProceedingNode(xMLNode);
        }
        return n;
    }

    private int alphaToNum(String string) throws XSLException {
        String string2 = string.toLowerCase();
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = cArray[i] - 97 + 1;
            n2 = n2 * 26 + n3;
        }
        return n2;
    }

    private static String numToAlpha(int n) throws XSLException {
        char[] cArray = new char[256];
        int n2 = cArray.length - 1;
        while (n > 26) {
            int n3 = n % 26;
            n /= 26;
            if (n3 == 0) {
                n3 = 26;
                --n;
            }
            cArray[n2--] = (char)(65 + n3 - 1);
        }
        if (n < 1) {
            return "";
        }
        cArray[n2--] = (char)(65 + n - 1);
        return new String(cArray, n2 + 1, cArray.length - n2 - 1);
    }

    private static String numToRoman(int n) throws XSLException {
        if (n == 0) {
            return "0";
        }
        String string = Integer.toString(n);
        String string2 = "";
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        int n3 = n2 - 1;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            string2 = string2 + XSLNumber.singleNumToRoman(c, n3);
            --n3;
        }
        return string2;
    }

    private static String singleNumToRoman(char c, int n) throws XSLException {
        int n2 = c - 48;
        String string = "";
        switch (n2) {
            case 1: {
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 2: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 3: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 4: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanFive(n);
                break;
            }
            case 5: {
                string = string + XSLNumber.saveRomanFive(n);
                break;
            }
            case 6: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 7: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 8: {
                string = string + XSLNumber.saveRomanFive(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanOne(n);
                break;
            }
            case 9: {
                string = string + XSLNumber.saveRomanOne(n);
                string = string + XSLNumber.saveRomanTen(n);
                break;
            }
        }
        return string;
    }

    private static String saveRomanOne(int n) throws XSLException {
        String string;
        switch (n) {
            case 0: {
                string = "I";
                break;
            }
            case 1: {
                string = "X";
                break;
            }
            case 2: {
                string = "C";
                break;
            }
            case 3: {
                string = "M";
                break;
            }
            case 4: {
                string = "(X)";
                break;
            }
            case 5: {
                string = "(C)";
                break;
            }
            case 6: {
                string = "(M)";
                break;
            }
            case 7: {
                string = "[X]";
                break;
            }
            case 8: {
                string = "[C]";
                break;
            }
            case 9: {
                string = "[M]";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String saveRomanFive(int n) throws XSLException {
        String string;
        switch (n) {
            case 0: {
                string = "V";
                break;
            }
            case 1: {
                string = "L";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "(V)";
                break;
            }
            case 4: {
                string = "(L)";
                break;
            }
            case 5: {
                string = "(D)";
                break;
            }
            case 6: {
                string = "[V]";
                break;
            }
            case 7: {
                string = "[L]";
                break;
            }
            case 8: {
                string = "[D]";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String saveRomanTen(int n) throws XSLException {
        return XSLNumber.saveRomanOne(n + 1);
    }

    private static int romanToNum(String string) throws XSLException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        if (n2 == 1) {
            return XSLNumber.romanToNumSingle(cArray[0]);
        }
        int n3 = 0;
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            nArray[i] = n = XSLNumber.romanToNumSingle(c);
        }
        Stack<Integer> stack = new Stack<Integer>();
        while (n3 < n2) {
            n = nArray[n3];
            stack.push(new Integer(n));
            if (++n3 == n2) {
                n4 = XSLNumber.terminateStackRoman(stack, n4);
                return n4;
            }
            int n5 = nArray[n3];
            stack.push(new Integer(n5));
            int n6 = Integer.parseInt(stack.pop().toString());
            int n7 = Integer.parseInt(stack.pop().toString());
            if (n6 > n7) {
                n4 += n6 - n7;
                stack.removeAllElements();
            } else {
                stack.push(new Integer(n6));
                n4 += n7;
            }
            if (++n3 != n2) continue;
            n4 = XSLNumber.terminateStackRoman(stack, n4);
            return n4;
        }
        return n4;
    }

    private static int terminateStackRoman(Stack stack, int n) throws XSLException {
        int n2 = stack.size();
        if (n2 == 0) {
            return n;
        }
        if (n2 == 2) {
            int n3;
            int n4 = Integer.parseInt(stack.pop().toString());
            if (n4 > (n3 = Integer.parseInt(stack.pop().toString()))) {
                n += n4 - n3;
            } else {
                n += n3;
                n += n4;
            }
        } else if (n2 == 1) {
            int n5 = Integer.parseInt(stack.pop().toString());
            n += n5;
        } else {
            while (!stack.isEmpty()) {
                int n6 = Integer.parseInt(stack.pop().toString());
                n += n6;
            }
        }
        return n;
    }

    private static int romanToNumSingle(char c) throws XSLException {
        int n = 1;
        switch (c) {
            case 'I': {
                n = 1;
                break;
            }
            case 'V': {
                n = 5;
                break;
            }
            case 'X': {
                n = 10;
                break;
            }
            case 'L': {
                n = 50;
                break;
            }
            case 'C': {
                n = 100;
                break;
            }
            case 'D': {
                n = 500;
                break;
            }
            case 'M': {
                n = 1000;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private String getCountString(int[] nArray) throws XSLException {
        int n = nArray.length;
        String string = n == 1 ? this.getCountStringSglAny(nArray[0], 0, 0) : this.getCountStringMul(nArray, n);
        string = this.m_strPrefix + string + this.m_strPostfix;
        return string;
    }

    private String getCountStringMul(int[] nArray, int n) throws XSLException {
        String string = "";
        this.m_intFormatsCurPtr = 0;
        int n2 = 0;
        if (this.m_blnIsMul && this.m_vecSeparators != null) {
            n2 = this.m_vecSeparators.size();
            if (this.m_strPostfix != "") {
                --n2;
            }
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                if (i <= n2) {
                    string = string + (String)this.m_vecSeparators.elementAt(i - 1);
                } else if (n2 < 1) {
                    if (!XMLCompatible.useBuggyBehavior(17626289)) {
                        string = string + ".";
                    }
                } else {
                    string = string + (String)this.m_vecSeparators.elementAt(n2 - 1);
                }
            }
            string = string + this.getCountStringSglAny(nArray[i], this.m_intFormatsCurPtr, i);
        }
        return string;
    }

    private String getCountStringSglAny(int n, int n2, int n3) throws XSLException {
        Integer n4;
        String string = "";
        int n5 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "1";
        int n6 = this.m_vecFormats.size();
        if (n2 < n6) {
            this.m_objLastIntCurFor = n4 = (Integer)this.m_vecFormats.elementAt(n2++);
        } else {
            n4 = this.m_objLastIntCurFor;
        }
        if (n4 == null) {
            n4 = DEC_FORMAT;
        }
        if (n4.equals(DEC_FORMAT)) {
            string2 = this.m_dfDecimalFormat.format(0L);
            string3 = this.m_dfDecimalFormat.format(n);
            if (n2 < n6) {
                this.m_intLastPadLen = n5 = ((Integer)this.m_vecFormats.elementAt(n2++)).intValue();
            } else {
                n5 = this.m_intLastPadLen;
            }
            if (n5 > 0) {
                this.m_dfDecimalFormat.setMinimumIntegerDigits(n5 + 1);
                string3 = this.m_dfDecimalFormat.format(n);
            }
            if (n2 < n6) {
                this.m_strLastFormatStartValue = string4 = this.m_vecFormats.elementAt(n2++).toString();
            } else if (this.m_strLastFormatStartValue != null) {
                string4 = this.m_strLastFormatStartValue;
            }
            if (!string4.equals("1")) {
                int n7 = Integer.valueOf(string4);
                int n8 = Integer.valueOf(string3);
                n8 = n8 + n7 - 1;
                string3 = String.valueOf(n8);
            } else if (this.ordinal) {
                string3 = string3 + this.formatNumberOrdinal(n);
            }
            string = string + string3;
        } else if (n4.equals(ALU_FORMAT)) {
            string3 = this.m_dfDecimalFormat.format(n);
            string4 = "";
            if (n2 < n6) {
                string4 = this.m_vecFormats.elementAt(n2++).toString();
            }
            string = string + XSLNumber.numToAlpha(n);
        } else if (n4.equals(ALL_FORMAT)) {
            string3 = this.m_dfDecimalFormat.format(n);
            if (n2 < n6) {
                string4 = this.m_vecFormats.elementAt(n2++).toString();
            }
            string = string + XSLNumber.numToAlpha(n).toLowerCase();
        } else if (n4.equals(RMU_FORMAT)) {
            string3 = this.m_dfDecimalFormat.format(n);
            if (!(string4 = this.m_vecFormats.elementAt(n2++).toString()).equals("I")) {
                int n9 = XSLNumber.romanToNum(string4);
                int n10 = Integer.valueOf(string3);
                n10 = n10 + n9 - 1;
                string = string + XSLNumber.numToRoman(n10);
            } else {
                string = string + XSLNumber.numToRoman(n);
            }
        } else if (n4.equals(RML_FORMAT)) {
            string3 = this.m_dfDecimalFormat.format(n);
            if (!(string4 = this.m_vecFormats.elementAt(n2++).toString()).equals("i")) {
                string4 = string4.toUpperCase();
                int n11 = XSLNumber.romanToNum(string4);
                int n12 = Integer.valueOf(string3);
                n12 = n12 + n11 - 1;
                string = string + XSLNumber.numToRoman(n12).toLowerCase();
            } else {
                string = string + XSLNumber.numToRoman(n).toLowerCase();
            }
        } else if (n4.equals(NML_FORMAT)) {
            string = string + this.nformatter.formatNumberName(n, this.ordinal, Boolean.FALSE);
        } else if (n4.equals(NMU_FORMAT)) {
            string = string + this.nformatter.formatNumberName(n, this.ordinal, Boolean.TRUE);
        } else if (n4.equals(NMT_FORMAT)) {
            string = string + this.nformatter.formatNumberName(n, this.ordinal, null);
        }
        this.m_intFormatsCurPtr = n2;
        return string;
    }

    @Override
    public synchronized void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "number", "", (byte)-1);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, XSLNUMBER);
        }
        XMLError xMLError = xSLTContext.getError();
        if (this.m_stringValue == null && this.select == null && xSLTContext.getContextNode() == null) {
            xMLError.error0(23043, 1);
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        if (this.m_avtLang != null) {
            this.m_strLang = this.m_avtLang.getValue(xSLTContext);
        }
        this.setDecimalFormat();
        if (this.m_avtGroupingSeparator != null || this.m_avtGroupingSize != null) {
            this.m_dfDecimalFormat.setGroupingUsed(true);
        } else {
            this.m_dfDecimalFormat.setGroupingUsed(false);
        }
        if (this.m_avtFormat != null) {
            this.m_strFormat = this.m_avtFormat.getValue(xSLTContext);
        }
        if (this.m_avtLetterValue != null) {
            this.m_strLetterValue = this.m_avtLetterValue.getValue(xSLTContext);
            if (this.m_strLetterValue != null) {
                this.m_strLetterValue = this.m_strLetterValue.intern();
            }
            if (this.m_strLetterValue != ALPHABETIC && this.m_strLetterValue != TRADITIONAL) {
                this.xss.err.error3(22222, 1, XSLNUMBER, LETTER_VALUE, this.m_strLetterValue);
            }
        }
        this.parseFormatString(this.m_strFormat);
        if (this.m_avtGroupingSeparator != null) {
            this.m_strGroupingSeparator = this.m_avtGroupingSeparator.getValue(xSLTContext);
            object = this.m_dfDecimalFormat.getDecimalFormatSymbols();
            ((DecimalFormatSymbols)object).setGroupingSeparator(this.m_strGroupingSeparator.charAt(0));
            this.m_dfDecimalFormat.setDecimalFormatSymbols((DecimalFormatSymbols)object);
        }
        if (this.m_avtGroupingSize != null) {
            this.m_strGroupingSize = this.m_avtGroupingSize.getValue(xSLTContext);
            this.m_dfDecimalFormat.setGroupingSize(Integer.parseInt(this.m_strGroupingSize));
        }
        if (this.m_stringValue != null) {
            this.m_stringValue.evaluate(xSLTContext);
            XPathSequence xPathSequence = (XPathSequence)xSLTContext.popExprValue();
            if (this.isBackwardCompatibilityMode()) {
                object = new int[1];
                object[0] = (int)Math.rint(XPathSequence.getNumberValue(xPathSequence));
            } else {
                int n = XPathSequence.getLength(xPathSequence);
                object = new int[n];
                int n2 = 0;
                while (((OXMLSequence)xPathSequence).next()) {
                    OXMLItem oXMLItem = ((OXMLSequence)xPathSequence).getItem();
                    object[n2] = (int)Math.rint(XPathItem.getNumberValue(oXMLItem));
                    if (object[n2] < 0) {
                        xMLError.error1(24009, 1, this.m_stringValue.getExprString());
                    }
                    ++n2;
                }
            }
        } else {
            int n;
            XMLNode xMLNode = null;
            if (this.select != null) {
                this.select.evaluate(xSLTContext);
                OXMLSequence oXMLSequence = xSLTContext.popExprValue();
                if (oXMLSequence.next()) {
                    xMLNode = XPathSequence.nextNode(oXMLSequence);
                }
                if (xMLNode == null || oXMLSequence.next()) {
                    xMLError.error0(23042, 1);
                }
                xSLTContext.setContextNode(xMLNode);
            }
            if (this.m_strCount == null) {
                if (xMLNode == null) {
                    xMLNode = xSLTContext.getContextNode();
                }
                n = xMLNode.getNodeType();
                String string = "/";
                if (n == 1) {
                    string = xMLNode.getNodeName();
                }
                String string2 = xMLNode.getNamespaceURI();
                String string3 = (String)this.prefixHash.get("#xpath-default-namespace");
                this.addNamespace("#xpath-default-namespace", string2);
                this.m_countPattern = XSLExprBase.createPattern(string, this, false, this.xss);
                this.addNamespace("#xpath-default-namespace", string3);
                this.m_intCountAnchorType = this.m_countPattern.getAnchorType();
                this.m_countPattern.getAnchorName(this.m_countAnchorName);
                this.m_countAnchorNamespace = this.m_countAnchorName[0];
                this.m_countAnchorLocalName = this.m_countAnchorName[1];
            }
            if (this.m_strLevel.equals(MULTIPLE)) {
                object = this.getMultiCnt(xSLTContext);
            } else if (this.m_strLevel.equals(ANY)) {
                n = this.getAnyCnt(xSLTContext);
                if (n > 0) {
                    object = new int[1];
                    object[0] = n;
                } else {
                    object = new int[0];
                }
            } else {
                n = this.getSingleCnt(xSLTContext);
                if (n > 0) {
                    object = new int[1];
                    object[0] = n;
                } else {
                    object = new int[0];
                }
            }
        }
        String string = this.getCountString((int[])object);
        xSLEventHandler.characters(string, false);
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, XSLNUMBER);
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)-1, xSLTContext.getJDWPContentHandler());
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            string4 = string4.intern();
            if (string3 == VALUE) {
                this.m_strValue = string4;
                this.m_stringValue = XSLExprBase.createExpression(this.m_strValue, (NSResolver)this, this.xss);
            } else if (string3 == LEVEL) {
                this.m_strLevel = string4;
                this.m_blnIsMul = this.m_strLevel.equals(MULTIPLE) || this.m_strLevel.equals(ANY);
                if (string4 != MULTIPLE && string4 != ANY && string4 != SINGLE) {
                    this.xss.err.error3(22222, 1, XSLNUMBER, LEVEL, string4);
                }
            } else if (string3 == COUNT) {
                this.m_strCount = string4;
                try {
                    this.m_countPattern = XSLExprBase.createPattern(this.m_strCount, this, false, this.xss);
                    this.m_intCountAnchorType = this.m_countPattern.getAnchorType();
                    this.m_countPattern.getAnchorName(this.m_countAnchorName);
                    this.m_countAnchorNamespace = this.m_countAnchorName[0];
                    this.m_countAnchorLocalName = this.m_countAnchorName[1];
                }
                catch (XPathException xPathException) {
                    String[] stringArray = new String[]{this.m_strCount, string3, this.getQualifiedName(), xPathException.errId == 22026 || xPathException.errId == 1026 || xPathException.errId == 22013 || xPathException.errId == 1013 ? "" : this.xss.err.getMessage1(22242, xPathException.getMessage())};
                    this.xss.err.error(22241, 1, stringArray);
                }
            } else if (string3 == FROM) {
                this.m_strFrom = string4;
                try {
                    this.m_fromPattern = XSLExprBase.createPattern(this.m_strFrom, this, false, this.xss);
                    this.m_intFromAnchorType = this.m_fromPattern.getAnchorType();
                    this.m_fromPattern.getAnchorName(this.m_fromAnchorName);
                    this.m_fromAnchorNamespace = this.m_fromAnchorName[0];
                    this.m_fromAnchorLocalName = this.m_fromAnchorName[1];
                }
                catch (XPathException xPathException) {
                    String[] stringArray = new String[]{this.m_strFrom, string3, this.getQualifiedName(), xPathException.errId == 22026 || xPathException.errId == 1026 || xPathException.errId == 22013 || xPathException.errId == 1013 ? "" : this.xss.err.getMessage1(22242, xPathException.getMessage())};
                    this.xss.err.error(22241, 1, stringArray);
                }
            } else if (string3 == LANG) {
                this.m_avtLang = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == FORMAT) {
                this.m_avtFormat = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == LETTER_VALUE) {
                this.m_avtLetterValue = new XSLNode.AttrValueTmpl(string4, this);
                if (string4 != ALPHABETIC && string4 != TRADITIONAL && !string4.startsWith(LEFT_BRACKET)) {
                    this.xss.err.error3(22222, 1, XSLNUMBER, LETTER_VALUE, string4);
                }
            } else if (string3 == GROUPING_SEPARATOR) {
                this.m_avtGroupingSeparator = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == GROUPING_SIZE) {
                this.m_avtGroupingSize = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "select") {
                this.select = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
            } else if (string3 == ORDINAL && !string4.equals("")) {
                this.ordinal = true;
            }
            super.setAttribute(string, string2, string3, string4);
        }
    }

    private void setDecimalFormat() {
        Locale locale = null;
        if (this.m_strLang != null && this.m_strLang.length() == 5 && this.m_strLang.indexOf(95) == 2) {
            String string = this.m_strLang.substring(0, 2).toLowerCase();
            String string2 = this.m_strLang.substring(3).toUpperCase();
            locale = new Locale(string, string2);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!locale.getLanguage().equals("en")) {
            this.ordinal = false;
        }
        this.m_dfDecimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        char c = decimalFormatSymbols.getGroupingSeparator();
        if (c > '\u007f') {
            decimalFormatSymbols.setGroupingSeparator('.');
        }
        this.m_dfDecimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    XSLExprBase matchFromPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        if (this.m_intFromAnchorType != -1) {
            if (this.m_intFromAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.m_fromAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? !this.m_fromAnchorLocalName.equals(((XMLNSNode)(object = (XMLElement)xMLNode)).getNodeLocalName()) || !this.m_fromAnchorNamespace.equals(((XMLElement)object).getNamespace()) : (xMLNode.getNodeType() == 2 ? !this.m_fromAnchorLocalName.equals(((XMLNSNode)(object = (XMLAttr)xMLNode)).getNodeLocalName()) || !this.m_fromAnchorNamespace.equals(((XMLAttr)object).getNamespace()) : !xMLNode.getNodeName().equals(this.m_fromAnchorLocalName)))) {
                return null;
            }
        }
        xSLTContext.saveCapturedSubstring(false);
        object = this.m_fromPattern.matchPattern(xMLNode, f, xSLTContext);
        xSLTContext.restoreCapturedSubstring();
        return object;
    }

    private String formatNumberOrdinal(long l) {
        long l2 = l % 10L;
        long l3 = l % 100L;
        if (l2 == 1L && l3 != 11L) {
            return "st";
        }
        if (l2 == 2L && l3 != 12L) {
            return "nd";
        }
        if (l2 == 3L && l3 != 13L) {
            return "rd";
        }
        return "th";
    }

    XSLExprBase matchCountPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        Object object;
        if (this.m_intCountAnchorType != -1) {
            if (this.m_intCountAnchorType != xMLNode.getNodeType()) {
                return null;
            }
            if (this.m_countAnchorNamespace != null && (xMLNode.getNodeType() == 1 ? !this.m_countAnchorLocalName.equals(((XMLNSNode)(object = (XMLElement)xMLNode)).getNodeLocalName()) || !this.m_countAnchorNamespace.equals(((XMLElement)object).getNamespace()) : (xMLNode.getNodeType() == 2 ? !this.m_countAnchorLocalName.equals(((XMLNSNode)(object = (XMLAttr)xMLNode)).getNodeLocalName()) || !this.m_countAnchorNamespace.equals(((XMLAttr)object).getNamespace()) : !xMLNode.getNodeName().equals(this.m_countAnchorLocalName)))) {
                return null;
            }
        }
        xSLTContext.saveCapturedSubstring(false);
        object = this.m_countPattern.matchPattern(xMLNode, f, xSLTContext);
        xSLTContext.restoreCapturedSubstring();
        return object;
    }

    @Override
    void endContent() throws XSLException, XQException {
        super.endContent();
        if (this.m_strValue != null && (this.select != null || this.m_strLevel != null || this.m_strCount != null || this.m_strFrom != null)) {
            this.xss.err.error1(24009, 1, VALUE);
        }
        if (this.m_strLevel == null) {
            this.m_strLevel = SINGLE;
        }
    }

    static class IntFormatter
    extends IntegerFormatter<XSLException> {
        @Override
        public XSLException createInvalidPictureStringException(String string) {
            return null;
        }

        @Override
        public XSLException notSupported(String string) {
            return null;
        }

        String formatNumberName(int n, boolean bl, Boolean bl2) throws XSLException {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                this.formatNumberName(n, bl, bl2, stringBuilder);
            }
            catch (Exception exception) {
                throw new XSLException(exception.getMessage());
            }
            return stringBuilder.toString();
        }
    }
}

