/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecodeReader;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTDBuilder;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetReader2;
import oracle.xml.util.QxNameHash;
import org.xml.sax.SAXException;

public class BinXMLInfosetReader
extends BinXMLDecodeReader
implements InfosetReader2,
BinXMLConstants {
    DTDBuilder builder;
    boolean dtd = false;

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl) throws BinXMLException {
        super(binXMLStreamImpl, binXMLDecoderImpl);
    }

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl, boolean bl) throws BinXMLException {
        super(binXMLStreamImpl, binXMLDecoderImpl, bl);
    }

    BinXMLInfosetReader(BinXMLStreamImpl binXMLStreamImpl) throws BinXMLException {
        super(binXMLStreamImpl, null);
    }

    String getStreamURI() {
        return this.binStream.getStreamURI();
    }

    public int hashCode() {
        return this.binStream.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof BinXMLInfosetReader) {
            return this.binStream == ((BinXMLInfosetReader)object).binStream;
        }
        return false;
    }

    private Locator getLocator(short s, BinXMLDecodeReader.DecodeElem decodeElem) {
        Locator locator;
        if (!((s & 1) <= 0 && (s & 0x20) <= 0 || (s & 2) <= 0 && (s & 0x10) <= 0)) {
            long l;
            if (decodeElem.typeid != 0) {
                s = (short)(s | 0x100);
                l = decodeElem.typeid;
            } else {
                l = decodeElem.id;
            }
            locator = new LocatorArraySchema(s, this.eventMark, this.curElem.id, this.curElem.pfxid, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
        } else if ((s & 2) > 0 || (s & 0x10) > 0) {
            long l;
            if (decodeElem.typeid != 0) {
                s = (short)(s | 0x100);
                l = decodeElem.typeid;
            } else {
                l = decodeElem.id;
            }
            locator = new LocatorSchema(s, this.eventMark, l, this.oldKidnum, (byte)this.getSchemaId(this.schema));
        } else {
            locator = (s & 1) > 0 || (s & 0x20) > 0 ? new LocatorArray(s, this.eventMark, this.curElem.id, this.curElem.pfxid) : new Locator(s, this.eventMark);
        }
        return locator;
    }

    @Override
    public BinaryStream getStream() {
        return this.binStream;
    }

    @Override
    public Object getOffsetObject() {
        return this.getOffset();
    }

    @Override
    public InfosetReader.Offset getOffset() {
        BinXMLDecodeReader.DecodeElem decodeElem;
        short s = 0;
        Locator locator = null;
        if (this.event == 4 || this.elemStack.size() < 2) {
            decodeElem = this.elemStack.peek();
            if (this.state == 3) {
                decodeElem = this.elemStack.get(this.elemStack.size() - 2);
                s = (short)(8 | decodeElem.flags);
            } else {
                s = this.prevSibling != null ? (short)(0x20 | decodeElem.flags) : decodeElem.flags;
            }
        } else {
            decodeElem = this.elemStack.get(this.elemStack.size() - 2);
            s = decodeElem.flags;
        }
        locator = this.getLocator(s, decodeElem);
        if (this.schema != null) {
            locator.schid = (byte)this.getSchemaId(this.schema);
        }
        if (decodeElem.streamId != this.curStream.id && this.state != 3) {
            locator.streamId = decodeElem.streamId;
            locator.flags = (short)(locator.flags | 4);
        }
        if (this.printLocator) {
            System.out.print("getOffset - ");
            locator.print();
        }
        return locator;
    }

    private void seekCommon(Locator locator, boolean bl) throws BinXMLException {
        if (!bl) {
            this.pushStreamMark(locator.mark);
        } else {
            this.pushStreamParentMark(locator.streamId, locator.mark);
        }
    }

    private void seekSelfModeBase(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem, boolean bl, boolean bl2) throws BinXMLException {
        this.seekCommon(locator, false);
        decodeElem = bl ? this.elemStack.getNew() : new BinXMLDecodeReader.DecodeElem();
        if (!bl2) {
            decodeElem.pfxid = 0;
        }
        this.pushElem(decodeElem);
    }

    private void seekSelfMode(Locator locator) throws BinXMLException {
        this.seekSelfModeBase(locator, this.curElem, true, false);
    }

    private void seekDefaultMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekSelfModeBase(locator, decodeElem, false, true);
    }

    private void seekOptMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekSelfModeBase(locator, decodeElem, false, false);
        this.getNext(false);
    }

    private void seekArrModeBase(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem, boolean bl) throws BinXMLException {
        this.seekCommon(locator, false);
        LocatorArray locatorArray = (LocatorArray)locator;
        decodeElem = this.elemStack.getNew();
        decodeElem.setArrMode(bl);
        this.pushElem(decodeElem);
        this.curElem = this.getDecodeElem(locatorArray.qnameid);
        this.curElem.pfxid = locatorArray.pfxid;
        if (locatorArray.pfxid != 0) {
            this.curElem.setPrefix(this.getPrefix(locatorArray.pfxid));
        } else {
            this.curElem.setPrefix(null);
        }
    }

    private void seekArrMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekArrModeBase(locator, decodeElem, true);
    }

    private void seekArrNxtMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekArrModeBase(locator, decodeElem, false);
        this.prevSibling = this.curElem;
    }

    private void seekOptArrMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekArrMode(locator, decodeElem);
        this.getNext(false);
    }

    private void seekSeqKidModeCommon(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem, short s) throws BinXMLException {
        this.seekCommon(locator, false);
        LocatorSchema locatorSchema = (LocatorSchema)locator;
        this.curElem = (locator.flags & 0x100) > 0 ? this.getDecodeElemByTypeId((int)locatorSchema.propid) : this.getDecodeElem(locatorSchema.propid);
        this.curElem.setPrefix(null);
        this.curElem.kidnum = locatorSchema.kidnum;
        if ((locator.flags & s & 2) > 0) {
            this.curElem.setSeqMode(true);
        } else {
            this.curElem.setKidMode(true);
        }
        this.curElem.pfxid = 0;
        this.pushElem(this.curElem);
        decodeElem = this.curElem;
    }

    private void seekSeqKidMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekSeqKidModeCommon(locator, decodeElem, (short)2);
    }

    private void seekOptSeqKidMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekSeqKidModeCommon(locator, decodeElem, (short)10);
        this.getNext(false);
    }

    private void seekArrSeqKidModeBase(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem, boolean bl, short s) throws BinXMLException {
        this.seekCommon(locator, false);
        LocatorArraySchema locatorArraySchema = (LocatorArraySchema)locator;
        decodeElem = (locator.flags & 0x100) > 0 ? this.getDecodeElemByTypeId((int)locatorArraySchema.propid) : this.getDecodeElem(locatorArraySchema.propid);
        decodeElem.setPrefix(null);
        decodeElem.kidnum = locatorArraySchema.kidnum;
        decodeElem.setArrMode(bl);
        if ((locator.flags & s & 2) > 0) {
            decodeElem.setSeqMode(true);
            this.pushElem(decodeElem);
        } else {
            decodeElem.setKidMode(true);
            if (decodeElem.prop != null && !decodeElem.prop.isSequential()) {
                this.pushElem(decodeElem);
            }
        }
        this.curElem = this.getDecodeElem(locatorArraySchema.qnameid);
        this.curElem.pfxid = locatorArraySchema.pfxid;
        if (locatorArraySchema.pfxid != 0) {
            this.curElem.setPrefix(this.getPrefix(locatorArraySchema.pfxid));
        } else {
            this.curElem.setPrefix(null);
        }
    }

    private void seekArrSeqKidMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        this.seekArrSeqKidModeBase(locator, decodeElem, true, (short)3);
    }

    private void seekArrNxtSeqKidMode(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        if ((locator.flags & 1) > 0) {
            this.seekArrSeqKidModeBase(locator, decodeElem, true, (short)34);
        } else {
            this.seekArrSeqKidModeBase(locator, decodeElem, false, (short)34);
        }
        this.prevSibling = this.curElem;
    }

    private void seekSelfStrmMode(Locator locator) throws BinXMLException {
        this.seekCommon(locator, true);
        this.curElem = new BinXMLDecodeReader.DecodeElem();
        this.pushElem(this.curElem);
        this.pushStreamMark(locator.mark);
        if (this.curStream.locator != null) {
            String[] stringArray = this.curStream.locator.split(",");
            switch (stringArray[0].charAt(0)) {
                case 'A': {
                    this.locId = Long.parseLong(stringArray[2]);
                    this.curElem.setArrMode(true);
                    break;
                }
                case 'K': 
                case 'S': {
                    this.vocabId.setVocabID(stringArray[3].getBytes());
                    this.schema = this.vocabMngr.getBinXMLSchema(this.vocabId);
                    this.addSchema(this.schema);
                    this.pushSchema(this.schema);
                    this.locId = Long.parseLong(stringArray[2]);
                    break;
                }
                case 'T': {
                    this.locId = 1L;
                    break;
                }
                case 'E': {
                    this.locId = 0L;
                }
            }
        }
    }

    private void seek(Locator locator, BinXMLDecodeReader.DecodeElem decodeElem) throws BinXMLException {
        if ((locator.flags & 1) > 0) {
            if ((locator.flags & 2) > 0 || (locator.flags & 0x10) > 0) {
                this.seekArrSeqKidMode(locator, decodeElem);
            } else {
                this.seekArrMode(locator, decodeElem);
            }
        } else if ((locator.flags & 0x20) > 0) {
            if ((locator.flags & 2) > 0 || (locator.flags & 0x10) > 0) {
                this.seekArrNxtSeqKidMode(locator, decodeElem);
            } else {
                this.seekArrNxtMode(locator, decodeElem);
            }
        } else if ((locator.flags & 2) > 0 || (locator.flags & 0x10) > 0) {
            this.seekSeqKidMode(locator, decodeElem);
        } else if ((locator.flags & 4) > 0) {
            this.seekSelfStrmMode(locator);
        } else if (locator.flags == 8) {
            this.seekSelfModeBase(locator, decodeElem, false, false);
        } else if (locator.flags == 0) {
            this.seekSelfMode(locator);
        } else {
            this.seekDefaultMode(locator, decodeElem);
        }
        if ((locator.flags & 8) > 0) {
            this.getNext(false);
        }
    }

    @Override
    public void seekFromObject(Object object) {
        BinXMLDecodeReader.PrefixInfo prefixInfo = null;
        BinXMLDecodeReader.DecodeElem decodeElem = null;
        Locator locator = (Locator)object;
        if (locator == null) {
            return;
        }
        if (this.printLocator) {
            System.out.print("seek - ");
            locator.print();
        }
        try {
            this.resetSimple();
            if (locator.schid >= 0) {
                this.schema = this.getSchema(locator.schid);
                this.pushSchema(this.schema);
            }
            this.seek(locator, decodeElem);
            this.mark = locator.mark;
            if (prefixInfo != null) {
                this.pushNamespace(prefixInfo);
            }
            this.event = this.getNextEvent(false);
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
            throw new IllegalStateException(binXMLException);
        }
    }

    @Override
    public void seek(InfosetReader.Offset offset) {
        this.seekFromObject(offset);
    }

    @Override
    public long offsetToLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        boolean bl = true;
        if (this.event == 8 || this.state == 3) {
            bl = false;
        }
        try {
            short s = this.nextByte();
            if (s == 216) {
                s = this.nextByte2();
            }
            if (s == 217 || s == 160) {
                bl = false;
            }
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
            throw new IllegalStateException(binXMLException);
        }
        return bl;
    }

    @Override
    public void next() {
        try {
            if (this.event == 100) {
                this.buildDTD();
            }
            this.event = this.getNextEvent(false);
        }
        catch (BinXMLException binXMLException) {
            System.out.println(binXMLException.getMessage());
            throw new IllegalStateException(binXMLException);
        }
    }

    DTD buildDTD() {
        if (this.event == 100) {
            try {
                if (this.builder == null) {
                    this.builder = new DTDBuilder();
                }
                while (true) {
                    switch (this.event) {
                        case 100: {
                            if (this.dtd) break;
                            this.builder.startDTD(this.dtdName, this.publicId, this.systemId);
                            break;
                        }
                        case 101: {
                            if (this.dtd) break;
                            this.builder.elementDecl(this.elemName, this.contentSpec);
                            break;
                        }
                        case 102: {
                            if (this.dtd) break;
                            if (this.attrCount > 0) {
                                for (int i = 0; i < this.attrCount; ++i) {
                                    this.builder.attributeDecl(this.elemName, this.attrNames[i], this.attrTypes[i], this.attrModes[i], this.values[i]);
                                }
                                this.attrCount = 0;
                                break;
                            }
                            this.builder.attributeDecl(this.elemName, this.attrName, this.attrType, this.attrMode, this.value);
                            break;
                        }
                        case 103: {
                            if (this.dtd) break;
                            this.builder.internalEntityDecl(this.entName, this.value);
                            break;
                        }
                        case 104: {
                            if (this.dtd) break;
                            this.builder.unparsedEntityDecl(this.entName, this.publicId, this.systemId, this.notName);
                            break;
                        }
                        case 105: {
                            if (this.dtd) break;
                            this.builder.externalEntityDecl(this.entName, this.publicId, this.systemId);
                            break;
                        }
                        case 106: {
                            break;
                        }
                        case 107: {
                            if (this.dtd) break;
                            this.builder.notationDecl(this.notName, this.publicId, this.systemId);
                            break;
                        }
                        case 5: {
                            this.builder.comment(this.value.toCharArray(), 0, (int)this.datalen);
                            break;
                        }
                        case 108: {
                            if (!this.dtd) {
                                this.builder.endDTD();
                            }
                            this.dtd = true;
                            return this.builder.getDoctype();
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new RuntimeException(this.err.getMessage0(35008));
                        }
                    }
                    this.event = this.getNextEvent(false);
                }
            }
            catch (BinXMLException binXMLException) {
                System.out.println(binXMLException.getMessage());
                throw new IllegalStateException(binXMLException);
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
                throw new IllegalStateException(sAXException);
            }
        }
        return null;
    }

    @Override
    public void skip() {
        try {
            this.skipNode();
        }
        catch (BinXMLException binXMLException) {
            throw new IllegalStateException(binXMLException);
        }
    }

    @Override
    public int getEventType() {
        if (this.event == 100 || this.event == 108) {
            return 11;
        }
        return this.event;
    }

    @Override
    public QName getQName() {
        switch (this.event) {
            case 3: {
                return QxNameHash.create("", this.piTarget, "");
            }
            case 1: 
            case 2: {
                return QxNameHash.create(this.curElem.getURI(), this.curElem.getLocal(), this.curElem.getPrefix());
            }
        }
        return QxNameHash.create("", "", "");
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.curElem.getURI();
    }

    @Override
    public String getPrefix(String string) {
        return this.curElem.getPrefix();
    }

    @Override
    public TypedAttributes getAttributes() {
        return this.attrlist;
    }

    @Override
    public String getAttribute(QName qName) {
        return null;
    }

    @Override
    public String getValue() {
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventText(null);
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value;
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            throw new IllegalStateException(binXMLException);
        }
    }

    @Override
    public char[] getData() {
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventChars();
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value.toCharArray();
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            throw new IllegalStateException(binXMLException);
        }
    }

    public char[] getData(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        try {
            switch (this.event) {
                case 4: {
                    return this.getEventChars(n);
                }
                case 3: 
                case 5: 
                case 12: {
                    return this.value.toCharArray();
                }
            }
            return null;
        }
        catch (BinXMLException binXMLException) {
            throw new IllegalStateException(binXMLException);
        }
    }

    @Override
    public int getDataStart() {
        return 0;
    }

    @Override
    public int getDataLength() {
        switch (this.event) {
            case 3: 
            case 5: 
            case 12: {
                return this.value.length();
            }
        }
        return (int)this.datalen;
    }

    @Override
    public boolean isNSResolutionSupported() {
        return false;
    }

    @Override
    public boolean isSeekSupported() {
        return this.binStream.isSeekSupported();
    }

    @Override
    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        return 0;
    }

    @Override
    public byte offsetObjectToBytes(Object object, byte[] byArray, int n) {
        return 0;
    }

    @Override
    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        return null;
    }

    @Override
    public Object offsetObjectFromBytes(byte[] byArray, int n) {
        return null;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getStandalone() {
        return this.standalone;
    }

    @Override
    public DTD getDoctype() {
        if (this.event == 100) {
            this.buildDTD();
        }
        if (this.dtd) {
            return this.builder.getDoctype();
        }
        return null;
    }

    @Override
    public QName getTypeName() {
        return null;
    }

    @Override
    public int getPrimitiveTypeId() {
        return 0;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public int getEventFlags() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public Object clone() {
        return this.getReader();
    }

    protected class LocatorArraySchema
    extends Locator {
        long qnameid;
        short pfxid;
        long propid;
        short kidnum;
        byte schid;

        LocatorArraySchema(short s, int n, long l, short s2, long l2, short s3, byte by) {
            super(s, n);
            this.qnameid = l;
            this.pfxid = s2;
            this.propid = l2;
            this.kidnum = s3;
            this.schid = by;
        }

        @Override
        public void print() {
            System.out.println("LocatorArraySchema(" + this.flags + ", " + this.pfxid + ":" + this.qnameid + ") at " + this.mark);
        }
    }

    protected class LocatorSchema
    extends Locator {
        long propid;
        short kidnum;

        LocatorSchema(short s, int n, long l, short s2, byte by) {
            super(s, n);
            this.propid = l;
            this.kidnum = s2;
            this.schid = by;
        }

        @Override
        public String toString() {
            long l = 1L - this.propid;
            BinXMLSchema binXMLSchema = BinXMLInfosetReader.this.getSchema(this.schid);
            BinXMLVocabId binXMLVocabId = binXMLSchema.getSchemaId();
            String string = new String(binXMLVocabId.getVocabID(), 0, 16);
            return "IRAc".concat(Long.toString(this.mark)).concat("c").concat(Long.toString(l)).concat("c").concat(string);
        }

        @Override
        public void print() {
            System.out.println("LocatorSchema(" + this.flags + ", " + this.propid + ") at " + this.mark);
        }
    }

    protected class LocatorArray
    extends Locator {
        long qnameid;
        short pfxid;

        LocatorArray(short s, int n, long l, short s2) {
            super(s, n);
            this.qnameid = l;
            this.pfxid = s2;
        }

        @Override
        public String toString() {
            return "IRAc".concat(Long.toString(this.mark)).concat("c").concat(Long.toString(this.qnameid));
        }

        @Override
        public void print() {
            System.out.println("LocatorArray(" + this.flags + ", " + this.pfxid + ":" + this.qnameid + ") at " + this.mark);
        }
    }

    protected class Locator
    implements InfosetReader.Offset {
        short flags;
        int mark;
        byte schid;
        byte streamId = (byte)-1;

        Locator(short s, int n) {
            this.flags = s;
            this.mark = n;
            this.schid = (byte)-1;
        }

        public int compareTo(Object object) {
            Locator locator = (Locator)object;
            if (this.mark == locator.mark) {
                if (this.flags == locator.flags) {
                    return 0;
                }
                if ((this.flags & 0xF) == 8) {
                    return 1;
                }
                return -1;
            }
            return this.mark < locator.mark ? -1 : 1;
        }

        public String toString() {
            if ((this.flags & 0xF) == 8) {
                return "IRTc" + this.mark;
            }
            return "IREc" + this.mark;
        }

        public void print() {
            System.out.println("Locator(" + this.flags + ") at " + this.mark);
        }
    }
}

