/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLAttrList
implements NamedNodeMap,
Serializable,
XMLConstants {
    XMLElement parent;
    long cstate;
    int flags;

    native int xdbGetNumAttrs(long var1, long var3);

    native long xdbGetAttributeNode(long var1, long var3, String var5, String var6);

    native long xdbSetAttributeNode(long var1, long var3, long var5);

    native long xdbRemoveAttributeNode(long var1, long var3, String var5, String var6);

    native long xdbGetNodeItemAt(long var1, long var3, long var5);

    public XMLAttrList(XMLElement xMLElement) {
        switch (xMLElement.flags & 3) {
            case 1: {
                this.flags |= 1;
                break;
            }
            case 2: {
                this.flags |= 2;
            }
        }
        this.parent = xMLElement;
    }

    public int getLength() {
        switch (this.flags & 3) {
            case 1: {
                int n = 0;
                for (XMLNode xMLNode = this.parent.xdkGetFirstAttr(); xMLNode != null; xMLNode = xMLNode.xdkGetNextNode()) {
                    ++n;
                }
                return n;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                return this.xdbGetNumAttrs(this.parent.xdbGetCtx(), this.cstate);
            }
        }
        return 0;
    }

    public Node getNamedItem(String string) {
        switch (this.flags & 3) {
            case 1: {
                return this.parent.getAttributeNode(string);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbGetAttributeNode(this.parent.xdbGetCtx(), this.cstate, null, string);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node setNamedItem(Node node) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                this.parent.checkDocument((XMLNode)node);
                return this.parent.setAttributeNode((XMLAttr)node);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbSetAttributeNode(this.parent.xdbGetCtx(), this.cstate, ((XMLNode)node).nodeId);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNode(string);
                if (xMLAttr != null) {
                    if (!this.parent.xdkSetAttributeDefault(xMLAttr)) {
                        this.parent.xdkRemoveAttr(xMLAttr);
                    }
                    xMLAttr.resetNodeFlag(65536);
                    if (this.parent.isScalable()) {
                        this.parent.xdkKeepNode();
                    }
                } else {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                return xMLAttr;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbRemoveAttributeNode(this.parent.xdbGetCtx(), this.cstate, null, string);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node item(int n) {
        switch (this.flags & 3) {
            case 1: {
                for (XMLNode xMLNode = this.parent.xdkGetFirstAttr(); xMLNode != null; xMLNode = xMLNode.xdkGetNextNode()) {
                    if (n == 0) {
                        return xMLNode;
                    }
                    --n;
                }
                break;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbGetNodeItemAt(this.parent.xdbGetCtx(), this.cstate, n);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        switch (this.flags & 3) {
            case 1: {
                return this.parent.getAttributeNodeNS(string, string2);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbGetAttributeNode(this.parent.xdbGetCtx(), this.cstate, string, string2);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                return this.parent.setAttributeNodeNS((XMLAttr)node);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbSetAttributeNode(this.parent.xdbGetCtx(), this.cstate, ((XMLNode)node).nodeId);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNodeNS(string, string2);
                this.parent.checkReadOnly();
                if (xMLAttr != null) {
                    if (!this.parent.xdkSetAttributeDefault(xMLAttr)) {
                        this.parent.xdkRemoveAttr(xMLAttr);
                    }
                    xMLAttr.resetNodeFlag(65536);
                    if (this.parent.isScalable()) {
                        this.parent.xdkKeepNode();
                    }
                } else {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                return xMLAttr;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l = this.xdbRemoveAttributeNode(this.parent.xdbGetCtx(), this.cstate, string, string2);
                return this.parent.xdbGetNodeFromId(l, (short)2);
            }
        }
        return null;
    }

    XMLAttr xdbGetNextAttr(XMLAttr xMLAttr) {
        this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
        if (this.cstate != 0L) {
            int n = this.xdbGetNumAttrs(this.parent.xdbGetCtx(), this.cstate);
            long l = 0L;
            long l2 = xMLAttr.xdbGetNodeId();
            for (int i = 0; i < n; ++i) {
                long l3 = this.xdbGetNodeItemAt(this.parent.xdbGetCtx(), this.cstate, i);
                if (l == l2) {
                    return (XMLAttr)this.parent.xdbGetNodeFromId(l3, (short)2);
                }
                l = l3;
            }
        }
        return null;
    }
}

