/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.xml.jaxp.JXDocumentBuilder;
import oracle.xml.parser.v2.DOMParser;

public class JXDocumentBuilderFactory
extends DocumentBuilderFactory {
    public static final String ERROR_STREAM = "oracle.xml.parser.DOMParser.ErrorStream";
    public static final String ERROR_ENCODING = "oracle.xml.parser.DOMParser.ErrorEncoding";
    public static final String SHOW_WARNINGS = "oracle.xml.parser.DOMParser.ShowWarning";
    public static final String DEBUG_MODE = "oracle.xml.parser.DOMParser.DebugMode";
    public static final String NODE_FACTORY = "oracle.xml.parser.DOMParser.NodeFactory";
    public static final String DTD_OBJECT = "oracle.xml.parser.XMLParser.DTDObject";
    public static final String USE_DTD_ONLY_FOR_VALIDATION = "oracle.xml.parser.XMLParser.UseDTDForValidation";
    public static final String SCHEMA_OBJECT = "oracle.xml.parser.XMLParser.SchemaObject";
    public static final String BASE_URL = "oracle.xml.parser.XMLParser.BaseURL";
    public static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String XSDRECNS = "http://www.w3.org/2001/XMLSchema";
    private Hashtable attributes;
    private boolean secure = false;
    private boolean compact_doc = true;
    private boolean deterministic = true;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        JXDocumentBuilder jXDocumentBuilder = new JXDocumentBuilder();
        DOMParser dOMParser = jXDocumentBuilder.getDOMParser();
        if (!this.isExpandEntityReferences()) {
            dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", Boolean.FALSE);
        }
        dOMParser.setValidationMode(this.isValidating());
        dOMParser.retainCDATASection(!this.isCoalescing());
        dOMParser.setIgnoringComments(this.isIgnoringComments());
        if (this.isIgnoringElementContentWhitespace()) {
            dOMParser.resetPreserveWhitespace();
        } else {
            dOMParser.setPreserveWhitespace(true);
        }
        dOMParser.setAttribute("oracle.xml.parser.DOMParser.CompactDoc", new Boolean(this.compact_doc));
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ContentModelDeterministic", new Boolean(this.deterministic));
        if (this.secure) {
            dOMParser.setEntityDepth(11);
            dOMParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", Boolean.FALSE);
            dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionCountLimit", 64000);
        } else {
            dOMParser.setEntityDepth(16);
            dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionCountLimit", 64000);
        }
        if (this.attributes != null) {
            Enumeration enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.isValidating() && (string.equals(SCHEMA_LANGUAGE) || string.equals(SCHEMA_SOURCE))) continue;
                dOMParser.setAttribute(string, this.attributes.get(string));
            }
            jXDocumentBuilder.setConnection((Connection)this.attributes.get("oracle.xml.parser.XMLDocument.Connection"));
            jXDocumentBuilder.setDOMKind((String)this.attributes.get("oracle.xml.parser.XMLDocument.Kind"));
        }
        return jXDocumentBuilder;
    }

    public boolean isIgnoreElementContentWhitespace() {
        return this.isIgnoringElementContentWhitespace();
    }

    public void setIgnoreElementContentWhitespace(boolean bl) {
        this.setIgnoringElementContentWhitespace(bl);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (this.isValidAttribute(string)) {
            if (string == "oracle.xdkjava.security.entityExpansionDepth") {
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                int n = (Integer)object;
                if (n < 0 || n > 16) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.attributes == null) {
                this.attributes = new Hashtable(5);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (this.isValidAttribute(string)) {
            if (this.attributes != null) {
                return this.attributes.get(string);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    private boolean isValidAttribute(String string) {
        if ((string = string.intern()) == ERROR_STREAM || string == ERROR_ENCODING || string == SHOW_WARNINGS || string == DEBUG_MODE || string == NODE_FACTORY || string == DTD_OBJECT || string == SCHEMA_OBJECT || string == BASE_URL || string == "oracle.xml.parser.XMLDocument.Connection" || string == "oracle.xml.parser.XMLDocument.Kind" || string == USE_DTD_ONLY_FOR_VALIDATION || string == SCHEMA_LANGUAGE || string == "oracle.xdkjava.security.entityExpansionDepth" || string == "oracle.xdkjava.security.entityExpansionCountLimit" || string == "oracle.xml.parser.XMLParser.AllowIllegalUTF8Encoding") {
            return true;
        }
        if (string == SCHEMA_SOURCE) {
            return this.attributes != null && (String)this.attributes.get(SCHEMA_LANGUAGE) == XSDRECNS;
        }
        return false;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (string == null) {
            throw new ParserConfigurationException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.secure = bl;
        } else if (string.equals("http://oracle.com/oracle.xml.parser.DOMParser.CompactDoc")) {
            this.compact_doc = bl;
        } else if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            this.deterministic = bl;
        } else {
            throw new ParserConfigurationException();
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.secure;
        }
        if (string.equals("http://oracle.com/oracle.xml.parser.DOMParser.CompactDoc")) {
            return this.compact_doc;
        }
        if (string.equals("oracle.xml.parser.XMLParser.ContentModelDeterministic")) {
            return this.deterministic;
        }
        throw new ParserConfigurationException();
    }
}

