/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class CXMLReader
implements InfosetReader,
CXMLConstants {
    byte[] buf;
    char[] chdata;
    int chdataLen;
    int eventType;
    int flags;
    int pageid;
    int readPos;
    int evtPageId;
    int evtOffset;
    boolean evtInit;
    QxName qname;
    SAXAttrList attrs;
    TypeInfo typeinfo;
    TypeInfo attrtypeinfo;
    CXMLStream stream;
    private byte cxml_version = (byte)4;

    CXMLReader(CXMLStream cXMLStream) {
        this.stream = cXMLStream;
        this.evtInit = true;
        this.attrs = new SAXAttrList(4);
        this.chdata = new char[256];
        this.typeinfo = new TypeInfo();
        this.attrtypeinfo = new TypeInfo();
        this.init();
    }

    public void init() {
        this.evtPageId = 0;
        this.pageid = 0;
        this.evtOffset = 0;
        this.readPos = 0;
        this.buf = this.stream.load(this.pageid, false);
    }

    public boolean isNSResolutionSupported() {
        return false;
    }

    public BinaryStream getStream() {
        return this.stream;
    }

    public String getNamespaceURI(String string) {
        return null;
    }

    public String getPrefix(String string) {
        return null;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public InfosetReader.Offset getOffset() {
        return new Offset(this.evtPageId, (short)this.evtOffset);
    }

    public void seek(InfosetReader.Offset offset) {
        this.stream.unload(this.pageid, false, this.buf);
        Offset offset2 = (Offset)offset;
        this.pageid = offset2.pageid;
        this.readPos = offset2.pageoffset;
        this.evtInit = true;
        this.buf = this.stream.load(this.pageid, false);
        this.next();
    }

    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        Offset offset2 = (Offset)offset;
        if (n + 6 > byArray.length) {
            return -1;
        }
        byArray[n++] = (byte)(offset2.pageid >>> 24 & 0xFF);
        byArray[n++] = (byte)(offset2.pageid >>> 16 & 0xFF);
        byArray[n++] = (byte)(offset2.pageid >>> 8 & 0xFF);
        byArray[n++] = (byte)(offset2.pageid >>> 0 & 0xFF);
        byArray[n++] = (byte)(offset2.pageoffset >>> 8 & 0xFF);
        byArray[n++] = (byte)(offset2.pageoffset >>> 0 & 0xFF);
        return 6;
    }

    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        if (n + 6 > byArray.length) {
            return null;
        }
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        n2 = byArray[n++] & 0xFF;
        n3 = byArray[n++] & 0xFF;
        short s = (short)((n2 << 8) + n3);
        return new Offset(n6, s);
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean hasNext() {
        return this.eventType != 8;
    }

    public void next() {
        try {
            if (!this.evtInit) {
                this.initEvent();
            }
            this.evtPageId = this.pageid;
            this.evtOffset = this.readPos;
            this.evtInit = true;
            this.flags = 0;
            byte by = this.peekByte();
            switch (by) {
                case 0: {
                    this.eventType = 7;
                    this.readDocument();
                    break;
                }
                case 15: 
                case 28: {
                    this.eventType = 1;
                    this.evtInit = false;
                    break;
                }
                case 24: 
                case 25: {
                    this.eventType = 10;
                    this.evtInit = false;
                    break;
                }
                case 23: {
                    this.eventType = 4;
                    this.evtInit = false;
                    break;
                }
                case 21: {
                    this.eventType = 12;
                    this.evtInit = false;
                    break;
                }
                case 20: {
                    this.eventType = 3;
                    this.evtInit = false;
                    break;
                }
                case 29: {
                    this.eventType = 5;
                    this.evtInit = false;
                    break;
                }
                case 30: {
                    this.eventType = 14;
                    this.evtInit = false;
                    break;
                }
                case 22: {
                    this.eventType = 2;
                    this.readByte();
                    break;
                }
                case 37: {
                    this.eventType = 8;
                    this.readByte();
                    break;
                }
                case 31: {
                    this.eventType = 11;
                    this.evtInit = false;
                    break;
                }
                default: {
                    throw new RuntimeException("byte " + by + " at " + this.readPos + " in " + this.pageid);
                }
            }
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initEvent() {
        try {
            this.readPos = this.evtOffset;
            this.flags = 0;
            switch (this.eventType) {
                case 1: {
                    this.qname = this.readElemQName();
                    this.readTypeInfo(this.typeinfo);
                    this.skipElemSize();
                    this.readAttributes();
                    this.skipElemSize();
                    break;
                }
                case 10: {
                    this.qname = this.readAttrQName();
                    this.readTypeInfo(this.typeinfo);
                    this.readChars();
                    this.checkNullStr();
                    if (!this.readBoolean()) break;
                    this.flags |= 0x10000;
                    break;
                }
                case 4: {
                    this.readByte();
                    this.readChars();
                    this.checkNullStr();
                    break;
                }
                case 12: {
                    this.readByte();
                    this.readChars();
                    this.checkNullStr();
                    break;
                }
                case 3: {
                    this.readByte();
                    this.qname = this.readTagName();
                    this.readChars();
                    this.checkNullStr();
                    if (!this.readBoolean()) break;
                    this.flags |= 0x80;
                    break;
                }
                case 5: {
                    this.readByte();
                    this.readChars();
                    this.checkNullStr();
                    if (!this.readBoolean()) break;
                    this.flags |= 0x80;
                    break;
                }
                case 14: {
                    this.readByte();
                    this.qname = this.readTagName();
                    break;
                }
                case 11: {
                    DTD dTD;
                    DTD dTD2 = dTD = this.stream.getDTD();
                    synchronized (dTD2) {
                        if (this.stream.dtdEnd == -1) {
                            dTD.readNodeInfo(this, true);
                            this.stream.dtdEnd = this.readPos;
                        } else {
                            this.readPos = this.stream.dtdEnd;
                        }
                        break;
                    }
                }
                default: {
                    throw new RuntimeException("event " + this.eventType + " at " + this.readPos + " in " + this.pageid);
                }
            }
            this.evtInit = true;
        }
        catch (IOException iOException) {
            RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
    }

    public void skip() {
        if (!this.evtInit) {
            this.initEvent();
        }
        if (this.eventType == 1) {
            try {
                this.skipContent(true);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException(iOException.getMessage());
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
            this.eventType = 2;
        } else {
            this.next();
        }
    }

    public String getEncoding() {
        return this.stream.getEncoding();
    }

    public String getVersion() {
        return this.stream.getVersion();
    }

    public String getStandalone() {
        return this.stream.getStandalone();
    }

    public DTD getDoctype() {
        return this.stream.getDTD();
    }

    public QName getQName() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.qname;
    }

    public QName getTypeName() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.typeinfo.typename;
    }

    public int getPrimitiveTypeId() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.typeinfo.typeid;
    }

    public boolean isGlobal() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.typeinfo.global;
    }

    public boolean isNilled() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.typeinfo.nillable;
    }

    public TypedAttributes getAttributes() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.attrs;
    }

    public String getAttribute(QName qName) {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.attrs.getValue(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public String getValue() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return new String(this.chdata, 0, this.chdataLen);
    }

    public char[] getData() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.chdata;
    }

    public int getDataStart() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return 0;
    }

    public int getDataLength() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.chdataLen;
    }

    public int getEventFlags() {
        if (!this.evtInit) {
            this.initEvent();
        }
        return this.flags;
    }

    public void close() {
        this.stream.returnInfosetReader(this);
    }

    public Object clone() {
        CXMLReader cXMLReader = (CXMLReader)this.stream.getInfosetReader();
        cXMLReader.pageid = this.pageid;
        cXMLReader.readPos = this.readPos;
        cXMLReader.eventType = this.eventType;
        cXMLReader.evtPageId = this.evtPageId;
        cXMLReader.evtOffset = this.evtOffset;
        cXMLReader.evtInit = this.evtInit;
        cXMLReader.qname = this.qname;
        cXMLReader.flags = this.flags;
        cXMLReader.chdataLen = this.chdataLen;
        cXMLReader.attrs.copy(this.attrs);
        cXMLReader.typeinfo.copy(this.typeinfo);
        cXMLReader.attrtypeinfo.copy(this.attrtypeinfo);
        System.arraycopy(this.chdata, 0, cXMLReader.chdata, 0, this.chdataLen);
        return cXMLReader;
    }

    private void readChars() throws IOException {
        int n = this.readUTF8Len();
        if (n > this.chdata.length) {
            this.chdata = new char[n];
        }
        this.chdataLen = this.readUTFChars(this.chdata, n);
    }

    private void readAttributes() throws IOException {
        int n = 0;
        byte by = this.peekByte();
        this.attrs.reset();
        while (by == 25 || by == 24) {
            QxName qxName = this.readQName(false);
            this.readTypeInfo(this.attrtypeinfo);
            String string = this.readUTF();
            if (string == null) {
                string = "";
            }
            boolean bl = this.readBoolean();
            this.attrs.addAttr(qxName.getPrefix(), qxName.getLocalPart(), qxName.getQName(), string, bl, 0, qxName.getNamespaceURI());
            this.attrs.setTypeInfo(n, this.attrtypeinfo.typeid, this.attrtypeinfo.typename);
            by = this.peekByte();
            ++n;
        }
    }

    public byte readByte() throws IOException {
        if (this.readPos >= CXMLStream.BUFSIZE) {
            this.stream.unload(this.pageid, false, this.buf);
            this.buf = this.stream.load(++this.pageid, false);
            this.readPos = 0;
        }
        return this.buf[this.readPos++];
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public byte peekByte() throws IOException {
        if (this.readPos >= CXMLStream.BUFSIZE) {
            byte[] byArray = this.stream.load(this.pageid + 1, false);
            byte by = byArray[0];
            this.stream.unload(this.pageid + 1, false, byArray);
            return by;
        }
        return this.buf[this.readPos];
    }

    public int readShort() throws IOException {
        int n = this.readByte() & 0xFF;
        int n2 = this.readByte() & 0xFF;
        return (n << 8) + n2;
    }

    public char readChar() throws IOException {
        int n = this.readByte() & 0xFF;
        int n2 = this.readByte() & 0xFF;
        return (char)((n << 8) + n2);
    }

    public int readInt() throws IOException {
        int n = this.readByte() & 0xFF;
        int n2 = this.readByte() & 0xFF;
        int n3 = this.readByte() & 0xFF;
        int n4 = this.readByte() & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public String readUTF() throws IOException {
        int n = this.readUTF8Len();
        if (n > this.chdata.length) {
            this.chdata = new char[n];
        }
        this.chdataLen = this.readUTFChars(this.chdata, n);
        String string = new String(this.chdata, 0, this.chdataLen);
        if (this.cxml_version == 4 && this.chdataLen == 1 && this.chdata[0] == '\u0017') {
            string = null;
        } else if (this.cxml_version == 2 && string.equals("null")) {
            string = null;
        }
        return string;
    }

    QxName readElemQName() throws IOException {
        return this.readQName(true);
    }

    QxName readAttrQName() throws IOException {
        return this.readQName(false);
    }

    QxName readQName(boolean bl) throws IOException {
        byte by;
        byte by2;
        int n;
        String string = "";
        String string2 = "";
        CXMLCodeSpace cXMLCodeSpace = bl ? this.stream.elemCodeSpace : this.stream.attrCodeSpace;
        byte by3 = this.readByte();
        if (by3 == (bl ? (byte)28 : 25)) {
            string = this.readUTF();
            if (this.cxml_version == 2 && string == null) {
                string = "null";
            }
            cXMLCodeSpace.addToken(string);
        } else if (by3 == (bl ? (byte)15 : 24)) {
            by3 = this.readByte();
            if ((by3 & 0x80) == 128) {
                n = CXMLCodeSpace.extractTokenValue(by3, this.readByte());
            } else if ((by3 & 0xC0) == 192) {
                by2 = this.readByte();
                by = this.readByte();
                n = CXMLCodeSpace.extractTokenValue(by3, by2, by);
            } else {
                n = by3;
            }
            string = cXMLCodeSpace.getElementFromToken(n);
        }
        by3 = this.peekByte();
        if (by3 == 27 || by3 == 33) {
            by3 = this.readByte();
            if (by3 == 27) {
                string2 = this.readUTF();
                this.stream.nsCodeSpace.addToken(string2);
            } else {
                by3 = this.readByte();
                if ((by3 & 0x80) == 128) {
                    n = CXMLCodeSpace.extractTokenValue(by3, this.readByte());
                } else if ((by3 & 0xC0) == 192) {
                    by2 = this.readByte();
                    by = this.readByte();
                    n = CXMLCodeSpace.extractTokenValue(by3, by2, by);
                } else {
                    n = by3;
                }
                string2 = this.stream.nsCodeSpace.getElementFromToken(n);
            }
        }
        QxName qxName = QxNameHash.create(string2, string);
        return qxName;
    }

    void readTypeInfo(TypeInfo typeInfo) throws IOException {
        typeInfo.clear();
        byte by = this.peekByte();
        if (by == 35 || by == 36) {
            this.readByte();
            byte by2 = this.readByte();
            typeInfo.nillable = (by2 & 2) == 2;
            boolean bl = typeInfo.global = (by2 & 1) == 1;
            if ((by2 & 4) == 4) {
                typeInfo.typeid = this.readByte();
            }
            int n = (by2 & 8) == 8 ? this.readInt() : this.readShort();
            if (by == 35) {
                String string = this.readUTF();
                String string2 = this.readUTF();
                typeInfo.typename = QxNameHash.create(string, string2);
                this.ensureTypeCapacity(n + 1);
                this.stream.getTypeList().set(n, typeInfo.typename);
            } else {
                typeInfo.typename = (QxName)this.stream.getTypeList().get(n);
            }
        }
    }

    void readDocument() throws IOException {
        int n;
        char[] cArray = new char[cXMLFILE_LEN];
        for (n = 0; n < cXMLFILE_LEN; ++n) {
            cArray[n] = this.readChar();
            if (cArray[n] == cXMLFILE[n]) continue;
            throw new IOException("Error: The binary stream is not a compressed serialized stream");
        }
        n = this.readByte();
        if (n != 4 && n != 2) {
            throw new IOException("Error: The binary stream version is not compatible with this release of parser.");
        }
        this.cxml_version = (byte)n;
        n = this.peekByte();
        if (n == 16) {
            this.readByte();
            String string = this.readUTF();
            this.stream.setVersion(string);
            String string2 = this.readUTF();
            this.stream.setEncoding(string2);
            n = this.readByte();
            if (n == 1) {
                this.stream.setStandalone("yes");
            } else if (n == 16) {
                this.stream.setStandalone("no");
            } else if (n == 17) {
                this.stream.setStandalone(null);
            }
        }
    }

    int readUTF8Len() throws IOException {
        int n = this.readShort();
        if (n == 65535) {
            n = this.readInt();
        }
        return n;
    }

    int readUTFChars(char[] cArray, int n) throws IOException {
        int n2 = 0;
        block5: while (n > 0) {
            int n3 = this.readByte() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    --n;
                    cArray[n2++] = (char)n3;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (n < 2) {
                        throw new UTFDataFormatException();
                    }
                    n -= 2;
                    byte by = this.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n2++] = (char)((n3 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    if (n < 3) {
                        throw new UTFDataFormatException();
                    }
                    n -= 3;
                    byte by = this.readByte();
                    byte by2 = this.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n2++] = (char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return n2;
    }

    private final QxName readTagName() throws IOException {
        String string = this.readUTF();
        return QxNameHash.create("", string, "", string);
    }

    private void skipContent(boolean bl) throws IOException {
        int n = 1;
        block10: do {
            byte by = this.readByte();
            switch (by) {
                case 15: 
                case 28: {
                    ++n;
                    this.skipToken(by);
                    this.skipAttrs();
                    break;
                }
                case 24: 
                case 25: {
                    this.skipToken(by);
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 21: 
                case 23: {
                    this.skipString();
                    break;
                }
                case 16: 
                case 20: {
                    this.skipString();
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 29: {
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 31: {
                    --this.readPos;
                    DTD dTD = this.stream.getDTD();
                    if (dTD == null) {
                        dTD = new DTD();
                        dTD.readNodeInfo(this, true);
                        this.stream.setDTD(dTD);
                        this.stream.dtdEnd = this.readPos;
                        break;
                    }
                    this.readPos = this.stream.dtdEnd;
                    break;
                }
                case 22: {
                    --n;
                    break;
                }
                case 34: {
                    int n2 = this.readShort();
                    if (!bl || this.readPos + n2 > CXMLStream.BUFSIZE) continue block10;
                    this.readPos += n2;
                    break;
                }
                default: {
                    throw new RuntimeException("byte " + by + " at " + (this.readPos - 1) + " in " + this.pageid);
                }
            }
        } while (bl && n != 0);
    }

    void skipElemSize() throws IOException {
        byte by = this.peekByte();
        if (by == 34) {
            this.skipByte();
            this.skipByte();
            this.skipByte();
        }
    }

    private void skipAttrs() throws IOException {
        byte by;
        while ((by = this.peekByte()) == 25 || by == 24) {
            this.skipByte();
            this.skipToken(by);
            this.skipString();
            this.skipByte();
        }
    }

    private void skipByte() throws IOException {
        if (this.readPos >= CXMLStream.BUFSIZE) {
            this.stream.unload(this.pageid, false, this.buf);
            this.buf = this.stream.load(++this.pageid, false);
            this.readPos = 0;
        }
        ++this.readPos;
    }

    private void skipString() throws IOException {
        int n = this.readShort();
        if (n == 65535) {
            n = this.readInt();
        }
        this.readPos += n;
        while (this.readPos >= CXMLStream.BUFSIZE) {
            this.readPos -= CXMLStream.BUFSIZE;
            this.stream.unload(this.pageid, false, this.buf);
            this.buf = this.stream.load(++this.pageid, false);
        }
    }

    private void skipToken(byte by) throws IOException {
        String string;
        if (by == 28 || by == 25) {
            string = this.readUTF();
            if (by == 28) {
                this.stream.elemCodeSpace.addToken(string);
            } else if (by == 25) {
                this.stream.attrCodeSpace.addToken(string);
            }
        } else {
            byte by2 = this.readByte();
            if ((by2 & 0x80) == 128) {
                this.skipByte();
            }
            if ((by2 & 0xC0) == 192) {
                this.skipByte();
            }
        }
        by = this.peekByte();
        if (by == 27) {
            this.skipByte();
            string = this.readUTF();
            this.stream.nsCodeSpace.addToken(string);
        } else if (by == 33) {
            this.skipByte();
            byte by3 = this.readByte();
            if ((by3 & 0x80) == 128) {
                this.skipByte();
            }
            if ((by3 & 0xC0) == 192) {
                this.skipByte();
            }
        }
        by = this.peekByte();
        if (by == 35 || by == 36) {
            this.readByte();
            byte by4 = this.readByte();
            int n = (by4 & 8) == 8 ? this.readInt() : this.readShort();
            if ((by4 & 4) == 4) {
                this.readByte();
            }
            if (by == 35) {
                String string2 = this.readUTF();
                String string3 = this.readUTF();
                QxName qxName = QxNameHash.create(string2, string3);
                this.ensureTypeCapacity(n + 1);
                this.stream.getTypeList().set(n, qxName);
            }
        }
    }

    private void ensureTypeCapacity(int n) {
        int n2;
        Vector vector = this.stream.getTypeList();
        for (int i = n2 = vector.size(); i < n; ++i) {
            vector.add(null);
        }
    }

    private void checkNullStr() {
        String string;
        if (this.cxml_version == 4 && this.chdataLen == 1 && this.chdata[0] == '\u0017') {
            this.chdataLen = 0;
            this.chdata = null;
        } else if (this.cxml_version == 2 && (string = new String(this.chdata, 0, this.chdataLen)).equals("null")) {
            this.chdataLen = 0;
        }
    }

    static class Offset
    implements InfosetReader.Offset {
        int pageid;
        short pageoffset;

        Offset(int n, short s) {
            this.pageid = n;
            this.pageoffset = s;
        }

        public int compareTo(Object object) {
            Offset offset = (Offset)object;
            int n = this.pageid - offset.pageid;
            if (n == 0) {
                return this.pageoffset - offset.pageoffset;
            }
            return n;
        }

        public String toString() {
            long l = this.pageid;
            return "ID".concat(Long.toString((l << 16) + (long)this.pageoffset));
        }

        public boolean equals(Object object) {
            if (object instanceof Offset) {
                Offset offset = (Offset)object;
                return this.compareTo(offset) == 0;
            }
            return false;
        }
    }

    static class TypeInfo {
        QxName typename;
        int typeid;
        boolean global;
        boolean nillable;

        TypeInfo() {
        }

        void clear() {
            this.typename = null;
            this.typeid = -1;
            this.global = false;
            this.nillable = false;
        }

        public void copy(TypeInfo typeInfo) {
            this.typename = typeInfo.typename;
            this.typeid = typeInfo.typeid;
            this.global = typeInfo.global;
            this.nillable = typeInfo.nillable;
        }
    }
}

