/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.event;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import oracle.jdbc.OracleDriver;
import oracle.xdb.XDBOutputStream;
import oracle.xdb.XMLType;
import oracle.xdb.event.XDBEvent;
import oracle.xdb.event.XDBHandlerList;
import oracle.xdb.event.XDBLink;
import oracle.xdb.event.XDBLock;
import oracle.xdb.event.XDBPath;
import oracle.xdb.event.XDBRenderStream;
import oracle.xdb.servlet.XDBServletRequest;
import oracle.xdb.spi.XDBResource;

public class XDBRepositoryEvent
extends XDBEvent {
    private static final int OPEN_ACCESS_READ = 1;
    private static final int OPEN_ACCESS_WRITE = 2;
    private static final int OPEN_ACCESS_READ_WRITE = 3;
    private static final int OPEN_DENY_NONE = 0;
    private static final int OPEN_DENY_READ = 1;
    private static final int OPEN_DENY_READ_WRITE = 2;
    protected Connection m_conn;

    private synchronized native String getInterfaceNative(long var1, long var3);

    private synchronized native boolean checkServletNative(long var1, long var3);

    private synchronized native long getPathNative(long var1, long var3);

    private synchronized native long getResourceNative(long var1, long var3);

    private synchronized native long getParentNative(long var1, long var3);

    private synchronized native long getLockNative(long var1, long var3);

    private synchronized native long getLinkNative(long var1, long var3);

    private synchronized native long getOldResourceNative(long var1, long var3);

    private synchronized native long getHandlerListNative(long var1, long var3);

    private synchronized native String getParameterNative(long var1, long var3, String var5);

    private synchronized native long getOutputStreamNative(long var1, long var3);

    private synchronized native int getStreamOffsetNative(long var1, long var3);

    private synchronized native void setRenderStreamNative(long var1, long var3, long var5);

    private synchronized native void setRenderPathNative(long var1, long var3, String var5);

    private synchronized native long getApplicationDataNative(long var1, long var3);

    private synchronized native long allocHeapNative(long var1, long var3, long var5);

    private synchronized native long WriteToSegStreamNative(long var1, long var3, long var5, long var7, byte[] var9, int var10, int var11, long var12);

    XDBRepositoryEvent(long ev) {
        super(ev);
    }

    @Deprecated
    public String getInterface() {
        return this.getInterfaceNative(XDBResource.getServerEnv(), this.m_evcstate);
    }

    @Deprecated
    public HttpServletRequest getServletRequest() {
        this.checkServletNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBServletRequest();
    }

    @Deprecated
    public XMLType getApplicationData() {
        XMLType xt;
        long cstate = this.getApplicationDataNative(XDBResource.getServerEnv(), this.m_evcstate);
        try {
            if (this.m_conn == null) {
                DriverManager.registerDriver((Driver)new OracleDriver());
                OracleDriver ora = new OracleDriver();
                this.m_conn = ora.defaultConnection();
            }
            xt = new XMLType(this.m_conn, cstate);
        }
        catch (SQLException e) {
            return null;
        }
        return xt;
    }

    @Deprecated
    public XDBPath getPath() {
        long cstate = this.getPathNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBPath(cstate);
    }

    @Deprecated
    public XDBResource getResource() {
        long cstate = this.getResourceNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    @Deprecated
    public XDBResource getParent() {
        long cstate = this.getParentNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    @Deprecated
    public XDBHandlerList getHandlerList() {
        long cstate = this.getHandlerListNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBHandlerList(cstate);
    }

    @Deprecated
    public XDBLink getLink() {
        long cstate = this.getLinkNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBLink(cstate);
    }

    @Deprecated
    public String getParameter(String key) {
        return this.getParameterNative(XDBResource.getServerEnv(), this.m_evcstate, key);
    }

    @Deprecated
    public XDBResource getOldResource() {
        long cstate = this.getOldResourceNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBResource(null, null, cstate);
    }

    @Deprecated
    public XDBOutputStream getOutputStream() {
        long gp = XDBResource.getServerEnv();
        long os = this.getOutputStreamNative(gp, this.m_evcstate);
        int offset = this.getStreamOffsetNative(gp, this.m_evcstate);
        return new XDBRenderStream(gp, os, this.m_evcstate, offset);
    }

    @Deprecated
    private long inputToSegStream(long gp, InputStream istr, long svchdl, long errhdl, long strmHeap) throws SQLException {
        long segstream = 0L;
        byte[] buf = new byte[1024];
        try {
            int nread;
            int off = 0;
            while ((nread = istr.read(buf)) != -1) {
                segstream = this.WriteToSegStreamNative(gp, svchdl, errhdl, segstream, buf, off, nread, strmHeap);
                off += nread;
            }
        }
        catch (IOException e) {
            throw new SQLException();
        }
        return segstream;
    }

    @Deprecated
    public void setRenderStream(InputStream istr) throws SQLException {
        long strmHeap = this.allocHeapNative(XDBResource.getServerEnv(), 0L, 0L);
        long segstream = this.inputToSegStream(XDBResource.getServerEnv(), istr, 0L, 0L, strmHeap);
        this.setRenderStreamNative(XDBResource.getServerEnv(), this.m_evcstate, segstream);
    }

    @Deprecated
    public void setRenderPath(String path) {
        this.setRenderPathNative(XDBResource.getServerEnv(), this.m_evcstate, path);
    }

    @Deprecated
    public XDBLock getLock() {
        long cstate = this.getLockNative(XDBResource.getServerEnv(), this.m_evcstate);
        return new XDBLock(cstate);
    }

    @Deprecated
    private BigInteger getUpdateByteOffset() {
        return null;
    }

    @Deprecated
    private long getUpdateByteCount() {
        return 0L;
    }

    @Deprecated
    private int getOpenAccessMode() {
        return 0;
    }

    @Deprecated
    private int getOpenDenyMode() {
        return 0;
    }
}

