/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.cert.CertificateVerifier;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.core.AuthenticationException;

public class TrustedCAPolicy
implements CertificateTrustPolicy {
    private boolean requireCRL = false;
    private boolean requireCA = true;
    private LinkedHashMap<X500Name, X509> trustedTable = new LinkedHashMap();

    public TrustedCAPolicy() {
    }

    public TrustedCAPolicy(Vector<X509> trustedCACerts, boolean requireCRL, boolean requireCA) {
        this((List<X509>)trustedCACerts, requireCRL, requireCA);
    }

    public TrustedCAPolicy(List<X509> trustedCACerts, boolean requireCRL, boolean requireCA) {
        this.setTrustedCAs(trustedCACerts);
        this.requireCRL = requireCRL;
        this.requireCA = requireCA;
    }

    @Override
    public CertificateVerifier makeCertificateVerifier(Vector<X509> certificates, Vector<CRL> crls) {
        return this.makeCertificateVerifier((List<X509>)certificates, (List<CRL>)crls);
    }

    public CertificateVerifier makeCertificateVerifier(List<X509> certificates, List<CRL> crls) {
        return new TrustedCACertificateVerifier(certificates, crls);
    }

    public void addTrustedCA(X509 trustedCACert) {
        this.trustedTable.put(trustedCACert.getSubject(), trustedCACert);
    }

    public void setRequireCRLs(boolean flag) {
        this.requireCRL = flag;
    }

    public boolean getRequireCRLs() {
        return this.requireCRL;
    }

    public void setRequireCAFlag(boolean flag) {
        this.requireCA = flag;
    }

    public boolean getRequireCAFlag() {
        return this.requireCA;
    }

    public void setTrustedCAs(Vector<X509> trustedCACerts) {
        this.setTrustedCAs((List<X509>)trustedCACerts);
    }

    public void setTrustedCAs(List<X509> trustedCACerts) {
        this.trustedTable.clear();
        if (trustedCACerts == null) {
            return;
        }
        for (X509 c : trustedCACerts) {
            this.trustedTable.put(c.getSubject(), c);
        }
    }

    @Deprecated
    public Enumeration<X509> trustedCAs() {
        return this.trustedTable == null ? null : new Vector<X509>(this.trustedTable.values()).elements();
    }

    public ArrayList<X509> getTrustedCAs() {
        return this.trustedTable == null ? null : new ArrayList<X509>(this.trustedTable.values());
    }

    class TrustedCACertificateVerifier
    implements CertificateVerifier {
        private LinkedHashMap<IssuerAndSerialNo, X509> iasnTable = new LinkedHashMap();
        private LinkedHashMap<X500Name, X509> subjectTable = new LinkedHashMap();
        private LinkedHashMap<X500Name, CRL> crlTable = new LinkedHashMap();

        TrustedCACertificateVerifier(List<X509> certificates, List<CRL> crls) {
            if (certificates != null) {
                int size = certificates.size();
                for (int i = 0; i < size; ++i) {
                    X509 cert = certificates.get(i);
                    IssuerAndSerialNo iasn = new IssuerAndSerialNo(cert);
                    this.iasnTable.put(iasn, cert);
                    this.subjectTable.put(cert.getSubject(), cert);
                }
            }
            if (crls != null) {
                for (CRL crl : crls) {
                    this.crlTable.put(crl.getIssuer(), crl);
                }
            }
        }

        @Override
        public X509 getValidCertificate(IssuerAndSerialNo iasn) throws AuthenticationException {
            X509 cert = this.iasnTable.get(iasn);
            if (cert == null) {
                return null;
            }
            if (TrustedCAPolicy.this.trustedTable.containsKey(cert.getSubject())) {
                return cert;
            }
            ArrayList<X509> certChain = new ArrayList<X509>();
            X500Name holder = null;
            while (cert != null) {
                X509 obj = this.subjectTable.get(cert.getIssuer());
                if (obj != null && certChain.contains(obj)) {
                    throw new AuthenticationException("Chain does not terminate with a trusted CA");
                }
                certChain.add(cert);
                holder = cert.getIssuer();
                cert = this.subjectTable.get(holder);
                if (TrustedCAPolicy.this.trustedTable.containsKey(holder)) break;
                if (cert != null) continue;
                throw new AuthenticationException("Chain does not terminate with a trusted CA");
            }
            X509 certCA = (X509)TrustedCAPolicy.this.trustedTable.get(holder);
            boolean notFirstCert = false;
            while (!certChain.isEmpty()) {
                BasicConstraintsExtension bc;
                cert = (X509)certChain.get(certChain.size() - 1);
                CRL crlist = this.crlTable.get(certCA.getSubject());
                cert.setIssuerCertificate(certCA);
                if (crlist != null) {
                    cert.setIssuerCRL(crlist);
                } else if (TrustedCAPolicy.this.requireCRL) {
                    throw new AuthenticationException("CRL not found for certificate");
                }
                if (TrustedCAPolicy.this.requireCA && notFirstCert && ((bc = (BasicConstraintsExtension)certCA.getExtension(PKIX.id_ce_basicConstraints)) == null || !bc.getCA())) {
                    throw new AuthenticationException("Certificate is not a CA");
                }
                if (!cert.verify()) {
                    throw new AuthenticationException("Certificate invalid");
                }
                certCA = cert;
                certChain.remove(certChain.size() - 1);
                notFirstCert = true;
            }
            return cert;
        }
    }
}

