/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class AuthorityKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_authorityKeyIdentifier;
    private byte[] keyID = null;
    private Vector issuer = null;
    private BigInteger serialNo = null;

    public AuthorityKeyIDExtension() {
        super(TYPE);
    }

    public AuthorityKeyIDExtension(byte[] keyID) {
        this(keyID, false);
    }

    public AuthorityKeyIDExtension(byte[] keyID, boolean critical) {
        super(TYPE, critical);
        this.keyID = keyID;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(GeneralName issuer, BigInteger serialNo) {
        this(issuer, serialNo, false);
    }

    public AuthorityKeyIDExtension(GeneralName issuer, BigInteger serialNo, boolean critical) {
        super(TYPE, critical);
        this.issuer = new Vector();
        this.issuer.addElement(issuer);
        this.serialNo = serialNo;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(Vector issuer, BigInteger serialNo) {
        this(issuer, serialNo, false);
    }

    public AuthorityKeyIDExtension(Vector issuer, BigInteger serialNo, boolean critical) {
        super(TYPE, critical);
        this.issuer = issuer;
        this.serialNo = serialNo;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(InputStream is) throws IOException {
        super(is);
    }

    public byte[] getAuthorityKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    public Enumeration authorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer != null ? this.issuer.elements() : null;
    }

    public BigInteger getAuthorityCertSerialNo() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.serialNo;
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        if (this.keyID != null) {
            seq.addElement((ASN1Object)new ASN1GenericPrimitive(this.keyID, 0));
        }
        if (this.issuer != null && this.serialNo != null) {
            seq.addElement((ASN1Object)new ASN1GenericConstructed(this.issuer, 1));
            seq.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Integer(this.serialNo), 2));
        }
        byte[] b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            if (sis.getCurrentTag() == 0) {
                sis.setCurrentTag(4);
                this.keyID = ASN1OctetString.inputValue((InputStream)sis);
            } else {
                this.keyID = null;
            }
            if (this.keyID == null || sis.hasMoreData()) {
                if (sis.getCurrentTag() == 1) {
                    sis.setCurrentTag(16);
                    ASN1SequenceInputStream names = new ASN1SequenceInputStream((InputStream)sis);
                    this.issuer = new Vector();
                    while (names.hasMoreData()) {
                        this.issuer.addElement(new GeneralName((InputStream)names));
                    }
                    names.terminate();
                } else {
                    this.issuer = null;
                }
                if (sis.getCurrentTag() == 2) {
                    sis.setCurrentTag(2);
                    this.serialNo = ASN1Integer.inputValue((InputStream)sis);
                } else {
                    this.serialNo = null;
                }
            } else {
                this.issuer = null;
                this.serialNo = null;
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("authorityKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getAuthorityKeyID() != null) {
            s.append("keyID = " + Utils.toHexString((byte[])this.getAuthorityKeyID()));
            began = true;
        }
        if (this.getAuthorityCertSerialNo() != null) {
            if (began) {
                s.append(", ");
            }
            s.append("serialNo = " + this.getAuthorityCertSerialNo());
            began = true;
        }
        if (this.issuer != null) {
            if (began) {
                s.append(", ");
            }
            s.append("issuer = {");
            boolean mid = false;
            int size = this.issuer.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((GeneralName)this.issuer.elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

