/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.ssl.OracleSSLX509TrustManager14;

public class SSLSocketClient14 {
    private static boolean a = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        Socket socket = null;
        try {
            String string;
            Object object;
            Object object2;
            if (stringArray.length < 2) {
                System.out.println("java SSLSocketClient [host] [port] [-cert_validation_mode <strict|non-strict>]");
                System.exit(0);
            }
            Security.insertProviderAt(new OraclePKIProvider(), 1);
            KeyStore keyStore = KeyStore.getInstance(System.getProperty("javax.net.ssl.trustStoreType"), "OraclePKI");
            FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.trustStore"));
            keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
            String string2 = System.getProperty("test.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
            System.out.println("Using TrustManagerFactory =" + string2);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            if (a) {
                for (int i = 0; i < trustManagerArray.length; ++i) {
                    object2 = (OracleSSLX509TrustManager14)trustManagerArray[i];
                    ((OracleSSLX509TrustManager14)object2).a(a);
                }
            }
            KeyManager[] keyManagerArray = null;
            if (System.getProperty("javax.net.ssl.keyStore") != null) {
                object2 = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType"), "OraclePKI");
                object = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
                ((KeyStore)object2).load((InputStream)object, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
                string = System.getProperty("test.keymanager.algorithm", KeyManagerFactory.getDefaultAlgorithm());
                System.out.println("Using KeyManagerFactory = " + string);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
                keyManagerFactory.init((KeyStore)object2, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
                keyManagerArray = keyManagerFactory.getKeyManagers();
            }
            object2 = SSLContext.getInstance("SSL");
            ((SSLContext)object2).init(keyManagerArray, trustManagerArray, null);
            object = ((SSLContext)object2).getSocketFactory();
            socket = (SSLSocket)((SocketFactory)object).createSocket(stringArray[0], Integer.parseInt(stringArray[1]));
            if (stringArray.length >= 4 && stringArray[2].equals("-cert_validation_mode") && stringArray[3].equals("strict")) {
                a = true;
            }
            ((SSLSocket)socket).startHandshake();
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            printWriter.println("GET /index.html HTTP/1.1");
            printWriter.println();
            printWriter.flush();
            if (printWriter.checkError()) {
                System.out.println("SSLSocketClient:  java.io.PrintWriter error");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
            bufferedReader.close();
            printWriter.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Exception caught:");
            exception.printStackTrace(System.out);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception caught:");
                exception.printStackTrace(System.out);
                System.out.println("Error closing file input stream");
            }
        }
    }
}

