/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.NZNative;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OracleKSIdentityEntry;
import oracle.security.pki.OracleKSTrustedCertEntry;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIECPublicKey;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIRSAPublicKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSEntry;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletPermission;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.OracleTrustFlagHelper;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.internal.pkcs12.PKCS12;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12CertBag;
import oracle.security.pki.internal.pkcs12.PKCS12KeyBag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.internal.pkcs12.PKCS12SecretBag;
import oracle.security.pki.internal.pkcs12.PKCS12ShroudedKeyBag;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.CertType;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.InvalidFormatException;
import oracle.security.pki.util.TrustFlags;
import oracle.security.pki.util.Utils;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private Hashtable<String, OracleKSEntry> b = new Hashtable();
    private Hashtable<String, OracleSSEntry> c = new Hashtable();
    private String d;
    private String e;
    private String f;
    private String g;
    private static final int[] h = new int[]{1, 2, 840, 113549, 1, 12, 0, 0, 0};
    private static final byte[] i = new byte[]{0, 0, 0, 0};
    private static final int j = 0;
    private static final int k = 1;
    private static final String l = "secret";
    private static final int m = 100;
    public static final String p11LibOID = "2.16.840.1.113894.2.99.300.2";
    public static final String p11TokLblOID = "2.16.840.1.113894.2.99.300.3";
    public static final String p11TokPwdOID = "2.16.840.1.113894.2.99.300.4";
    public static final String p11CrtLblOID = "2.16.840.1.113894.2.99.300.5";
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";
    private static final String n = "orakey";

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((OracleKSIdentityEntry)this.b.get(string)).g();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        try {
            OraclePKIDebug.a("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
            if (this.engineContainsAlias(string)) {
                return this.b.get(string).e();
            }
        }
        catch (Exception exception) {
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            System.out.println(exception.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            OracleKSEntry oracleKSEntry = this.b.get(string);
            if (oracleKSEntry instanceof OracleKSTrustedCertEntry) {
                return this.b.get(string).f();
            }
            Certificate[] certificateArray = this.b.get(string).e();
            if (certificateArray != null) {
                return certificateArray[0];
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return this.b.get(string).a();
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.b.get(string) != null) {
            this.engineDeleteEntry(string);
        }
        OraclePKIDebug.a("Alias in engineSetKeyEntry is: " + string);
        PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag();
        pKCS12KeyBag.a((PrivateKey)key);
        pKCS12KeyBag.a(string);
        OracleKSIdentityEntry oracleKSIdentityEntry = new OracleKSIdentityEntry((PKCS12Bag)pKCS12KeyBag, certificateArray);
        this.b.put(string, oracleKSIdentityEntry);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        OracleKSIdentityEntry oracleKSIdentityEntry = null;
        PrivateKey privateKey = null;
        PKCS12KeyBag pKCS12KeyBag = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                privateKey = CryptoUtils.inputPrivateKey(byteArrayInputStream);
                pKCS12KeyBag = new PKCS12KeyBag();
                pKCS12KeyBag.a(privateKey);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (this.b.get(string) != null) {
                this.engineDeleteEntry(string);
            }
            oracleKSIdentityEntry = new OracleKSIdentityEntry((PKCS12Bag)pKCS12KeyBag, certificateArray);
            this.b.put(string, oracleKSIdentityEntry);
        }
        catch (Exception exception) {
            throw new KeyStoreException(a.getString("PKI-02022"));
        }
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !this.b.get(string).c()) {
            throw new KeyStoreException(a.getString("PKI-04013"));
        }
        OracleKSTrustedCertEntry oracleKSTrustedCertEntry = new OracleKSTrustedCertEntry(certificate);
        this.b.put(string, oracleKSTrustedCertEntry);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException(a.getString("PKI-04014"));
        }
        this.b.remove(string);
    }

    public Enumeration engineAliases() {
        return new Vector<String>(this.b.keySet()).elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.b.containsKey(string);
    }

    @Override
    public int engineSize() {
        return this.b.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return this.b.get(string).d();
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return this.b.get(string).c();
        }
        return false;
    }

    public boolean IsPubKeyMatching(OraclePKIX509CertImpl oraclePKIX509CertImpl, OraclePKIX509CertImpl oraclePKIX509CertImpl2) {
        boolean bl = false;
        if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("EC") && oraclePKIX509CertImpl2.getPublicKey().getAlgorithm().equals("EC")) {
            OraclePKIECPublicKey oraclePKIECPublicKey = (OraclePKIECPublicKey)oraclePKIX509CertImpl.getPublicKey();
            OraclePKIECPublicKey oraclePKIECPublicKey2 = (OraclePKIECPublicKey)oraclePKIX509CertImpl2.getPublicKey();
            ECParameterSpec eCParameterSpec = oraclePKIECPublicKey.getParams();
            ECParameterSpec eCParameterSpec2 = oraclePKIECPublicKey2.getParams();
            if (oraclePKIECPublicKey2.getW().equals(oraclePKIECPublicKey2.getW()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator()) && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder())) {
                bl = true;
            }
        } else if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("RSA") && oraclePKIX509CertImpl2.getPublicKey().getAlgorithm().equals("RSA")) {
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey2 = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl2.getPublicKey();
            if (oraclePKIRSAPublicKey.getModulus().equals(oraclePKIRSAPublicKey2.getModulus()) && oraclePKIRSAPublicKey.getPublicExponent().equals(oraclePKIRSAPublicKey2.getPublicExponent())) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        for (Map.Entry<String, OracleKSEntry> entry : set) {
            if (!entry.getValue().f().equals(certificate)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void engineLoadForSSO(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.load(inputStream, cArray, false, true);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.load(inputStream, cArray, false, false);
    }

    public final void load(InputStream inputStream, char[] cArray, boolean bl) throws IOException, CertificateException {
        this.load(inputStream, cArray, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream inputStream, char[] cArray, boolean bl, boolean bl2) throws IOException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: Loading wallet from stream");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new OracleWalletPermission("load"));
                }
                return null;
            }
        });
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.a(cArray);
        } else {
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean bl3 = false;
            try {
                if (!bl2) {
                    if (inputStream instanceof FileInputStream) {
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:getting channel..");
                        fileChannel = ((FileInputStream)inputStream).getChannel();
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locking file (shared)..");
                        fileLock = FileLockProvider.a(null, fileChannel, 0L, inputStream.available(), true);
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locked file.");
                        bl3 = true;
                    }
                }
                pKCS12 = new PKCS12(cArray, inputStream);
            }
            finally {
                if (fileLock != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:releasing lock..");
                    fileLock.release();
                }
                if (bl3 && fileChannel != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:closing channel..");
                    fileChannel.close();
                }
            }
        }
        boolean bl4 = true;
        try {
            if (cArray != null) {
                bl4 = pKCS12.g();
            }
        }
        catch (AuthException authException) {
            bl4 = false;
        }
        if (!bl4) {
            throw new IOException(a.getString("PKI-02010"));
        }
        this.a(pKCS12, bl);
        OraclePKIDebug.a("OracleKeyStoreSpi: Keystore Loaded");
    }

    @Override
    public final void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException {
        OraclePKIDebug.a("OraclePKCS12KeyStoreSpi: Enter store");
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        PKCS12Safe pKCS12Safe = new PKCS12Safe(pKCS12);
        pKCS12Safe.a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        Set<String> set = this.b.keySet();
        int n = OracleKeyStoreSpi.getHighestComponentNumber(pKCS12) + 1;
        for (String string : set) {
            PKCS12Bag pKCS12Bag;
            Serializable serializable;
            OraclePKIDebug.a("Alias in store is: " + string);
            OracleKSEntry oracleKSEntry = this.b.get(string);
            if (oracleKSEntry instanceof OracleKSIdentityEntry) {
                serializable = ((OracleKSIdentityEntry)oracleKSEntry).g();
                pKCS12Bag = new PKCS12KeyBag(pKCS12Safe, (PrivateKey)serializable);
                pKCS12Bag.a(OracleLocalKeyId.c(0, n));
                pKCS12Bag.a(string);
                pKCS12Safe.a(pKCS12Bag);
            } else if (oracleKSEntry instanceof OracleKSTrustedCertEntry) {
                serializable = (X509Certificate)oracleKSEntry.f();
                pKCS12Bag = new PKCS12CertBag(pKCS12Safe, X509.a((X509Certificate)serializable));
                pKCS12Bag.a(string);
                pKCS12Bag.a(OracleLocalKeyId.e(0, n));
                pKCS12Safe.a(pKCS12Bag);
            }
            ++n;
        }
        pKCS12.a(pKCS12Safe);
        int n2 = pKCS12.length();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OraclePKCS12KeyStoreSpi: wallet size " + n2);
        }
        pKCS12.output(outputStream);
        OraclePKIDebug.a("OraclePKCS12KeyStoreSpi: Exit store");
    }

    public void printLocalKeyIDs(PKCS12 pKCS12) {
        System.out.println("-------------------");
        PKCS12Safe pKCS12Safe = pKCS12.f().get(0);
        ArrayList<PKCS12Bag> arrayList = pKCS12Safe.d();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            byte[] byArray = pKCS12Bag.c();
            if (OracleKeyStoreSpi.b(pKCS12Bag)) {
                System.out.println("CertReqBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && OracleLocalKeyId.c(byArray)) {
                System.out.println("User CertBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && OracleLocalKeyId.d(pKCS12Bag.c())) {
                System.out.println("Trusted CertBag = " + OracleLocalKeyId.l(byArray));
            }
            if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                System.out.println("KeyBag = " + OracleLocalKeyId.l(byArray));
            }
            if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
            System.out.println("SecretStoreBag = " + OracleLocalKeyId.l(byArray));
        }
    }

    int a() {
        return this.c.size();
    }

    Enumeration b() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.c.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    Enumeration c() {
        return new Vector<String>(this.c.keySet()).elements();
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.c.remove(string);
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            OracleSSEntry oracleSSEntry = this.c.get(string);
            oracleSSEntry.a(cArray);
        } else {
            OracleSSEntry oracleSSEntry = new OracleSSEntry(string, cArray);
            this.c.put(oracleSSEntry.b(), oracleSSEntry);
        }
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return this.c.get(string).a();
        }
        return null;
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.c.containsKey(string);
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n = 1;
        Enumeration<OracleSSEntry> enumeration = new Vector<OracleSSEntry>(this.c.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n)) {
            ++n;
        }
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n, cArray3);
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration<OracleSSEntry> enumeration = new Vector<OracleSSEntry>(this.c.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration<OracleSSEntry> enumeration = new Vector<OracleSSEntry>(this.c.values()).elements();
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration<OracleSSEntry> enumeration = new Vector<OracleSSEntry>(this.c.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            OracleSSEntry oracleSSEntry = enumeration.nextElement();
            String string = new String(oracleSSEntry.a());
            String string2 = oracleSSEntry.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static boolean a(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    private static boolean b(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.b(pKCS12Bag.c());
    }

    private static boolean c(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    private static boolean d(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.e(pKCS12Bag.c());
    }

    private static boolean e(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.f(pKCS12Bag.c());
    }

    private static boolean f(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.g(pKCS12Bag.c());
    }

    private static boolean g(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.h(pKCS12Bag.c());
    }

    private static boolean h(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return OracleLocalKeyId.i(pKCS12Bag.c());
    }

    private static Vector a(PKCS12 pKCS12) {
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList<PKCS12Bag> arrayList2 = pKCS12Safe.d();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12Bag pKCS12Bag = arrayList2.get(j);
                if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found secret store bag");
                vector.addElement(pKCS12Bag);
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.a(arrayList2);
        }
        return vector;
    }

    private void b(PKCS12 pKCS12) {
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList<PKCS12Bag> arrayList2 = pKCS12Safe.d();
            for (int j = 0; j < arrayList2.size(); ++j) {
                ASN1Object aSN1Object;
                PKCS12Bag pKCS12Bag = arrayList2.get(j);
                if (OracleKeyStoreSpi.e(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 lib info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
                    this.d = new String(((ASN1OctetString)aSN1Object).b());
                    arrayList2.remove(j);
                    --j;
                }
                if (OracleKeyStoreSpi.f(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
                    this.e = new String(((ASN1OctetString)aSN1Object).b());
                    arrayList2.remove(j);
                    --j;
                }
                if (OracleKeyStoreSpi.g(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
                    this.f = new String(((ASN1OctetString)aSN1Object).b());
                    arrayList2.remove(j);
                    --j;
                }
                if (!OracleKeyStoreSpi.h(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
                this.g = new String(((ASN1OctetString)aSN1Object).b());
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.a(arrayList2);
        }
    }

    public String getP11Lib() {
        return this.d;
    }

    public String getP11TokenLabel() {
        return this.e;
    }

    public String getP11TokenPassphrase() {
        return this.f;
    }

    public String getP11CertLabel() {
        return this.g;
    }

    byte[] a(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object2).f());
        }
        aSN1Object2 = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object2).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            aSN1Object = arrayList.get(n);
            if (!OracleKeyStoreSpi.e(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 lib bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11LibOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.a(OracleLocalKeyId.a(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 lib bag ");
        ((PKCS12Safe)aSN1Object2).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object2).f());
        }
        aSN1Object2 = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object2).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            aSN1Object = arrayList.get(n);
            if (!OracleKeyStoreSpi.f(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token label bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.a(OracleLocalKeyId.b(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token label bag ");
        ((PKCS12Safe)aSN1Object2).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] c(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object2).f());
        }
        aSN1Object2 = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object2).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            aSN1Object = arrayList.get(n);
            if (!OracleKeyStoreSpi.g(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token pwd bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokPwdOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.a(OracleLocalKeyId.c(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token pwd bag ");
        ((PKCS12Safe)aSN1Object2).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] d(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object2).f());
        }
        aSN1Object2 = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object2).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        boolean bl = false;
        int n = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            aSN1Object = arrayList.get(n);
            if (!OracleKeyStoreSpi.h(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 cert label bag");
            bl = true;
            break;
        }
        if (bl) {
            arrayList.remove(n);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11CrtLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.a(OracleLocalKeyId.d(0));
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 cert label bag ");
        ((PKCS12Safe)aSN1Object2).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static void a(PKCS12 pKCS12, Vector<PKCS12Bag> vector, Vector<PKCS12Bag> vector2, Vector<PKCS12Bag> vector3) {
        if (null == vector) {
            vector = new Vector();
        }
        if (null == vector2) {
            vector2 = new Vector();
        }
        if (null == vector3) {
            vector3 = new Vector();
        }
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList<PKCS12Bag> arrayList2 = pKCS12Safe.d();
            Iterator<PKCS12Bag> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                PKCS12Bag pKCS12Bag = iterator.next();
                if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                    vector.add(pKCS12Bag);
                    iterator.remove();
                    continue;
                }
                if (OracleKeyStoreSpi.a(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                    vector2.add(pKCS12Bag);
                    iterator.remove();
                    continue;
                }
                if (!OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found certReq bag");
                vector3.add(pKCS12Bag);
                iterator.remove();
            }
            pKCS12Safe.a(arrayList2);
        }
    }

    private static Vector c(PKCS12 pKCS12) {
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Safe pKCS12Safe = arrayList.get(i);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i);
            ArrayList<PKCS12Bag> arrayList2 = pKCS12Safe.d();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12Bag pKCS12Bag = arrayList2.get(j);
                if (!OracleKeyStoreSpi.a(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                vector.addElement(pKCS12Bag);
                arrayList2.remove(j);
                --j;
            }
            pKCS12Safe.a(arrayList2);
        }
        return vector;
    }

    void a(PKCS12 pKCS12, boolean bl) throws CertificateException, IOException {
        Hashtable<String, Object> hashtable;
        Hashtable<String, OracleKSEntry> hashtable2;
        block17: {
            int n;
            String string;
            String string2;
            OracleKSEntry oracleKSEntry;
            Object object;
            int n2;
            Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
            Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
            Vector<PKCS12Bag> vector3 = new Vector<PKCS12Bag>();
            OracleKeyStoreSpi.a(pKCS12, vector, vector2, vector3);
            Vector vector4 = OracleKeyStoreSpi.a(pKCS12);
            this.b(pKCS12);
            hashtable2 = new Hashtable<String, OracleKSEntry>(vector.size() + vector2.size());
            hashtable = new Hashtable<String, Object>(vector4.size());
            for (n2 = 0; n2 < vector.size(); ++n2) {
                OraclePKIDebug.a("Processing identity " + n2);
                object = vector.get(n2);
                oracleKSEntry = new OracleKSIdentityEntry((PKCS12Bag)object, vector2, vector3);
                string2 = null;
                string = ((PKCS12Bag)object).b();
                if (!bl) {
                    if (string != null) {
                        string2 = string;
                    } else {
                        string2 = oracleKSEntry.b();
                        n = 1;
                        while (hashtable2.containsKey(string2)) {
                            string2 = string2 + ' ' + Integer.toString(n);
                            ++n;
                        }
                    }
                    OraclePKIDebug.a("Storing identity " + n2 + " as " + string2);
                    hashtable2.put(string2, oracleKSEntry);
                    continue;
                }
                n = OracleKeyStoreSpi.getHighestIndexForAliasWithOrakeyPrefix(Collections.list(hashtable2.keys())) + 1;
                hashtable2.put(n + n, oracleKSEntry);
            }
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                OraclePKIDebug.a("Processing CertReq with no matching pvt key " + n2);
                object = vector3.get(n2);
                oracleKSEntry = new OracleKSIdentityEntry((PKCS12Bag)object, vector2);
                string2 = null;
                string = ((PKCS12Bag)object).b();
                if (string != null) {
                    string2 = string;
                } else {
                    string2 = oracleKSEntry.b();
                    n = 1;
                    while (hashtable2.containsKey(string2)) {
                        string2 = string2 + ' ' + Integer.toString(n);
                        ++n;
                    }
                }
                OraclePKIDebug.a("Storing creq " + n2 + " as " + string2);
                hashtable2.put(string2, oracleKSEntry);
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                OraclePKIDebug.a("Processing TP " + n2);
                object = vector2.get(n2);
                oracleKSEntry = new OracleKSTrustedCertEntry((PKCS12CertBag)object);
                string2 = null;
                string = ((PKCS12Bag)object).b();
                if (string != null) {
                    string2 = string;
                } else {
                    string2 = oracleKSEntry.b();
                    n = 1;
                    while (hashtable2.containsKey(string2)) {
                        string2 = oracleKSEntry.b() + ' ' + Integer.toString(n);
                        ++n;
                    }
                }
                OraclePKIDebug.a("Storing TP " + n2 + " as " + string2);
                hashtable2.put(string2, oracleKSEntry);
            }
            try {
                for (n2 = 0; n2 < vector4.size(); ++n2) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: Storing Secret" + n2);
                    object = new OracleSSEntry((PKCS12SecretBag)vector4.get(n2));
                    hashtable.put(((OracleSSEntry)object).b(), object);
                }
            }
            catch (OracleSecretStoreException oracleSecretStoreException) {
                throw new IOException(oracleSecretStoreException.toString());
            }
            catch (Exception exception) {
                if (!OraclePKIDebug.getDebugFlag()) break block17;
                exception.printStackTrace();
            }
        }
        this.b = hashtable2;
        this.c = hashtable;
    }

    byte[] a(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        Object object;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = null;
        pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
            OracleKeyStoreSpi.a(pKCS12);
        }
        aSN1Object = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new secret store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + "bags");
        if (this.c.size() > 0) {
            Set<Map.Entry<String, OracleSSEntry>> set = this.c.entrySet();
            object = set.iterator();
            int n = 0;
            while (object.hasNext()) {
                OracleSSEntry oracleSSEntry = object.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object);
                oracleSSEntry.a(pKCS12SecretBag);
                pKCS12SecretBag.a(OracleLocalKeyId.a(0, n));
                arrayList.add(0, pKCS12SecretBag);
                ++n;
                OraclePKIDebug.a("OracleWallet: added secret bag");
            }
        }
        ((PKCS12Safe)aSN1Object).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object);
        }
        int n = pKCS12.length();
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS12.f().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray, byte by) throws IOException, KeyStoreException, CertificateException {
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        boolean bl = false;
        if ((by & 1) != 0) {
            bl = true;
        }
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
            OracleKeyStoreSpi.a(pKCS12, null, null, null);
        }
        aSN1Object = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.f().get(0);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: v12compat=" + bl);
        ((PKCS12Safe)aSN1Object).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            int n = 0;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                pKCS12CertBag.a(OracleLocalKeyId.b(0, n));
                arrayList.add(0, pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag");
                continue;
            }
            if (!keyStore.isKeyEntry(string)) continue;
            throw new IOException("Not Implemented for private keys");
        }
        ((PKCS12Safe)aSN1Object).a(arrayList);
        if (arrayList.size() >= 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object);
        }
        int n = pKCS12.length();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet: wallet has " + pKCS12.f().size() + " safes");
            OraclePKIDebug.a("OracleWallet: wallet size " + n);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, byte by) throws IOException {
        PKCS12 pKCS12 = new PKCS12(cArray, inputStream);
        boolean bl = cArray.length == cArray2.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        byte[] byArray = Arrays.copyOf(i, i.length);
        for (int i = 0; bl && i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            bl = false;
        }
        pKCS12.a(cArray2);
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        if ((by & 1) != 0) {
            bl3 = true;
        }
        if ((by & 2) != 0) {
            bl5 = true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag;
            boolean bl6 = false;
            PKCS12Safe pKCS12Safe = arrayList.get(0);
            ArrayList<PKCS12Bag> arrayList2 = pKCS12Safe.d();
            for (int j = 0; j < arrayList2.size(); ++j) {
                PKCS12Bag pKCS12Bag2;
                pKCS12Bag = arrayList2.get(j);
                if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
                    pKCS12Bag2 = (PKCS12ShroudedKeyBag)pKCS12Bag;
                    ((PKCS12ShroudedKeyBag)pKCS12Bag2).a(cArray);
                    PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag(pKCS12Safe, ((PKCS12ShroudedKeyBag)pKCS12Bag2).g());
                    pKCS12KeyBag.a(pKCS12Bag2.c());
                    pKCS12KeyBag.a(pKCS12Bag2.b());
                    arrayList2.remove(j);
                    arrayList2.add(j, pKCS12KeyBag);
                    continue;
                }
                if (!(pKCS12Bag instanceof PKCS12SecretBag) || !((PKCS12SecretBag)(pKCS12Bag2 = (PKCS12SecretBag)pKCS12Bag)).e().equals(new ASN1ObjectID(h))) continue;
                bl6 = true;
                byArray = ((ASN1OctetString)((PKCS12SecretBag)pKCS12Bag2).f()).b();
                if (byArray[0] == 1) {
                    bl2 = true;
                }
                if (byArray[1] == 1) {
                    bl4 = true;
                }
                arrayList2.remove(j);
            }
            byArray = Arrays.copyOf(OracleKeyStoreSpi.i, OracleKeyStoreSpi.i.length);
            if (bl2 || bl3) {
                byArray[0] = 1;
            }
            if (bl4 || bl5) {
                byArray[1] = 1;
            }
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.a("Array length: " + OracleKeyStoreSpi.i.length);
                OraclePKIDebug.a("Wallet Conf :" + by);
                OraclePKIDebug.a("Trust Flags: Now Previous :" + bl5 + "," + bl4);
                OraclePKIDebug.a("V12 Flags: Now Previous :" + bl3 + "," + bl2);
                OraclePKIDebug.a("Final value of secret bag:" + Arrays.toString(byArray));
            }
            ASN1OctetString aSN1OctetString = new ASN1OctetString(byArray);
            pKCS12Safe.a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
            if (bl3 || bl2 || bl4 || bl5) {
                pKCS12Bag = new PKCS12SecretBag(pKCS12Safe, new ASN1ObjectID(h), aSN1OctetString);
                pKCS12Bag.a(OracleLocalKeyId.a(0, 0, OracleLocalKeyId.a));
                pKCS12Bag.a(l + new Random().nextInt(100));
                arrayList2.add(pKCS12Bag);
            }
            pKCS12Safe.a(arrayList2);
            pKCS12Safe.a(cArray2);
        }
        try {
            pKCS12.output(outputStream);
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.a("Verifying wallet " + pKCS12.g());
            }
        }
        catch (AuthException authException) {
            OraclePKIDebug.a("Verifying wallet failed" + authException);
            throw new IOException("Could not store wallet " + authException);
        }
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, PrivateKey privateKey, String string) throws IOException, KeyStoreException {
        int n;
        Object object;
        Object object2;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        aSN1Object = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            object2 = arrayList.get(i);
            if (OracleKeyStoreSpi.c((PKCS12Bag)object2)) {
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                if (string != null && ((PKCS12Bag)object2).b().equalsIgnoreCase(string)) {
                    throw new IOException(a.getString("PKI-04008") + string);
                }
                object = ((PKCS12Bag)object2).c();
                n3 = OracleLocalKeyId.l(object);
                if (n3 == n2) {
                    ++n2;
                } else if (n3 > n2) {
                    n2 = n3 + 1;
                }
            }
            if (!OracleKeyStoreSpi.b((PKCS12Bag)object2) || (n = OracleKeyStoreSpi.a(pKCS12, n3 = OracleLocalKeyId.l(object = ((PKCS12Bag)object2).c()))) != 0) continue;
            if (n3 == n2) {
                ++n2;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3 + 1;
        }
        if (string == null) {
            string = n2 == 0 ? n : n + Integer.toString(n2);
        }
        if (privateKey != null) {
            PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)aSN1Object, privateKey);
            pKCS12KeyBag.a(OracleLocalKeyId.c(0, n2));
            pKCS12KeyBag.a(string.toLowerCase());
            arrayList.add(pKCS12KeyBag);
            OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        object2 = byteArrayOutputStream.toByteArray();
        object = new ASN1OctetString((byte[])object2);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object, new ASN1ObjectID("42.134.72.134.247.13.1.10"), (ASN1Object)object);
        pKCS12SecretBag.a(OracleLocalKeyId.d(0, n2));
        pKCS12SecretBag.a(string.toLowerCase());
        arrayList.add(pKCS12SecretBag);
        OraclePKIDebug.a("OracleKeyStoreSpi: added req bag " + n2);
        ((PKCS12Safe)aSN1Object).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object);
        }
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n);
        pKCS12.output(byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, boolean bl) throws IOException, KeyStoreException {
        Object object;
        Object object2;
        ASN1Object aSN1Object;
        if (this.a(oraclePKIX509CertImpl)) {
            throw new KeyStoreException(a.getString("PKI-04003"));
        }
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        aSN1Object = null;
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        if (arrayList.size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = arrayList.get(0);
        }
        ArrayList<PKCS12Bag> arrayList2 = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList2.size() + " bags");
        int n = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = arrayList2.get(i);
            if (string != null && (object = ((PKCS12Bag)object2).b()) != null && ((String)object).equalsIgnoreCase(string)) {
                throw new IOException(a.getString("PKI-04008") + string);
            }
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object2) || !OracleLocalKeyId.d(((PKCS12Bag)object2).c())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.a(OracleLocalKeyId.b(0, n));
        if (bl && null != oraclePKIX509CertImpl) {
            object2 = oraclePKIX509CertImpl.getSubjectDN();
            object = oraclePKIX509CertImpl.getIssuerDN();
            String string3 = object2 != null ? object2.getName() : null;
            String string4 = object != null ? object.getName() : null;
            string2 = OracleTrustFlagHelper.recalculateTrustFlagforTrustCert(string3, string4, oraclePKIX509CertImpl.getBasicConstraints(), string2);
            byte[] byArray = pKCS12CertBag.c();
            OracleLocalKeyId.a(byArray, string2);
            pKCS12CertBag.a(byArray);
        }
        if (string != null) {
            pKCS12CertBag.a(string.toLowerCase());
        }
        arrayList2.add(pKCS12CertBag);
        int n2 = pKCS12.length();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.a("OracleWallet: added key bag " + n);
            OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + arrayList.size() + " safes");
            OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n2);
        }
        object = new ByteArrayOutputStream(n2);
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException, InvalidFormatException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2)) continue;
            Key key = this.engineGetKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else {
                if (!key.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null || !x500Name.equals(new X500Name(string = certificateRequest.e().toString()))) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04005"));
        }
        return this.a(inputStream, cArray, certificateRequest, true);
    }

    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || !string.equals(string2)) continue;
            Key key = this.engineGetKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else {
                if (!key.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        return this.a(inputStream, cArray, certificateRequest, true);
    }

    byte[] f(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry(string2) || !string.equals(string2)) continue;
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)this.engineGetKey(string2, null);
            certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            if (!oraclePKIRSAPrivateKey.isPvtKeyPresent()) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemovePrivateKey: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        return this.a(inputStream, cArray, certificateRequest, false);
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, boolean bl) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n;
        Object object;
        ASN1Object aSN1Object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = pKCS12.f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray3;
            boolean bl2;
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals(byArray, byArray3 = ((ASN1OctetString)(object = ((PKCS12SecretBag)pKCS12Bag).f())).b()))) continue;
            byArray2 = pKCS12Bag.c();
            if (!bl) break;
            arrayList.remove(i);
            break;
        }
        byte[] byArray4 = OracleLocalKeyId.c(OracleLocalKeyId.k(byArray2), OracleLocalKeyId.l(byArray2));
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)object) || !this.a(((PKCS12Bag)object).c(), byArray4)) continue;
            arrayList.remove(n);
            break;
        }
        ((PKCS12Safe)aSN1Object).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object);
        }
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    int g(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2)) continue;
            object = this.engineGetKey((String)object2, null);
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCRCompNum: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = pKCS12.f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            ASN1Object aSN1Object2;
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object, byArray2 = ((ASN1OctetString)(aSN1Object2 = ((PKCS12SecretBag)pKCS12Bag).f())).b()))) continue;
            byArray = pKCS12Bag.c();
            return OracleLocalKeyId.l(byArray);
        }
        throw new IOException("Check wallet.");
    }

    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        return this.a(inputStream, cArray, x500Principal, null, null);
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        Object object4;
        Serializable serializable3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        X500Name x500Name = null;
        BigInteger bigInteger = null;
        X500Name x500Name2 = new X500Name(x500Principal.toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            serializable2 = null;
            if (!this.engineIsKeyEntry((String)object4) || (serializable2 = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object4)) == null) continue;
            object3 = ((OraclePKIX509CertImpl)serializable2).getSubjectDN().toString();
            object2 = ((OraclePKIX509CertImpl)serializable2).getIssuerDN().toString();
            serializable = ((OraclePKIX509CertImpl)serializable2).getSerialNumber();
            bl = false;
            bl2 = false;
            if (!x500Name2.equals(new X500Name((String)object3))) continue;
            if (string == null || string != null && x500Name != null && x500Name.equals(new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger != null && bigInteger.equals(serializable)) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            if (!bl3) {
                bl3 = true;
                serializable3 = serializable2;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (!bl3) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        object4 = new PKCS12();
        ((PKCS12)object4).a(cArray);
        if (inputStream != null) {
            serializable2 = new PKCS12(cArray, inputStream);
            ((PKCS12)object4).a(((PKCS12)serializable2).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable2 = ((PKCS12)object4).f().get(0);
        object3 = ((PKCS12Safe)serializable2).d();
        object2 = new ArrayList(((ArrayList)object3).size());
        serializable = null;
        X509 x509 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(((PKCS12Bag)object).c())) {
                serializable = ((PKCS12CertBag)object).e();
                if (serializable3 != null) {
                    x509 = new X509(((OraclePKIX509CertImpl)serializable3).getEncoded());
                }
                if (x509 != null && x509.equals(serializable)) continue;
                ((ArrayList)object2).add(object);
                continue;
            }
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && !OracleLocalKeyId.d(((PKCS12Bag)object).c())) {
                serializable = ((PKCS12CertBag)object).e();
                if (serializable3 != null) {
                    x509 = new X509(((OraclePKIX509CertImpl)serializable3).getEncoded());
                }
                if (x509 != null && x509.equals(serializable)) continue;
            }
            ((ArrayList)object2).add(object);
        }
        ((PKCS12Safe)serializable2).a((List<PKCS12Bag>)object2);
        if (((ArrayList)object2).size() > 0 && ((PKCS12)object4).f().isEmpty()) {
            ((PKCS12)object4).a((PKCS12Safe)serializable2);
        }
        n = ((PKCS12)object4).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object4).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object4).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        ASN1Object aSN1Object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null || !string.equals(object2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        object2 = new PKCS12();
        ((PKCS12)object2).a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            ((PKCS12)object2).a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object2).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(((PKCS12Bag)object).c())) {
                X509 x509 = ((PKCS12CertBag)object).e();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                arrayList2.add((PKCS12Bag)object);
                continue;
            }
            arrayList2.add((PKCS12Bag)object);
        }
        ((PKCS12Safe)aSN1Object).a(arrayList2);
        if (arrayList2.size() > 0 && ((PKCS12)object2).f().isEmpty()) {
            ((PKCS12)object2).a((PKCS12Safe)aSN1Object);
        }
        n = ((PKCS12)object2).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object2).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        Object object4;
        Serializable serializable3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger = null;
        x500Name = new X500Name(oraclePKIX509CertImpl.getSubjectDN().toString());
        if (string != null) {
            x500Name2 = new X500Name(string);
        }
        if (string2 != null) {
            bigInteger = string2.length() > 2 && string2.charAt(0) == '0' && (string2.charAt(1) == 'x' || string2.charAt(1) == 'X') ? new BigInteger(string2.substring(2), 16) : new BigInteger(string2);
        }
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            serializable2 = null;
            if (!this.engineIsKeyEntry((String)object4) || (serializable2 = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object4)) == null) continue;
            object3 = ((OraclePKIX509CertImpl)serializable2).getSubjectDN().toString();
            object2 = ((OraclePKIX509CertImpl)serializable2).getIssuerDN().toString();
            serializable = ((OraclePKIX509CertImpl)serializable2).getSerialNumber();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (!x500Name.equals(new X500Name((String)object3))) continue;
            if (string == null || x500Name2 != null && x500Name2.equals(new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger != null && bigInteger.equals(serializable)) {
                bl2 = true;
            }
            if (this.IsPubKeyMatching(oraclePKIX509CertImpl, (OraclePKIX509CertImpl)serializable2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3) continue;
            if (!bl4) {
                bl4 = true;
                serializable3 = serializable2;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (!bl4) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        object4 = new PKCS12();
        ((PKCS12)object4).a(cArray);
        if (inputStream != null) {
            serializable2 = new PKCS12(cArray, inputStream);
            ((PKCS12)object4).a(((PKCS12)serializable2).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable2 = ((PKCS12)object4).f().get(0);
        object3 = ((PKCS12Safe)serializable2).d();
        object2 = new ArrayList(((ArrayList)object3).size());
        serializable = null;
        X509 x509 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.c(((PKCS12Bag)object).c())) {
                serializable = ((PKCS12CertBag)object).e();
                if (serializable3 != null) {
                    x509 = new X509(((OraclePKIX509CertImpl)serializable3).getEncoded());
                }
                if (x509 != null && x509.equals(serializable)) continue;
                ((ArrayList)object2).add(object);
                continue;
            }
            ((ArrayList)object2).add(object);
        }
        ((PKCS12Safe)serializable2).a((List<PKCS12Bag>)object2);
        if (((ArrayList)object2).size() > 0 && ((PKCS12)object4).f().isEmpty()) {
            ((PKCS12)object4).a((PKCS12Safe)serializable2);
        }
        n = ((PKCS12)object4).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object4).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object4).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    boolean b(InputStream inputStream, char[] cArray) throws IOException, CertificateEncodingException {
        ASN1Object aSN1Object;
        OraclePKIDebug.a("OracleKeyStoreSpi::checkTrustFlagsEnabled: Entry");
        byte[] byArray = new byte[]{0, 0, 0, 0};
        boolean bl = false;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        aSN1Object = pKCS12.f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12SecretBag pKCS12SecretBag;
            if (!(arrayList.get(i) instanceof PKCS12SecretBag) || !(pKCS12SecretBag = (PKCS12SecretBag)arrayList.get(i)).e().equals(new ASN1ObjectID(h)) || (byArray = ((ASN1OctetString)pKCS12SecretBag.f()).b())[1] != 1) continue;
            bl = true;
            break;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::checkTrustFlagsEnabled: Exit");
        return bl;
    }

    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, CertificateEncodingException {
        ASN1Object aSN1Object;
        OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: Entry");
        String string = null;
        String string2 = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            pKCS12.a(((PKCS12)aSN1Object).f());
        }
        aSN1Object = pKCS12.f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray;
            string = null;
            string2 = null;
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || (byArray = pKCS12Bag.c()) == null || (string = OracleLocalKeyId.a(byArray)) == null || "".equals(string)) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).e();
            String string3 = x509.n().toString();
            String string4 = x509.o().toString();
            if (OracleLocalKeyId.c(byArray)) {
                string2 = CertType.USER.getCertCode() + x509.m().toString() + string3 + string4;
            } else if (OracleLocalKeyId.d(byArray)) {
                string2 = CertType.TRUSTED.getCertCode() + x509.m().toString() + string3 + string4;
            }
            if (string2 == null || string == null) continue;
            hashMap.put(string2, string);
            OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: " + string2 + " = " + string);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::getTrustFlagsValue: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, String string, String string2, String string3, String string4, HashMap hashMap) throws IOException, CertificateEncodingException, InvalidFormatException {
        Serializable serializable;
        Object object;
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Entry");
        boolean bl = false;
        boolean bl2 = false;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object) || (serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !(bl = this.a(((OraclePKIX509CertImpl)serializable).getX509(), string, string2, string3))) continue;
            if (bl2) {
                OraclePKIDebug.a(a.getString("PKI-04025"));
                throw new IOException(a.getString("PKI-04025"));
            }
            oraclePKIX509CertImpl = serializable;
            bl2 = true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Found 1 matching cert for assigning Trust Flags.");
        if (!bl2) {
            OraclePKIDebug.a(a.getString("PKI-04023"));
            throw new IOException(a.getString("PKI-04023"));
        }
        if (TrustFlags.NZTF_VALID_PEER.getDisplayName().equals(string4) && oraclePKIX509CertImpl != null && oraclePKIX509CertImpl.getBasicConstraints() != -1) {
            OraclePKIDebug.a("Cannot assign VALID_PEER flag to a CA certificate.");
            throw new IOException("Cannot assign VALID_PEER flag to a CA certificate.");
        }
        if (oraclePKIX509CertImpl != null && oraclePKIX509CertImpl.getBasicConstraints() == -1 && (TrustFlags.NZTF_SERVER_AUTH.getDisplayName().equals(string4) || TrustFlags.NZTF_CLIENT_AUTH.getDisplayName().equals(string4) || string4 != null && string4.equals(TrustFlags.NZTF_SERVER_AUTH.getDisplayName() + "," + TrustFlags.NZTF_CLIENT_AUTH.getDisplayName()))) {
            OraclePKIDebug.a("Cannot assign SERVER_AUTH/CLIENT_AUTH flag to an EE certificate.");
            throw new IOException(a.getString("PKI-04029"));
        }
        if (!this.a(oraclePKIX509CertImpl, hashMap, string4)) {
            OraclePKIDebug.a("This operation will result in wallet going into an inconsistent state.");
            throw new IOException("This operation will result in wallet going into an inconsistent state.");
        }
        object = new PKCS12();
        ((PKCS12)object).a(cArray);
        if (inputStream != null) {
            serializable = new PKCS12(cArray, inputStream);
            ((PKCS12)object).a(((PKCS12)serializable).f());
        }
        serializable = ((PKCS12)object).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)serializable).d();
        X509 x509 = new X509(oraclePKIX509CertImpl.getEncoded());
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = false;
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.c())) continue;
            byte[] byArray = pKCS12Bag.c();
            X509 x5092 = ((PKCS12CertBag)pKCS12Bag).e();
            if (x509 == null || !x509.equals(x5092)) continue;
            OracleLocalKeyId.a(byArray, string4);
            pKCS12Bag.a(byArray);
            OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Trust Flags successfully assigned to matching certificate.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object).length());
        ((PKCS12)object).output(byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagstoCert: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    private boolean a(X509 x509, String string, String string2, String string3) throws InvalidFormatException {
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger = null;
        if (string == null) {
            return false;
        }
        string4 = x509.m().toString();
        string5 = x509.n().toString();
        bigInteger = x509.o();
        if (null != bigInteger) {
            string6 = bigInteger.toString();
            string7 = bigInteger.toString(16);
            string8 = "0x" + bigInteger.toString(16);
        }
        try {
            x500Name = new X500Name(new X500Principal(string).toString());
            if (string2 != null) {
                x500Name2 = new X500Name(new X500Principal(string2).toString());
            }
            if (x500Name.equals(new X500Name(string4))) {
                if (x500Name2 != null && !x500Name2.equals(new X500Name(string5))) {
                    return false;
                }
                return string3 == null || null == bigInteger || string3.equals(string6) || string3.equalsIgnoreCase(string7) || string3.equalsIgnoreCase(string8);
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(a.getString("PKI-07024"));
        }
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap, String string) throws IOException {
        boolean bl = true;
        boolean bl2 = false;
        if (oraclePKIX509CertImpl == null) {
            return bl;
        }
        String string2 = CertType.TRUSTED.getCertCode() + oraclePKIX509CertImpl.getSubjectDN().toString() + oraclePKIX509CertImpl.getIssuerDN().toString() + oraclePKIX509CertImpl.getSerialNumber().toString();
        if (hashMap == null) {
            return bl;
        }
        String string3 = (String)hashMap.get(string2);
        String string4 = TrustFlags.NZTF_SERVER_AUTH.getDisplayName();
        if (string3 == null) {
            return bl;
        }
        if (string3.indexOf(string4) == -1) {
            return bl;
        }
        if (string3.indexOf(string4) != -1 && string.indexOf(string4) != -1) {
            return bl;
        }
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        Iterator<Map.Entry<String, OracleKSEntry>> iterator = set.iterator();
        while (iterator.hasNext() && bl) {
            Certificate[] certificateArray;
            Map.Entry<String, OracleKSEntry> entry = iterator.next();
            if (!(entry.getValue() instanceof OracleKSIdentityEntry) || (certificateArray = ((OracleKSIdentityEntry)entry.getValue()).e()) == null || ((X509Certificate)certificateArray[certificateArray.length - 1]).getSubjectDN().getName().equals(((X509Certificate)certificateArray[certificateArray.length - 1]).getIssuerDN().getName())) continue;
            bl2 = false;
            for (int i = 1; i < certificateArray.length; ++i) {
                String string5;
                if (oraclePKIX509CertImpl.equals(certificateArray[i]) || (string5 = (String)hashMap.get(string2 = CertType.TRUSTED.getCertCode() + ((X509Certificate)certificateArray[i]).getSubjectDN().getName() + ((X509Certificate)certificateArray[i]).getIssuerDN().getName() + ((X509Certificate)certificateArray[i]).getSerialNumber().toString())) == null || string5.indexOf(string4) == -1) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    byte[] b(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (this.engineIsCertificateEntry((String)object2) && (serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null) continue;
        }
        object2 = new PKCS12();
        ((PKCS12)object2).a(cArray);
        if (inputStream != null) {
            serializable = new PKCS12(cArray, inputStream);
            ((PKCS12)object2).a(((PKCS12)serializable).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable = ((PKCS12)object2).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)serializable).d();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(((PKCS12Bag)object).c())) continue;
            arrayList2.add((PKCS12Bag)object);
        }
        ((PKCS12Safe)serializable).a(arrayList2);
        if (arrayList2.size() > 0 && ((PKCS12)object2).f().isEmpty()) {
            ((PKCS12)object2).a((PKCS12Safe)serializable);
        }
        n = ((PKCS12)object2).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object2).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    boolean a(X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals(new X500Name(string = oraclePKIX509CertImpl.getSubjectDN().toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching DN.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl, hashMap);
    }

    boolean a(String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (!string.equals(string2) || oraclePKIX509CertImpl == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching alias.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl, hashMap);
    }

    int i(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCertCompNum: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        object = new PKCS12();
        ((PKCS12)object).a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            ((PKCS12)object).a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.c(pKCS12Bag.c())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).e();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals(x509)) continue;
            byte[] byArray = pKCS12Bag.c();
            return OracleLocalKeyId.l(byArray);
        }
        return 0;
    }

    int j(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetTCertCompNum: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        object = new PKCS12();
        ((PKCS12)object).a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            ((PKCS12)object).a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !OracleLocalKeyId.d(pKCS12Bag.c())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).e();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals(x509)) continue;
            byte[] byArray = pKCS12Bag.c();
            return OracleLocalKeyId.l(byArray);
        }
        return 0;
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        return this.a(inputStream, cArray, x500Principal, null, null, hashMap);
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Serializable serializable2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        X500Name x500Name = null;
        BigInteger bigInteger = null;
        X500Name x500Name2 = new X500Name(x500Principal.toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            serializable = null;
            if (!this.engineIsCertificateEntry((String)object4) || (serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object4)) == null) continue;
            object3 = ((OraclePKIX509CertImpl)serializable).getSubjectDN().toString();
            object2 = ((OraclePKIX509CertImpl)serializable).getIssuerDN().toString();
            BigInteger bigInteger2 = ((OraclePKIX509CertImpl)serializable).getSerialNumber();
            bl = false;
            bl2 = false;
            if (!x500Name2.equals(new X500Name((String)object3))) continue;
            if (string == null || string != null && x500Name != null && x500Name.equals(new X500Name((String)object2))) {
                bl = true;
            }
            if (string2 == null || string2 != null && bigInteger.equals(bigInteger2)) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            if (!bl3) {
                bl3 = true;
                serializable2 = serializable;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025") + " " + ((OraclePKIX509CertImpl)serializable).getSubjectDN().toString());
        }
        if (!bl3) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        object4 = new PKCS12();
        ((PKCS12)object4).a(cArray);
        if (inputStream != null) {
            serializable = new PKCS12(cArray, inputStream);
            ((PKCS12)object4).a(((PKCS12)serializable).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable = ((PKCS12)object4).f().get(0);
        object3 = ((PKCS12Safe)serializable).d();
        object2 = new ArrayList(((ArrayList)object3).size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + "bags");
        int n2 = 0;
        X509 x509 = null;
        X509 x5092 = null;
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(((PKCS12Bag)object).c())) {
                String string3;
                x509 = ((PKCS12CertBag)object).e();
                if (serializable2 != null) {
                    x5092 = new X509(((OraclePKIX509CertImpl)serializable2).getEncoded());
                }
                if (x5092 != null && x5092.equals(x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)serializable, x509);
                pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                String string4 = null;
                byte[] byArray = ((PKCS12Bag)object).c();
                string4 = OracleLocalKeyId.a(byArray);
                if (string4 != null && !"".equals(string4)) {
                    byArray = pKCS12CertBag.c();
                    OracleLocalKeyId.a(byArray, string4);
                    pKCS12CertBag.a(byArray);
                }
                if ((string3 = ((PKCS12Bag)object).b()) != null) {
                    pKCS12CertBag.a(string3);
                }
                ((ArrayList)object2).add(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            ((ArrayList)object2).add(object);
        }
        ((PKCS12Safe)serializable).a((List<PKCS12Bag>)object2);
        if (((ArrayList)object2).size() > 0 && ((PKCS12)object4).f().isEmpty()) {
            ((PKCS12)object4).a((PKCS12Safe)serializable);
        }
        n = ((PKCS12)object4).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object4).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object4).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        int n;
        ASN1Object aSN1Object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null || !string.equals(object2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        object2 = new PKCS12();
        ((PKCS12)object2).a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            ((PKCS12)object2).a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object2).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(((PKCS12Bag)object).c())) {
                String string2;
                X509 x509 = ((PKCS12CertBag)object).e();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                String string3 = null;
                byte[] byArray = ((PKCS12Bag)object).c();
                string3 = OracleLocalKeyId.a(byArray);
                if (string3 != null && !"".equals(string3)) {
                    byArray = pKCS12CertBag.c();
                    OracleLocalKeyId.a(byArray, string3);
                    pKCS12CertBag.a(byArray);
                }
                if ((string2 = ((PKCS12Bag)object).b()) != null) {
                    pKCS12CertBag.a(string2);
                }
                arrayList2.add(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            arrayList2.add((PKCS12Bag)object);
        }
        ((PKCS12Safe)aSN1Object).a(arrayList2);
        if (arrayList2.size() > 0 && ((PKCS12)object2).f().isEmpty()) {
            ((PKCS12)object2).a((PKCS12Safe)aSN1Object);
        }
        n = ((PKCS12)object2).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object2).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    protected void a(boolean bl) throws CertificateException {
        for (String string : this.b.keySet()) {
            OracleKSIdentityEntry oracleKSIdentityEntry;
            Certificate[] certificateArray;
            String string2 = string;
            if (!this.engineIsKeyEntry(string2) || (certificateArray = (oracleKSIdentityEntry = (OracleKSIdentityEntry)this.b.get(string2)).e()) == null) continue;
            for (int i = 1; i < certificateArray.length; ++i) {
                X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
                Utils.trustedCertificateValidation(x509Certificate, bl);
            }
        }
    }

    public int retainOnlyLatestAndValidCertificateForUniquePrivateKey() {
        int n = 0;
        Hashtable hashtable = new Hashtable();
        HashMap<Key, OracleKSIdentityEntry> hashMap = new HashMap<Key, OracleKSIdentityEntry>();
        block3: for (String object : this.b.keySet()) {
            Object object2 = object;
            if (!this.engineIsKeyEntry((String)object2)) continue;
            OracleKSIdentityEntry oracleKSIdentityEntry = (OracleKSIdentityEntry)this.b.get(object2);
            Key key = oracleKSIdentityEntry.g();
            Certificate[] certificateArray = oracleKSIdentityEntry.e();
            if (certificateArray != null) {
                for (Certificate certificate : certificateArray) {
                    StringBuilder stringBuilder;
                    X509Certificate x509Certificate;
                    X509Certificate x509Certificate2 = (X509Certificate)certificate;
                    try {
                        x509Certificate2.checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        x509Certificate = (X509Certificate)certificateArray[0];
                        stringBuilder = new StringBuilder("Certificate with Subject DN=").append(x509Certificate2.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate2.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate2.getSerialNumber());
                        stringBuilder.append(" has already expired. ");
                        stringBuilder.append("So import of private key, certificate chain pair having user certificate with SubjectDN=");
                        stringBuilder.append(x509Certificate.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
                        stringBuilder.append(" is skipped.");
                        System.out.println(stringBuilder);
                        if (OraclePKIDebug.getDebugFlag()) {
                            certificateExpiredException.printStackTrace();
                        }
                        ++n;
                        continue block3;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        x509Certificate = (X509Certificate)certificateArray[0];
                        stringBuilder = new StringBuilder("Certificate with Subject DN=").append(x509Certificate2.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate2.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate2.getSerialNumber());
                        stringBuilder.append(" is not yet into its validity period. ");
                        stringBuilder.append("So import of private key, certificate chain pair having user certificate with SubjectDN=");
                        stringBuilder.append(x509Certificate.getSubjectDN().getName());
                        stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN().getName());
                        stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
                        stringBuilder.append(" is skipped.");
                        System.out.println(stringBuilder);
                        if (OraclePKIDebug.getDebugFlag()) {
                            certificateNotYetValidException.printStackTrace();
                        }
                        ++n;
                        continue block3;
                    }
                }
            }
            if (!hashMap.containsKey(key)) {
                hashMap.put(key, oracleKSIdentityEntry);
                continue;
            }
            Object object3 = null;
            X509Certificate x509Certificate = null;
            Certificate[] certificateArray2 = ((OracleKSEntry)hashMap.get(key)).e();
            if (certificateArray2 != null) {
                object3 = (X509Certificate)certificateArray2[0];
            }
            if (certificateArray != null) {
                x509Certificate = (X509Certificate)certificateArray[0];
            }
            if (object3 != null && ((X509Certificate)object3).getNotBefore() != null && x509Certificate.getNotBefore() != null && ((X509Certificate)object3).getNotBefore().compareTo(x509Certificate.getNotBefore()) < 0) {
                hashMap.put(key, oracleKSIdentityEntry);
                StringBuilder stringBuilder = new StringBuilder("User certificate with Subject DN=").append(((X509Certificate)object3).getSubjectDN());
                stringBuilder.append(", Issuer DN=").append(((X509Certificate)object3).getIssuerDN());
                stringBuilder.append(", Serial No.=").append(((X509Certificate)object3).getSerialNumber());
                stringBuilder.append(" and corresponding certificate chain are not imported because another user certificate for same private key is more recently issued.");
                System.out.println(stringBuilder);
                continue;
            }
            if (x509Certificate == null) continue;
            StringBuilder stringBuilder = new StringBuilder("User certificate with Subject DN=").append(x509Certificate.getSubjectDN());
            stringBuilder.append(", Issuer DN=").append(x509Certificate.getIssuerDN());
            stringBuilder.append(", Serial No.=").append(x509Certificate.getSerialNumber());
            stringBuilder.append(" and corresponding certificate chain are not imported because another user certificate for same private key is more recently issued.");
            System.out.println(stringBuilder);
        }
        int n2 = 0;
        for (Object object2 : hashMap.keySet()) {
            hashtable.put(n + n2++, hashMap.get(object2));
        }
        this.b = hashtable;
        return n;
    }

    public static ArrayList<String> getAliases(PKCS12 pKCS12) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PKCS12Safe pKCS12Safe : pKCS12.f()) {
            for (PKCS12Bag pKCS12Bag : pKCS12Safe.d()) {
                if (pKCS12Bag.b() == null) continue;
                arrayList.add(pKCS12Bag.b());
            }
        }
        return arrayList;
    }

    public static int getHighestIndexForAliasWithOrakeyPrefix(List<String> list) {
        int n = -1;
        for (String string : list) {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (!string2.startsWith(n)) continue;
            String string3 = string2.substring(n.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public static int getHighestComponentNumber(PKCS12 pKCS12) throws IOException {
        int n = 0;
        for (PKCS12Safe pKCS12Safe : pKCS12.f()) {
            for (PKCS12Bag pKCS12Bag : pKCS12Safe.d()) {
                if (!OracleKeyStoreSpi.c(pKCS12Bag) && !OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                byte[] byArray = pKCS12Bag.c();
                int n2 = OracleLocalKeyId.l(byArray);
                if (OracleKeyStoreSpi.c(pKCS12Bag) && n2 > n) {
                    n = n2;
                    continue;
                }
                if (!OracleKeyStoreSpi.b(pKCS12Bag) || OracleKeyStoreSpi.a(pKCS12, n2) || n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    private boolean a(Key key, Certificate[] certificateArray) {
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Entry");
        for (String string : this.b.keySet()) {
            Certificate[] certificateArray2;
            Key key2;
            OracleKSEntry oracleKSEntry = this.b.get(string);
            if (!this.engineIsKeyEntry(string) || (key2 = ((OracleKSIdentityEntry)oracleKSEntry).g()) == null || (certificateArray2 = oracleKSEntry.e()) == null || certificateArray2.length <= 0) continue;
            Certificate certificate = certificateArray2[0];
            if (!Arrays.equals(key.getEncoded(), key2.getEncoded()) || !certificateArray[0].equals(certificate)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Exit");
            return true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyAndCertificateChainPresentAlready: Exit");
        return false;
    }

    private boolean a(Key key) {
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Entry");
        for (String string : this.b.keySet()) {
            Key key2;
            OracleKSEntry oracleKSEntry = this.b.get(string);
            if (!this.engineIsKeyEntry(string) || (key2 = ((OracleKSIdentityEntry)oracleKSEntry).g()) == null || !Arrays.equals(key.getEncoded(), key2.getEncoded())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Exit");
            return true;
        }
        OraclePKIDebug.a("OracleKeyStoreSpi::isPrivateKeyPresentAlready: Exit");
        return false;
    }

    public byte[] internalAddPrivateKeyAndCertificateChain(InputStream inputStream, char[] cArray, String string, Key key, Certificate[] certificateArray) throws IOException, CertificateEncodingException, InvalidFormatException {
        Object object;
        int n;
        Serializable serializable;
        OraclePKIDebug.a("OracleKeyStoreSpi::internalAddPrivateKeyAndCertificateChain: Entry");
        X509 x509 = new X509(certificateArray[0].getEncoded());
        X500Name x500Name = new X500Name(x509.m().toString());
        X500Name x500Name2 = new X500Name(x509.n().toString());
        X500Name x500Name3 = null;
        X500Name x500Name4 = null;
        X500Name x500Name5 = null;
        X500Name x500Name6 = null;
        boolean bl = false;
        if (x500Name != null && x500Name.equals(x500Name2)) {
            bl = true;
        }
        boolean bl2 = this.a(key);
        boolean bl3 = false;
        if (this.a(key, certificateArray)) {
            bl3 = true;
        }
        if (bl3) {
            PKCS12 pKCS12 = new PKCS12(cArray, inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
            StringBuilder stringBuilder = new StringBuilder("Skipped import of private key, certificate chain pair having user certificate with Subject DN=");
            stringBuilder.append(x509.m());
            stringBuilder.append(", Issuer DN=").append(x509.n());
            stringBuilder.append(", Serial No.=").append(x509.o());
            stringBuilder.append(", because this private key and certificate chain are already present in the wallet.");
            System.out.println(stringBuilder);
            pKCS12.output(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.a(cArray);
        ArrayList<Object> arrayList = null;
        PKCS12Safe pKCS12Safe = null;
        int n2 = 1;
        ArrayList<String> arrayList2 = null;
        if (inputStream != null) {
            PKCS12 pKCS122 = new PKCS12(cArray, inputStream);
            arrayList = pKCS122.f();
            n2 = OracleKeyStoreSpi.getHighestComponentNumber(pKCS122) + 1;
            arrayList2 = OracleKeyStoreSpi.getAliases(pKCS122);
        } else {
            arrayList = new ArrayList<PKCS12Safe>();
            arrayList.add(new PKCS12Safe(pKCS12));
            arrayList2 = new ArrayList<String>();
        }
        int n3 = OracleKeyStoreSpi.getHighestIndexForAliasWithOrakeyPrefix(arrayList2) + 1;
        pKCS12Safe = (PKCS12Safe)arrayList.get(0);
        ArrayList<PKCS12Bag> arrayList3 = pKCS12Safe.d();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = false;
        boolean bl10 = false;
        PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag(pKCS12Safe, (PrivateKey)key);
        if (!bl2) {
            pKCS12KeyBag.a(n + n3);
            pKCS12KeyBag.a(OracleLocalKeyId.c(0, n2));
            pKCS12Safe.d().add(pKCS12KeyBag);
            serializable = new StringBuilder("Imported private key, certificate chain pair having Subject DN=");
            ((StringBuilder)serializable).append(x509.m());
            ((StringBuilder)serializable).append(", Issuer DN=").append(x509.n());
            ((StringBuilder)serializable).append(", Serial No.=").append(x509.o());
            ((StringBuilder)serializable).append(" with alias (inside wallet) as ").append(n).append(n3);
            OraclePKIDebug.a(((StringBuilder)serializable).toString());
        }
        serializable = new ArrayList();
        for (n = certificateArray.length - 1; n >= 0; --n) {
            Serializable serializable2;
            bl4 = false;
            bl5 = false;
            bl6 = false;
            bl7 = true;
            bl8 = true;
            bl9 = false;
            bl10 = false;
            object = new X509(certificateArray[n].getEncoded());
            for (int i = 0; i < arrayList3.size(); ++i) {
                X509 x5092;
                serializable2 = arrayList3.get(i);
                if (OracleKeyStoreSpi.a((PKCS12Bag)serializable2) && OracleLocalKeyId.d(((PKCS12Bag)serializable2).c())) {
                    x5092 = ((PKCS12CertBag)serializable2).e();
                    if (x5092 != null && x5092.equals(object)) {
                        bl4 = true;
                        if (n != 0) {
                            break;
                        }
                    } else {
                        x500Name3 = new X500Name(((X509)object).m().toString());
                        x500Name4 = new X500Name(((X509)object).n().toString());
                        x500Name5 = new X500Name(x5092.m().toString());
                        x500Name6 = new X500Name(x5092.n().toString());
                        if (x500Name3 != null && x500Name3.equals(x500Name5) && x500Name4 != null && x500Name4.equals(x500Name6) && this.IsPubKeyMatching(new OraclePKIX509CertImpl((X509)object), new OraclePKIX509CertImpl(x5092))) {
                            if (((X509)object).D().compareTo(x5092.D()) > 0) {
                                bl10 = true;
                                arrayList3.remove(i);
                                if (n != 0) break;
                                --i;
                            } else {
                                bl8 = false;
                            }
                        }
                    }
                }
                if (n != 0 || !OracleKeyStoreSpi.a((PKCS12Bag)serializable2) || !OracleLocalKeyId.c(((PKCS12Bag)serializable2).c())) continue;
                x5092 = ((PKCS12CertBag)serializable2).e();
                if (x5092 != null && x5092.equals(object)) {
                    bl5 = true;
                    continue;
                }
                if (!this.IsPubKeyMatching(new OraclePKIX509CertImpl(x509), new OraclePKIX509CertImpl(x5092))) continue;
                bl6 = true;
                x500Name5 = new X500Name(x5092.m().toString());
                x500Name6 = new X500Name(x5092.n().toString());
                if (x500Name == null || !x500Name.equals(x500Name5) || x500Name2 == null || !x500Name2.equals(x500Name6)) continue;
                if (x509.D().compareTo(x5092.D()) > 0) {
                    bl9 = true;
                    arrayList3.remove(i);
                    continue;
                }
                bl7 = false;
            }
            PKCS12CertBag pKCS12CertBag = new PKCS12CertBag(pKCS12Safe, (X509)object);
            if (n != 0 && !bl4 && bl8) {
                pKCS12CertBag.a(OracleLocalKeyId.b(0, 0));
                ((ArrayList)serializable).add(pKCS12CertBag);
                continue;
            }
            if (n != 0) continue;
            if (bl && !bl4 && bl8) {
                serializable2 = new PKCS12CertBag(pKCS12Safe, (X509)object);
                ((PKCS12Bag)serializable2).a(OracleLocalKeyId.b(0, 0));
                ((ArrayList)serializable).add(serializable2);
            }
            if (!bl6 || bl9) {
                pKCS12CertBag.a(n + n3);
                pKCS12CertBag.a(OracleLocalKeyId.c(0, n2));
                ((ArrayList)serializable).add(pKCS12CertBag);
                continue;
            }
            serializable2 = new StringBuilder("Skipped import of user certificate with Subject DN=");
            ((StringBuilder)serializable2).append(x509.m());
            ((StringBuilder)serializable2).append(", Issuer DN=").append(x509.n());
            ((StringBuilder)serializable2).append(", Serial No.=").append(x509.o());
            ((StringBuilder)serializable2).append(", because a user cert with same private key is already present in the wallet and that is most recently issued certificate.");
            System.out.println(serializable2);
        }
        arrayList3.addAll((Collection<PKCS12Bag>)((Object)serializable));
        pKCS12Safe.a(arrayList3);
        if (!bl2) {
            OracleKSIdentityEntry oracleKSIdentityEntry = new OracleKSIdentityEntry(pKCS12KeyBag, new Vector(serializable), new Vector());
            this.b.put(string, oracleKSIdentityEntry);
        }
        pKCS12.a(arrayList);
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        pKCS12.output((OutputStream)object);
        OraclePKIDebug.a("OracleKeyStoreSpi::internalAddPrivateKeyAndCertificateChain: Exit");
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, HashMap hashMap, boolean bl) throws IOException, KeyStoreException {
        int n;
        Object object;
        byte[] byArray;
        KeyPair keyPair;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray2;
        PKCS12CertBag pKCS12CertBag;
        Object object2;
        int n2;
        ArrayList<PKCS12Bag> arrayList;
        ASN1Object aSN1Object;
        PKCS12 pKCS12;
        block38: {
            Object object3;
            ((ByteArrayInputStream)inputStream).mark(((ByteArrayInputStream)inputStream).available());
            byte[] byArray3 = this.a(inputStream, cArray, oraclePKIX509CertImpl, hashMap);
            ((ByteArrayInputStream)inputStream).reset();
            if (byArray3 == null && this.getP11Lib() != null) {
                byArray3 = this.a(inputStream, cArray, oraclePKIX509CertImpl);
            }
            ((ByteArrayInputStream)inputStream).reset();
            pKCS12 = new PKCS12();
            pKCS12.a(cArray);
            if (inputStream != null) {
                aSN1Object = new PKCS12(cArray, inputStream);
                pKCS12.a(((PKCS12)aSN1Object).f());
            }
            aSN1Object = null;
            if (pKCS12.f().isEmpty()) {
                OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
                aSN1Object = new PKCS12Safe(pKCS12);
                ((PKCS12Safe)aSN1Object).a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
            } else {
                OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
                aSN1Object = pKCS12.f().get(0);
            }
            arrayList = ((PKCS12Safe)aSN1Object).d();
            OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
            n2 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = arrayList.get(i);
                if (!OracleKeyStoreSpi.a((PKCS12Bag)object2) || !OracleLocalKeyId.c(((PKCS12Bag)object2).c())) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                ++n2;
            }
            pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
            if (bl) {
                OracleLocalKeyId.a(byArray3, TrustFlags.NZTF_USER_CERT.getDisplayName());
            }
            pKCS12CertBag.a(byArray3);
            object2 = oraclePKIX509CertImpl.getPublicKey().getAlgorithm();
            Object var14_15 = null;
            byArray2 = null;
            bigInteger2 = null;
            bigInteger = BigInteger.TEN;
            keyPair = null;
            byArray = null;
            if (((String)object2).equals("RSA")) {
                try {
                    object3 = JCEUtil.getCipherInstance("RSA/ECB/PKCS1Padding");
                    ((Cipher)object3).init(1, oraclePKIX509CertImpl.getPublicKey());
                    byArray2 = ((Cipher)object3).doFinal(bigInteger.toByteArray());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (OraclePKIDebug.getDebugFlag()) {
                        generalSecurityException.printStackTrace();
                    }
                    break block38;
                }
            }
            if (((String)object2).equals("EC")) {
                try {
                    object3 = JCEUtil.getKeyPairGeneratorInstance("EC");
                    ((KeyPairGenerator)object3).initialize(((ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams());
                    keyPair = ((KeyPairGenerator)object3).generateKeyPair();
                    object = JCEUtil.getKeyAgreementInstance("ECDH");
                    ((KeyAgreement)object).init(keyPair.getPrivate());
                    ((KeyAgreement)object).doPhase((ECPublicKey)oraclePKIX509CertImpl.getPublicKey(), true);
                    byArray = ((KeyAgreement)object).generateSecret();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    generalSecurityException.printStackTrace();
                }
            }
        }
        if (string != null) {
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object4;
                PKCS12Bag pKCS12Bag = arrayList.get(i);
                if (pKCS12Bag.b() == null || !pKCS12Bag.b().equals(string)) continue;
                PrivateKey privateKey = null;
                if (pKCS12Bag instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)pKCS12Bag).e();
                } else {
                    if (!(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).g();
                }
                String string2 = privateKey.getAlgorithm();
                if (!string2.equals(object2)) continue;
                if (string2.equals("RSA")) {
                    try {
                        object4 = JCEUtil.getCipherInstance("RSA/ECB/PKCS1Padding");
                        ((Cipher)object4).init(2, privateKey);
                        bigInteger2 = new BigInteger(((Cipher)object4).doFinal(byArray2));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        if (OraclePKIDebug.getDebugFlag()) {
                            generalSecurityException.printStackTrace();
                        }
                        bigInteger2 = BigInteger.ZERO;
                    }
                    if (!bigInteger2.equals(bigInteger)) continue;
                    n = 1;
                    break;
                }
                if (!string2.equals("EC")) continue;
                try {
                    object4 = JCEUtil.getKeyAgreementInstance("ECDH");
                    ((KeyAgreement)object4).init((ECPrivateKey)privateKey);
                    if (keyPair != null) {
                        ((KeyAgreement)object4).doPhase(keyPair.getPublic(), true);
                    }
                    if (!Arrays.equals(byArray, ((KeyAgreement)object4).generateSecret())) continue;
                    n = 1;
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
            if (n == 0) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                Object object5;
                object = arrayList.get(n);
                PrivateKey privateKey = null;
                if (object instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)object).e();
                } else {
                    if (!(object instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)object).g();
                }
                String string3 = privateKey.getAlgorithm();
                if (!string3.equals(object2)) continue;
                if (string3.equals("RSA")) {
                    try {
                        object5 = JCEUtil.getCipherInstance("RSA/ECB/PKCS1Padding");
                        ((Cipher)object5).init(2, privateKey);
                        bigInteger2 = new BigInteger(((Cipher)object5).doFinal(byArray2));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        if (OraclePKIDebug.getDebugFlag()) {
                            generalSecurityException.printStackTrace();
                        }
                        bigInteger2 = BigInteger.ZERO;
                    }
                    if (!bigInteger2.equals(bigInteger)) continue;
                    string = ((PKCS12Bag)object).b();
                    break;
                }
                if (!string3.equals("EC")) continue;
                try {
                    object5 = JCEUtil.getKeyAgreementInstance("ECDH");
                    ((KeyAgreement)object5).init((ECPrivateKey)privateKey);
                    if (keyPair != null) {
                        ((KeyAgreement)object5).doPhase(keyPair.getPublic(), true);
                    }
                    if (!Arrays.equals(byArray, ((KeyAgreement)object5).generateSecret())) continue;
                    string = ((PKCS12Bag)object).b();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            pKCS12CertBag.a(string.toLowerCase());
        }
        arrayList.add(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        ((PKCS12Safe)aSN1Object).a(arrayList);
        if (arrayList.size() > 0 && pKCS12.f().isEmpty()) {
            pKCS12.a((PKCS12Safe)aSN1Object);
        }
        n = pKCS12.length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        int n;
        ASN1Object aSN1Object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object2) || (oraclePKIX509CertImpl2 = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null || !string.equals(object2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalReplaceTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        object2 = new PKCS12();
        ((PKCS12)object2).a(cArray);
        if (inputStream != null) {
            aSN1Object = new PKCS12(cArray, inputStream);
            ((PKCS12)object2).a(((PKCS12)aSN1Object).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object2).f().get(0);
        ArrayList<PKCS12Bag> arrayList = ((PKCS12Safe)aSN1Object).d();
        ArrayList<PKCS12Bag> arrayList2 = new ArrayList<PKCS12Bag>(arrayList.size());
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(arrayList.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(((PKCS12Bag)object).c())) {
                byte[] byArray;
                PKCS12CertBag pKCS12CertBag;
                X509 x509 = ((PKCS12CertBag)object).e();
                X509 x5092 = new X509(oraclePKIX509CertImpl2.getEncoded());
                if (x509.equals(oraclePKIX509CertImpl.getX509()) && (x5092 == null || !x5092.equals(oraclePKIX509CertImpl.getX509()))) {
                    OraclePKIDebug.a("Certificate is already present in wallet.");
                    throw new IOException(a.getString("PKI-04003") + " " + oraclePKIX509CertImpl.getSubjectDN().toString());
                }
                if (x5092 == null || !x5092.equals(x509)) {
                    String string3;
                    if (((PKCS12Bag)object).b() != null && ((PKCS12Bag)object).b().equalsIgnoreCase(string)) {
                        throw new IOException(a.getString("PKI-04008") + string);
                    }
                    pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                    pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                    String string4 = null;
                    byArray = ((PKCS12Bag)object).c();
                    string4 = OracleLocalKeyId.a(byArray);
                    if (string4 != null && !"".equals(string4)) {
                        byArray = pKCS12CertBag.c();
                        OracleLocalKeyId.a(byArray, string4);
                        pKCS12CertBag.a(byArray);
                    }
                    if ((string3 = ((PKCS12Bag)object).b()) != null) {
                        pKCS12CertBag.a(string3);
                    }
                    arrayList2.add(pKCS12CertBag);
                    vector2.addElement(pKCS12CertBag);
                    OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                    ++n2;
                    continue;
                }
                pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
                pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                if (string2 == null) {
                    byArray = ((PKCS12Bag)object).c();
                    string2 = OracleLocalKeyId.a(byArray);
                }
                if (string2 != null) {
                    byArray = pKCS12CertBag.c();
                    OracleLocalKeyId.a(byArray, string2);
                    pKCS12CertBag.a(byArray);
                }
                pKCS12CertBag.a(string.toLowerCase());
                arrayList2.add(pKCS12CertBag);
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                continue;
            }
            arrayList2.add((PKCS12Bag)object);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object)) continue;
            vector2.addElement((PKCS12Bag)object);
            if (!OracleLocalKeyId.d(((PKCS12Bag)object).c())) continue;
            vector.addElement((PKCS12Bag)object);
        }
        ((PKCS12Safe)aSN1Object).a(arrayList2);
        if (arrayList2.size() > 0 && ((PKCS12)object2).f().isEmpty()) {
            ((PKCS12)object2).a((PKCS12Safe)aSN1Object);
        }
        n = ((PKCS12)object2).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object2).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidFormatException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        Object object4;
        Serializable serializable3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        X500Name x500Name = null;
        BigInteger bigInteger = null;
        X500Name x500Name2 = new X500Name(oraclePKIX509CertImpl.getSubjectDN().toString());
        if (string != null) {
            x500Name = new X500Name(string);
        }
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            serializable2 = null;
            if (!this.engineIsCertificateEntry((String)object4) || (serializable2 = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object4)) == null) continue;
            object3 = ((OraclePKIX509CertImpl)serializable2).getSubjectDN().toString();
            object2 = ((OraclePKIX509CertImpl)serializable2).getIssuerDN().toString();
            serializable = ((OraclePKIX509CertImpl)serializable2).getSerialNumber();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (!x500Name2.equals(new X500Name((String)object3))) continue;
            if (string == null || x500Name != null && x500Name.equals(new X500Name((String)object2))) {
                bl = true;
            }
            if (bigInteger == null || bigInteger != null && bigInteger.equals(serializable)) {
                bl2 = true;
            }
            if (this.IsPubKeyMatching(oraclePKIX509CertImpl, (OraclePKIX509CertImpl)serializable2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3) continue;
            if (!bl4) {
                bl4 = true;
                serializable3 = serializable2;
                continue;
            }
            OraclePKIDebug.a("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025") + " " + ((OraclePKIX509CertImpl)serializable2).getSubjectDN().toString());
        }
        if (!bl4) {
            OraclePKIDebug.a("internalReplaceTrustedCert: No trusted cert in wallet with matching inputs.");
            throw new IOException(a.getString("PKI-04007"));
        }
        object4 = new PKCS12();
        ((PKCS12)object4).a(cArray);
        if (inputStream != null) {
            serializable2 = new PKCS12(cArray, inputStream);
            ((PKCS12)object4).a(((PKCS12)serializable2).f());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable2 = ((PKCS12)object4).f().get(0);
        object3 = ((PKCS12Safe)serializable2).d();
        object2 = new ArrayList(((ArrayList)object3).size());
        serializable = new Vector();
        Vector<PKCS12Bag> vector = new Vector<PKCS12Bag>(((ArrayList)object3).size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + ((ArrayList)object3).size() + " bags");
        int n2 = 0;
        for (n = 0; n < ((ArrayList)object3).size(); ++n) {
            object = (PKCS12Bag)((ArrayList)object3).get(n);
            if (OracleKeyStoreSpi.a((PKCS12Bag)object) && OracleLocalKeyId.d(((PKCS12Bag)object).c())) {
                byte[] byArray;
                PKCS12CertBag pKCS12CertBag;
                X509 x509 = ((PKCS12CertBag)object).e();
                X509 x5092 = null;
                if (serializable3 != null) {
                    x5092 = new X509(((OraclePKIX509CertImpl)serializable3).getEncoded());
                }
                if (x509.equals(oraclePKIX509CertImpl.getX509()) && (x5092 == null || !x5092.equals(oraclePKIX509CertImpl.getX509()))) {
                    OraclePKIDebug.a("Certificate is already present in wallet.");
                    throw new IOException(a.getString("PKI-04003") + " " + oraclePKIX509CertImpl.getSubjectDN().toString());
                }
                if (x5092 == null || !x5092.equals(x509)) {
                    String string4;
                    pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)serializable2, x509);
                    pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                    String string5 = null;
                    byArray = ((PKCS12Bag)object).c();
                    string5 = OracleLocalKeyId.a(byArray);
                    if (string5 != null && !"".equals(string5)) {
                        byArray = pKCS12CertBag.c();
                        OracleLocalKeyId.a(byArray, string5);
                        pKCS12CertBag.a(byArray);
                    }
                    if ((string4 = ((PKCS12Bag)object).b()) != null) {
                        pKCS12CertBag.a(string4);
                    }
                    ((ArrayList)object2).add(pKCS12CertBag);
                    vector.addElement(pKCS12CertBag);
                    OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                    ++n2;
                    continue;
                }
                pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)serializable2, oraclePKIX509CertImpl.getX509());
                pKCS12CertBag.a(OracleLocalKeyId.b(0, n2));
                if (string3 == null) {
                    byArray = ((PKCS12Bag)object).c();
                    string3 = OracleLocalKeyId.a(byArray);
                }
                if (string3 != null) {
                    byArray = pKCS12CertBag.c();
                    OracleLocalKeyId.a(byArray, string3);
                    pKCS12CertBag.a(byArray);
                }
                ((ArrayList)object2).add(pKCS12CertBag);
                vector.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                continue;
            }
            ((ArrayList)object2).add(object);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object)) continue;
            vector.addElement((PKCS12Bag)object);
            if (!OracleLocalKeyId.c(((PKCS12Bag)object).c())) continue;
            ((Vector)serializable).addElement(object);
        }
        ((PKCS12Safe)serializable2).a((List<PKCS12Bag>)object2);
        if (((ArrayList)object2).size() > 0 && ((PKCS12)object4).f().isEmpty()) {
            ((PKCS12)object4).a((PKCS12Safe)serializable2);
        }
        n = ((PKCS12)object4).length();
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object4).f().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + n);
        object = new ByteArrayOutputStream(n);
        ((PKCS12)object4).output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        int n = -1;
        try {
            int n2 = NZNative.Pkcs11HasMatchingPvtKey(this.getP11Lib(), this.getP11TokenLabel(), this.getP11TokenPassphrase(), oraclePKIX509CertImpl.getEncoded());
            if (n2 != 0) {
                OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in HSM");
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            IOException iOException = new IOException();
            iOException.initCause(certificateEncodingException);
            throw iOException;
        }
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        for (Map.Entry<String, OracleKSEntry> entry : set) {
            if (!(entry.getValue() instanceof OracleKSIdentityEntry)) continue;
            OracleKSIdentityEntry oracleKSIdentityEntry = (OracleKSIdentityEntry)entry.getValue();
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)oracleKSIdentityEntry.g();
            CertificateRequest certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            OraclePKIRSAPublicKey oraclePKIRSAPublicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
            if (oraclePKIRSAPrivateKey.isPvtKeyPresent() || certificateRequest == null || !this.a(oraclePKIRSAPublicKey, certificateRequest)) continue;
            n = ((OracleKSIdentityEntry)entry.getValue()).i();
            if (((OracleKSIdentityEntry)entry.getValue()).f() == null) break;
            throw new IOException(a.getString("PKI-04004"));
        }
        if (n == -1) {
            OraclePKIDebug.a("OracleKeyStoreSpi: Could not generate localkeyID");
            throw new IOException("OracleKeyStoreSpi: Could not generate localkeyID");
        }
        byArray = OracleLocalKeyId.e(0, n);
        return byArray;
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap) throws IOException {
        byte[] byArray = null;
        boolean bl = false;
        boolean bl2 = false;
        if (hashMap != null && hashMap.size() > 0) {
            bl = true;
        }
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        for (Map.Entry<String, OracleKSEntry> entry : set) {
            if (!(entry.getValue() instanceof OracleKSIdentityEntry)) continue;
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("RSA")) {
                if (((OracleKSIdentityEntry)entry.getValue()).g() instanceof OraclePKIECPrivateKey) continue;
                privateKey = (OraclePKIRSAPrivateKey)((OracleKSIdentityEntry)entry.getValue()).g();
                publicKey = (OraclePKIRSAPublicKey)oraclePKIX509CertImpl.getPublicKey();
                if (privateKey == null || ((OraclePKIRSAPrivateKey)privateKey).isPvtKeyPresent() && !this.a((OraclePKIRSAPublicKey)publicKey, (OraclePKIRSAPrivateKey)privateKey)) continue;
                if (((OraclePKIRSAPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            } else if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("EC")) {
                if (((OracleKSIdentityEntry)entry.getValue()).g() instanceof OraclePKIRSAPrivateKey) continue;
                privateKey = (OraclePKIECPrivateKey)((OracleKSIdentityEntry)entry.getValue()).g();
                publicKey = (OraclePKIECPublicKey)oraclePKIX509CertImpl.getPublicKey();
                if (!((OraclePKIECPrivateKey)privateKey).isPvtKeyPresent() || !this.a((OraclePKIECPublicKey)publicKey, (OraclePKIECPrivateKey)privateKey)) continue;
                if (((OraclePKIECPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            }
            if ((byArray = ((OracleKSIdentityEntry)entry.getValue()).h()) == null) continue;
            if (((OracleKSIdentityEntry)entry.getValue()).f() == null) break;
            throw new IOException(a.getString("PKI-04004"));
        }
        if (byArray == null) {
            OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in wallet");
            if (this.getP11Lib() == null) {
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        return byArray;
    }

    boolean a(OraclePKIRSAPublicKey oraclePKIRSAPublicKey, CertificateRequest certificateRequest) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPublicKey.getModulus();
        BigInteger bigInteger3 = ((RSAPublicKey)certificateRequest.f()).getPublicExponent();
        BigInteger bigInteger4 = ((RSAPublicKey)certificateRequest.f()).getModulus();
        if (bigInteger.equals(bigInteger3) && bigInteger2.equals(bigInteger4)) {
            bl = true;
        }
        return bl;
    }

    boolean a(OraclePKIRSAPublicKey oraclePKIRSAPublicKey, OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPrivateKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPrivateKey.getModulus();
        BigInteger bigInteger3 = oraclePKIRSAPublicKey.getPublicExponent();
        BigInteger bigInteger4 = oraclePKIRSAPublicKey.getModulus();
        if (bigInteger.equals(bigInteger3) && bigInteger2.equals(bigInteger4)) {
            bl = true;
        }
        return bl;
    }

    boolean a(OraclePKIECPublicKey oraclePKIECPublicKey, OraclePKIECPrivateKey oraclePKIECPrivateKey) {
        try {
            byte[] byArray = "abcxyz".getBytes();
            Signature signature = JCEUtil.getSignatureInstance("SHA256withECDSA");
            signature.initSign(oraclePKIECPrivateKey);
            signature.update(byArray, 0, byArray.length);
            byte[] byArray2 = signature.sign();
            Signature signature2 = JCEUtil.getSignatureInstance("SHA256withECDSA");
            signature2.initVerify(oraclePKIECPublicKey);
            signature2.update(byArray, 0, byArray.length);
            return signature2.verify(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl, HashMap hashMap) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (hashMap != null && hashMap.size() > 0) {
            bl2 = true;
        }
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        Iterator<Map.Entry<String, OracleKSEntry>> iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            String string;
            String string2;
            Certificate[] certificateArray;
            Map.Entry<String, OracleKSEntry> entry = iterator.next();
            if (!(entry.getValue() instanceof OracleKSIdentityEntry) || (certificateArray = ((OracleKSIdentityEntry)entry.getValue()).e()) == null) continue;
            for (int i = 0; !(i >= certificateArray.length || i > 0 && bl2 && (string2 = (String)hashMap.get(string = CertType.TRUSTED.getCertCode() + ((X509Certificate)certificateArray[i]).getSubjectDN().getName() + ((X509Certificate)certificateArray[i]).getIssuerDN().getName() + ((X509Certificate)certificateArray[i]).getSerialNumber().toString())) != null && string2.indexOf(TrustFlags.NZTF_SERVER_AUTH.getDisplayName()) != -1); ++i) {
                if (!oraclePKIX509CertImpl.equals(certificateArray[i])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set<Map.Entry<String, OracleKSEntry>> set = this.b.entrySet();
        for (Map.Entry<String, OracleKSEntry> entry : set) {
            Certificate certificate;
            if (!(entry.getValue() instanceof OracleKSTrustedCertEntry) || !(certificate = entry.getValue().f()).equals(oraclePKIX509CertImpl)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean a(PKCS12 pKCS12, int n) throws IOException {
        boolean bl = false;
        PKCS12Safe pKCS12Safe = null;
        if (pKCS12.f().isEmpty()) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12Safe = new PKCS12Safe(pKCS12);
            pKCS12Safe.a(PBEAlgorithmIdentifier.i, AlgID.Z, AlgID.r);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12Safe = pKCS12.f().get(0);
        }
        ArrayList<PKCS12Bag> arrayList = pKCS12Safe.d();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + arrayList.size() + " bags");
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray;
            int n2;
            PKCS12Bag pKCS12Bag = arrayList.get(i);
            if (!OracleKeyStoreSpi.c(pKCS12Bag) || (n2 = OracleLocalKeyId.l(byArray = pKCS12Bag.c())) != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        String string = null;
        byte[] byArray = null;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2;
            object4 = (String)enumeration.nextElement();
            if (null == object4 || ((String)object4).isEmpty() || null == (serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object4))) continue;
            object3 = ((OraclePKIX509CertImpl)serializable).getSubjectDN();
            String string3 = string2 = object3 != null ? object3.getName() : null;
            if (bl) {
                string = TrustFlags.NZTF_NULL.getDisplayName();
            } else if (null != object4) {
                object2 = ((OraclePKIX509CertImpl)serializable).getIssuerDN();
                object = object2 != null ? object2.getName() : null;
                String string4 = this.engineIsCertificateEntry((String)object4) ? CertType.TRUSTED.name() : CertType.USER.name();
                string = OracleTrustFlagHelper.evaluateTrustFlagForCert(string2, (String)object, ((OraclePKIX509CertImpl)serializable).getBasicConstraints(), string4);
            }
            hashMap2.put(string2, string);
        }
        object4 = new PKCS12();
        ((PKCS12)object4).a(cArray);
        if (inputStream != null) {
            serializable = new PKCS12(cArray, inputStream);
            ((PKCS12)object4).a(((PKCS12)serializable).f());
        }
        serializable = ((PKCS12)object4).f().get(0);
        object3 = ((PKCS12Safe)serializable).d();
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            object2 = (PKCS12Bag)((ArrayList)object3).get(i);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object2)) continue;
            byArray = ((PKCS12Bag)object2).c();
            object = ((PKCS12CertBag)object2).e();
            string = (String)hashMap2.get(((X509)object).I().getName());
            OracleLocalKeyId.a(byArray, string);
            ((PKCS12Bag)object2).a(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object4).length());
        ((PKCS12)object4).output(byteArrayOutputStream);
        OraclePKIDebug.a("OracleKeyStoreSpi::assignTrustFlagsto Cert: Exit");
        return byteArrayOutputStream.toByteArray();
    }

    public static final String getType() {
        String string = Security.getProperty("keystore.type");
        if (!OraclePKIGenFunc.isNullOrEmpty(string)) {
            return string;
        }
        return "pkcs12";
    }

    public final Provider getProvider() {
        return new OraclePKIProvider();
    }

    public final String getDefaultType() {
        return "pkcs12";
    }
}

