/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.DigestInfo;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.CipherException;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class PKCS12
implements Externalizable,
ASN1Object {
    private ArrayList<PKCS12Safe> a = new ArrayList();
    private char[] b;
    private byte[] c;
    private AlgorithmIdentifier d;
    private byte[] e;
    private byte[] f;
    private BigInteger g;
    private ASN1Sequence h;

    public PKCS12() {
    }

    public PKCS12(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public PKCS12(String string, InputStream inputStream) throws IOException {
        this();
        if (string != null) {
            this.a(string);
        }
        this.input(inputStream);
    }

    public PKCS12(char[] cArray, InputStream inputStream) throws IOException {
        this();
        if (cArray != null) {
            this.a(cArray);
        }
        this.input(inputStream);
    }

    public PKCS12(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this();
        if (string != null) {
            this.a(string);
        }
        this.a(aSN1Sequence);
    }

    void a() {
        this.h = null;
        this.e = null;
        this.c = null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        this.a();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        int n = ASN1Integer.b(aSN1SequenceInputStream).intValue();
        if (n != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + n);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
        if (aSN1ObjectID.a(ASN1Utils.e, 7, 1)) {
            if (aSN1SequenceInputStream2.a()) {
                aSN1ConstructedInputStream = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream2, 0);
                object = ASN1OctetString.a(aSN1ConstructedInputStream);
                aSN1ConstructedInputStream.b();
                ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(new ByteArrayInputStream((byte[])object));
                while (aSN1SequenceInputStream3.a()) {
                    this.a(new PKCS12Safe(this, new ASN1Sequence(aSN1SequenceInputStream3)));
                }
                this.c = (byte[])object;
                aSN1SequenceInputStream3.b();
            }
        } else {
            if (aSN1ObjectID.a(ASN1Utils.e, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + aSN1ObjectID.d());
        }
        aSN1SequenceInputStream2.b();
        if (aSN1SequenceInputStream.a()) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            object = new DigestInfo(aSN1ConstructedInputStream);
            this.d = ((DigestInfo)object).getDigestAlgID();
            this.e = ((DigestInfo)object).getDigest();
            this.f = ASN1OctetString.a(aSN1ConstructedInputStream);
            this.g = aSN1ConstructedInputStream.a() ? ASN1Integer.b(aSN1ConstructedInputStream) : BigInteger.valueOf(1L);
            aSN1ConstructedInputStream.b();
        } else {
            this.d = null;
            this.e = null;
            this.f = null;
            this.g = null;
        }
        aSN1SequenceInputStream.b();
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.f().output(outputStream);
    }

    private ASN1Sequence f() {
        if (this.h != null) {
            return this.h;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(new ASN1Integer(3L));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.a(new ASN1ObjectID(ASN1Utils.e, 7, 1));
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.a));
        aSN1Sequence2.a(new ASN1GenericConstructed(new ASN1OctetString(byArray), 0));
        aSN1Sequence.a(aSN1Sequence2);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        if (this.e == null) {
            try {
                this.g();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(noSuchAlgorithmException.toString());
                streamableOutputException.initCause(noSuchAlgorithmException);
                throw streamableOutputException;
            }
            catch (InvalidKeyException invalidKeyException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(invalidKeyException.toString());
                streamableOutputException.initCause(invalidKeyException);
                throw streamableOutputException;
            }
            catch (CipherException cipherException) {
                StreamableOutputException streamableOutputException = new StreamableOutputException(cipherException.toString());
                streamableOutputException.initCause(cipherException);
                throw streamableOutputException;
            }
        }
        aSN1Sequence3.a(new DigestInfo(this.d, this.e));
        aSN1Sequence3.a(new ASN1OctetString(this.f));
        if (this.g.intValue() != 1) {
            aSN1Sequence3.a(new ASN1Integer(this.g));
        }
        aSN1Sequence.a(aSN1Sequence3);
        this.h = aSN1Sequence;
        return aSN1Sequence;
    }

    public static String a(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.N) || algorithmIdentifier.equals(AlgID.O) || algorithmIdentifier.equals(AlgID.V) || algorithmIdentifier.equals(AlgID.W)) {
            string = "HmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.K) || algorithmIdentifier.equals(AlgID.U)) {
            string = "HmacMD5";
        } else if (algorithmIdentifier.equals(AlgID.Q) || algorithmIdentifier.equals(AlgID.X)) {
            string = "HmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.R) || algorithmIdentifier.equals(AlgID.Y)) {
            string = "HmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.S) || algorithmIdentifier.equals(AlgID.Z)) {
            string = "HmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.T) || algorithmIdentifier.equals(AlgID.aa)) {
            string = "HmacSHA512";
        }
        return string;
    }

    public static String b(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.N) || algorithmIdentifier.equals(AlgID.O)) {
            string = "SHA-1";
        } else if (algorithmIdentifier.equals(AlgID.K)) {
            string = "MD5";
        } else if (algorithmIdentifier.equals(AlgID.Q)) {
            string = "SHA-224";
        } else if (algorithmIdentifier.equals(AlgID.R)) {
            string = "SHA-256";
        } else if (algorithmIdentifier.equals(AlgID.S)) {
            string = "SHA-384";
        } else if (algorithmIdentifier.equals(AlgID.T)) {
            string = "SHA-512";
        }
        return string;
    }

    private void g() throws NoSuchAlgorithmException, InvalidKeyException, CipherException {
        Object object;
        if (this.d == null) {
            this.d = AlgID.N;
        }
        if (this.f == null) {
            object = JCEUtil.getSecureRandom();
            this.f = new byte[8];
            ((SecureRandom)object).nextBytes(this.f);
        }
        object = CryptoUtils.getHmacAlg(this.d);
        Mac mac = JCEUtil.getMacInstance((String)object);
        if (this.g == null) {
            this.g = BigInteger.valueOf(10000L);
        }
        byte[] byArray = PKCS12.a(PKCS12.b(this.d), this.b, this.f, this.g.intValue(), (byte)3, mac.getMacLength());
        mac.init(new SecretKeySpec(byArray, (String)object));
        this.c = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.a));
        this.e = mac.doFinal(this.c);
    }

    @Override
    public int length() {
        return this.f().length();
    }

    public String b() {
        return this.b == null ? null : new String(this.b);
    }

    public char[] c() {
        return this.b;
    }

    public void a(String string) {
        if (this.b != null && !Arrays.equals(this.b, string.toCharArray())) {
            this.a();
        }
        this.b = string.toCharArray();
    }

    public void a(char[] cArray) {
        if (this.b != null && !Arrays.equals(this.b, cArray)) {
            this.a();
        }
        this.b = cArray;
    }

    public ArrayList<PKCS12Safe> d() {
        return this.a;
    }

    public void a(List<PKCS12Safe> list) {
        this.a = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<PKCS12Safe>(list));
        this.a();
    }

    public void a(PKCS12Safe pKCS12Safe) {
        this.a.add(pKCS12Safe);
        this.a();
    }

    public boolean e() throws AuthException {
        try {
            if (this.e == null) {
                this.g();
                return true;
            }
            String string = PKCS12.a(this.d);
            Mac mac = JCEUtil.getMacInstance(string);
            if (this.g == null) {
                this.g = BigInteger.valueOf(10000L);
            }
            byte[] byArray = PKCS12.a(PKCS12.b(this.d), this.b, this.f, this.g.intValue(), (byte)3, mac.getMacLength());
            mac.init(new SecretKeySpec(byArray, string));
            byte[] byArray2 = mac.doFinal(this.c);
            return Utils.areEqual(this.e, byArray2);
        }
        catch (CipherException cipherException) {
            AuthException authException = new AuthException(cipherException.toString());
            authException.initCause(cipherException);
            throw authException;
        }
        catch (InvalidKeyException invalidKeyException) {
            AuthException authException = new AuthException(invalidKeyException.toString());
            authException.initCause(invalidKeyException);
            throw authException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AuthException authException = new AuthException(noSuchAlgorithmException.toString());
            authException.initCause(noSuchAlgorithmException);
            throw authException;
        }
    }

    static byte[] a(String string, char[] cArray, byte[] byArray, int n, byte by, int n2) throws NoSuchAlgorithmException {
        int n3;
        if (cArray == null) {
            throw new NullPointerException("Password not set");
        }
        MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(string);
        int n4 = messageDigest.getDigestLength();
        int n5 = string.contains("512") || string.contains("384") ? 128 : 64;
        byte[] byArray2 = new byte[n5];
        Utils.setArray(byArray2, by);
        byte[] byArray3 = new byte[cArray.length * 2];
        Utils.charsToBytes(cArray, byArray3);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n6 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n5 + 1) * n5;
        int n7 = byArray4.length == 0 ? 0 : ((byArray4.length - 1) / n5 + 1) * n5;
        byte[] byArray5 = new byte[n6 + n7];
        for (n3 = 0; n3 < n6; n3 += byArray.length) {
            System.arraycopy(byArray, 0, byArray5, n3, Math.min(n6 - n3, byArray.length));
        }
        int n8 = byArray5.length;
        for (n3 = n6; n3 < n8; n3 += byArray4.length) {
            System.arraycopy(byArray4, 0, byArray5, n3, Math.min(byArray5.length - n3, byArray4.length));
        }
        Utils.setArray(byArray4, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = null;
        for (int i = 0; i < n2; i += n4) {
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
            byArray7 = messageDigest.digest();
            int n9 = n - 1;
            for (int j = 0; j < n9; ++j) {
                messageDigest.update(byArray7);
                byArray7 = messageDigest.digest();
            }
            byte[] byArray8 = new byte[n5];
            for (n9 = 0; n9 < n5; n9 += n4) {
                System.arraycopy(byArray7, 0, byArray8, n9, Math.min(n5 - n9, n4));
            }
            BigInteger bigInteger = new BigInteger(1, byArray8).add(BigInteger.ONE);
            BigInteger bigInteger2 = BigInteger.ONE.shiftLeft(n5 * 8).subtract(BigInteger.ONE);
            int n10 = byArray5.length;
            for (int j = 0; j < n10; j += n5) {
                byte[] byArray9 = new byte[n5];
                System.arraycopy(byArray5, j, byArray9, 0, n5);
                BigInteger bigInteger3 = new BigInteger(1, byArray9).add(bigInteger).and(bigInteger2);
                Utils.toByteArray(bigInteger3, byArray5, j, n5);
            }
            System.arraycopy(byArray7, 0, byArray6, i, Math.min(n2 - i, n4));
        }
        Utils.setArray(byArray7, (byte)0);
        messageDigest = null;
        return byArray6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        boolean bl = false;
        Iterator<PKCS12Safe> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append(']');
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

