/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.util.Map;
import java.util.TreeMap;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;

public enum SignatureAlgorithms {
    MD5("md5", "MD5withRSA", AlgID.y),
    SHA1("sha1", "SHA1withRSA", AlgID.z),
    SHA256("sha256", "SHA256withRSA", AlgID.B),
    SHA384("sha384", "SHA384withRSA", AlgID.C),
    SHA512("sha512", "SHA512withRSA", AlgID.D),
    ECDSASHA1("ecdsasha1", "SHA1withECDSA", AlgID.H),
    ECDSASHA256("ecdsasha256", "SHA256withECDSA", AlgID.I),
    ECDSASHA384("ecdsasha384", "SHA384withECDSA", AlgID.J),
    ECDSASHA512("ecdsasha512", "SHA512withECDSA", AlgID.K),
    MLDSA44("mldsa44", "ML-DSA-44", AlgID.V),
    MLDSA65("mldsa65", "ML-DSA-65", AlgID.W),
    MLDSA87("mldsa87", "ML-DSA-87", AlgID.X),
    SLHDSASHA2128S("slhdsasha2128s", "SLH-DSA-SHA2-128s", AlgID.ab),
    SLHDSASHA2128F("slhdsasha2128f", "SLH-DSA-SHA2-128f", AlgID.ac),
    SLHDSASHA2192S("slhdsasha2192s", "SLH-DSA-SHA2-192s", AlgID.ad),
    SLHDSASHA2192F("slhdsasha2192f", "SLH-DSA-SHA2-192f", AlgID.ae),
    SLHDSASHA2256S("slhdsasha2256s", "SLH-DSA-SHA2-256s", AlgID.af),
    SLHDSASHA2256F("slhdsasha2256f", "SLH-DSA-SHA2-256f", AlgID.ag),
    SLHDSASHAKE128S("slhdsashake128f", "SLH-DSA-SHAKE-128s", AlgID.ai),
    SLHDSASHAKE128F("slhdsashake128s", "SLH-DSA-SHAKE-128f", AlgID.ah),
    SLHDSASHAKE192S("slhdsashake192s", "SLH-DSA-SHAKE-192s", AlgID.aj),
    SLHDSASHAKE192F("slhdsashake192f", "SLH-DSA-SHAKE-192f", AlgID.ak),
    SLHDSASHAKE256S("slhdsashake256s", "SLH-DSA-SHAKE-256s", AlgID.al),
    SLHDSASHAKE256F("slhdsashake256f", "SLH-DSA-SHAKE-256f", AlgID.am);

    private final String a;
    private final String b;
    private final AlgorithmIdentifier c;
    private static final Map<String, SignatureAlgorithms> d;
    private static final Map<String, SignatureAlgorithms> e;

    private SignatureAlgorithms(String string2, String string3, AlgorithmIdentifier algorithmIdentifier) {
        this.a = string2;
        this.b = string3;
        this.c = algorithmIdentifier;
    }

    public AlgorithmIdentifier getSignAlgorithmId() {
        return this.c;
    }

    public String getSignAlgorithmName() {
        return this.a;
    }

    public static AlgorithmIdentifier getSignatureAlgorithm(String string) {
        if (d != null && !d.isEmpty() && string != null) {
            String string2 = string.toLowerCase();
            SignatureAlgorithms signatureAlgorithms = d.get(string2);
            if (signatureAlgorithms != null) {
                return signatureAlgorithms.getSignAlgorithmId();
            }
            if (e != null && !e.isEmpty() && string != null) {
                SignatureAlgorithms signatureAlgorithms2 = e.get(string);
                if (signatureAlgorithms2 != null) {
                    return signatureAlgorithms2.getSignAlgorithmId();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static boolean isSignAlgorithmValid(String string) {
        if (d.containsKey(string)) {
            return true;
        }
        return e.containsKey(string);
    }

    public String getStandardJCEName() {
        return this.b;
    }

    static {
        d = new TreeMap<String, SignatureAlgorithms>(String.CASE_INSENSITIVE_ORDER);
        e = new TreeMap<String, SignatureAlgorithms>(String.CASE_INSENSITIVE_ORDER);
        for (SignatureAlgorithms signatureAlgorithms : SignatureAlgorithms.values()) {
            d.put(signatureAlgorithms.getSignAlgorithmName(), signatureAlgorithms);
        }
        for (SignatureAlgorithms signatureAlgorithms : SignatureAlgorithms.values()) {
            e.put(signatureAlgorithms.getStandardJCEName(), signatureAlgorithms);
        }
    }
}

