/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import oracle.security.pki.JCEUtil;

public class OraclePKIKeyPair {
    private final PrivateKey a;
    private final PublicKey b;

    protected OraclePKIKeyPair(PrivateKey privateKey, PublicKey publicKey) {
        this.a = privateKey;
        this.b = publicKey;
    }

    public static OraclePKIKeyPair generateRSAKey(int n) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("RSA");
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return new OraclePKIKeyPair(keyPair.getPrivate(), keyPair.getPublic());
    }

    public static OraclePKIKeyPair generateECKey(String string) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("EC");
        keyPairGenerator.initialize(new ECGenParameterSpec(string));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return new OraclePKIKeyPair(keyPair.getPrivate(), keyPair.getPublic());
    }

    public static OraclePKIKeyPair generateECKey(ECGenParameterSpec eCGenParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("EC");
        keyPairGenerator.initialize(eCGenParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return new OraclePKIKeyPair(keyPair.getPrivate(), keyPair.getPublic());
    }

    public static OraclePKIKeyPair generateKeyWthAlgorithm(String string, int n) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance(string);
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return new OraclePKIKeyPair(keyPair.getPrivate(), keyPair.getPublic());
    }

    public PrivateKey getPrivateKey() {
        return this.a;
    }

    public PublicKey getPublicKey() {
        return this.b;
    }
}

