/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCPublicKey;
import oracle.security.pki.internal.pqc.util.PQCKeyUtil;
import oracle.security.pki.internal.pqc.util.PQCObjectIdentifiers;

public class PQCUtils {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public static void a(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid algorithm as input");
        }
        AlgorithmIdentifier algorithmIdentifier = PQCObjectIdentifiers.a(string);
        if (algorithmIdentifier == null) {
            throw new IOException(MessageFormat.format(a.getString("PKI-02025"), string));
        }
    }

    public static ASN1Sequence a(PublicKey publicKey) throws IOException {
        if (publicKey == null) {
            OraclePKIDebug.debug("Key is null, returning null");
            return null;
        }
        byte[] byArray = publicKey.getEncoded();
        if (byArray == null) {
            OraclePKIDebug.debug("Key encoding is null, returning null");
            return null;
        }
        try {
            ASN1Object aSN1Object;
            ASN1Object aSN1Object2;
            ASN1Sequence aSN1Sequence;
            ByteArrayInputStream byteArrayInputStream;
            block12: {
                ASN1Sequence aSN1Sequence2;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    aSN1Sequence = new ASN1Sequence();
                    ASN1Sequence aSN1Sequence3 = new ASN1Sequence(byteArrayInputStream);
                    aSN1Object2 = aSN1Sequence3.a(0);
                    aSN1Object = aSN1Sequence3.a(1);
                    if (aSN1Object2 != null && aSN1Object != null) break block12;
                    OraclePKIDebug.debug("ASN1Sequence elements are null");
                    aSN1Sequence2 = null;
                }
                catch (Throwable throwable) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                byteArrayInputStream.close();
                return aSN1Sequence2;
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Object2);
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Object;
            aSN1Sequence.a(algorithmIdentifier);
            aSN1Sequence.a(aSN1BitString);
            ASN1Sequence aSN1Sequence4 = aSN1Sequence;
            byteArrayInputStream.close();
            return aSN1Sequence4;
        }
        finally {
            OraclePKIDebug.debug("Exit subjectPQCPublicKeyInfo");
        }
    }

    public static String a(Key key, String string) {
        OraclePKIDebug.debug("Enter getAlgorithmFromSpec");
        try {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Key type cannot be null or empty");
            }
            if (!string.equals("Public") && !string.equals("Private")) {
                throw new IllegalArgumentException("Invalid key type: " + string);
            }
            Method method = key.getClass().getMethod("getParams", new Class[0]);
            Object object = method.invoke((Object)key, new Object[0]);
            if (object == null) {
                throw new IllegalArgumentException("Key parameters cannot be null");
            }
            Class<?> clazz = Class.forName("java.security.spec.NamedParameterSpec");
            if (!clazz.isInstance(object)) {
                throw new IllegalArgumentException("Parameters must be of type NamedParameterSpec");
            }
            Method method2 = clazz.getMethod("getName", new Class[0]);
            String string2 = (String)method2.invoke(object, new Object[0]);
            OraclePKIDebug.debug("Exit getAlgorithmFromSpec: " + string2);
            return string2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            OraclePKIDebug.debug("NamedParameterSpec not available in this JDK version");
            throw new IllegalStateException("NamedParameterSpec not supported" + classNotFoundException.getMessage());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            OraclePKIDebug.debug("Failed to retrieve algorithm name from key" + reflectiveOperationException.getMessage());
            throw new IllegalArgumentException("Failed to get algorithm from key");
        }
    }

    public static int b(PublicKey publicKey) {
        OraclePKIDebug.debug("Enter getPublicKeyBitLength");
        try {
            PublicKey publicKey2;
            if (publicKey == null) {
                throw new IllegalArgumentException("Public key cannot be null");
            }
            PublicKey publicKey3 = publicKey2 = publicKey instanceof OraclePKIPQCPublicKey ? ((OraclePKIPQCPublicKey)publicKey).a() : publicKey;
            if (publicKey2 == null) {
                throw new IllegalArgumentException("Extracted public key is null");
            }
            int n = PQCUtils.c(publicKey2);
            if (n > 0) {
                int n2 = n;
                return n2;
            }
            int n3 = PQCUtils.d(publicKey2);
            return n3;
        }
        catch (SecurityException securityException) {
            OraclePKIDebug.debug("Security violation accessing key information");
            throw new IllegalStateException("Cannot access key information" + securityException.getMessage());
        }
        catch (Exception exception) {
            OraclePKIDebug.debug("Unexpected error getting key length");
            throw new IllegalStateException("Failed to determine key length" + exception.getMessage());
        }
        finally {
            OraclePKIDebug.debug("Exit getPublicKeyBitLength");
        }
    }

    private static int c(PublicKey publicKey) {
        try {
            Method method = publicKey.getClass().getMethod("getParams", new Class[0]);
            Object object = method.invoke((Object)publicKey, new Object[0]);
            if (object == null) {
                return -1;
            }
            Class<?> clazz = Class.forName("java.security.spec.NamedParameterSpec");
            if (!clazz.isInstance(object)) {
                return -1;
            }
            Method method2 = clazz.getMethod("getName", new Class[0]);
            String string = (String)method2.invoke(object, new Object[0]);
            PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(string);
            return pQCKeyInfo != null ? pQCKeyInfo.a() : -1;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            OraclePKIDebug.debug("Modern key size determination failed");
            return -1;
        }
    }

    private static int d(PublicKey publicKey) {
        String string = publicKey.getAlgorithm();
        if (string != null && string.startsWith("ML-DSA")) {
            PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(string);
            return pQCKeyInfo != null ? pQCKeyInfo.a() : -1;
        }
        return -1;
    }
}

