/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.util;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.internal.pqc.util.PQCUtils;

public class PQCKeyUtil {
    private static final Map<String, PQCKeyInfo> a = PQCKeyUtil.a();
    private static final Map<String, PQCKeyInfo> b = PQCKeyUtil.b();
    private static final int c = -1;
    private static final int d = 0;

    private static Map<String, PQCKeyInfo> a() {
        HashMap<String, PQCKeyInfo> hashMap = new HashMap<String, PQCKeyInfo>();
        hashMap.put("ML-DSA-44", new PQCKeyInfo(1312, 2528, 2420));
        hashMap.put("ML-DSA-65", new PQCKeyInfo(1952, 4000, 3296));
        hashMap.put("ML-DSA-87", new PQCKeyInfo(2592, 4864, 4595));
        hashMap.put("ML-KEM-512", new PQCKeyInfo(1568, 1568, 1697));
        hashMap.put("ML-KEM-768", new PQCKeyInfo(3104, 3104, 3366));
        hashMap.put("ML-KEM-1024", new PQCKeyInfo(5120, 5120, 5348));
        return hashMap;
    }

    private static Map<String, PQCKeyInfo> b() {
        HashMap<String, PQCKeyInfo> hashMap = new HashMap<String, PQCKeyInfo>();
        hashMap.put("SLH-DSA-SHA2-128s", new PQCKeyInfo(896, 1280, 1700));
        hashMap.put("SLH-DSA-SHA2-128f", new PQCKeyInfo(896, 1280, 1700));
        hashMap.put("SLH-DSA-SHA2-192s", new PQCKeyInfo(1472, 2048, 2700));
        hashMap.put("SLH-DSA-SHA2-192f", new PQCKeyInfo(1472, 2048, 2700));
        hashMap.put("SLH-DSA-SHA2-256s", new PQCKeyInfo(2048, 2816, 3500));
        hashMap.put("SLH-DSA-SHA2-256f", new PQCKeyInfo(2048, 2816, 3500));
        hashMap.put("SLH-DSA-SHAKE-128s", new PQCKeyInfo(896, 1280, 1700));
        hashMap.put("SLH-DSA-SHAKE-128f", new PQCKeyInfo(896, 1280, 1700));
        hashMap.put("SLH-DSA-SHAKE-192s", new PQCKeyInfo(1472, 2048, 2700));
        hashMap.put("SLH-DSA-SHAKE-192f", new PQCKeyInfo(1472, 2048, 2700));
        hashMap.put("SLH-DSA-SHAKE-256s", new PQCKeyInfo(2048, 2816, 3500));
        hashMap.put("SLH-DSA-SHAKE-256f", new PQCKeyInfo(2048, 2816, 3500));
        return hashMap;
    }

    public static PQCKeyInfo a(String string) {
        if (string == null || string.isEmpty()) {
            OraclePKIDebug.debug("Invalid algorithm specified");
            return null;
        }
        return a.get(string);
    }

    public static PQCKeyInfo b(String string) {
        if (string == null || string.isEmpty()) {
            OraclePKIDebug.debug("Invalid security strength specified");
            return null;
        }
        return b.get(string);
    }

    private static int a(String string, String string2) {
        if (string == null || string.isEmpty()) {
            OraclePKIDebug.debug("Invalid algorithm specified");
            return -1;
        }
        PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(string);
        if (pQCKeyInfo == null) {
            OraclePKIDebug.debug("Key size information is unavailable for the specified algorithm and security level");
            return -1;
        }
        return string2.equals("Public") ? pQCKeyInfo.a() : pQCKeyInfo.b();
    }

    private static int b(String string, String string2) {
        if (string == null || string.isEmpty()) {
            OraclePKIDebug.debug("Invalid algorithm specified");
            return -1;
        }
        PQCKeyInfo pQCKeyInfo = PQCKeyUtil.b(string);
        if (pQCKeyInfo == null) {
            OraclePKIDebug.debug("Key size information is unavailable for the specified algorithm and security level");
            return -1;
        }
        return string2.equals("Public") ? pQCKeyInfo.a() : pQCKeyInfo.b();
    }

    public static int a(Key key, String string) {
        if (string == null || string.isEmpty() || !string.equals("Public") && !string.equals("Private")) {
            OraclePKIDebug.debug("Invalid key type specified");
            return -1;
        }
        String string2 = string.equals("Private") ? PQCUtils.a(key, "Private") : PQCUtils.a(key, "Public");
        if (string2 == null) {
            OraclePKIDebug.debug("Invalid algorithm specified");
            return -1;
        }
        if (string2.contains("ML-DSA")) {
            return PQCKeyUtil.a(string2, string);
        }
        if (string2.contains("SLH-DSA")) {
            return PQCKeyUtil.b(string2, string);
        }
        return 0;
    }

    public static class PQCKeyInfo {
        private final int a;
        private final int b;
        private final int c;

        public PQCKeyInfo(int n, int n2, int n3) {
            this.a = n;
            this.b = n2;
            this.c = n3;
        }

        public int a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public int c() {
            return this.c;
        }

        public String toString() {
            return String.format("Public key size: %d bytes, Private key size: : %d bytes,Signature size: %d bytes", this.a, this.b, this.c);
        }
    }
}

