/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.EnumSet;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCPrivateKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.util.Utils;

public class OraclePKIMLDSAPrivateKey
extends OraclePKIPQCPrivateKey {
    byte[] a;
    byte[] b;

    public OraclePKIMLDSAPrivateKey(String string, int n, String string2, EnumSet<KeyUsage> enumSet, byte[] byArray) {
        super(string, n, string2, enumSet, byArray);
        try {
            this.a(byArray);
        }
        catch (IOException iOException) {
            OraclePKIDebug.debug(" key attributes" + iOException.getMessage());
        }
    }

    public OraclePKIMLDSAPrivateKey(PrivateKey privateKey, CertificateRequest certificateRequest) {
        super(privateKey, certificateRequest);
    }

    private void a(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            throw new IOException("Invalid encoded bytes: NULL or empty");
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            int n;
            if (byteArrayInputStream.read() != 48) {
                throw new IOException("Invalid PKCS#8 encoding: Expected SEQUENCE tag");
            }
            int n2 = byteArrayInputStream.read();
            if (n2 > 128) {
                n = n2 - 128;
                byteArrayInputStream.skip(n);
            }
            if (byteArrayInputStream.skip(n = byteArrayInputStream.available() - 112) != (long)n) {
                throw new IOException("Failed to skip PKCS#8 header");
            }
            this.a = new byte[32];
            if (byteArrayInputStream.read(this.a) != 32) {
                throw new IOException("Failed to read rho");
            }
            int n3 = 32;
            int n4 = 32;
            if (byteArrayInputStream.skip(n3 + n4) != (long)(n3 + n4)) {
                throw new IOException("Failed to skip K and s");
            }
            this.b = new byte[48];
            if (byteArrayInputStream.read(this.b) != 48) {
                throw new IOException("Failed to read tr");
            }
        }
    }

    public String toString() {
        try {
            this.a(this.getEncoded());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return "ML-DSA data: \n\talias = " + this.e + "\n\trho = " + Utils.toHexString(this.a) + "\n\ttr: " + Utils.toHexString(this.b);
    }
}

