/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.fips;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.fips.FIPSConfig;
import oracle.security.pki.fips.FIPSJARRegistry;
import oracle.security.pki.fips.FIPSVersion;

public final class FIPSProviderLoader {
    public static final String a = "com.rsa.jsafe.crypto.CryptoJ";
    public static final String b = "com.rsa.jsafe.crypto.FIPS140Context";
    public static final String c = "FIPS140_MODE";

    private static URLClassLoader a() throws IOException {
        List<String> list;
        FIPSVersion fIPSVersion = FIPSConfig.a();
        if (fIPSVersion == null) {
            try {
                fIPSVersion = FIPSConfig.d();
            }
            catch (Exception exception) {
                throw new IOException("Failed to detect FIPS version" + exception.getMessage());
            }
        }
        if (fIPSVersion == null) {
            fIPSVersion = FIPSVersion.a;
        }
        if ((list = FIPSJARRegistry.a(fIPSVersion)) == null || list.isEmpty()) {
            throw new IOException("No JARs found for FIPS version: " + (Object)((Object)fIPSVersion));
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : list) {
            if (string == null || string.trim().isEmpty()) {
                throw new IOException("Invalid JAR name in registry for FIPS version: " + (Object)((Object)fIPSVersion));
            }
            URL uRL = FIPSProviderLoader.b(string);
            if (uRL == null) {
                throw new IllegalArgumentException("JAR not found in classpath: " + string);
            }
            arrayList.add(uRL);
        }
        return new URLClassLoader(arrayList.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
    }

    public static Provider a(String string) throws NoSuchProviderException {
        Provider provider;
        block12: {
            if (string == null || string.trim().isEmpty()) {
                throw new NoSuchProviderException("Provider class name is null or empty");
            }
            URLClassLoader uRLClassLoader = FIPSProviderLoader.a();
            try {
                Object obj;
                Class<?> clazz = Class.forName(a, true, uRLClassLoader);
                Field field = clazz.getField(c);
                int n = field.getInt(null);
                Class<?> clazz2 = Class.forName(b, true, uRLClassLoader);
                Constructor<?> constructor = clazz2.getConstructor(Integer.TYPE);
                try {
                    obj = constructor.newInstance(n);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new NoSuchProviderException("The available JsafeJCE provider is not the FIPS 140 variant: " + string);
                }
                Class<?> clazz3 = Class.forName(string, true, uRLClassLoader);
                Constructor<?> constructor2 = clazz3.getConstructor(clazz2);
                Object obj2 = constructor2.newInstance(obj);
                if (!(obj2 instanceof Provider)) {
                    String string2 = obj2.getClass().getName();
                    throw new NoSuchProviderException("Not a provider instance: " + string2);
                }
                provider = (Provider)obj2;
                if (uRLClassLoader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (uRLClassLoader != null) {
                        try {
                            uRLClassLoader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ReflectiveOperationException exception) {
                    throw new NoSuchProviderException("Failed to instantiate provider: " + string + " (" + exception.getMessage() + ")");
                }
            }
            uRLClassLoader.close();
        }
        return provider;
    }

    private static URL b(String string) throws IOException {
        String[] stringArray;
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String string2 = System.getProperty("java.class.path");
        for (String string3 : stringArray = string2.split(File.pathSeparator)) {
            if (!string3.endsWith(string)) continue;
            try {
                Path path = Paths.get(string3, new String[0]);
                Path path2 = path.toRealPath(new LinkOption[0]);
                return path2.toUri().toURL();
            }
            catch (Exception exception) {
                throw new IOException("Invalid JAR path: " + string3);
            }
        }
        throw new IOException("Couldn't find JAR in classpath");
    }
}

