/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.fips;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessController;
import java.security.Security;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.fips.FIPSVersion;

public class FIPSConfig {
    private static final String b;
    private static FIPSVersion c;
    public static final Map<String, FIPSVersion> a;

    public static synchronized void a(FIPSVersion fIPSVersion) {
        c = fIPSVersion;
        JCEUtil.clearCachedObjects();
    }

    public static synchronized FIPSVersion a() {
        return c;
    }

    public static synchronized String b() {
        if (c == null) {
            return "FIPS mode not enabled";
        }
        return c.toString();
    }

    public static synchronized boolean c() {
        return c != null;
    }

    public static FIPSVersion d() throws IOException {
        String string = FIPSConfig.e();
        if (string == null || string.trim().isEmpty()) {
            throw new IOException("FIPS config file path is null or empty");
        }
        String string2 = FIPSConfig.a(string);
        if (string2.isEmpty()) {
            throw new IOException("Invalid FIPS configuration value");
        }
        if (a.containsKey(string2)) {
            return a.get(string2);
        }
        throw new IOException("Invalid FIPS_140 value: " + string2);
    }

    private static String a(String string) throws IOException {
        Object object;
        if (string == null || string.trim().isEmpty()) {
            throw new IOException("FIPS config file path is null or empty");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("FIPS config file does not exist: " + string);
        }
        Properties properties = new Properties();
        try {
            object = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read FIPS config file: " + string, iOException);
        }
        object = properties.getProperty("FIPS_140", "").trim().toUpperCase(Locale.ROOT);
        if (((String)object).isEmpty()) {
            throw new IOException("FIPS_140 property missing in 'fips.ora' file: " + string);
        }
        return object;
    }

    private static String e() throws IOException {
        String string;
        String string2 = System.getenv("FIPS_HOME");
        String string3 = System.getProperty("os.name");
        boolean bl = string3 != null && string3.toLowerCase(Locale.ROOT).startsWith("windows");
        String string4 = string = bl ? "\\" : "/";
        if (string2 == null || string2.trim().isEmpty()) {
            string2 = System.getenv("ORACLE_HOME");
            if (string2 == null || string2.trim().isEmpty()) {
                throw new IOException("Oracle Home not set");
            }
            string2 = string2.trim() + string + "ldap" + string + "admin" + string + "fips.ora";
        } else {
            string2 = string2.trim() + string + "fips.ora";
        }
        File file = new File(string2);
        if (!file.exists()) {
            throw new IOException("FIPS config file does not exist");
        }
        return string2;
    }

    static {
        c = null;
        b = AccessController.doPrivileged(() -> Security.getProperty("oracle.security.crypto.jce.mode"));
        if (b != null) {
            if (b.equalsIgnoreCase("fips140")) {
                FIPSConfig.a(FIPSVersion.a);
            } else if (b.equalsIgnoreCase("fips140_3")) {
                FIPSConfig.a(FIPSVersion.b);
            }
        }
        a = new HashMap<String, FIPSVersion>();
        a.put("FIPS_140_2", FIPSVersion.a);
        a.put("FIPS_140_3", FIPSVersion.b);
        a.put("TRUE", FIPSVersion.a);
    }
}

