/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import oracle.security.pki.fips.FIPSConfig;
import oracle.security.pki.fips.FIPSProviderLoader;

public final class JCEUtil {
    public static final String JSAFEJCE_CLASS_NAME = "com.rsa.jsafe.provider.JsafeJCE";
    public static final String JSAFEJCE_NAME = "JsafeJCE";
    public static final String SECURE_RANDOM_ALG = "CTRDRBG";
    public static final String JSAFEJCE_SECURE_RANDOM_ALG = "DefaultRandom";
    public static final String JCE_FIPS140_PROVIDER_CLASS_SECURITY_PROPERTY = "oracle.security.crypto.jce.fips140_provider_class";
    private static final String a;
    private static final boolean b;
    private static boolean c;
    private static boolean d;
    private static Provider e;
    private static SecureRandom f;

    public static synchronized boolean isJsafeJCERegistered() {
        if (b && FIPSConfig.c()) {
            return true;
        }
        if (!d) {
            c = JCEUtil.a();
            d = true;
        }
        return c;
    }

    private static boolean a() {
        if (Security.getProvider(JSAFEJCE_NAME) != null) {
            return true;
        }
        for (Provider provider : Security.getProviders()) {
            if (!provider.getName().startsWith("JsafeJCE/")) continue;
            return true;
        }
        return false;
    }

    private static Provider b() throws NoSuchAlgorithmException {
        try {
            return JCEUtil.getJCEProvider();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    public static synchronized Provider getJCEProvider() throws NoSuchProviderException {
        if (e == null) {
            e = JCEUtil.a(a, FIPSConfig.c() && b);
            if (FIPSConfig.c()) {
                JCEUtil.a(e);
            }
        }
        return e;
    }

    private static Provider a(String string, boolean bl) throws NoSuchProviderException {
        try {
            if (bl) {
                return FIPSProviderLoader.a(string);
            }
            return (Provider)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new NoSuchProviderException("Failed to instantiate provider: " + string + ", Error: " + exception.getMessage());
        }
    }

    public static synchronized void clearCachedObjects() {
        e = null;
        f = null;
    }

    private static void a(Provider provider) {
        Security.removeProvider(provider.getName());
        Security.insertProviderAt(provider, 1);
    }

    public static synchronized void registerJsafeJCE() throws NoSuchProviderException {
        if (b) {
            Provider provider = JCEUtil.getJCEProvider();
            JCEUtil.a(provider);
        } else if (!JCEUtil.isJsafeJCERegistered()) {
            Provider provider = JCEUtil.a(JSAFEJCE_CLASS_NAME, false);
            JCEUtil.a(provider);
        }
    }

    public static synchronized SecureRandom getSecureRandom() {
        if (f == null) {
            if (FIPSConfig.c()) {
                String string = b ? JSAFEJCE_SECURE_RANDOM_ALG : SECURE_RANDOM_ALG;
                try {
                    f = SecureRandom.getInstance(string, JCEUtil.getJCEProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    InternalError internalError = new InternalError("SecureRandom algorithm " + string + " not available");
                    internalError.initCause(generalSecurityException);
                    throw internalError;
                }
            } else {
                f = new SecureRandom();
            }
        }
        return f;
    }

    public static Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return Signature.getInstance(string, JCEUtil.b());
        }
        return Signature.getInstance(string);
    }

    public static Mac getMacInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return Mac.getInstance(string, JCEUtil.b());
        }
        return Mac.getInstance(string);
    }

    public static MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return MessageDigest.getInstance(string, JCEUtil.b());
        }
        return MessageDigest.getInstance(string);
    }

    public static SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return SecretKeyFactory.getInstance(string, JCEUtil.b());
        }
        return SecretKeyFactory.getInstance(string);
    }

    public static Cipher getCipherInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (FIPSConfig.c()) {
            return Cipher.getInstance(string, JCEUtil.b());
        }
        return Cipher.getInstance(string);
    }

    public static KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return KeyPairGenerator.getInstance(string, JCEUtil.b());
        }
        return KeyPairGenerator.getInstance(string);
    }

    public static KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return KeyFactory.getInstance(string, JCEUtil.b());
        }
        return KeyFactory.getInstance(string);
    }

    public static KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        if (FIPSConfig.c()) {
            return KeyAgreement.getInstance(string, JCEUtil.b());
        }
        return KeyAgreement.getInstance(string);
    }

    public static CertificateFactory getCertificateFactoryInstance(String string) throws CertificateException {
        if (FIPSConfig.c()) {
            try {
                return CertificateFactory.getInstance(string, JCEUtil.b());
            }
            catch (Exception exception) {
                throw new CertificateException(exception.getMessage());
            }
        }
        return CertificateFactory.getInstance(string);
    }

    static {
        d = false;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            public String a() {
                return Security.getProperty(JCEUtil.JCE_FIPS140_PROVIDER_CLASS_SECURITY_PROPERTY);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
        if (string == null) {
            string = JSAFEJCE_CLASS_NAME;
            b = true;
        } else {
            b = string.equalsIgnoreCase(JSAFEJCE_CLASS_NAME);
        }
        a = string;
    }
}

