/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.IntStream;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.internal.core.CBCAlgorithmIdentifier;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.internal.pqc.keys.OraclePKIMLDSAPublicKey;
import oracle.security.pki.internal.pqc.keys.OraclePKISLHDSAPublicKey;
import oracle.security.pki.internal.pqc.util.PQCObjectIdentifiers;
import oracle.security.pki.internal.pqc.util.PQCUtils;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.KeyWrapper;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class CryptoUtils {
    private static final ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static volatile Set<String> b;

    public static PublicKey inputSPKI(InputStream inputStream) throws IOException {
        PublicKey publicKey;
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.a(0));
        KeyWrapper keyWrapper = new KeyWrapper();
        ASN1Object aSN1Object = null;
        if (algorithmIdentifier.a().equals(AlgID.w.a())) {
            aSN1Object = aSN1Sequence.a(1);
        } else {
            if (PQCObjectIdentifiers.a(algorithmIdentifier.a())) {
                return CryptoUtils.generatePublicKeyFromBytes(Utils.toBytes(aSN1Sequence), "ML-DSA");
            }
            aSN1Object = ASN1Utils.a(new ByteArrayInputStream(((ASN1BitString)aSN1Sequence.a(1)).b()));
        }
        if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("RSA")) {
            keyWrapper.initializeRSAPublicKeyFromContents(algorithmIdentifier, aSN1Object);
            publicKey = (RSAPublicKey)keyWrapper.getKey();
        } else if (OIDManager.getKeyAlgoFromOIDMap(algorithmIdentifier.a()).equals("EC")) {
            keyWrapper.initializeECPublicKeyFromContents(algorithmIdentifier, aSN1Object);
            publicKey = (ECPublicKey)keyWrapper.getKey();
        } else if (PQCObjectIdentifiers.a(algorithmIdentifier.a())) {
            publicKey = CryptoUtils.generatePublicKeyFromBytes(Utils.toBytes(aSN1Sequence), "ML-DSA");
        } else if (PQCObjectIdentifiers.b(algorithmIdentifier.a())) {
            publicKey = CryptoUtils.generatePublicKeyFromBytes(Utils.toBytes(aSN1Sequence), "ML-KEM");
        } else {
            OraclePKIDebug.debug("Exit - returning null");
            return null;
        }
        OraclePKIDebug.debug("Exit");
        return publicKey;
    }

    public static byte[] convertStreamToBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static PrivateKey inputPrivateKey(InputStream var0) throws IOException {
        block62: {
            block61: {
                block65: {
                    block64: {
                        block63: {
                            OraclePKIDebug.debug("Enter");
                            var1_1 = CryptoUtils.convertStreamToBytes(var0);
                            var2_2 = new ByteArrayInputStream(var1_1);
                            var3_3 = new ASN1Sequence(var2_2);
                            var4_4 = null;
                            var5_5 /* !! */  = null;
                            var6_6 = (ASN1Integer)var3_3.a(0);
                            if (!var6_6.a(0)) {
                                throw new IOException("Error in inputPrivateKey. FIPSVersion should be 0");
                            }
                            var7_8 = null;
                            if (var3_3.c() != 9) break block63;
                            var7_8 = AlgID.e;
                            var4_4 = var3_3;
                            ** GOTO lbl69
                        }
                        if (var3_3.c() != 5) break block64;
                        var7_8 = AlgID.E;
                        var4_4 = var3_3;
                        ** GOTO lbl69
                    }
                    var7_8 = new AlgorithmIdentifier((ASN1Sequence)var3_3.a(1));
                    var8_9 = var3_3.a(2);
                    if (!var7_8.a().equals(AlgID.w.a())) break block65;
                    var4_4 = var8_9;
                    ** GOTO lbl69
                }
                if (!PQCObjectIdentifiers.a(var7_8.a())) break block61;
                var9_10 = CryptoUtils.generatePrivateKeyFromBytes(Utils.toBytes(var3_3), "ML-DSA");
                if (var3_3.c() == 9) {
                    ((ASN1Integer)var3_3.a(3)).b();
                    ((ASN1Integer)var3_3.a(4)).b();
                    ((ASN1Integer)var3_3.a(5)).b();
                    ((ASN1Integer)var3_3.a(6)).b();
                    ((ASN1Integer)var3_3.a(7)).b();
                    ((ASN1Integer)var3_3.a(8)).b();
                } else if (var3_3.c() == 5) {
                    ((ASN1Integer)var3_3.a(3)).b();
                } else {
                    if (var3_3.a(2) instanceof ASN1OctetString) {
                        Utils.setArray(((ASN1OctetString)var3_3.a(2)).b(), (byte)0);
                    }
                    if (var4_4 != null) {
                        if (var4_4 instanceof ASN1Sequence) {
                            var10_13 = (ASN1Sequence)var4_4;
                            if (var10_13.c() == 9) {
                                ((ASN1Integer)var10_13.a(3)).b();
                                ((ASN1Integer)var10_13.a(4)).b();
                                ((ASN1Integer)var10_13.a(5)).b();
                                ((ASN1Integer)var10_13.a(6)).b();
                                ((ASN1Integer)var10_13.a(7)).b();
                                ((ASN1Integer)var10_13.a(8)).b();
                            } else if (var10_13.c() == 5) {
                                ((ASN1Integer)var10_13.a(3)).b();
                            }
                        } else if (var4_4 instanceof ASN1Integer) {
                            ((ASN1Integer)var4_4).b();
                        }
                    }
                }
                return var9_10;
            }
            if (var8_9 instanceof ASN1OctetString) {
                var4_4 = ASN1Utils.a(new ByteArrayInputStream(((ASN1OctetString)var8_9).b()));
            } else if (var8_9 instanceof ASN1Sequence) {
                var4_4 = var8_9;
            } else {
                throw new IOException("Invalid private key contents");
            }
lbl69:
            // 5 sources

            var8_9 = new KeyWrapper();
            if (OIDManager.getKeyAlgoFromOIDMap(var7_8.a()).equals("RSA")) {
                var8_9.initializeRSAPrivateKeyFromContents(var7_8, (ASN1Object)var4_4);
                var5_5 /* !! */  = (RSAPrivateKey)var8_9.getKey();
                break block62;
            }
            if (OIDManager.getKeyAlgoFromOIDMap(var7_8.a()).equals("EC")) {
                var8_9.initializeECPrivateKeyFromContents(var7_8, (ASN1Object)var4_4);
                var5_5 /* !! */  = (ECPrivateKey)var8_9.getKey();
                break block62;
            }
            OraclePKIDebug.debug("Exit - returning null");
            var9_11 = null;
            if (var3_3.c() == 9) {
                ((ASN1Integer)var3_3.a(3)).b();
                ((ASN1Integer)var3_3.a(4)).b();
                ((ASN1Integer)var3_3.a(5)).b();
                ((ASN1Integer)var3_3.a(6)).b();
                ((ASN1Integer)var3_3.a(7)).b();
                ((ASN1Integer)var3_3.a(8)).b();
            } else if (var3_3.c() == 5) {
                ((ASN1Integer)var3_3.a(3)).b();
            } else {
                if (var3_3.a(2) instanceof ASN1OctetString) {
                    Utils.setArray(((ASN1OctetString)var3_3.a(2)).b(), (byte)0);
                }
                if (var4_4 != null) {
                    if (var4_4 instanceof ASN1Sequence) {
                        var10_14 = (ASN1Sequence)var4_4;
                        if (var10_14.c() == 9) {
                            ((ASN1Integer)var10_14.a(3)).b();
                            ((ASN1Integer)var10_14.a(4)).b();
                            ((ASN1Integer)var10_14.a(5)).b();
                            ((ASN1Integer)var10_14.a(6)).b();
                            ((ASN1Integer)var10_14.a(7)).b();
                            ((ASN1Integer)var10_14.a(8)).b();
                        } else if (var10_14.c() == 5) {
                            ((ASN1Integer)var10_14.a(3)).b();
                        }
                    } else if (var4_4 instanceof ASN1Integer) {
                        ((ASN1Integer)var4_4).b();
                    }
                }
            }
            return var9_11;
        }
        try {
            OraclePKIDebug.debug("Exit");
            var9_12 = var5_5 /* !! */ ;
        }
        catch (ClassCastException var6_7) {
            try {
                throw new IOException("Class does not implement PrivateKey");
            }
            catch (Throwable var11_16) {
                if (var3_3.c() == 9) {
                    ((ASN1Integer)var3_3.a(3)).b();
                    ((ASN1Integer)var3_3.a(4)).b();
                    ((ASN1Integer)var3_3.a(5)).b();
                    ((ASN1Integer)var3_3.a(6)).b();
                    ((ASN1Integer)var3_3.a(7)).b();
                    ((ASN1Integer)var3_3.a(8)).b();
                } else if (var3_3.c() == 5) {
                    ((ASN1Integer)var3_3.a(3)).b();
                } else {
                    if (var3_3.a(2) instanceof ASN1OctetString) {
                        Utils.setArray(((ASN1OctetString)var3_3.a(2)).b(), (byte)0);
                    }
                    if (var4_4 != null) {
                        if (var4_4 instanceof ASN1Sequence) {
                            var12_17 = var4_4;
                            if (var12_17.c() == 9) {
                                ((ASN1Integer)var12_17.a(3)).b();
                                ((ASN1Integer)var12_17.a(4)).b();
                                ((ASN1Integer)var12_17.a(5)).b();
                                ((ASN1Integer)var12_17.a(6)).b();
                                ((ASN1Integer)var12_17.a(7)).b();
                                ((ASN1Integer)var12_17.a(8)).b();
                            } else if (var12_17.c() == 5) {
                                ((ASN1Integer)var12_17.a(3)).b();
                            }
                        } else if (var4_4 instanceof ASN1Integer) {
                            ((ASN1Integer)var4_4).b();
                        }
                    }
                }
                throw var11_16;
            }
        }
        if (var3_3.c() == 9) {
            ((ASN1Integer)var3_3.a(3)).b();
            ((ASN1Integer)var3_3.a(4)).b();
            ((ASN1Integer)var3_3.a(5)).b();
            ((ASN1Integer)var3_3.a(6)).b();
            ((ASN1Integer)var3_3.a(7)).b();
            ((ASN1Integer)var3_3.a(8)).b();
        } else if (var3_3.c() == 5) {
            ((ASN1Integer)var3_3.a(3)).b();
        } else {
            if (var3_3.a(2) instanceof ASN1OctetString) {
                Utils.setArray(((ASN1OctetString)var3_3.a(2)).b(), (byte)0);
            }
            if (var4_4 != null) {
                if (var4_4 instanceof ASN1Sequence) {
                    var10_15 = (ASN1Sequence)var4_4;
                    if (var10_15.c() == 9) {
                        ((ASN1Integer)var10_15.a(3)).b();
                        ((ASN1Integer)var10_15.a(4)).b();
                        ((ASN1Integer)var10_15.a(5)).b();
                        ((ASN1Integer)var10_15.a(6)).b();
                        ((ASN1Integer)var10_15.a(7)).b();
                        ((ASN1Integer)var10_15.a(8)).b();
                    } else if (var10_15.c() == 5) {
                        ((ASN1Integer)var10_15.a(3)).b();
                    }
                } else if (var4_4 instanceof ASN1Integer) {
                    ((ASN1Integer)var4_4).b();
                }
            }
        }
        return var9_12;
    }

    public static byte[] generateKeyID(PublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(publicKey.getEncoded());
        return messageDigest.digest();
    }

    public static ASN1Sequence subjectPublicKeyInfo(KeyWrapper keyWrapper) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(keyWrapper.getAlgID());
        if (keyWrapper.getAlgID().a().equals(AlgID.w.a())) {
            aSN1Sequence.a(keyWrapper.getContents());
        } else {
            aSN1Sequence.a(new ASN1BitString(Utils.toBytes(keyWrapper.getContents())));
        }
        return aSN1Sequence;
    }

    public static byte[] getIV(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier instanceof CBCAlgorithmIdentifier) {
            return ((CBCAlgorithmIdentifier)algorithmIdentifier).c();
        }
        CBCAlgorithmIdentifier cBCAlgorithmIdentifier = new CBCAlgorithmIdentifier(algorithmIdentifier.a(), algorithmIdentifier.b());
        return cBCAlgorithmIdentifier.c();
    }

    public static Signature getSignatureInstance(String string, Key key) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Signature.getInstance(string, "LunaJCAProvider");
        }
        return Signature.getInstance(string);
    }

    public static Cipher getCipherInstance(Key key, String string) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (key.getClass().getName().contains("Luna")) {
            return Cipher.getInstance(string, "LunaJCEProvider");
        }
        return Cipher.getInstance(string);
    }

    public static AlgorithmParameterSpec getOEPAlgoSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, PSource pSource, Key key) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InstantiationException, InvocationTargetException {
        if (key.getClass().getName().contains("Luna")) {
            Class<?> clazz = Class.forName("com.chrysalisits.crypto.LunaParameterSpecOAEP");
            Class[] classArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE, byte[].class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            byte[] byArray = ((PSource.PSpecified)pSource).getValue() != null ? ((PSource.PSpecified)pSource).getValue() : new byte[]{};
            Object[] objectArray = new Object[]{"SHA1", clazz.getDeclaredField("mgfType_MGF1").get(null), clazz.getDeclaredField("sourceType_DATA_SPECIFIED").get(null), byArray};
            return (AlgorithmParameterSpec)constructor.newInstance(objectArray);
        }
        return new OAEPParameterSpec(string, string2, algorithmParameterSpec, pSource);
    }

    public static String searchServiceProvider(String string, String string2) {
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (service.getType() != string || service.getAlgorithm() != string2) continue;
                return String.valueOf(provider.getName());
            }
        }
        return null;
    }

    public static String getCipherTransformation(AlgorithmIdentifier algorithmIdentifier, boolean bl) {
        if (algorithmIdentifier != null) {
            ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
            if (aSN1ObjectID.equals(AlgID.b.a())) {
                if (bl) {
                    return "DES/CBC/PKCS5Padding";
                }
                return "DES/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.a.a())) {
                if (bl) {
                    return "DES/ECB/PKCS5Padding";
                }
                return "DES/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.d.a())) {
                if (bl) {
                    return "DESede/CBC/PKCS5Padding";
                }
                return "DESede/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.c.a())) {
                if (bl) {
                    return "DESede/ECB/PKCS5Padding";
                }
                return "DESede/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.n.a()) || aSN1ObjectID.equals(AlgID.p.a()) || aSN1ObjectID.equals(AlgID.r.a())) {
                if (bl) {
                    return "AES/CBC/PKCS5Padding";
                }
                return "AES/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.m.a()) || aSN1ObjectID.equals(AlgID.o.a()) || aSN1ObjectID.equals(AlgID.q.a())) {
                if (bl) {
                    return "AES/ECB/PKCS5Padding";
                }
                return "AES/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.h.a())) {
                if (bl) {
                    return "RC2/CBC/PKCS5Padding";
                }
                return "RC2/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.i.a())) {
                if (bl) {
                    return "RC4/CBC/PKCS5Padding";
                }
                return "RC4/CBC/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.k.a())) {
                if (bl) {
                    return "Blowfish/ECB/PKCS5Padding";
                }
                return "Blowfish/ECB/NoPadding";
            }
            if (aSN1ObjectID.equals(AlgID.l.a())) {
                if (bl) {
                    return "Blowfish/CBC/PKCS5Padding";
                }
                return "Blowfish/CBC/NoPadding";
            }
            return null;
        }
        return null;
    }

    public static String getEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier != null) {
            ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
            if (aSN1ObjectID.equals(AlgID.b.a()) || aSN1ObjectID.equals(AlgID.a.a())) {
                return "DES";
            }
            if (aSN1ObjectID.equals(AlgID.d.a()) || aSN1ObjectID.equals(AlgID.c.a())) {
                return "DESede";
            }
            if (aSN1ObjectID.equals(AlgID.n.a()) || aSN1ObjectID.equals(AlgID.m.a())) {
                return "AES128";
            }
            if (aSN1ObjectID.equals(AlgID.p.a()) || aSN1ObjectID.equals(AlgID.o.a())) {
                return "AES192";
            }
            if (aSN1ObjectID.equals(AlgID.r.a()) || aSN1ObjectID.equals(AlgID.q.a())) {
                return "AES256";
            }
            if (aSN1ObjectID.equals(AlgID.i.a())) {
                return "RC4";
            }
            if (aSN1ObjectID.equals(AlgID.j.a()) || aSN1ObjectID.equals(AlgID.l.a()) || aSN1ObjectID.equals(AlgID.k.a())) {
                return "Blowfish";
            }
            if (aSN1ObjectID.equals(AlgID.h.a())) {
                return "RC2";
            }
            return algorithmIdentifier.toString();
        }
        return null;
    }

    public static String getPBEAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier != null) {
            ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.b)) {
                return "pbeWithMD2AndDES_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.c)) {
                return "pbeWithMD2AndRC2_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.d)) {
                return "pbeWithMD5AndDES_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.g)) {
                return "pbeWithSHA1AndRC2_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.k)) {
                return "pbeWithSHAAnd128BitRC4";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.l)) {
                return "pbeWithSHAAnd40BitRC4";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.o)) {
                return "pbeWithSHAAnd128BitRC2_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.p)) {
                return "pbeWithSHAAnd40BitRC2_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.e)) {
                return "pbeWithMD5AndRC2_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.f)) {
                return "pbeWithSHA1AndDES_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.m)) {
                return "pbeWithSHAAnd3_KeyTripleDES_CBC";
            }
            if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.n)) {
                return "pbeWithSHAAnd2_KeyTripleDES_CBC";
            }
            return algorithmIdentifier.toString();
        }
        return null;
    }

    public static String getHmacAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.Q) || algorithmIdentifier.equals(AlgID.O) || algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.ao) || algorithmIdentifier.equals(AlgID.ap)) {
            string = "HmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.L) || algorithmIdentifier.equals(AlgID.an)) {
            string = "HmacMD5";
        } else if (algorithmIdentifier.equals(AlgID.R) || algorithmIdentifier.equals(AlgID.aq)) {
            string = "HmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.S) || algorithmIdentifier.equals(AlgID.ar)) {
            string = "HmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.T) || algorithmIdentifier.equals(AlgID.as)) {
            string = "HmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.U) || algorithmIdentifier.equals(AlgID.at)) {
            string = "HmacSHA512";
        }
        return string;
    }

    public static String getDigestAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.Q) || algorithmIdentifier.equals(AlgID.O) || algorithmIdentifier.equals(AlgID.P) || algorithmIdentifier.equals(AlgID.ao) || algorithmIdentifier.equals(AlgID.ap)) {
            string = "SHA-1";
        } else if (algorithmIdentifier.equals(AlgID.L) || algorithmIdentifier.equals(AlgID.an)) {
            string = "MD5";
        } else if (algorithmIdentifier.equals(AlgID.N)) {
            string = "MD2";
        } else if (algorithmIdentifier.equals(AlgID.R) || algorithmIdentifier.equals(AlgID.aq)) {
            string = "SHA-224";
        } else if (algorithmIdentifier.equals(AlgID.S) || algorithmIdentifier.equals(AlgID.ar)) {
            string = "SHA-256";
        } else if (algorithmIdentifier.equals(AlgID.T) || algorithmIdentifier.equals(AlgID.as)) {
            string = "SHA-384";
        } else if (algorithmIdentifier.equals(AlgID.U) || algorithmIdentifier.equals(AlgID.at)) {
            string = "SHA-512";
        }
        return string;
    }

    public static int getHashAlgoBlockSize(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier == AlgID.O || algorithmIdentifier == AlgID.P || algorithmIdentifier == AlgID.Q || algorithmIdentifier == AlgID.S) {
            return 64;
        }
        if (algorithmIdentifier == AlgID.T || algorithmIdentifier == AlgID.U) {
            return 128;
        }
        if (algorithmIdentifier == AlgID.L || algorithmIdentifier == AlgID.M || algorithmIdentifier == AlgID.N) {
            return 64;
        }
        return 0;
    }

    public static String getSignatureAlg(AlgorithmIdentifier algorithmIdentifier) {
        String string = null;
        if (algorithmIdentifier.equals(AlgID.x)) {
            string = "MD2withRSA";
        } else if (algorithmIdentifier.equals(AlgID.y)) {
            string = "MD5withRSA";
        } else if (algorithmIdentifier.equals(AlgID.z)) {
            string = "SHA1withRSA";
        } else if (algorithmIdentifier.equals(AlgID.A)) {
            string = "SHA224withRSA";
        } else if (algorithmIdentifier.equals(AlgID.B)) {
            string = "SHA256withRSA";
        } else if (algorithmIdentifier.equals(AlgID.C)) {
            string = "SHA384withRSA";
        } else if (algorithmIdentifier.equals(AlgID.D)) {
            string = "SHA512withRSA";
        } else if (algorithmIdentifier.equals(AlgID.E)) {
            string = "SHA1withDSA";
        } else if (algorithmIdentifier.equals(AlgID.H)) {
            string = "SHA1withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.I)) {
            string = "SHA256withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.J)) {
            string = "SHA384withECDSA";
        } else if (algorithmIdentifier.equals(AlgID.K)) {
            string = "SHA512withECDSA";
        } else if (PQCObjectIdentifiers.a(algorithmIdentifier.a())) {
            string = "ML-DSA";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSupportedKeyTypes() {
        if (b != null) {
            return b;
        }
        Class<CryptoUtils> clazz = CryptoUtils.class;
        synchronized (CryptoUtils.class) {
            if (b == null) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Provider provider : Security.getProviders()) {
                    provider.getServices().stream().filter(service -> "KeyFactory".equals(service.getType())).map(Provider.Service::getAlgorithm).forEach(hashSet::add);
                }
                b = hashSet;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return b;
        }
    }

    public static PublicKey generatePublicKeyFromBytes(byte[] byArray, String string) throws IOException {
        OraclePKIDebug.debug("Enter");
        if (byArray == null || byArray.length == 0) {
            throw new IOException("Invalid encoded bytes: NULL or empty");
        }
        if (string == null || string.isEmpty()) {
            throw new IOException("Key algorithm cannot be null or empty");
        }
        if (!CryptoUtils.getSupportedKeyTypes().contains(string)) {
            throw new IOException("Unsupported key algorithm " + string);
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            OraclePKIDebug.debug("Exit");
            return publicKey;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Failed to generate public key from bytes");
        }
    }

    public static PrivateKey generatePrivateKeyFromBytes(byte[] byArray, String string) throws IOException {
        OraclePKIDebug.debug("Enter");
        if (byArray == null || byArray.length == 0) {
            throw new IOException("Invalid encoded bytes: NULL or empty");
        }
        if (string == null || string.isEmpty()) {
            throw new IOException("Key algorithm cannot be null or empty");
        }
        if (!CryptoUtils.getSupportedKeyTypes().contains(string)) {
            throw new IOException("Unsupported key algorithm " + string);
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            OraclePKIDebug.debug("Exit");
            return privateKey;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("Failed to generate private key from bytes");
        }
    }

    public static RSAPrivateKey generateRSAPrivateKeyFromBytes(byte[] byArray) {
        OraclePKIDebug.debug("Enter");
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            OraclePKIDebug.debug("Exit");
            return rSAPrivateKey;
        }
        catch (GeneralSecurityException generalSecurityException) {
            OraclePKIDebug.debug("Exit - Error: " + generalSecurityException.getMessage());
            return null;
        }
    }

    public static int getPublicKeyBitLength(PublicKey publicKey) {
        int n = 0;
        OraclePKIDebug.debug("Enter");
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof ECPublicKey) {
            n = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        } else {
            if (publicKey instanceof OraclePKIMLDSAPublicKey || publicKey instanceof OraclePKISLHDSAPublicKey) {
                return PQCUtils.b(publicKey);
            }
            OraclePKIDebug.debug("Unsupported key type");
        }
        OraclePKIDebug.debug("Exit");
        return n;
    }

    public static PublicKey generatePublicKey(byte[] byArray) throws Exception {
        OraclePKIDebug.debug("Enter");
        if (byArray == null || byArray.length == 0) {
            throw new IOException("Invalid encoded bytes: NULL or empty");
        }
        Set<String> set = CryptoUtils.getSupportedKeyTypes();
        if (set == null || set.isEmpty()) {
            throw new IOException("Error: No key type is supported");
        }
        for (String string : set) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                OraclePKIDebug.debug("Exit");
                return publicKey;
            }
            catch (Exception exception) {
                OraclePKIDebug.debug("Public key generation failed with: " + string + " - " + exception.getMessage());
            }
        }
        throw new IOException("No matching key type found.");
    }

    public static void validateCertificateKeyUsage(String string) throws GeneralSecurityException {
        OraclePKIDebug.debug("Enter");
        if (OraclePKIGenFunc.isNullOrEmpty(string)) {
            return;
        }
        OracleCertExtension oracleCertExtension = new OracleCertExtension();
        oracleCertExtension.setKeyUsage(string);
        int[] nArray = oracleCertExtension.getKeyUsage();
        boolean bl = IntStream.of(nArray).anyMatch(n -> n == 7);
        boolean bl2 = IntStream.of(nArray).anyMatch(n -> n == 8);
        if (bl && bl2) {
            String string2 = a.getString("PKI-04031");
            OraclePKIDebug.debug(string2);
            throw new GeneralSecurityException(string2);
        }
        OraclePKIDebug.debug("Exit");
    }

    public static void validateSignatureAndKeyAlgorithm(String string, String string2) throws SignatureException {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid signature algorithm as input");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Invalid private key algorithm as input");
        }
        if (string2.equals("RSA")) {
            if (string.contains("ECDSA")) {
                throw new SignatureException("Cannot create ECDSA signature using RSA key");
            }
            if (string.contains("ML-DSA")) {
                throw new SignatureException("Cannot create ML-DSA signature using RSA key");
            }
            if (string.contains("SLH-DSA")) {
                throw new SignatureException("Cannot create SLH-DSA signature using RSA key");
            }
        }
        if (string2.equals("EC")) {
            if (string.contains("RSA")) {
                throw new SignatureException("Cannot create RSA signature using EC keys");
            }
            if (string.contains("ML-DSA")) {
                throw new SignatureException("Cannot create ML-DSA signature using EC key");
            }
            if (string.contains("SLH-DSA")) {
                throw new SignatureException("Cannot create SLH-DSA signature using EC key");
            }
        }
        if (string2.contains("ML-DSA")) {
            if (string.contains("RSA")) {
                throw new SignatureException("Cannot create RSA signature using ML-DSA key");
            }
            if (string.contains("ECDSA")) {
                throw new SignatureException("Cannot create EC signature using ML-DSA key");
            }
            if (string.contains("SLH-DSA")) {
                throw new SignatureException("Cannot create SLH-DSA signature using ML-DSA key");
            }
        }
        if (string2.contains("SLH-DSA")) {
            if (string.contains("RSA")) {
                throw new SignatureException("Cannot create RSA signature using SLH-DSA key");
            }
            if (string.contains("ECDSA")) {
                throw new SignatureException("Cannot create EC signature using SLH-DSA key");
            }
            if (string.contains("ML-DSA")) {
                throw new SignatureException("Cannot create SLH-DSA signature using SLH-DSA key");
            }
        }
    }

    public static int getAESKeyLength(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier == null || algorithmIdentifier.a() == null) {
            return 0;
        }
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.a();
        if (aSN1ObjectID.equals(AlgID.n.a())) {
            return 16;
        }
        if (aSN1ObjectID.equals(AlgID.p.a())) {
            return 24;
        }
        if (aSN1ObjectID.equals(AlgID.r.a())) {
            return 32;
        }
        return 0;
    }
}

