/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import com.rsa.jsafe.crypto.CryptoJVersion;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.fips.FIPSConfig;
import oracle.security.pki.fips.FIPSVersion;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.textui.OracleCRLTextUI;
import oracle.security.pki.textui.OracleCertTextUI;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.textui.OracleSecretStoreTextUI;
import oracle.security.pki.textui.OracleWalletTextUI;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class OraclePKITextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "Syntax : \n[-option [value]]     : mandatory, for example [-wallet [wallet]] \n[-option <value>]     : optional, but when option is used its value is mandatory. \n<option>              : optional, for example <-summary>, <-complete> \n[option1] | [option2] : option1 'or' option2\n";

    public static void main(String[] stringArray) {
        String[] stringArray2;
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(new int[]{2, 5, 4, 9});
        ASN1ObjectID aSN1ObjectID2 = new ASN1ObjectID(new int[]{2, 5, 4, 12});
        ASN1ObjectID aSN1ObjectID3 = new ASN1ObjectID(new int[]{2, 5, 4, 5});
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        block23: for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = stringArray[i];
            if (stringArray2 == null) continue;
            switch (stringArray2) {
                case "-nologo": {
                    bl = true;
                    stringArray[i] = null;
                    continue block23;
                }
                case "-print_lib_info": {
                    bl2 = true;
                    stringArray[i] = null;
                    continue block23;
                }
                case "-jsafe": {
                    try {
                        JCEUtil.registerJsafeJCE();
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        System.err.println("Unable to register Crypto-J JsafeJCE provider");
                        System.exit(1);
                    }
                    stringArray[i] = null;
                    continue block23;
                }
                case "-fips140_mode": {
                    String string2 = string = i + 1 < stringArray.length ? stringArray[i + 1] : null;
                    if (string != null && FIPSConfig.a.containsKey(string.toUpperCase())) {
                        FIPSConfig.a(FIPSConfig.a.get(string));
                        stringArray[i + 1] = null;
                    } else {
                        FIPSConfig.a(FIPSVersion.a);
                    }
                    stringArray[i] = null;
                    continue block23;
                }
                case "-use_jce": 
                case "-use_jce_only": {
                    stringArray[i] = null;
                    continue block23;
                }
            }
        }
        stringArray = (String[])Arrays.stream(stringArray).filter(Objects::nonNull).toArray(String[]::new);
        if (!FIPSConfig.c()) {
            try {
                FIPSVersion fIPSVersion = FIPSConfig.d();
                if (fIPSVersion != null) {
                    FIPSConfig.a(fIPSVersion);
                }
            }
            catch (IOException iOException) {
                OraclePKIDebug.debug("Unable to read FIPS version from fips.ora: " + iOException.getMessage());
            }
        }
        if (!bl) {
            System.out.println(OraclePKIGenFunc.copyrightVersionBanner("Oracle PKI Tool"));
            System.out.println();
        }
        if (FIPSConfig.c()) {
            try {
                Provider provider = JCEUtil.getJCEProvider();
                if (bl2) {
                    System.out.println(FIPSConfig.b() + " compliant module is enabled.");
                    System.out.println("FIPS provider details: " + provider);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("Unable to get FIPS 140 cryptographic module: " + generalSecurityException.getMessage());
                n = 1;
                System.exit(n);
            }
        } else if (bl2) {
            System.out.println("FIPS module is not enabled.");
            System.out.println("Crypto services provider: " + Security.getProviders()[0]);
        }
        if (stringArray.length == 0) {
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode [FIPS_140_2|FIPS_140_3]>");
            n = 1;
            System.exit(n);
        }
        try {
            OIDManager.getOIDManager().setAttributeTypeName("STREET_ADDR", new ASN1ObjectID(Utils.toStream(aSN1ObjectID)));
            OIDManager.getOIDManager().setAttributeTypeName("TITLE", new ASN1ObjectID(Utils.toStream(aSN1ObjectID2)));
            OIDManager.getOIDManager().setAttributeTypeName("SERIAL_NUM", new ASN1ObjectID(Utils.toStream(aSN1ObjectID3)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("Failed to initialize");
            n = 1;
            System.exit(n);
        }
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        if (stringArray[0].equals("help")) {
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode [FIPS_140_2|FIPS_140_3]>");
            System.out.println(b);
        } else if (stringArray[0].equals("crl")) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleCRLTextUI.command(stringArray2);
        } else if (stringArray[0].equals("wallet")) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleWalletTextUI.command(stringArray2);
        } else if (stringArray[0].equals("cert")) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleCertTextUI.command(stringArray2);
        } else if (stringArray[0].equals("secretstore")) {
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            OracleSecretStoreTextUI.command(stringArray2);
        } else if (stringArray[0].equals("cryptoj_version")) {
            System.out.println("Crypto-J version is " + CryptoJVersion.getProductID());
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println("orapki [crl|wallet|cert|secretstore|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode [FIPS_140_2|FIPS_140_3]>");
            n = -1;
        }
        TimeZone.setDefault(timeZone);
        System.exit(n);
    }
}

