/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.EnumSet;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.internal.pqc.util.PQCKeyUtil;
import oracle.security.pki.internal.pqc.util.PQCUtils;
import oracle.security.pki.util.CryptoUtils;

abstract class OraclePKIPQCPrivateKey
extends OraclePKIPQCKey
implements PrivateKey {
    protected final PrivateKey g;
    private CertificateRequest a;

    public OraclePKIPQCPrivateKey(PrivateKey privateKey, CertificateRequest certificateRequest) {
        super(PQCUtils.a(privateKey, "Private"), PQCKeyUtil.a(privateKey, "Private"), null, null);
        this.g = privateKey;
        this.a = certificateRequest;
    }

    protected OraclePKIPQCPrivateKey(String string, int n, String string2, EnumSet<KeyUsage> enumSet, byte[] byArray) {
        super(string, n, enumSet, string2);
        try {
            this.g = CryptoUtils.generatePrivateKeyFromBytes(byArray, string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public boolean c() {
        return this.g != null;
    }

    @Override
    public byte[] getEncoded() {
        return this.g.getEncoded();
    }

    public CertificateRequest b() {
        return this.a;
    }

    @Override
    public String getAlgorithm() {
        return this.g.getAlgorithm();
    }

    public PrivateKey a() {
        return this.g;
    }

    public byte[] a(String string, byte[] byArray) throws Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Algorithm cannot be null or empty");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Data cannot be null or empty");
        }
        if (this.g == null) {
            throw new IOException("Private key is not initialized");
        }
        try {
            Signature signature = JCEUtil.getSignatureInstance(string);
            if (signature == null) {
                throw new NoSuchAlgorithmException("Unsupported signature algorithm: " + string);
            }
            signature.initSign(this.g);
            signature.update(byArray);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Error initializing signature instance: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new Exception("Error during signing", exception);
        }
    }
}

