/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pqc.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.EnumSet;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.pqc.keys.OraclePKIPQCPrivateKey;
import oracle.security.pki.internal.pqc.util.KeyUsage;
import oracle.security.pki.util.Utils;

public class OraclePKIMLKEMPrivateKey
extends OraclePKIPQCPrivateKey {
    private final byte[] a = new byte[32];
    private final byte[] b = new byte[32];

    public OraclePKIMLKEMPrivateKey(String string, int n, String string2, EnumSet<KeyUsage> enumSet, byte[] byArray) throws IOException {
        super(string, n, string2, enumSet, byArray);
        this.a(byArray);
    }

    public OraclePKIMLKEMPrivateKey(PrivateKey privateKey, CertificateRequest certificateRequest, byte[] byArray, byte[] byArray2) {
        super(privateKey, certificateRequest);
    }

    private void a(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 64) {
            throw new IOException("Invalid ML-KEM private key length. Expected 64 bytes, but got: " + (byArray == null ? "null" : Integer.valueOf(byArray.length)));
        }
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            if (byteArrayInputStream.read(this.a) != 32) {
                throw new IOException("Failed to read rho (expected 32 bytes).");
            }
            if (byteArrayInputStream.read(this.b) != 32) {
                throw new IOException("Failed to read H(pk) (expected 32 bytes).");
            }
        }
    }

    public byte[] d() {
        return (byte[])this.a.clone();
    }

    public byte[] e() {
        return (byte[])this.b.clone();
    }

    public String toString() {
        return "ML-KEM Private Key:\n\tAlias = " + this.e + "\n\trho = " + Utils.toHexString(this.a) + "\n\thPk = " + Utils.toHexString(this.b);
    }
}

