/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.C041;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.NZNative;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OracleFileSSOWalletImpl;
import oracle.security.pki.OracleFileWalletImpl;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OracleNewWalletImpl;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletImpl;
import oracle.security.pki.OracleWalletJks;
import oracle.security.pki.OracleWalletPersona;
import oracle.security.pki.PKIConstants;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.fips.FIPSConfig;
import oracle.security.pki.internal.OraclePKIRSAKeyHelper;
import oracle.security.pki.internal.PBEEncPKCS8;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKCS7;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.RevokedCertificate;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.internal.cert.ext.AuthorityKeyIDExtension;
import oracle.security.pki.internal.cert.ext.BasicConstraintsExtension;
import oracle.security.pki.internal.cert.ext.KeyUsageExtension;
import oracle.security.pki.internal.cert.ext.SubjectAltNameExtension;
import oracle.security.pki.internal.cert.ext.SubjectKeyIDExtension;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.PBEAlgorithmIdentifier;
import oracle.security.pki.internal.pkcs12.PKCS12;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.internal.pqc.keys.OraclePKIMLDSAPrivateKey;
import oracle.security.pki.internal.pqc.keys.OraclePKISLHDSAPrivateKey;
import oracle.security.pki.internal.pqc.util.OraclePKIPQCKeyPair;
import oracle.security.pki.internal.pqc.util.PQCKeyUtil;
import oracle.security.pki.internal.pqc.util.PQCUtils;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.CertificateAttributes;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.EccCurveParameters;
import oracle.security.pki.util.OraclePKIKeyPair;
import oracle.security.pki.util.SignatureAlgorithms;
import oracle.security.pki.util.Utils;

public class OracleWallet {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static final String v = "file:";
    private static final char w = ':';
    protected static final String b = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    protected static final String c = "-----END NEW CERTIFICATE REQUEST-----";
    protected static final String d = "-----BEGIN CERTIFICATE-----";
    protected static final String e = "-----END CERTIFICATE-----";
    protected static final String f = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    protected static final String g = "-----END ENCRYPTED PRIVATE KEY-----";
    protected static final String h = "-----BEGIN PRIVATE KEY-----";
    protected static final String i = "-----END PRIVATE KEY-----";
    private String x = null;
    private byte[] y = null;
    private char[] z = null;
    private char[] A = null;
    private boolean B = false;
    private HashMap C;
    private OracleWalletImpl D = null;
    private int E = 0;
    private OracleSecretStore F = null;
    private AlgorithmIdentifier G = null;
    private AlgorithmIdentifier H = null;
    public static final byte WLTCONF_NONE = 0;
    public static final byte WLTCONF_V12Compat = 1;
    public static final byte WLTCONF_TFCompat = 2;
    public static final int MIGRATE_ALL = 0;
    public static final int MIGRATE_KEY_ENTIRES_ONLY = 1;
    public static final int MIGRATE_TRUSTED_ENTRIES_ONLY = 2;
    public static final boolean SUPPORTS_MULTIPLE_CERTS_FOR_A_PRIVATE_KEY = false;
    public static final String DEFAULT_SSVS = "SSV_ENV_HOSTNAME,SSV_ENV_USERNAME,SSV_MACHINE_ID";
    protected static final String j = "SSV_ENV_HOSTNAME";
    protected static final String k = "SSV_ENV_USERNAME";
    protected static final String l = "SSV_BIOS_SERIAL_NUMBER";
    protected static final String m = "SSV_BIOS_UUID";
    protected static final String n = "SSV_MACHINE_ID";
    protected static final String o = "SSV_GENERIC_0";
    protected static final String p = "SSV_GENERIC_1";
    protected static final String q = "SSV_MACNAME_0";
    protected static final String r = "SSV_MACNAME_1";
    int s = 0;
    String t = null;
    String u = null;
    private boolean I = false;
    public static final String ENTRUST_PREMIUM_CERT = "MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==";
    public static final String ENTRUST_GLOBAL_CERT = "MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==";
    public static final String ENTRUST_MAIN_CERT = "MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=";

    public OracleWallet() {
        this.c();
    }

    public static OracleWallet getInstance(String string) {
        OracleWallet oracleWallet = null;
        oracleWallet = string != null && string.equals("jks") ? new OracleWalletJks() : new OracleWallet();
        return oracleWallet;
    }

    public String getLocation() {
        return this.x;
    }

    public HashMap getMapTrustFlagsValue() {
        if (this.B && this.C != null && this.C.size() > 0) {
            return new HashMap(this.C);
        }
        return null;
    }

    public void setLocation(String string) {
        this.x = string;
    }

    public void setWalletRioType(int n) {
        this.E = n;
    }

    public void setCertSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        try {
            this.G = new AlgorithmIdentifier(Utils.toStream(SignatureAlgorithms.getSignatureAlgorithm(string)));
        }
        catch (IOException iOException) {
            this.G = null;
        }
        if (this.G == null) {
            System.out.println(a.getString("INVALID_SIGNATURE_ALGORITHM") + string);
        }
    }

    public String getCertSignAlgorithm() {
        if (this.G != null) {
            return this.G.toString();
        }
        return "(default)";
    }

    public AlgorithmIdentifier getCertSignAlgorithmId() {
        if (this.G != null) {
            return this.G;
        }
        return null;
    }

    public void setCRLSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        this.H = SignatureAlgorithms.getSignatureAlgorithm(string);
        if (this.H == null) {
            System.out.println(a.getString("INVALID_SIGNATURE_ALGORITHM") + string);
        }
    }

    public String getCRLSignAlgorithm() {
        if (this.H != null) {
            return this.H.toString();
        }
        return "(default)";
    }

    public static String getDefaultLocation() {
        return null;
    }

    public static boolean isValidPassword(char[] cArray) {
        int n = 8;
        boolean bl = false;
        boolean bl2 = false;
        if (cArray == null) {
            return false;
        }
        if (cArray.length < 8) {
            return false;
        }
        for (char c : cArray) {
            if (Character.isLetter(c)) {
                bl = true;
            } else {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return bl && bl2;
    }

    public static int[] getKeysizes() {
        int[] nArray = new int[OraclePKIRSAKeyHelper.getKeySizes().size()];
        int n = 0;
        for (Integer n2 : OraclePKIRSAKeyHelper.getKeySizes()) {
            nArray[n++] = n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2) throws IOException {
        BigInteger bigInteger = new BigInteger(128, JCEUtil.getSecureRandom());
        this.a(x500Principal, n, n2, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n) throws IOException {
        BigInteger bigInteger = new BigInteger(128, JCEUtil.getSecureRandom());
        this.a(x500Principal, string, n, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, String string2) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, null, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, int n, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        this.a(x500Principal, string, n, null, null, bigInteger, oracleCertExtension, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2) throws IOException {
        this.a(x500Principal, n, 0, date, date2, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, String string2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, null, string2);
    }

    public void createSelfSigned(X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n, 0, date, date2, bigInteger, oracleCertExtension, string);
    }

    public void createSelfSigned(X500Principal x500Principal, String string, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        this.a(x500Principal, string, 0, date, date2, bigInteger, oracleCertExtension, string2);
    }

    public void createSelfSignedWithAttribs(CertificateAttributes certificateAttributes) throws IOException {
        if (certificateAttributes == null) {
            throw new IOException("Input 'CertificateAttributes' object is null");
        }
        String string = certificateAttributes.getKeyAlg();
        if (string.equals("RSA")) {
            this.a(certificateAttributes.getSubjectDN(), certificateAttributes.getKeySize(), certificateAttributes.getValidity(), certificateAttributes.getValidFrom(), certificateAttributes.getValidTo(), certificateAttributes.getSerialNum(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else if (string.equals("ECC")) {
            this.a(certificateAttributes.getSubjectDN(), certificateAttributes.getECCurve(), certificateAttributes.getValidity(), certificateAttributes.getValidFrom(), certificateAttributes.getValidTo(), certificateAttributes.getSerialNum(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else if (string.contains("ML-DSA") || string.contains("SLH-DSA")) {
            this.a(certificateAttributes.getKeyAlg(), certificateAttributes.getSubjectDN(), certificateAttributes.getValidity(), certificateAttributes.getValidFrom(), certificateAttributes.getValidTo(), certificateAttributes.getSerialNum(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else {
            throw new IOException(MessageFormat.format(a.getString("PKI-02025"), string));
        }
    }

    private void a(String string, X500Principal x500Principal, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        try {
            OraclePKIPQCKeyPair oraclePKIPQCKeyPair = OraclePKIPQCKeyPair.a(string);
            this.a(x500Principal, oraclePKIPQCKeyPair.getPrivateKey(), oraclePKIPQCKeyPair.getPublicKey(), n, date, date2, bigInteger, oracleCertExtension, string2);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void a(X500Principal x500Principal, int n, int n2, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        OraclePKIRSAKeyHelper.validateKeysize(n);
        try {
            OraclePKIKeyPair oraclePKIKeyPair = OraclePKIKeyPair.generateRSAKey(n);
            this.a(x500Principal, oraclePKIKeyPair.getPrivateKey(), oraclePKIKeyPair.getPublicKey(), n2, date, date2, bigInteger, oracleCertExtension, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(a.getString("PKI-02013"), generalSecurityException);
        }
    }

    private void a(X500Principal x500Principal, String string, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string2) throws IOException {
        if (string == null) {
            throw new IOException(a.getString("PKI-07011"));
        }
        ECGenParameterSpec eCGenParameterSpec = null;
        EccCurveParameters eccCurveParameters = EccCurveParameters.get(string);
        if (eccCurveParameters == null) {
            throw new IOException(a.getString("PKI-02014"));
        }
        eCGenParameterSpec = new ECGenParameterSpec(eccCurveParameters.getNickName());
        try {
            OraclePKIKeyPair oraclePKIKeyPair = OraclePKIKeyPair.generateECKey(eCGenParameterSpec);
            this.a(x500Principal, oraclePKIKeyPair.getPrivateKey(), oraclePKIKeyPair.getPublicKey(), n, date, date2, bigInteger, oracleCertExtension, string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(generalSecurityException.getMessage());
        }
    }

    private void a(X500Principal x500Principal, PrivateKey privateKey, PublicKey publicKey, int n, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl;
        Serializable serializable;
        Object object;
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, publicKey, privateKey);
        X509 x509 = null;
        try {
            object = null;
            if (this.G != null) {
                object = new AlgorithmIdentifier(Utils.toStream(this.G));
            }
            x509 = n == 0 ? new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, date, date2, (AlgorithmIdentifier)object) : new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, n, (AlgorithmIdentifier)object);
            if (oracleCertExtension != null) {
                if (oracleCertExtension.getSubjectKeyId()) {
                    SubjectKeyIDExtension subjectKeyIDExtension = new SubjectKeyIDExtension(CryptoUtils.generateKeyID(publicKey), false);
                    x509.a(subjectKeyIDExtension);
                    certificateRequest.a(subjectKeyIDExtension);
                    x509.a(new AuthorityKeyIDExtension(subjectKeyIDExtension.e(), false));
                }
                if (oracleCertExtension.getKeyUsage() != null) {
                    serializable = new KeyUsageExtension(oracleCertExtension.getKeyUsage(), true);
                    certificateRequest.a((X509Extension)serializable);
                    x509.a((X509Extension)serializable);
                }
                if (oracleCertExtension.getBasicConstraints() != null) {
                    serializable = oracleCertExtension.getBasicConstraints();
                    x509.a((X509Extension)serializable);
                    certificateRequest.a((X509Extension)serializable);
                }
                if ((serializable = oracleCertExtension.getSubjectAlternativeNamesList()) != null) {
                    SubjectAltNameExtension subjectAltNameExtension = new SubjectAltNameExtension((List<GeneralName>)((Object)serializable));
                    certificateRequest.a(subjectAltNameExtension);
                    x509.a(subjectAltNameExtension);
                }
            }
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
            serializable = this.getCertSignAlgorithmId();
            if (null != serializable) {
                certificateRequest.a((AlgorithmIdentifier)serializable);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw (IOException)iOException.initCause(exception);
        }
        try {
            if (oraclePKIX509CertImpl != null) {
                if (this.z == null) {
                    this.A = this.d();
                }
                this.internalAddCertReq(certificateRequest, privateKey, string);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
                object = null;
                if (string != null) {
                    int n2 = 1;
                    object = string + ' ' + Integer.toString(n2);
                }
                this.internalAddTrustedCert(oraclePKIX509CertImpl, (String)object, null);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
                this.internalAddUserCert(oraclePKIX509CertImpl, string);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
            }
        }
        catch (Exception exception) {
            serializable = new IOException(exception.getLocalizedMessage());
            throw (IOException)((Throwable)serializable).initCause(exception);
        }
    }

    public void create(char[] cArray) throws IOException {
        this.create(cArray, (byte)0);
    }

    public void create(char[] cArray, byte by) throws IOException {
        this.c();
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        if (cArray != null) {
            this.z = new char[cArray.length];
            System.arraycopy(cArray, 0, this.z, 0, cArray.length);
        }
        this.y = null;
        this.D = new OracleNewWalletImpl();
        try {
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            this.setKeyStore(keyStore, by);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    protected void a(KeyStore keyStore) {
    }

    public InputStream getWalletArray(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.z != null && !bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        } else if (this.z != null && bl && this.s == 0) {
            C041 c041 = new C041();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(this.y);
            byteArrayInputStream = c041.c(byteArrayInputStream2) == 0 ? (ByteArrayInputStream)this.a(1) : new ByteArrayInputStream(this.y);
        } else if (this.z != null && bl && this.s != 0) {
            C041 c041 = new C041();
            ByteArrayInputStream byteArrayInputStream3 = new ByteArrayInputStream(this.y);
            byteArrayInputStream = c041.c(byteArrayInputStream3) == 0 ? (ByteArrayInputStream)this.a(3) : new ByteArrayInputStream(this.y);
        } else if (this.z == null && bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        } else {
            throw new IOException("Cannot create p12 without password.");
        }
        return byteArrayInputStream;
    }

    public byte[] getWalletArrayB(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.getWalletArray(bl);
        int n = byteArrayInputStream.available();
        byte[] byArray = new byte[n];
        byteArrayInputStream.read(byArray, 0, n);
        return byArray;
    }

    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.c();
        if (cArray != null) {
            this.z = new char[cArray.length];
            System.arraycopy(cArray, 0, this.z, 0, cArray.length);
        }
        try {
            int n = inputStream.available();
            this.D = this.a(cArray);
            this.y = new byte[n];
            inputStream.read(this.y);
            OraclePKIDebug.debug("Oracle Wallet: wallet size " + this.y.length);
            if (this.z == null) {
                C041 c041 = new C041();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
                int n2 = c041.c(byteArrayInputStream);
                int n3 = c041.e(byteArrayInputStream);
                if (n2 == 3 && n3 == 7) {
                    this.s = c041.c(this.y);
                    this.t = c041.d(this.y);
                    this.u = c041.e(this.y);
                }
            }
            this.getSecretStore();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.debug("OracleWallet.setWalletArray: " + throwable.toString());
            this.c();
            IOException iOException = new IOException(throwable.getLocalizedMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
    }

    public void setWalletArray(byte[] byArray, char[] cArray) throws IOException {
        this.setWalletArray(new ByteArrayInputStream(byArray), cArray);
    }

    public synchronized void open(String string, char[] cArray) throws IOException {
        OraclePKIDebug.debug("OracleWallet:open(), enter...");
        OraclePKIDebug.debug("OracleWallet:open(), Wallet path: " + string);
        if (OraclePKIGenFunc.isNullOrEmpty(string)) {
            throw new IOException(a.getString("NO_WRL_ERROR"));
        }
        this.c();
        if (cArray != null) {
            this.z = new char[cArray.length];
            System.arraycopy(cArray, 0, this.z, 0, cArray.length);
        }
        try {
            this.D = this.a(string, cArray);
            OraclePKIDebug.debug("OracleWallet:open(), getting wallet data from wallet path: " + string);
            this.y = this.D.a();
            OraclePKIDebug.debug("OracleWallet:open(), wallet size = " + this.y.length);
            if (this.z == null) {
                C041 c041 = new C041();
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
                    int n = c041.c(byteArrayInputStream);
                    int n2 = c041.e(byteArrayInputStream);
                    if (n == 3 && n2 == 7) {
                        this.s = c041.c(this.y);
                        this.t = c041.d(this.y);
                        this.u = c041.e(this.y);
                    } else {
                        this.A = c041.b(byteArrayInputStream);
                    }
                }
                catch (IOException iOException) {
                    this.c();
                    throw new IOException(iOException.getMessage());
                }
            }
            OraclePKIDebug.debug("OracleWallet:open(), create and load the secret store in wallet");
            this.getSecretStore();
            if (this.checkTrustFlagsEnabled()) {
                this.B = true;
                OraclePKIDebug.debug("OracleWallet:open() Trust Flags are enabled, loading info");
                this.C = new HashMap();
                this.getTrustFlagsValue(this.C);
                if (this.C.size() == 0) {
                    this.C = null;
                }
            }
            OraclePKIDebug.debug("OracleWallet:open() Trust Flags Enabled :" + this.B);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.c();
            IOException iOException = new IOException(fileNotFoundException.getLocalizedMessage());
            iOException.initCause(fileNotFoundException);
            throw iOException;
        }
        catch (Throwable throwable) {
            OraclePKIDebug.debug("OracleWallet:open() " + throwable.toString());
            this.c();
            IOException iOException = new IOException(throwable.getLocalizedMessage());
            iOException.initCause(throwable);
            throw iOException;
        }
        OraclePKIDebug.debug("OracleWallet:open(), exit...");
    }

    public void openDefault(char[] cArray) throws IOException {
        String string = "";
        this.open(string, cArray);
        throw new IOException("not implemented");
    }

    public void createSSO() throws IOException {
        if (this.z == null && this.D == null) {
            this.z = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.a(2);
            this.c();
            this.y = new byte[((InputStream)byteArrayInputStream).available()];
            byteArrayInputStream.read(this.y);
            OraclePKIDebug.debug("OracleWallet: created ALO " + this.y.length + " bytes.");
        }
    }

    public void createSSO_OLD() throws IOException {
        if (this.z == null && this.D == null) {
            this.z = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            this.D = this.a(this.x, this.z);
            OraclePKIDebug.debug("OracleWallet: saving sso (ALO) " + this.y.length + " bytes.");
            this.D.b(this.y, this.z, 2);
        } else {
            OraclePKIDebug.debug("OracleWallet: saving sso (AL) " + this.y.length + " bytes.");
            this.D.b(this.y, this.z, 1);
        }
    }

    public void deleteSSOWallet() throws IOException {
        this.D.d();
    }

    public void deleteWallet() throws IOException {
        this.D.c();
    }

    public void save() throws IOException {
        OraclePKIDebug.debug("OracleWallet: saving " + this.y.length + " bytes.");
        String string = this.x;
        if (string == null) {
            string = this.D.e();
        }
        this.saveAs(string);
    }

    public synchronized void saveAs(String string) throws IOException {
        this.saveAs(string, (byte)0);
    }

    public synchronized void saveAs(String string, byte by) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        C041 c041 = new C041();
        Utils.validateSpaceAvailableForWallet(this.y.length, c041.a());
        OracleWalletImpl oracleWalletImpl = this.a(string, new char[16]);
        if (this.z == null) {
            Object object;
            OraclePKIDebug.debug("OracleWallet: saving sso (ALO) " + this.y.length + " bytes.");
            char[] cArray = null;
            try {
                object = new ByteArrayInputStream(this.y);
                if (c041.c((InputStream)object) == 2) {
                    int n = c041.e((InputStream)object);
                    cArray = c041.b((InputStream)object);
                    if (this.A == null) {
                        this.A = cArray;
                    }
                    PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)object);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
                    pKCS12.output(byteArrayOutputStream);
                    this.y = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            oracleWalletImpl.b(this.y, this.A, 2, by);
            this.z = null;
            object = null;
            try {
                object = c041.a(this.A, 2);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((Object)object).length + this.y.length);
            byteArrayOutputStream.write((byte[])object);
            byteArrayOutputStream.write(this.y);
            this.y = byteArrayOutputStream.toByteArray();
        } else {
            String string2 = null;
            string2 = string.endsWith("ewallet.p12") ? string.replaceAll("ewallet.p12", "cwallet.sso") : string.concat("/cwallet.sso");
            OracleWalletImpl oracleWalletImpl2 = this.a(string2, null);
            if (!oracleWalletImpl2.b()) {
                OraclePKIDebug.debug("OracleWallet: saving p12 " + this.y.length + " bytes.");
                oracleWalletImpl.a(this.y, this.z, by);
            } else {
                OraclePKIDebug.debug("OracleWallet: saving p12 " + this.y.length + " bytes.");
                oracleWalletImpl.a(this.y, this.z, by);
                OraclePKIDebug.debug("OracleWallet: saving p12 (& sso or lsso) " + this.y.length + " bytes.");
                byte[] byArray = oracleWalletImpl2.a();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n = c041.c(byteArrayInputStream);
                int n2 = c041.e(byteArrayInputStream);
                if (n == 1) {
                    oracleWalletImpl.a(this.y, this.z, n, by);
                } else if (n == 3 && n2 == 7) {
                    if (this.s == 0) {
                        this.s = c041.c(byArray);
                        this.t = c041.d(byArray);
                        this.u = c041.e(byArray);
                    }
                    oracleWalletImpl.a(this.y, this.z, n, by, this.s, this.t, this.u);
                } else if (n == 3) {
                    if (this.s == 0) {
                        this.saveSSVs(DEFAULT_SSVS);
                    }
                    oracleWalletImpl.a(this.y, this.z, n, by, this.s, this.t, this.u);
                }
            }
        }
        this.D = oracleWalletImpl;
    }

    public synchronized void saveSSO() throws IOException {
        OraclePKIDebug.debug("OracleWallet: saving sso " + this.y.length + " bytes.");
        this.D.b(this.y, this.z, 1);
    }

    private void b() throws IOException {
        if (this.s == 0) {
            return;
        }
        System.out.println("Wallet is v7 LSSO wallet. SSVs used are -");
        if ((this.s & 1) == 1) {
            System.out.println("    Hostname");
        }
        if ((this.s & 2) == 2) {
            System.out.println("    Username");
        }
        if ((this.s & 0x10) == 16) {
            System.out.println("    Machine ID");
        }
        if ((this.s & 0x80) == 128) {
            System.out.println("    MAC name0=" + this.t);
        }
        if ((this.s & 0x100) == 256) {
            System.out.println("    MAC name1=" + this.u);
        }
    }

    public void saveSSVs(String string) throws IOException {
        String[] stringArray = null;
        OraclePKIDebug.debug("OracleWallet.saveSSVs(): enter...");
        stringArray = string.split(",", -1);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (stringArray[i].equals(j)) {
                this.s |= 1;
                OraclePKIDebug.debug("  use SSV_HOSTNAME");
                continue;
            }
            if (stringArray[i].equals(k)) {
                this.s |= 2;
                OraclePKIDebug.debug("  use SSV_USERNAME");
                continue;
            }
            if (stringArray[i].equals(n)) {
                this.s |= 0x10;
                OraclePKIDebug.debug("  use SSV_MACHINEID");
                continue;
            }
            if (stringArray[i].startsWith(q)) {
                stringArray2 = stringArray[i].split(":", -1);
                if (stringArray2.length != 2) {
                    throw new IOException("SSV MACNAME0 format should be: SSV_MACNAME_0:<name>. Input=" + stringArray[i]);
                }
                this.t = stringArray2[1];
                this.s |= 0x80;
                OraclePKIDebug.debug("  use SSV_MACNAME0:" + this.t);
                continue;
            }
            if (stringArray[i].startsWith(r)) {
                stringArray2 = stringArray[i].split(":", -1);
                if (stringArray2.length != 2) {
                    throw new IOException("SSV MACNAME1 format should be: SSV_MACNAME_1:<name>. Input=" + stringArray[i]);
                }
                this.u = stringArray2[1];
                this.s |= 0x100;
                OraclePKIDebug.debug("  use SSV_MACNAME1:" + this.u);
                continue;
            }
            OraclePKIDebug.debug("Unsupported SSV: " + stringArray[i]);
            throw new IOException("Unsupported SSV: " + stringArray[i]);
        }
        OraclePKIDebug.debug("OracleWallet.saveSSVs() exit");
    }

    public void saveLSSO(String string) throws IOException {
        OraclePKIDebug.debug("OracleWallet: saving lsso " + this.y.length + " bytes.");
        this.saveSSVs(string);
        this.D.b(this.y, this.z, 3, (byte)0, this.s, this.t, this.u);
    }

    public void saveLSSO() throws IOException {
        OraclePKIDebug.debug("OracleWallet: saving lsso " + this.y.length + " bytes.");
        if (this.s == 0) {
            this.saveSSVs(DEFAULT_SSVS);
        }
        this.D.b(this.y, this.z, 3, (byte)0, this.s, this.t, this.u);
    }

    public boolean exists(String string) throws IOException {
        OracleWalletImpl oracleWalletImpl = this.a(string, this.z);
        return oracleWalletImpl.b();
    }

    public boolean exists(String string, boolean bl) throws IOException {
        OracleWalletImpl oracleWalletImpl = null;
        oracleWalletImpl = bl ? this.a(string, this.z) : this.a(string, this.z == null ? "".toCharArray() : this.z);
        return oracleWalletImpl.b();
    }

    public synchronized OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        ByteArrayInputStream byteArrayInputStream = null;
        OraclePKIDebug.debug("OracleWallet: getSecretStore: enter...");
        if (this.F == null) {
            this.F = new OracleSecretStore();
            if (this.y != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.y);
            }
            this.F.load(byteArrayInputStream, this.z);
            OraclePKIDebug.debug("OracleWallet: getSecretStore: created and loaded the secret store in wallet");
        }
        OraclePKIDebug.debug("OracleWallet: getSecretStore: exit...");
        return this.F;
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            if (null == Security.getProvider("OraclePKI")) {
                Security.insertProviderAt(new OraclePKIProvider(), 1);
            }
            keyStore = this.z != null ? KeyStore.getInstance("PKCS12", "OraclePKI") : KeyStore.getInstance("SSO", "OraclePKI");
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.y != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.y);
            }
            keyStore.load(byteArrayInputStream, this.z);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        return keyStore;
    }

    public synchronized void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.debug("OracleWallet: setSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (oracleSecretStore != this.F) {
            throw new OracleSecretStoreException("Secretstore mismatch.");
        }
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        this.y = oracleSecretStore.setStoreInWallet(byteArrayInputStream, this.z);
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.setKeyStore(keyStore, (byte)0);
    }

    public void setKeyStore(KeyStore keyStore, byte by) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: setKeyStore");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, keyStore, this.z, by);
    }

    public KeyStore createPKCS11KeyStore(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        if (string3 == null) {
            String string4 = string == null ? "/opt/bar/cfg/pkcs11.cfg" : string;
            Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Provider provider = (Provider)constructor.newInstance(string4);
            Security.addProvider(provider);
            keyStore = KeyStore.getInstance("PKCS11");
            keyStore.load(null, string2.toCharArray());
        } else if (string3.contains("Luna")) {
            Class<?> clazz = Class.forName("com.chrysalisits.crypto.LunaJCAProvider");
            Provider provider = (Provider)clazz.newInstance();
            Security.removeProvider(provider.getName());
            Security.insertProviderAt(provider, 1);
            keyStore = KeyStore.getInstance("Luna");
            keyStore.load(null, null);
        }
        return keyStore;
    }

    public OracleWallet migratePKCS12toJKS(char[] cArray, int n) throws IOException {
        String string;
        Enumeration<String> enumeration;
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        OracleWallet oracleWallet = OracleWallet.getInstance("jks");
        oracleWallet.create(cArray);
        KeyStore keyStore = oracleWallet.getKeyStore();
        KeyStore keyStore2 = this.getKeyStore();
        try {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                keyStore.deleteEntry(string);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        try {
            enumeration = keyStore2.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                string = enumeration.nextElement();
                if ((n == 0 || n == 2) && keyStore2.isCertificateEntry(string)) {
                    certificateArray = (Certificate[])keyStore2.getCertificate(string);
                    keyStore.setCertificateEntry(string, (Certificate)certificateArray);
                    continue;
                }
                if (n != 0 && n != 1 || !keyStore2.isKeyEntry(string)) continue;
                certificateArray = keyStore2.getCertificateChain(string);
                Key key = keyStore2.getKey(string, this.z);
                if (certificateArray == null) {
                    X509 x509 = null;
                    BigInteger bigInteger = new BigInteger("7");
                    int n2 = 3650;
                    CertificateRequest certificateRequest = null;
                    PrivateKey privateKey = null;
                    if (key.getAlgorithm().equals("RSA")) {
                        certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                        privateKey = (PrivateKey)key;
                    } else if (key.getAlgorithm().equals("EC")) {
                        certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                        privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "EC");
                    } else if (key.getAlgorithm().contains("ML-DSA")) {
                        certificateRequest = ((OraclePKIMLDSAPrivateKey)privateKey).b();
                        privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "ML-DSA");
                    } else {
                        if (!key.getAlgorithm().contains("SLH-DSA")) continue;
                        certificateRequest = ((OraclePKISLHDSAPrivateKey)privateKey).b();
                        privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "SLH-DSA");
                    }
                    x509 = new X509(certificateRequest.e(), certificateRequest.f(), certificateRequest.e(), privateKey, bigInteger, n2, null);
                    CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.g()));
                    Certificate[] certificateArray2 = new Certificate[]{x509Certificate};
                    keyStore.setKeyEntry(string, key, cArray, certificateArray2);
                    continue;
                }
                keyStore.setKeyEntry(string, key, cArray, certificateArray);
            }
            oracleWallet.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        return oracleWallet;
    }

    public void migrateJKStoPKCS12(KeyStore keyStore, char[] cArray, String[] stringArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        OraclePKIDebug.debug("OracleWallet: migrateJKStoPKCS12");
        if (cArray == null) {
            throw new IOException("keystore password cannot be null");
        }
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            } else {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            }
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            throw new UnrecoverableEntryException("passwords of the keystore and key entries should be the same");
        }
    }

    void a(KeyStore keyStore, char[] cArray, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        X509Certificate[] x509CertificateArray = (X509Certificate[])privateKeyEntry.getCertificateChain();
        PublicKey publicKey = x509Certificate.getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[x509CertificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl(new X509(x509CertificateArray[i].getEncoded()));
        }
        if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            if (oraclePKIX509CertImplArray2.length > 1) {
                for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                    try {
                        String string2 = keyStore.getCertificateAlias(oraclePKIX509CertImplArray2[i]);
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], string2, null);
                        if (this.z != null) continue;
                        this.A = this.b(this.A);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
                this.a(x500Principal, keyPair, privateKey, string);
                this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
            }
        } else {
            Principal principal;
            try {
                principal = (OraclePKIPrincipalImpl)oraclePKIX509CertImplArray[0].getIssuerDN();
                OraclePKIPrincipalImpl oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)oraclePKIX509CertImplArray[0].getSubjectDN();
                if (((OraclePKIPrincipalImpl)principal).equals(oraclePKIPrincipalImpl)) {
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray[0], string, null);
                    if (this.z == null) {
                        this.A = this.b(this.A);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            principal = x509Certificate.getSubjectX500Principal();
            int n = 1;
            string = string + ' ' + Integer.toString(n);
            this.a((X500Principal)principal, keyPair, privateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
            if (this.z == null) {
                this.A = this.b(this.A);
            }
        }
    }

    void a(KeyStore keyStore, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x509Certificate.getEncoded()));
        try {
            this.internalAddTrustedCert(oraclePKIX509CertImpl, string, null);
            if (this.z == null) {
                this.A = this.b(this.A);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void a(X500Principal x500Principal, KeyPair keyPair, PrivateKey privateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.getName());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair.getPublic(), keyPair.getPrivate());
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalAddCertReq(certificateRequest, privateKey, string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: listAliases");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.engineAliases();
    }

    public CRL createCRL(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.createCRL(null, null, null, n);
    }

    public CRL createCRL(String string, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.createCRL(string, null, null, n);
    }

    public CRL createCRL(String string, String string2, String string3, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Serializable serializable;
        Object object;
        KeyStore keyStore = this.getKeyStore();
        PrivateKey privateKey = null;
        X509 x509 = null;
        X509 x5092 = null;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Enumeration<String> enumeration = keyStore.aliases();
        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string3);
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)object)) continue;
            x5092 = ((OraclePKIX509CertImpl)keyStore.getCertificate((String)object)).getX509();
            x500Name = x5092.m();
            bl = false;
            bl2 = false;
            bl3 = false;
            if (string != null && (string == null || !x500Name.equals(new X500Name(string)))) continue;
            bl = true;
            x500Name2 = x5092.n();
            if (string2 != null && (string2 == null || !x500Name2.equals(new X500Name(string2)))) continue;
            bl2 = true;
            bigInteger2 = x5092.o();
            if (bigInteger == null || bigInteger != null && bigInteger.equals(bigInteger2)) {
                bl3 = true;
            }
            if (!bl || !bl2 || !bl3 || bl4) continue;
            bl4 = true;
            x509 = x5092;
            serializable = keyStore.getKey((String)object, null);
            if (serializable != null && PKIConstants.SupportedKeyTypes.contains(serializable.getAlgorithm())) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(serializable.getEncoded(), serializable.getAlgorithm());
                continue;
            }
            OraclePKIDebug.debug("Multiple certs with matching params exist.");
            throw new IOException(a.getString("PKI-04025"));
        }
        if (privateKey == null || x509 == null) {
            throw new IOException(a.getString("PKI-04002"));
        }
        try {
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
            oraclePKIX509CertImpl.checkValidity();
        }
        catch (Exception exception) {
            throw new IOException(a.getString("PKI-04026"));
        }
        try {
            object = null;
            object = new CRL();
            ((CRL)object).a(x509.m());
            ((CRL)object).a(n);
            serializable = null;
            if (this.H != null) {
                serializable = new AlgorithmIdentifier(Utils.toStream(this.H));
            }
            ((CRL)object).a(privateKey, (AlgorithmIdentifier)serializable);
            SubjectKeyIDExtension subjectKeyIDExtension = null;
            subjectKeyIDExtension = (SubjectKeyIDExtension)x509.a(PKIX.D);
            if (subjectKeyIDExtension != null) {
                ((CRL)object).a(new AuthorityKeyIDExtension(subjectKeyIDExtension.e()));
            } else {
                OraclePKIDebug.debug("Issuer's cert does not have Subject Key Identifier set,so can not set Authority Key Identifier in CRL generated.");
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CRL revokeCertificate(InputStream inputStream, CRL cRL) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        RevokedCertificate revokedCertificate = new RevokedCertificate(oraclePKIX509CertImplArray[0].getSerialNumber(), new Date());
        KeyStore keyStore = this.getKeyStore();
        PrivateKey privateKey = null;
        Enumeration<String> enumeration = keyStore.aliases();
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.a());
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string);
            if (oraclePKIPrincipalImpl == null || !oraclePKIPrincipalImpl.equals(((X509Certificate)oraclePKIX509CertImpl).getSubjectDN())) continue;
            try {
                bl = OracleWallet.verifyCRLSignature(oraclePKIX509CertImpl, cRL);
            }
            catch (Exception exception) {
                OraclePKIDebug.debug("Could not verify CRL signature");
            }
            if (!bl) continue;
            Key key = keyStore.getKey(string, null);
            if (key.getAlgorithm().equals("RSA")) {
                privateKey = (PrivateKey)key;
                break;
            }
            if (key.getAlgorithm().equals("EC")) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "EC");
                break;
            }
            if (key.getAlgorithm().contains("ML-DSA")) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "ML-DSA");
                break;
            }
            if (!key.getAlgorithm().contains("SLH-DSA")) break;
            privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "SLH-DSA");
            break;
        }
        if (privateKey == null || oraclePKIX509CertImpl == null) {
            throw new IOException(a.getString("PKI-04002"));
        }
        try {
            oraclePKIX509CertImpl.checkValidity();
        }
        catch (Exception exception) {
            throw new IOException(a.getString("PKI-04026"));
        }
        cRL.a(revokedCertificate);
        if (this.H == null) {
            cRL.a(privateKey, null);
        } else {
            try {
                cRL.a(privateKey, new AlgorithmIdentifier(Utils.toStream(this.H)));
            }
            catch (IOException iOException) {
                System.out.println("Could not set signing key: " + iOException.getLocalizedMessage());
                cRL = null;
            }
        }
        return cRL;
    }

    public static boolean getRevocationStatus(InputStream inputStream, CRL cRL) throws IOException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        return cRL.d(oraclePKIX509CertImplArray[0].getSerialNumber());
    }

    public static boolean verifyCRLSignature(InputStream inputStream, CRL cRL) throws IOException, AuthException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        return OracleWallet.verifyCRLSignature(oraclePKIX509CertImplArray[0], cRL);
    }

    public static boolean verifyCRLSignature(OraclePKIX509CertImpl oraclePKIX509CertImpl, CRL cRL) throws IOException, AuthException {
        PublicKey publicKey = null;
        PublicKey publicKey2 = oraclePKIX509CertImpl.getPublicKey();
        if (publicKey2 != null) {
            String string = publicKey2.getAlgorithm();
            publicKey = CryptoUtils.generatePublicKeyFromBytes(publicKey2.getEncoded(), string);
            cRL.a(publicKey);
        }
        return cRL.i();
    }

    public void addCertRequestWithAttribs(CertificateAttributes certificateAttributes) throws GeneralSecurityException, IOException {
        if (certificateAttributes == null) {
            throw new IllegalArgumentException("attributes cannot be null");
        }
        if (certificateAttributes.getKeyAlg() == null) {
            throw new IllegalArgumentException("key algorithm cannot be null");
        }
        String string = certificateAttributes.getKeyAlg();
        if (string.equals("RSA")) {
            this.addCertRequestWithRSAKey(certificateAttributes.getSubjectDN(), certificateAttributes.getKeySize(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else if (string.equals("ECC")) {
            this.addCertRequestWithECKey(certificateAttributes.getSubjectDN(), certificateAttributes.getECCurve(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else if (string.contains("ML-DSA") || string.contains("SLH-DSA")) {
            this.a(certificateAttributes.getSubjectDN(), certificateAttributes.getKeyAlg(), certificateAttributes.getExtensions(), certificateAttributes.getAlias());
        } else {
            throw new IllegalArgumentException("key algorithm not supported");
        }
    }

    public void addCertRequest(X500Principal x500Principal, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithRSAKey(x500Principal, n, null, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithRSAKey(x500Principal, n, null, string);
    }

    public void addCertRequest(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithRSAKey(x500Principal, n, oracleCertExtension, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension, String string) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.addCertRequestWithRSAKey(x500Principal, n, oracleCertExtension, string);
    }

    public void addCertRequestWithRSAKey(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIRSAKeyHelper.validateKeysize(n);
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("RSA");
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            this.a(x500Principal, privateKey, publicKey, oracleCertExtension, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(a.getString("PKI-02013"));
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
    }

    public void addCertRequest(X500Principal x500Principal, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithECKey(x500Principal, string, null, null);
    }

    public void addCertRequest(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithECKey(x500Principal, string, null, string2);
    }

    public void addCertRequest(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequestWithECKey(x500Principal, string, oracleCertExtension, null);
    }

    public void addCertRequest(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension, String string2) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.addCertRequestWithECKey(x500Principal, string, oracleCertExtension, string2);
    }

    public void addCertRequestWithECKey(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (string == null) {
            throw new IOException(a.getString("PKI-07011"));
        }
        try {
            KeyPairGenerator keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("EC");
            ECGenParameterSpec eCGenParameterSpec = null;
            if (EccCurveParameters.get(string) != null) {
                eCGenParameterSpec = new ECGenParameterSpec(EccCurveParameters.get(string).getNickName());
            } else if (EccCurveParameters.getByNickName(string) != null) {
                eCGenParameterSpec = new ECGenParameterSpec(string);
            } else {
                IOException iOException = new IOException(a.getString("PKI-02014"));
                throw iOException;
            }
            try {
                keyPairGenerator.initialize(eCGenParameterSpec);
                KeyPair keyPair = keyPairGenerator.genKeyPair();
                PrivateKey privateKey = keyPair.getPrivate();
                PublicKey publicKey = keyPair.getPublic();
                this.a(x500Principal, privateKey, publicKey, oracleCertExtension, string2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IOException(a.getString("PKI-07009"));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(a.getString("PKI-02014"));
        }
    }

    private void a(X500Principal x500Principal, String string, OracleCertExtension oracleCertExtension, String string2) throws IOException, GeneralSecurityException {
        OraclePKIPQCKeyPair oraclePKIPQCKeyPair;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key algorithm is null or empty");
        }
        if (string.contains("ML-DSA")) {
            oraclePKIPQCKeyPair = OraclePKIPQCKeyPair.b(string);
        } else if (string.contains("SLH-DSA")) {
            oraclePKIPQCKeyPair = OraclePKIPQCKeyPair.c(string);
        } else {
            throw new IllegalArgumentException(MessageFormat.format(a.getString("PKI-02025"), string));
        }
        this.a(x500Principal, oraclePKIPQCKeyPair.getPrivateKey(), oraclePKIPQCKeyPair.getPublicKey(), oracleCertExtension, string2);
    }

    private void a(X500Principal x500Principal, PrivateKey privateKey, PublicKey publicKey, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Cloneable cloneable;
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, publicKey, privateKey);
        if (oracleCertExtension != null) {
            if (oracleCertExtension.getSubjectKeyId()) {
                certificateRequest.a(new SubjectKeyIDExtension(CryptoUtils.generateKeyID(publicKey), false));
            }
            if (oracleCertExtension.getKeyUsage() != null) {
                certificateRequest.a(new KeyUsageExtension(oracleCertExtension.getKeyUsage(), true));
            }
            if (oracleCertExtension.getBasicConstraints() != null) {
                certificateRequest.a(oracleCertExtension.getBasicConstraints());
            }
            if ((cloneable = oracleCertExtension.getSubjectAlternativeNamesList()) != null) {
                certificateRequest.a(new SubjectAltNameExtension((List<GeneralName>)((Object)cloneable)));
            }
        }
        if (null != (cloneable = this.getCertSignAlgorithmId())) {
            certificateRequest.a(new AlgorithmIdentifier(Utils.toStream(cloneable)));
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalAddCertReq(certificateRequest, privateKey, string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void addCertRequest(CertificateRequest certificateRequest) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalAddCertReq(certificateRequest, null, null);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public String exportCertReqB64(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string2, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            String string3 = null;
            if (certificateRequest != null && certificateRequest.e() != null) {
                string3 = certificateRequest.e().toString();
            }
            if (string3 == null || !x500Name.equals(new X500Name(string3))) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output(byteArrayOutputStream);
            string = Utils.getBase64EncodedCert(byteArrayOutputStream.toByteArray(), b, c);
            break;
        }
        return string;
    }

    public InputStream exportCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = this.exportCertReqB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string3, null);
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            if (certificateRequest == null || !string.equals(string3)) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output(byteArrayOutputStream);
            string2 = Utils.getBase64EncodedCert(byteArrayOutputStream.toByteArray(), b, c);
            break;
        }
        return string2;
    }

    public InputStream exportCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = this.exportCertReqB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public InputStream createCert(InputStream inputStream, int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, (Date)null, (Date)null, BigInteger.ZERO);
    }

    public InputStream createCert(InputStream inputStream, int n, String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, null, null, BigInteger.ZERO, string, string2, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, int n, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, (Date)null, (Date)null, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, int n, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, null, null, bigInteger, string, string2, bigInteger2);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2, String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, BigInteger.ZERO, string, string2, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, bigInteger, string, string2, bigInteger2);
    }

    private InputStream a(InputStream inputStream, int n, Date date, Date date2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n, date, date2, bigInteger, null, null, null);
    }

    private InputStream a(InputStream inputStream, int n, Date date, Date date2, BigInteger bigInteger, String string, String string2, BigInteger bigInteger2) throws IOException {
        try {
            Object object;
            Serializable serializable;
            BasicConstraintsExtension basicConstraintsExtension;
            CertificateRequest certificateRequest = new CertificateRequest(inputStream);
            KeyStore keyStore = this.getKeyStore();
            String string3 = this.a(string, string2, bigInteger2);
            Key key = keyStore.getKey(string3, null);
            PrivateKey privateKey = null;
            if (key.getAlgorithm().equals("RSA")) {
                privateKey = (PrivateKey)key;
            } else if (key.getAlgorithm().equals("EC")) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "EC");
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "ML-DSA");
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                privateKey = CryptoUtils.generatePrivateKeyFromBytes(key.getEncoded(), "SLH-DSA");
            }
            Certificate certificate = keyStore.getCertificate(string3);
            X509 x509 = ((OraclePKIX509CertImpl)certificate).getX509();
            Utils.trustedCertificateValidation((X509Certificate)certificate, this.I);
            if (privateKey == null || x509 == null) {
                OraclePKIDebug.debug("CreateCert: " + a.getString("PKI-04002"));
                throw new IOException(a.getString("PKI-04002"));
            }
            X509 x5092 = null;
            AlgorithmIdentifier algorithmIdentifier = null;
            if (this.G != null) {
                algorithmIdentifier = new AlgorithmIdentifier(Utils.toStream(this.G));
            }
            x5092 = n == 0 ? new X509(certificateRequest.e(), certificateRequest.f(), x509.m(), privateKey, bigInteger, date, date2, algorithmIdentifier) : new X509(certificateRequest.e(), certificateRequest.f(), x509.m(), privateKey, bigInteger, n, algorithmIdentifier);
            ArrayList<X509Extension> arrayList = null;
            X509ExtensionSet x509ExtensionSet = certificateRequest.i();
            if (x509ExtensionSet != null) {
                arrayList = x509ExtensionSet.b();
                for (int i = 0; i < arrayList.size(); ++i) {
                    x5092.a(arrayList.get(i));
                }
            }
            if ((basicConstraintsExtension = (BasicConstraintsExtension)x509.a(PKIX.H)) != null && basicConstraintsExtension.e() && (serializable = basicConstraintsExtension.f()) != null) {
                int n2 = ((BigInteger)serializable).signum();
                if (n2 < 0) {
                    throw new IOException(a.getString("PKI-04028"));
                }
                object = (BasicConstraintsExtension)x5092.a(PKIX.H);
                if (object != null && ((BasicConstraintsExtension)object).e() && ((BasicConstraintsExtension)object).f() != null && ((BigInteger)serializable).compareTo(((BasicConstraintsExtension)object).f()) < 1) {
                    OraclePKIDebug.debug("Issuing CA's pathlength is equal to or less than the ICA's pathlength.");
                    if (this.I) {
                        throw new IOException(a.getString("PKI-04028"));
                    }
                }
            }
            serializable = null;
            serializable = (SubjectKeyIDExtension)x509.a(PKIX.D);
            if (serializable != null) {
                x5092.a(new AuthorityKeyIDExtension(((SubjectKeyIDExtension)serializable).e(), false));
            } else {
                OraclePKIDebug.debug("Issuer's cert does not have Subject Key Identifier set,so can not set Authority Key Identifier in certificate generated.");
            }
            ByteArrayInputStream byteArrayInputStream = null;
            object = new ByteArrayOutputStream();
            x5092.output((OutputStream)object);
            String string4 = Utils.getBase64EncodedCert(((ByteArrayOutputStream)object).toByteArray(), d, e);
            byte[] byArray = string4.getBytes();
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getLocalizedMessage());
        }
    }

    private String a(String string, String string2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = null;
        if (string == null && string2 == null && bigInteger == null) {
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                string3 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string3) || (certificate = keyStore.getCertificate(string3)) == null) continue;
                return string3;
            }
        } else {
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                string3 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string3) || (certificate = keyStore.getCertificate(string3)) == null) continue;
                X509 x509 = ((OraclePKIX509CertImpl)certificate).getX509();
                if (string != null && !x509.m().toString().equals(string) || string2 != null && !x509.n().toString().equals(string2) || bigInteger != null && !x509.o().equals(bigInteger)) continue;
                return string3;
            }
        }
        OraclePKIDebug.debug("OracleWallet.internalGetSignerAlias: " + a.getString("PKI-04007"));
        throw new IOException(a.getString("PKI-04007"));
    }

    public String exportCertB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.exportCertB64(x500Principal, null, null);
    }

    public String exportCertB64(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        String string3 = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string4;
            String string5 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string5);
            if (oraclePKIX509CertImpl == null || !x500Name.equals(new X500Name(string4 = oraclePKIX509CertImpl.getSubjectDN().toString())) || string != null && !((String)(object = oraclePKIX509CertImpl.getIssuerDN().toString())).equals(string)) continue;
            if (string2 != null) {
                string2 = string2.replaceAll("^0+(?!$)", "");
                object = oraclePKIX509CertImpl.getSerialNumber();
                if (object == null) continue;
                String string6 = ((BigInteger)object).toString();
                String string7 = ((BigInteger)object).toString(16);
                String string8 = "0x" + ((BigInteger)object).toString(16);
                if (!string6.equals(string2) && !string7.equalsIgnoreCase(string2) && !string8.equalsIgnoreCase(string2)) continue;
            }
            object = oraclePKIX509CertImpl.getEncoded();
            string3 = Utils.getBase64EncodedCert((byte[])object, d, e);
            break;
        }
        return string3;
    }

    public InputStream exportCert(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = this.exportCertB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !string.equals(string3)) continue;
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string2 = Utils.getBase64EncodedCert(byArray, d, e);
            break;
        }
        return string2;
    }

    public InputStream exportCert(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.exportCert(x500Principal, null, null);
    }

    public InputStream exportCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        String string3 = this.exportCertB64(x500Principal, string, string2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        return byteArrayInputStream;
    }

    public String exportPrivateKeyB64(String string, char[] cArray, byte[] byArray) throws IOException {
        return this.exportPrivateKeyB64(string, cArray, byArray, 10000);
    }

    public String exportPrivateKeyB64(String string, char[] cArray, byte[] byArray, int n) throws IOException {
        String string2 = null;
        KeyStore keyStore = null;
        String string3 = "PBEWithHmacSHA256AndAES_256";
        byte[] byArray2 = new byte[16];
        PBEKeySpec pBEKeySpec = null;
        SecretKey secretKey = null;
        if (!this.canModify()) {
            throw new IOException("Cannot export private key from SSO wallet.");
        }
        try {
            keyStore = this.getKeyStore();
            Key key = keyStore.getKey(string, this.z);
            if (key instanceof PrivateKey) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n, ivParameterSpec);
                pBEKeySpec = new PBEKeySpec(cArray, byArray, n, 256);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string3);
                secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                Cipher cipher = JCEUtil.getCipherInstance(string3);
                if (FIPSConfig.c()) {
                    cipher.init(1, (Key)secretKey, ivParameterSpec);
                } else {
                    cipher.init(1, (Key)secretKey, pBEParameterSpec);
                }
                byte[] byArray3 = cipher.doFinal(key.getEncoded());
                string2 = Utils.getBase64EncodedCert(byArray3, h, i);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IOException(invalidAlgorithmParameterException.getMessage());
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        return string2;
    }

    public String exportPrivateKeyB64(String string, char[] cArray) throws IOException {
        String string2 = null;
        KeyStore keyStore = null;
        PBEKeySpec pBEKeySpec = null;
        Destroyable destroyable = null;
        int n = 10000;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[16];
        String string3 = "PBEWithHmacSHA256AndAES_256";
        if (!this.canModify()) {
            throw new IOException("Cannot export private key from SSO wallet.");
        }
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n, ivParameterSpec);
            pBEKeySpec = new PBEKeySpec(cArray, byArray, n, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string3);
            destroyable = secretKeyFactory.generateSecret(pBEKeySpec);
            keyStore = this.getKeyStore();
            Key key = keyStore.getKey(string, this.z);
            if (key instanceof PrivateKey) {
                Cipher cipher = Cipher.getInstance(string3);
                if (FIPSConfig.c()) {
                    cipher.init(1, (Key)((Object)destroyable), ivParameterSpec);
                } else {
                    cipher.init(1, (Key)((Object)destroyable), pBEParameterSpec);
                }
                byte[] byArray3 = cipher.doFinal(key.getEncoded());
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string3);
                algorithmParameters.init(pBEParameterSpec);
                byte[] byArray4 = PBEEncPKCS8.encodeEncPkcs8(algorithmParameters, byArray3);
                string2 = Utils.getBase64EncodedCert(byArray4, f, g);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        finally {
            if (pBEKeySpec != null) {
                pBEKeySpec.clearPassword();
            }
            try {
                if (destroyable != null) {
                    destroyable.destroy();
                }
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
        return string2;
    }

    public void importPrivateKeyB64(String string, String string2, char[] cArray, byte[] byArray, String string3, String string4) throws IOException {
        this.importPrivateKeyB64(string, string2, cArray, byArray, 10000, string3, string4);
    }

    public void importPrivateKeyB64(String string, String string2, char[] cArray, byte[] byArray, int n, String string3, String string4) throws IOException {
        block18: {
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            PublicKey publicKey2 = null;
            KeyPair keyPair = null;
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = null;
            Cipher cipher = null;
            PBEKeySpec pBEKeySpec = null;
            PBEParameterSpec pBEParameterSpec = null;
            Object var17_17 = null;
            Object var18_18 = null;
            Object var19_19 = null;
            PrivateKey privateKey2 = null;
            X500Name x500Name = null;
            CertificateRequest certificateRequest = null;
            SecretKey secretKey = null;
            String string5 = null;
            String string6 = null;
            String string7 = "PBEWithHmacSHA256AndAES_256";
            byte[] byArray2 = new byte[16];
            if (!this.canModify()) {
                throw new IOException("Cannot import private key to SSO wallet.");
            }
            try {
                if (null == string3) break block18;
                oraclePKIX509CertImplArray2 = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string3.getBytes()));
                publicKey = oraclePKIX509CertImplArray2[0].getPublicKey();
                string6 = oraclePKIX509CertImplArray2[0].getPublicKeyType();
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
                pBEParameterSpec = new PBEParameterSpec(byArray, n, ivParameterSpec);
                pBEKeySpec = new PBEKeySpec(cArray, byArray, n, 256);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string7);
                secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
                cipher = JCEUtil.getCipherInstance(string7);
                try {
                    cipher.init(2, (Key)secretKey, pBEParameterSpec);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    cipher.init(2, (Key)secretKey, ivParameterSpec);
                }
                if (string2.indexOf(h) == -1) {
                    throw new IOException("Header not present in private key");
                }
                if (string2.indexOf(i) == -1) {
                    throw new IOException("Footer not present in private key");
                }
                string5 = string2.substring(h.length(), string2.indexOf(i) - 1);
                byte[] byArray3 = cipher.doFinal(Base64.getMimeDecoder().decode(string5));
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    privateKey2 = CryptoUtils.generatePrivateKeyFromBytes(byArray3, "RSA");
                    keyPair = new KeyPair(publicKey, privateKey2);
                } else if (null != string6 && PKIConstants.SupportedKeyTypes.contains(string6)) {
                    privateKey = CryptoUtils.generatePrivateKeyFromBytes(byArray3, string6);
                    publicKey2 = CryptoUtils.generatePublicKeyFromBytes(publicKey.getEncoded(), string6);
                    keyPair = new KeyPair(publicKey2, privateKey);
                }
                x500Name = new X500Name(oraclePKIX509CertImplArray2[0].getSubjectDN().toString());
                certificateRequest = new CertificateRequest(x500Name, keyPair != null ? keyPair.getPublic() : null, keyPair != null ? keyPair.getPrivate() : null);
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    this.internalAddCertReq(certificateRequest, privateKey2, string);
                } else if (null != string6 && PKIConstants.SupportedKeyTypes.contains(string6)) {
                    this.internalAddCertReq(certificateRequest, privateKey, string);
                }
                if (this.z == null) {
                    this.A = this.d();
                }
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
                if (string4 != null) {
                    oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string4.getBytes()));
                    for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, null);
                        if (this.z != null) continue;
                        this.A = this.b(this.A);
                    }
                }
                this.internalAddUserCert(oraclePKIX509CertImplArray2[0], string);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
        }
    }

    public void importPrivateKeyB64(String string, String string2, char[] cArray, String string3, String string4) throws IOException {
        PrivateKey privateKey = null;
        PrivateKey privateKey2 = null;
        PublicKey publicKey = null;
        Object var9_9 = null;
        KeyPair keyPair = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = null;
        X500Name x500Name = null;
        CertificateRequest certificateRequest = null;
        String string5 = null;
        String string6 = null;
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        PBEKeySpec pBEKeySpec = null;
        Destroyable destroyable = null;
        String string7 = "PBEWithHmacSHA256AndAES_256";
        byte[] byArray = new byte[8];
        int n = 10000;
        if (!this.canModify()) {
            throw new IOException("Cannot import private key to SSO wallet.");
        }
        try {
            if (null != string3) {
                Object object;
                oraclePKIX509CertImplArray2 = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string3.getBytes()));
                publicKey = oraclePKIX509CertImplArray2[0].getPublicKey();
                string6 = oraclePKIX509CertImplArray2[0].getPublicKeyType();
                if (string2.indexOf(new String(f)) == -1) {
                    throw new IOException("Header not present in private key");
                }
                if (string2.indexOf(new String(g)) == -1) {
                    throw new IOException("Footer not present in private key");
                }
                string5 = string2.substring(new String(f).length(), string2.indexOf(new String(g)) - 1);
                byte[] byArray2 = Base64.getMimeDecoder().decode(string5);
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray2);
                Cipher cipher = Cipher.getInstance(string7);
                pBEKeySpec = new PBEKeySpec(cArray, byArray, n, 256);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string7);
                destroyable = secretKeyFactory.generateSecret(pBEKeySpec);
                AlgorithmParameters algorithmParameters = encryptedPrivateKeyInfo.getAlgParameters();
                cipher.init(2, (Key)((Object)destroyable), algorithmParameters);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    object = KeyFactory.getInstance("RSA");
                    privateKey = ((KeyFactory)object).generatePrivate(pKCS8EncodedKeySpec);
                    keyPair = new KeyPair(publicKey, privateKey);
                } else if (null != string6 && PKIConstants.SupportedKeyTypes.contains(string6)) {
                    object = KeyFactory.getInstance(string6);
                    privateKey = ((KeyFactory)object).generatePrivate(pKCS8EncodedKeySpec);
                    privateKey2 = CryptoUtils.generatePrivateKeyFromBytes(privateKey.getEncoded(), string6);
                    keyPair = new KeyPair(CryptoUtils.generatePublicKeyFromBytes(publicKey.getEncoded(), string6), privateKey2);
                }
                keyStore = this.getKeyStore();
                enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    Key key;
                    object = enumeration.nextElement();
                    if (!keyStore.isKeyEntry((String)object) || !((key = keyStore.getKey((String)object, this.z)) instanceof PrivateKey)) continue;
                    byte[] byArray3 = key.getEncoded();
                    if (!(null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA")) ? privateKey != null && Arrays.equals(byArray3, privateKey.getEncoded()) : null != string6 && (string6.equalsIgnoreCase("EC") || string6.equalsIgnoreCase("ML-DSA") || string6.equalsIgnoreCase("SLH-DSA")) && privateKey2 != null && Arrays.equals(byArray3, privateKey2.getEncoded()))) continue;
                    throw new IOException("Private key already present in wallet.");
                }
                if (this.z == null) {
                    this.A = this.d();
                }
                x500Name = new X500Name(oraclePKIX509CertImplArray2[0].getSubjectDN().toString());
                certificateRequest = new CertificateRequest(x500Name, keyPair != null ? keyPair.getPublic() : null, keyPair != null ? keyPair.getPrivate() : null);
                if (null != string6 && (string6.equalsIgnoreCase("") || string6.equalsIgnoreCase("RSA"))) {
                    this.internalAddCertReq(certificateRequest, privateKey, string);
                } else if (null != string6 && (string6.equalsIgnoreCase("EC") || string6.equalsIgnoreCase("SLH-DSA") || string6.equalsIgnoreCase("ML-DSA"))) {
                    this.internalAddCertReq(certificateRequest, privateKey2, string);
                }
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
                if (string4 != null) {
                    oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(new ByteArrayInputStream(string4.getBytes()));
                    for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                        this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, null);
                        if (this.z != null) continue;
                        this.A = this.b(this.A);
                    }
                }
                this.internalAddUserCert(oraclePKIX509CertImplArray2[0], string);
                if (this.z == null) {
                    this.A = this.b(this.A);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
        finally {
            if (pBEKeySpec != null) {
                pBEKeySpec.clearPassword();
            }
            try {
                if (destroyable != null) {
                    destroyable.destroy();
                }
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }

    public void importCertB64(String string, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, null, null);
    }

    public void importCertB64(String string, boolean bl, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, string2, null);
    }

    public boolean canModify() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        C041 c041;
        int n;
        boolean bl = true;
        if (this.z == null && ((n = (c041 = new C041()).c(byteArrayInputStream = new ByteArrayInputStream(this.y))) == 1 || n == 3)) {
            bl = false;
        }
        return bl;
    }

    public void importCert(InputStream inputStream, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.importCert(inputStream, bl, null, null);
    }

    public void importCert(InputStream inputStream, boolean bl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray;
        if (!this.canModify()) {
            throw new IOException(a.getString("PKI-02008"));
        }
        if (this.z == null) {
            this.A = this.d();
        }
        if ((oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream)).length > 1 && string2 != null) {
            throw new IOException(a.getString("PKI-04024"));
        }
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                if (i == 0) {
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], string, string2);
                    continue;
                }
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[i], null, string2);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            for (int i = 0; i < oraclePKIX509CertImplArray2.length - 1; ++i) {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i], null, string2);
            }
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
        } else {
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
        }
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void deleteCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveCertReq(x500Principal);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveCertReq(string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void removePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemovePrivateKey(string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void deleteCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.deleteCert(x500Principal, null, null);
    }

    public void deleteCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveUserCert(x500Principal, string, string2);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveUserCert(string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(x500Principal, this.C);
    }

    public boolean isTrustedCertUsedInChain(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(string, this.C);
    }

    public void replaceTrustpoint(InputStream inputStream, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalReplaceTrustedCert(oraclePKIX509CertImplArray[0], string, string2);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void replaceTrustpoint(InputStream inputStream, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalReplaceTrustedCert(oraclePKIX509CertImplArray[0], string, string2, string3);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void replaceUserCert(InputStream inputStream, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalRemoveUserCert(string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
        this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void replaceUserCert(InputStream inputStream, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        this.internalRemoveMatchingUserCert(oraclePKIX509CertImplArray[0], string, string2);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
        this.internalAddUserCert(oraclePKIX509CertImplArray[0], null);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void removeTrustpoint(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.removeTrustpoint(x500Principal, null, null);
    }

    public void removeTrustpoint(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveTrustedCert(x500Principal, string, string2);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveTrustedCert(string);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalRemoveAllTrusted();
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public boolean areTrustFlagsEnabled() {
        return this.B;
    }

    public boolean checkTrustFlagsEnabled() throws IOException, NoSuchAlgorithmException, CertificateException {
        if (this.z == null) {
            this.A = this.d();
        }
        return this.a();
    }

    protected boolean a() throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalCheckTrustFlagsEnabled");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.b(byteArrayInputStream, this.z);
    }

    public void getTrustFlagsValue(HashMap hashMap) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalGetTrustFlagsValue(hashMap);
    }

    public void internalGetTrustFlagsValue(HashMap hashMap) throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalGetTrustFlagsValue");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, hashMap);
    }

    public void assignTrustFlagstoCertificate(String string, String string2, String string3, String string4) throws Exception {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.internalAssignTrustFlagstoCertificate(string, string2, string3, string4);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    public void internalAssignTrustFlagstoCertificate(String string, String string2, String string3, String string4) throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalAssignTrustFlagstoCertificate");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, string, string2, string3, string4, this.C);
    }

    public int getPersonaCount() {
        return 1;
    }

    public X500Principal[] getCertReqDNs(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        CertificateRequest certificateRequest = null;
        while (enumeration.hasMoreElements()) {
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray)) continue;
            Key key = keyStore.getKey((String)x500PrincipalArray, null);
            if (key == null) {
                throw new IOException("Key with alias " + (String)x500PrincipalArray + " not found.");
            }
            if (key instanceof OraclePKIRSAPrivateKey) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key instanceof OraclePKIECPrivateKey) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key instanceof OraclePKIMLDSAPrivateKey) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key instanceof OraclePKISLHDSAPrivateKey) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            if (certificateRequest == null) continue;
            vector.add(new X500Principal(certificateRequest.e().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        CertificateRequest certificateRequest = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Key key = keyStore.getKey(string, null);
            if (key == null) {
                throw new IOException("Key with alias " + string + " not found.");
            }
            if (key instanceof OraclePKIRSAPrivateKey) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key instanceof OraclePKIECPrivateKey) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key instanceof OraclePKIMLDSAPrivateKey) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key instanceof OraclePKISLHDSAPrivateKey) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            if (certificateRequest == null) continue;
            arrayList2.add(certificateRequest.e().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertReqAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray)) continue;
            CertificateRequest certificateRequest = null;
            object = keyStore.getKey((String)stringArray, null);
            if (object == null) {
                throw new IOException("Key with alias " + (String)stringArray + " not found.");
            }
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)object).b();
            } else if (object.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)object).b();
            }
            if (certificateRequest == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            stringArray[n2] = (String)object.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getPPvtAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        int n2;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray)) continue;
            n2 = 0;
            object = keyStore.getKey((String)stringArray, null);
            if (object == null) {
                throw new IOException("Key with alias " + (String)stringArray + " not found.");
            }
            if (object.getAlgorithm().equals("RSA")) {
                n2 = ((OraclePKIRSAPrivateKey)object).isPvtKeyPresent() ? 1 : 0;
            } else if (object.getAlgorithm().equals("EC")) {
                n2 = ((OraclePKIECPrivateKey)object).isPvtKeyPresent() ? 1 : 0;
            } else if (object.getAlgorithm().contains("ML-DSA")) {
                n2 = ((OraclePKIMLDSAPrivateKey)object).c() ? 1 : 0;
            } else if (object.getAlgorithm().contains("SLH-DSA")) {
                n2 = ((OraclePKISLHDSAPrivateKey)object).c() ? 1 : 0;
            }
            if (n2 == 0) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        n2 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            stringArray[n2] = (String)object.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getPPvtInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[2];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        int n2 = this.internalGetCRCompNum(string);
        stringArray[0] = Integer.toString(n2);
        stringArray[1] = Integer.toString(-1);
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string2, null);
            if (key == null) {
                throw new IOException("Key with alias " + string2 + " not found.");
            }
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            if (certificateRequest == null || !string.equals(string2)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                stringArray[1] = Integer.toString(2);
                break;
            }
            stringArray[1] = Integer.toString(1);
            break;
        }
        return stringArray;
    }

    public byte[] getPPvtBytes(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            Key key = keyStore.getKey(string2, null);
            if (key == null) {
                throw new IOException("Key with alias " + string2 + " not found.");
            }
            if (!string.equals(string2)) continue;
            byArray = key.getEncoded();
            break;
        }
        return new String("").getBytes();
    }

    public byte[] getPPvtBytesUnEnc(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            Key key = keyStore.getKey(string2, null);
            if (key == null) {
                throw new IOException("Key with alias " + string2 + " not found.");
            }
            if (!string.equals(string2)) continue;
            byArray = key.getEncoded();
            break;
        }
        return byArray;
    }

    public int getCertReqCount(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string, null);
            if (key == null) {
                throw new IOException("Key with alias " + string + " not found.");
            }
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
            }
            if (certificateRequest == null) continue;
            ++n2;
        }
        return n2;
    }

    public X500Principal[] getCertReqDNs(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry((String)x500PrincipalArray) || keyStore.getCertificate((String)x500PrincipalArray) != null) continue;
                certificateRequest = null;
                object = keyStore.getKey((String)x500PrincipalArray, null);
                if (object == null) {
                    throw new IOException("Key with alias " + (String)x500PrincipalArray + " not found.");
                }
                if (object instanceof OraclePKIRSAPrivateKey) {
                    certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
                } else if (object instanceof OraclePKIECPrivateKey) {
                    certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
                } else if (object instanceof OraclePKIMLDSAPrivateKey) {
                    certificateRequest = ((OraclePKIMLDSAPrivateKey)object).b();
                } else if (object instanceof OraclePKISLHDSAPrivateKey) {
                    certificateRequest = ((OraclePKISLHDSAPrivateKey)object).b();
                }
                if (certificateRequest == null) continue;
                vector.add(new X500Principal(certificateRequest.e().toString()));
                continue;
            }
            if (!keyStore.isKeyEntry((String)x500PrincipalArray)) continue;
            certificateRequest = null;
            object = keyStore.getKey((String)x500PrincipalArray, null);
            if (object == null) {
                throw new IOException("Key with alias " + (String)x500PrincipalArray + " not found.");
            }
            if (object instanceof OraclePKIRSAPrivateKey) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object instanceof OraclePKIECPrivateKey) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            } else if (object instanceof OraclePKIMLDSAPrivateKey) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)object).b();
            } else if (object instanceof OraclePKISLHDSAPrivateKey) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)object).b();
            }
            if (certificateRequest == null) continue;
            vector.add(new X500Principal(certificateRequest.e().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)object.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null) continue;
                certificateRequest = null;
                Key key = keyStore.getKey(string, null);
                if (key == null) {
                    throw new IOException("Key with alias " + string + " not found.");
                }
                if (key instanceof OraclePKIRSAPrivateKey) {
                    certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                } else if (key instanceof OraclePKIECPrivateKey) {
                    certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                } else if (key instanceof OraclePKIMLDSAPrivateKey) {
                    certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
                } else if (key instanceof OraclePKISLHDSAPrivateKey) {
                    certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
                }
                if (certificateRequest == null) continue;
                arrayList2.add(certificateRequest.e().toString());
                arrayList2.add(string);
                arrayList.add(arrayList2);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            arrayList2.add(certificateRequest.e().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public int getCertReqCount(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null) continue;
                certificateRequest = null;
                Key key = keyStore.getKey(string, null);
                if (key == null) {
                    throw new IOException("Key with alias " + string + " not found.");
                }
                if (key instanceof OraclePKIRSAPrivateKey) {
                    certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                } else if (key instanceof OraclePKIECPrivateKey) {
                    certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                } else if (key instanceof OraclePKIMLDSAPrivateKey) {
                    certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
                } else if (key instanceof OraclePKISLHDSAPrivateKey) {
                    certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
                }
                if (certificateRequest == null) continue;
                ++n2;
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n2;
        }
        return n2;
    }

    public String[] getCertReqInfo(int n, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string, null);
            if (key == null) {
                throw new IOException("Key with alias " + string + " not found.");
            }
            if (key.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                stringArray[1] = Integer.valueOf(((RSAPublicKey)certificateRequest.f()).getModulus().bitLength()).toString();
            } else if (key.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                stringArray[1] = Integer.valueOf(((ECPublicKey)certificateRequest.f()).getParams().getCurve().getField().getFieldSize()).toString();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
                stringArray[1] = String.valueOf(PQCKeyUtil.a(certificateRequest.f(), "Public"));
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
                stringArray[1] = String.valueOf(PQCKeyUtil.a(certificateRequest.f(), "Public"));
            }
            if (certificateRequest != null && n2 == n3) {
                stringArray[0] = certificateRequest.e().toString();
                stringArray[2] = new String(certificateRequest.f().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n3;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2)) continue;
            CertificateRequest certificateRequest = null;
            Key key = keyStore.getKey(string2, null);
            if (key == null) {
                throw new IOException("Key with alias " + string2 + " not found.");
            }
            stringArray[3] = key.getAlgorithm();
            if (stringArray[3].equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)key).getCertificateRequest();
                stringArray[1] = Integer.valueOf(((RSAPublicKey)certificateRequest.f()).getModulus().bitLength()).toString();
            } else if (stringArray[3].equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)key).getCertificateRequest();
                stringArray[1] = Integer.valueOf(((ECPublicKey)certificateRequest.f()).getParams().getCurve().getField().getFieldSize()).toString();
            } else if (key.getAlgorithm().contains("ML-DSA")) {
                certificateRequest = ((OraclePKIMLDSAPrivateKey)key).b();
                stringArray[1] = String.valueOf(PQCKeyUtil.a(certificateRequest.f(), "Public"));
            } else if (key.getAlgorithm().contains("SLH-DSA")) {
                certificateRequest = ((OraclePKISLHDSAPrivateKey)key).b();
                stringArray[1] = String.valueOf(PQCKeyUtil.a(certificateRequest.f(), "Public"));
            }
            if (certificateRequest == null || !string.equals(string2)) continue;
            stringArray[0] = certificateRequest.e().toString();
            stringArray[2] = new String(certificateRequest.f().getAlgorithm());
            break;
        }
        return stringArray;
    }

    public X500Principal[] getCertDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(x509Certificate.getSubjectDN().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertDNalias(int n) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(x509Certificate.getSubjectDN().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getCertInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[13];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
            stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            PublicKey publicKey = oraclePKIX509CertImpl.getPublicKey();
            if (publicKey == null) {
                throw new IOException("Public key not found for alias " + string2);
            }
            String string3 = publicKey.getAlgorithm();
            if (string3 == null) {
                throw new IOException("Algorithm not found for alias " + string2);
            }
            if (string3.equals("RSA")) {
                stringArray[6] = Integer.valueOf(((RSAPublicKey)publicKey).getModulus().bitLength()).toString();
            } else if (string3.equals("EC")) {
                stringArray[6] = Integer.valueOf(((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize()).toString();
            } else if (string3.startsWith("ML-DSA")) {
                PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(PQCUtils.a(publicKey, "Public"));
                if (pQCKeyInfo == null) {
                    throw new IOException("Key information is null");
                }
                stringArray[6] = String.valueOf(pQCKeyInfo.a());
            } else if (string3.startsWith("SLH-DSA")) {
                PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.b(PQCUtils.a(publicKey, "Public"));
                if (pQCKeyInfo == null) {
                    throw new IOException("Key information is null");
                }
                stringArray[6] = String.valueOf(pQCKeyInfo.a());
            }
            stringArray[7] = string3;
            stringArray[8] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[9] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[10] = FIPSConfig.c() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
            stringArray[11] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[12] = Integer.toString(this.internalGetCertCompNum(string));
            break;
        }
        return stringArray;
    }

    protected String a(boolean[] blArray) {
        return "SSL";
    }

    public int getCertCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public X509Certificate getCert(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n2 == n3) {
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            if (x509Certificate2 == null) continue;
            ++n3;
        }
        return x509Certificate;
    }

    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X509Certificate x509Certificate = null;
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.z);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(a.getString("PKI-04016"));
        }
        x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        return x509Certificate;
    }

    public String getSSLCertAlias(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.z);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(a.getString("PKI-04016"));
        }
        return string;
    }

    public X500Principal[] getTrustpointDNs(int n) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(x509Certificate.getSubjectDN().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    public ArrayList getTrustpointDNalias(int n) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(x509Certificate.getSubjectDN().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getTrustpointAliases(int n) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public String[] getTrustpointInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[13];
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
            stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Long.toString(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L);
            stringArray[5] = Long.toString(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L);
            PublicKey publicKey = oraclePKIX509CertImpl.getPublicKey();
            if (publicKey == null) {
                throw new IOException("Public key of certificate is NULL");
            }
            String string3 = publicKey.getAlgorithm();
            if (string3 == null || string3.isEmpty()) {
                throw new IOException("Public key algorithm is either NULL or empty");
            }
            if (string3.equals("RSA")) {
                stringArray[6] = Integer.valueOf(((RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            } else if (string3.equals("EC")) {
                stringArray[6] = Integer.valueOf(((ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams().getCurve().getField().getFieldSize()).toString();
            } else if (string3.contains("ML-DSA")) {
                PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.a(string3);
                if (pQCKeyInfo == null) {
                    throw new IOException("Key information is null");
                }
                stringArray[6] = String.valueOf(pQCKeyInfo.a());
            } else if (string3.contains("SLH-DSA")) {
                PQCKeyUtil.PQCKeyInfo pQCKeyInfo = PQCKeyUtil.b(string3);
                if (pQCKeyInfo == null) {
                    throw new IOException("Key information is null");
                }
                stringArray[6] = String.valueOf(pQCKeyInfo.a());
            }
            stringArray[7] = string3;
            stringArray[8] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[9] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[10] = TransitionMode.isFIPS140ModeEnabled() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
            stringArray[11] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[12] = Integer.toString(this.internalGetTCertCompNum(string));
            break;
        }
        return stringArray;
    }

    public int getTrustpointCount(int n) throws IOException, KeyStoreException, CertificateException {
        int n2 = 0;
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n2;
        }
        return n2;
    }

    public X509Certificate getTrustpoint(int n, int n2) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n2 == n3) {
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            ++n3;
        }
        return x509Certificate;
    }

    public Map<String, Date> getCertsDNAndExpiry(int n) throws IOException, KeyStoreException, CertificateException {
        if (n != 0) {
            throw new IOException("No persona with index=" + n + " in wallet.");
        }
        HashMap<String, Date> hashMap = new HashMap<String, Date>();
        KeyStore keyStore = this.getKeyStore();
        if (keyStore == null) {
            return null;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            String string2 = "";
            string2 = string2 + "DN: " + x509Certificate.getSubjectDN().toString() + ";";
            string2 = string2 + "Serial No. " + x509Certificate.getSerialNumber();
            Date date = x509Certificate.getNotAfter();
            hashMap.put(string2, date);
        }
        return hashMap;
    }

    public void changePassword(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(a.getString("PKI-01002"));
        }
        if (this.z == null) {
            throw new IOException("Cannot modify SSO wallet password.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
        PKCS12 pKCS12 = new PKCS12(new String(this.z), (InputStream)byteArrayInputStream);
        pKCS12.a(cArray);
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).a(cArray);
        }
        try {
            OraclePKIDebug.debug("Verifying wallet " + pKCS12.g());
        }
        catch (AuthException authException) {
            OraclePKIDebug.debug("Verifying wallet failed" + authException);
            throw new IOException(a.getString("PKI-02004"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        this.y = byteArrayOutputStream.toByteArray();
        this.z = cArray;
    }

    public InputStream exportCertChain(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        return this.exportCertChain(x500Principal, null, null);
    }

    public InputStream exportCertChain(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateException {
        String string3 = this.exportCertChainB64(x500Principal, string, string2);
        return new ByteArrayInputStream(string3.getBytes());
    }

    public String exportCertChainB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        return this.exportCertChainB64(x500Principal, null, null);
    }

    public String exportCertChainB64(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateException {
        Serializable serializable;
        Enumeration<String> enumeration;
        Certificate[] certificateArray;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        if (x500Principal != null) {
            certificateArray = new X500Name(x500Principal.toString());
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string5;
                string4 = enumeration.nextElement();
                serializable = (OraclePKIX509CertImpl)keyStore.getCertificate(string4);
                if (serializable == null || !keyStore.isKeyEntry(string4) || !certificateArray.equals(new X500Name(string5 = ((OraclePKIX509CertImpl)serializable).getSubjectDN().toString())) || string != null && !((String)(object = ((OraclePKIX509CertImpl)serializable).getIssuerDN().toString())).equals(string)) continue;
                if (string2 != null) {
                    object = ((OraclePKIX509CertImpl)serializable).getSerialNumber();
                    if (object == null) continue;
                    String string6 = ((BigInteger)object).toString();
                    String string7 = ((BigInteger)object).toString(16);
                    String string8 = "0x" + ((BigInteger)object).toString(16);
                    if (!string6.equals(string2) && !string7.equalsIgnoreCase(string2) && !string8.equalsIgnoreCase(string2)) continue;
                }
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.debug("No certificate with matching DN found in wallet.");
                return string3;
            }
        } else {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string4 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.debug("No user certificate found in wallet.");
                return string3;
            }
        }
        certificateArray = keyStore.getCertificateChain(string4);
        serializable = new PKCS7();
        OraclePKIDebug.debug("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i = 1; i < certificateArray.length; ++i) {
                ((PKCS7)serializable).a(new X509(((OraclePKIX509CertImpl)certificateArray[i]).getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            ((PKCS7)serializable).a(new X509(((OraclePKIX509CertImpl)certificateArray[0]).getEncoded()));
        } else {
            OraclePKIDebug.debug("Certificate chain length is zero");
            return string3;
        }
        byte[] byArray = ((PKCS7)serializable).f();
        string3 = Utils.getBase64EncodedCert(byArray, d, e);
        return string3;
    }

    public InputStream exportCertChain(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = this.exportCertChainB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertChainB64(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = enumeration.nextElement();
            if (!string.equals(string3) || !keyStore.isKeyEntry(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.debug("No certificate with matching alias found in wallet.");
            return string2;
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string3);
        PKCS7 pKCS7 = new PKCS7();
        OraclePKIDebug.debug("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i = 1; i < certificateArray.length; ++i) {
                pKCS7.a(new X509(certificateArray[i].getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            pKCS7.a(new X509(certificateArray[0].getEncoded()));
        } else {
            OraclePKIDebug.debug("Certificate chain length is zero");
            return string2;
        }
        byte[] byArray = pKCS7.f();
        string2 = Utils.getBase64EncodedCert(byArray, d, e);
        return string2;
    }

    public String exportUserCertChainB64() throws IOException, KeyStoreException, CertificateException {
        String string = null;
        try {
            X509Certificate x509Certificate = this.getSSLCert(true);
            String string2 = x509Certificate.getSubjectDN().toString();
            string = this.exportCertChainB64(new X500Principal(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public String trustpointNeededB64(String string, String string2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        boolean bl2 = false;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(byteArrayInputStream);
        for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
            object = oraclePKIX509CertImplArray[i].getSubjectDN().toString();
            bl2 = this.isTrustedCertUsedInChain(new X500Principal((String)object));
            if (bl2) {
                return null;
            }
            if (string2 == null || !string2.equals(object)) continue;
            oraclePKIX509CertImpl = oraclePKIX509CertImplArray[i];
        }
        if (string2 != null) {
            if (oraclePKIX509CertImpl != null) {
                byte[] byArray = oraclePKIX509CertImpl.getEncoded();
                object = Utils.getBase64EncodedCert(byArray, d, e);
                return object;
            }
            throw new IOException("No trustpoint with matching DN in chain");
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
        oraclePKIX509CertImpl = bl ? oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1] : oraclePKIX509CertImplArray2[0];
        object = oraclePKIX509CertImpl.getEncoded();
        String string3 = Utils.getBase64EncodedCert((byte[])object, d, e);
        return string3;
    }

    public String exportTrustedB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string3 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string3) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string3)) == null || !string.equals(string3)) continue;
            byte[] byArray = x509Certificate.getEncoded();
            string2 = Utils.getBase64EncodedCert(byArray, d, e);
            break;
        }
        return string2;
    }

    public boolean isAutoLoginOnly() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            this.getSecretStore();
        }
        catch (Exception exception) {
            this.c();
            IOException iOException = new IOException(a.getString("PKI-03004"));
            iOException.initCause(exception);
            throw iOException;
        }
        if (this.y == null) {
            throw new IOException("Wallet array is null.");
        }
        byteArrayInputStream = new ByteArrayInputStream(this.y);
        if (this.z != null) {
            return false;
        }
        C041 c041 = new C041();
        return c041.c(byteArrayInputStream) == 2;
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, PrivateKey privateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, certificateRequest, privateKey, string);
    }

    public void internalRemoveCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, x500Principal);
    }

    public void internalRemoveCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.e(byteArrayInputStream, this.z, string);
    }

    public void internalRemovePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.f(byteArrayInputStream, this.z, string);
    }

    public int internalGetCRCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.debug("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.g(byteArrayInputStream, this.z, string);
    }

    public int internalGetTCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalGetTCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.j(byteArrayInputStream, this.z, string);
    }

    public int internalGetCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalGetCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.i(byteArrayInputStream, this.z, string);
    }

    public void internalAddTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Utils.trustedCertificateValidation(oraclePKIX509CertImpl, this.I);
        if (oraclePKIX509CertImpl.getX509().b() == null) {
            throw new IOException(a.getString("PKI-04019"));
        }
        String string3 = oraclePKIX509CertImpl.getX509().b().getAlgorithm();
        if (OraclePKIGenFunc.isNullOrEmpty(string3)) {
            throw new IOException("Public key algorithm is null or empty for certificate.");
        }
        if (!(string3.equals("RSA") || string3.equals("EC") || string3.contains("ML-DSA") || string3.contains("SLH-DSA"))) {
            throw new IOException(a.getString("PKI-04019"));
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, oraclePKIX509CertImpl, string, string2, this.areTrustFlagsEnabled());
    }

    public void internalReplaceTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Utils.trustedCertificateValidation(oraclePKIX509CertImpl, this.I);
        if (oraclePKIX509CertImpl.getX509().b() == null) {
            throw new IOException("Public key is null for certificate.");
        }
        String string3 = oraclePKIX509CertImpl.getX509().b().getAlgorithm();
        if (OraclePKIGenFunc.isNullOrEmpty(string3)) {
            throw new IOException("Public key algorithm is null or empty for certificate.");
        }
        if (!(string3.equals("RSA") || string3.equals("EC") || string3.contains("ML-DSA") || string3.contains("SLH-DSA"))) {
            throw new IOException(a.getString("PKI-04019") + string3);
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, oraclePKIX509CertImpl, string, string2, this.C);
    }

    public void internalReplaceTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Utils.trustedCertificateValidation(oraclePKIX509CertImpl, this.I);
        if (oraclePKIX509CertImpl.getX509().b() == null) {
            throw new IOException("Public key is null for certificate.");
        }
        String string4 = oraclePKIX509CertImpl.getX509().b().getAlgorithm();
        if (OraclePKIGenFunc.isNullOrEmpty(string4)) {
            throw new IOException("Public key algorithm is null or empty for certificate.");
        }
        if (!(string4.equals("RSA") || string4.equals("EC") || string4.contains("ML-DSA") || string4.contains("SLH-DSA"))) {
            throw new IOException(a.getString("PKI-04019") + string4);
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, oraclePKIX509CertImpl, string, string2, string3, this.C);
    }

    public void internalRemoveTrustedCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, x500Principal, string, string2, this.C);
    }

    public void internalRemoveTrustedCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, string, this.C);
    }

    public void internalRemoveAllTrusted() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveAllTrusted");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.z, this.C);
    }

    public void internalAddUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalAddUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, oraclePKIX509CertImpl, string, this.C, this.areTrustFlagsEnabled());
    }

    public void internalRemoveUserCert(X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, x500Principal, string, string2);
    }

    public void internalRemoveUserCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.h(byteArrayInputStream, this.z, string);
    }

    public void internalRemoveMatchingUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: internalRemoveMatchingUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, oraclePKIX509CertImpl, string, string2);
    }

    public Enumeration getWalletPersonas() {
        Hashtable<String, OracleWalletPersona> hashtable = new Hashtable<String, OracleWalletPersona>();
        OracleWalletPersona oracleWalletPersona = new OracleWalletPersona(this);
        hashtable.put("one", oracleWalletPersona);
        return hashtable.elements();
    }

    public void Pkcs11AddCertReq(String string, String string2, String string3, String string4, int n, String string5) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, Exception {
        byte[] byArray = NZNative.Pkcs11AddCertReq(string, string2, string3, string4, n, string5);
        if (byArray == null) {
            throw new IOException("creq is null");
        }
        CertificateRequest certificateRequest = new CertificateRequest(byArray);
        this.addCertRequest(certificateRequest);
    }

    public boolean containsPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = this.getPkcs11Info();
        return stringArray[0] != null;
    }

    public String[] getPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet:getP11Info ");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        String[] stringArray = new String[]{oracleKeyStoreSpi.getP11Lib(), oracleKeyStoreSpi.getP11TokenLabel(), oracleKeyStoreSpi.getP11TokenPassphrase(), oracleKeyStoreSpi.getP11CertLabel()};
        return stringArray;
    }

    public void addP11Lib(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, string);
    }

    public void addP11TokenLabel(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.z, string);
    }

    public void addP11TokenPwd(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.c(byteArrayInputStream, this.z, string);
    }

    public void addP11CertLbl(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.debug("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.d(byteArrayInputStream, this.z, string);
    }

    private void c() {
        this.z = null;
        this.x = null;
        this.y = null;
        this.D = null;
        this.F = null;
        this.B = false;
        this.C = null;
    }

    private OracleWalletImpl a(String string, char[] cArray) throws IOException {
        if (string.indexOf(58) < 2) {
            string = v + string;
        }
        if (string.toLowerCase(Locale.ENGLISH).startsWith(v)) {
            if (cArray == null) {
                return new OracleFileSSOWalletImpl(string.substring(v.length()));
            }
            return new OracleFileWalletImpl(string.substring(v.length()));
        }
        throw new IOException("Unsupported WRL type" + string);
    }

    private OracleWalletImpl a(char[] cArray) throws IOException {
        if (cArray == null) {
            return new OracleFileSSOWalletImpl(null);
        }
        return new OracleFileWalletImpl(null);
    }

    private InputStream a(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
        char[] cArray = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            if (n == 3) {
                byArray2 = c041.a(n, this.s, this.t, this.u);
                cArray = c041.f(byArray2);
            } else {
                cArray = c041.g(byArray);
                byArray2 = c041.a(cArray, n);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(this.z, (InputStream)byteArrayInputStream);
        pKCS12.a(cArray);
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).a(cArray);
        }
        try {
            pKCS12.output(byteArrayOutputStream);
            OraclePKIDebug.debug("Verifying wallet " + pKCS12.g());
        }
        catch (AuthException authException) {
            OraclePKIDebug.debug("Verifying wallet failed" + authException);
            throw new IOException("Could not create SSO wallet from p12" + authException);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray3);
    }

    private char[] d() throws IOException {
        char[] cArray = null;
        if (this.z == null) {
            C041 c041 = new C041();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
                c041.c(byteArrayInputStream);
                c041.e(byteArrayInputStream);
                cArray = c041.b(byteArrayInputStream);
            }
            catch (IOException iOException) {
                this.c();
                throw new IOException(iOException.getMessage());
            }
        }
        return cArray;
    }

    private char[] b(char[] cArray) throws IOException {
        if (this.z != null) {
            throw new IOException("");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.y);
        char[] cArray2 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            cArray2 = c041.g(byArray);
            byArray2 = c041.a(cArray2, 2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)byteArrayInputStream);
        pKCS12.a(cArray2);
        ArrayList<PKCS12Safe> arrayList = pKCS12.f();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).a(cArray2);
        }
        try {
            pKCS12.output(byteArrayOutputStream);
            OraclePKIDebug.debug("Verifying wallet " + pKCS12.g());
        }
        catch (AuthException authException) {
            OraclePKIDebug.debug("Verifying wallet failed" + authException);
            throw new IOException("Could not create SSO wallet from p12" + authException);
        }
        this.y = byteArrayOutputStream.toByteArray();
        return cArray2;
    }

    OraclePKIX509CertImpl[] a(OraclePKIX509CertImpl[] oraclePKIX509CertImplArray) throws IOException {
        int n;
        int n2;
        int n3;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = new OraclePKIX509CertImpl[oraclePKIX509CertImplArray.length];
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>(oraclePKIX509CertImplArray.length);
        Vector vector2 = new Vector(oraclePKIX509CertImplArray.length);
        for (n3 = 0; n3 < oraclePKIX509CertImplArray.length; ++n3) {
            vector.addElement(oraclePKIX509CertImplArray[n3]);
        }
        n3 = 0;
        for (n2 = 0; n2 < oraclePKIX509CertImplArray.length; ++n2) {
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl;
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl2 = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getIssuerDN();
            if (!oraclePKIPrincipalImpl2.equals(oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n2)).getSubjectDN())) continue;
            n3 = 1;
            vector2.addElement(vector.get(n2));
            vector.remove(n2);
            break;
        }
        if (n3 == 0) {
            throw new IOException("No self-signed cert in chain.");
        }
        n2 = 0;
        block2: do {
            n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                if (!((OraclePKIX509CertImpl)vector.get(n)).getIssuerDN().equals(((OraclePKIX509CertImpl)vector2.lastElement()).getSubjectDN())) continue;
                n2 = 1;
                vector2.addElement(vector.get(n));
                vector.remove(n);
                continue block2;
            }
        } while (n2 != 0);
        if (vector.size() != 0 || vector2.size() != oraclePKIX509CertImplArray.length) {
            throw new IOException("Could not form complete chain.");
        }
        for (n = 0; n < oraclePKIX509CertImplArray.length; ++n) {
            oraclePKIX509CertImplArray2[n] = (OraclePKIX509CertImpl)vector2.get(n);
        }
        return oraclePKIX509CertImplArray2;
    }

    private void a(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException(a.getString("PKI-02018"));
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        String string2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = fileInputStream.read();
        while (n != -1) {
            byteArrayOutputStream.write((byte)n);
            n = fileInputStream.read();
        }
        string2 = byteArrayOutputStream.toString();
        fileInputStream.close();
        if (OraclePKIGenFunc.isNullOrEmpty(string2)) {
            throw new IOException(a.getString("PKI-02021"));
        }
        if (!file.exists()) {
            throw new IOException(a.getString("PKI-02018"));
        }
    }

    public int importPKCS12File(String string, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        int n = 0;
        if (!this.canModify()) {
            throw new IOException(a.getString("PKI-02008"));
        }
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.debug("OracleWallet.importPKCS12File: parsing PKCS#12 file at location " + string);
        }
        this.a(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        oracleKeyStoreSpi.load(fileInputStream, cArray, true);
        oracleKeyStoreSpi.a(this.I);
        fileInputStream.close();
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.debug("During the import of PKCS#12 file into Oracle Wallet only most recently issued and currently valid certificate (validity is ensured for entire certificate chain) for a unique private key inside PKCS#12 file will be imported. Moreover, if same private key is already present in wallet then import will skip that entire priavte key and certificate chain pair.");
        }
        n = oracleKeyStoreSpi.retainOnlyLatestAndValidCertificateForUniquePrivateKey();
        Enumeration enumeration = oracleKeyStoreSpi.engineAliases();
        if (this.z == null) {
            this.A = this.d();
        }
        if (OraclePKIDebug.getDebugFlag()) {
            OraclePKIDebug.debug("OracleWallet.importPKCS12File: iterating through private key - certificate chain pairs inside PKCS#12 file and adding them into wallet one by one.");
        }
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string2 = (String)enumeration.nextElement();
            if (!oracleKeyStoreSpi.engineIsKeyEntry(string2)) continue;
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.y != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.y);
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.reset();
            }
            OracleKeyStoreSpi oracleKeyStoreSpi2 = null;
            oracleKeyStoreSpi2 = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
            if (OraclePKIDebug.getDebugFlag()) {
                OraclePKIDebug.debug("OracleWallet.importPKCS12File: parsing wallet.");
            }
            oracleKeyStoreSpi2.engineLoad(byteArrayInputStream, this.z);
            if (byteArrayInputStream != null) {
                byteArrayInputStream.reset();
            }
            if ((certificateArray = oracleKeyStoreSpi.engineGetCertificateChain(string2)) == null) continue;
            this.y = oracleKeyStoreSpi2.internalAddPrivateKeyAndCertificateChain(byteArrayInputStream, this.z, string2, oracleKeyStoreSpi.engineGetKey(string2, cArray), certificateArray);
            if (this.z != null) continue;
            this.A = this.b(this.A);
        }
        return n;
    }

    public void addTrustFlagsToCertificates(boolean bl) throws Exception {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.z == null) {
            this.A = this.d();
        }
        this.a(bl);
        if (this.z == null) {
            this.A = this.b(this.A);
        }
    }

    private void a(boolean bl) throws Exception {
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.y != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.y);
        }
        oracleKeyStoreSpi = this.z != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.z);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.y = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.z, this.C, bl);
    }

    public void printWalletInfo() {
        PKCS12 pKCS12 = null;
        PKCS12Safe pKCS12Safe = null;
        try {
            ASN1ObjectID aSN1ObjectID;
            pKCS12 = new PKCS12(this.z, this.getWalletArray(false));
            System.out.println("MAC: " + CryptoUtils.getHmacAlg(pKCS12.a()));
            System.out.println("Iteration count: " + pKCS12.b());
            pKCS12Safe = pKCS12.f().get(0);
            if (pKCS12Safe != null && (aSN1ObjectID = pKCS12Safe.e()) != null) {
                if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.i)) {
                    System.out.println("Encryption algorithm: " + CryptoUtils.getEncryptionAlgorithm(pKCS12Safe.f()) + "-" + CryptoUtils.getDigestAlg(pKCS12Safe.g()));
                } else {
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectID);
                    System.out.println("Encryption algorithm: " + CryptoUtils.getPBEAlgorithm(algorithmIdentifier));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCertValidationMode(String string) {
        if (!OraclePKIGenFunc.isNullOrEmpty(string) && string.equals("strict")) {
            this.I = true;
        }
    }

    public static enum DEF_TF_ADD {
        SERVER_CLIENT_AUTH,
        TRUSTED,
        USER,
        NULL;

    }
}

