/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlStore;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.cert.CRLDistPoint;
import oracle.security.pki.internal.cert.GeneralName;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.cert.ext.CRLDistPointExtension;

public class OraclePKIX509CrlDPStore
implements OraclePKIX509CrlStore {
    @Override
    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.debug("OraclePKIX509CrlDPStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        CRLDistPointExtension cRLDistPointExtension = (CRLDistPointExtension)x509.a(PKIX.Q);
        if (cRLDistPointExtension == null) {
            return null;
        }
        ArrayList<CRLDistPoint> arrayList = cRLDistPointExtension.e();
        OraclePKIDebug.debug("OraclePKIX509CrlDPStore: found " + arrayList.size() + " Distribution Points");
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<GeneralName> arrayList2 = arrayList.get(i).a().a();
            for (int j = 0; j < arrayList2.size(); ++j) {
                GeneralName generalName = arrayList2.get(j);
                if (generalName.a() != GeneralName.Type.g) continue;
                OraclePKIDebug.debug("OraclePKIX509CrlDPStore: trying " + ((ASN1String)generalName.b()).b());
                try {
                    URL uRL = new URL(((ASN1String)generalName.b()).b());
                    return new CRL(uRL);
                }
                catch (Exception exception) {
                    OraclePKIDebug.debug("OraclePKIX509CrlDPStore: " + exception);
                }
            }
        }
        OraclePKIDebug.debug("OraclePKIX509CrlDPStore: CRL not found");
        return null;
    }
}

